<?php
class dynPG_gallery {
    // $property_code -> string
    // String which is generatet by DynPG where Plugin might by inserted in.
    var $property_code;

    // $dynpg_instance -> instance of class TDynPG_MainClass
    // Copy of instance from super global $GLOBALS['DynPG'].
    var $dynpg_instance;

    // $rootToTool -> string
    // Path to the CMS directory in which DynPG has been installed
    var $rootToTool;

    // $rootToPlugin -> string
    // Path to the plugin directory in which plugin
    var $rootToPlugin;

    // $output_Message -> string
    // buffered outputs when succeeded or failed
    var $output_Message;

    // $language -> array[0..1] of [ string | TLanguage ]
    // instaance for current language class (default is "de")
    var $language;

    // $template -> TTemplate
    // instaance for current template processor
    var $template;

    // $parameters -> array
    // array of parameters for this plugin
    var $parameters;

    function dynPG_gallery()
    {
        $this->property_code = '';
        // 2. get some foreign data of DynPG CMS
            if ( isset( $GLOBALS['DynPG'] ) && is_object( $GLOBALS['DynPG'] ) ) {
                $this->dynpg_instance = $GLOBALS['DynPG'];
                $this->rootToTool = $this->dynpg_instance->PathToRoot;
            } else {
                $this->rootToTool = '';
                $this->rootToPlugin = '';
                $this->dynpg_instance = null;
            }
        
        // 7. read parameters

        // a) instanciate defaults
            $_ = Array(
                'settings_id' => null
            );

        // b) read user defined
            $this->parameters = array_merge($_, $this->dynpg_instance->_PlugIn['dpggallery']['parameters']);
        
        // 9. read current language (selected by includes class)
            $this->dynPG_gallery_setupLanguage( $this->dynpg_instance->_PlugIn['dpggallery']['language'] );
    }

    function perform()
    {
        $this->property_code = $this->dynPG_gallery_HandlegalleryInText();
    }

    function setParam($param = '', $value = '') {
        $this->parameters[strtolower($param)] = $value;
    }

    function dynPG_gallery_setupLanguage( $lang = 'de' )
    {
        require_once dirname( __FILE__ ) . '/languages/' . strtolower( $lang ) . '.lang.php';

        $this->language[0] = strtolower( $lang );
        $this->language[1] = new TLanguage( $this->language[0], 'DPGgallery' );
    }

    function getPicture( &$picture, $gallery_id, $extention, $from, $link, $cell, &$settings )
    {
      $RootToTool = $this->rootToTool;
      $image_overlay = '';
        
      if( $from == "small" ){
  			$path = FORMS_IMAGES_DESTINATIONURL_ROOT."/TN".$gallery_id."imgfile".$picture->picture_id.$extention;
  			$border = $settings->P_BORDER;
  			$link_2 = "</a>";
  			$style = "style=\"border:".$settings->P_BORDER_W."px ".$settings->P_BORDER_S." #".$settings->P_BORDER_C."\"";
  			$pic_size = "";
  			$cell = "P_div_".$cell;
  			
  			if( $settings->P_CSS == 1 ){			
  				$hspace = $settings->P_CSS_12 . "px";
  				$vspace = $settings->P_CSS_AB . "px";
  				$space = " style=\"padding:$hspace $vspace\" ";
  			}
  			else { $space = ""; }
  				
  			if( $settings->P_ALTTEXT == "TRUE" ){
  				$description = "<div class=\"DynPG_Gallery_Desc_small\">".$picture->DESCR."</div>";
  			} 
  		  else { $description = ""; }
          
          if(($settings->P_COLS * $settings->P_ROWS) == 1){
               $image_overlay = '<span class="play_button_overlay"></span>';
          }
  		}
  		elseif ( $from == "big"){
  			$path = FORMS_IMAGES_DESTINATIONURL_ROOT."/imgfile".$picture->picture_id.$extention;		
  			$border = $settings->G_BORDER;
  			$link_2 = "";
  			$style = "style=\"border:".$settings->G_BORDER_W."px ".$settings->G_BORDER_S." #".$settings->G_BORDER_C."\"";
  			
  			$size = @getimagesize( $RootToTool . $path );
  			$pic_width = $size[0];
  			$pic_height = $size[1];
  			if( $pic_width >= $pic_height && $pic_width > $settings->G_WIDTH ) {
  				$pic_size = "width=\"".$settings->G_WIDTH."\"";
  			} elseif ( $pic_width < $pic_height && $pic_height > $settings->G_HEIGHT ) {
  				$pic_size = "height=\"".$settings->G_HEIGHT."\"";
  			} else {
  				$pic_size = "";
  			}
  			
  			if( $settings->G_ALTTEXT == "TRUE" ){
  				$description = "<div class=\"DynPG_Gallery_Desc_big\">".$picture->DESCR."</div>";
  			} 
  			else { $description = ""; }
  
  			$space = "";
  			$cell = "G_div";
  		}
  
  		$returnPic = "";

      switch ( $border ) {
        case 1:
          $returnPic .= "
      			<div class=\"DynPG_Gallery_".$cell."\"".$space.">
      				$link<img src=\"" . $path . "\" $pic_size class=\"DynPG_Gallery_Images_".$from."\" alt=\"".dynpg_htmlentities_rigid(strip_tags($description),ENT_COMPAT,true)."\" />".$image_overlay.$link_2."
      				$description
      			</div>
      			";
          break;

        case 2:
          $returnPic .= "
      			<div class=\"DynPG_Gallery_".$cell."\"".$space.">
      				$link<img src=\"" . $path . "\" $pic_size $style alt=\"".dynpg_htmlentities_rigid(strip_tags($description),ENT_COMPAT,true)."\" />".$image_overlay.$link_2."
      				$description
      			</div>
      			";
          break;

        case 3:
          $returnPic = "<div class=\"DynPG_Gallery_".$cell."\"".$space.">
      				<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"background-color: #FFFFFF;\">
      				<tr>
      					<td></td>
      					<td></td>
      					<td width=\"8px\"></td>
      				</tr>
      				<tr>
      					<td></td>
      					<td>$link<IMG SRC=\"" . $path . "\" $pic_size border=\"0\">$link_2</td>
      					<td valign=\"top\" style=\"background-image: url(" . $RootToTool . "pictures/galeryborders/b1left.jpg);background-repeat:repeat-y;\"><img src=\"" . $RootToTool . "pictures/galeryborders/b1leftstart.jpg\"></td>
      				</tr>
      				<tr>
      					<td></td>
      					<td style=\"background-image: url(" . $RootToTool . "pictures/galeryborders/b1bottom.jpg);background-repeat:repeat-x;\"><img src=\"" . $RootToTool . "pictures/galeryborders/b1bottomstart.jpg\"></td>
      					<td height=\"8px\"><IMG SRC=\"" . $RootToTool . "pictures/galeryborders/b1corner4.jpg\"></td>
      				</tr>
      				</table>$description</div>";
          break;
      }
      return ( $returnPic );
    }

    function WriteGallery( $id, $FromClass = false, $RelPage = "", $RootToTool = "" )
    {
      if ( !$FromClass ) {
        if ( !empty( $GLOBALS["UseThisPageInClass"] ) ) $RelPage = $GLOBALS["UseThisPageInClass"] . "?" . ((!getenv( "QUERY_STRING" )) ? $SERVER['QUERY_STRING']: getenv( "QUERY_STRING" ));
        if ( !empty( $GLOBALS["DefineRootToTool"] ) ) $RootToTool = $GLOBALS["DefineRootToTool"];
      }

		  include $RootToTool . "connectdb.php";
      $PHP_SELF = $_SERVER['PHP_SELF'];
  		$plugin_dir = "plugins/DPGgallery/";
  		$show_thumbs = TRUE;

      $result = "<div class=\"DynPG_Gallery_Main\">";

      $get = "?x=1";
      if ( !empty( $_GET["read_article"] ) ) {
          $get .= "&amp;read_article=" . $_GET["read_article"];
      }
      if ( !empty( $_GET["read_group"] ) ) {
          $get .= "&amp;read_group=" . $_GET["read_group"];
      }
      if ( !empty( $_GET["read_category"] ) ) {
          $get .= "&amp;read_category=" . $_GET["read_category"];
      }
      if ( !empty( $_GET["t"] ) ) {
          $get .= "&amp;t=" . $_GET["t"];
      }

      if ( empty( $_GET["start"] ) || ( isset( $_GET["gal"] ) && $_GET["gal"] != $id ) ) {
          $start = 0;
      } else {
          $start = addslashes( $_GET["start"] );
      }
        
  		$RES = mysql_query("SELECT * 
                          FROM `dynpg_gallery` AS dg
                          INNER JOIN `dynpg_gallery_settings` AS dgs ON ".(!empty($this->parameters['settings_id'])?"'".(int)$this->parameters['settings_id']."'":"dg.setting_id")." = dgs.id 
                          WHERE dg.id='$id'");
  		$settings = mysql_fetch_object($RES);
  		$setting_id = $settings->setting_id;
  		
  		$SQL = mysql_query("SELECT * FROM `dynpg_gallery_pictures` WHERE `gallery_id`='$id'");
  		$total_pics = mysql_num_rows($SQL);
  
  		if( isset($_GET["pic"]) && $_GET["gal"] == $id ){
  			$sql="SELECT 
                dgp.picture_id AS `picture_id`, 
                dgp.POSITION AS `POSITION`, 
                dci.URL AS `URL`, 
                dci.DESCR AS `DESCR` 
              FROM 
                `dynpg_gallery_pictures` AS dgp 
              INNER JOIN 
                `dynpg_cms_images` AS dci ON dgp.picture_id = dci.id 
              WHERE dgp.id='" . addslashes( $_GET["pic"] ) . "'";
        $picture = mysql_fetch_object($SQL);
        $position = $picture->POSITION;
  			$pic_id = $picture->picture_id;
        $extention = strchr($picture->URL, ".");
  
        $next = $position + 1;
        $prev = $position-1;
        $order = "ASC";
        if ( $next > $total_pics ) {
            $next = 1;
            $order = "DESC";
        }
        if ( $prev < 1 ) {
            $prev = $total_pics;
            $order = "DESC";
        }
        $SQL = mysql_query( "SELECT * FROM `dynpg_gallery_pictures` WHERE `gallery_id`='$id' AND (`POSITION`='$next' OR `POSITION`='$prev') ORDER BY `POSITION` $order" );
        while ( $res = mysql_fetch_array( $SQL ) ) {
            $next_id[] = $res["id"];
        }
        $prev_picid = $next_id[0];
        $next_picid = $next_id[1];

        if ( $settings->G_SHOW_P != 1 ) {
            $show_back = "<td class=\"DynPG_Gallery_tbl_ImgNavigation_col_02\"><a href=\"$PHP_SELF" . $get . "&amp;start=$start\" class=\"DynPG_Gallery_tbl_ImgNavigation_link\"><img src=\"".$RootToTool.$plugin_dir."images/overview.gif\" border=\"0\" alt=\"{$this->language[1]->str['lang_gallery_back_from_detail']}\" title=\"{$this->language[1]->str['lang_gallery_back_from_detail']}\" /></a></td>";
        } else {
            $show_back = "";
        }
	
        $result .= "
    			<div class=\"DynPG_Gallery_ImgNavigation\">
    				<table class=\"DynPG_Gallery_tbl_ImgNavigation\" align=\"center\">
    				<tr>
    					<td class=\"DynPG_Gallery_tbl_ImgNavigation_col_01\"><a href=\"$PHP_SELF" . $get . "&amp;pic=$prev_picid&amp;start=$start&amp;gal=$id\" class=\"DynPG_Gallery_tbl_ImgNavigation_link\"><img src=\"".$RootToTool.$plugin_dir."images/back.gif\" border=\"0\" alt=\"{$this->language[1]->str['lang_gallery_navigation_back']}\" title=\"{$this->language[1]->str['lang_gallery_navigation_back']}\" /></a></td>
    					$show_back
    					<td class=\"DynPG_Gallery_tbl_ImgNavigation_col_03\"><a href=\"$PHP_SELF" . $get . "&amp;pic=$next_picid&amp;start=$start&amp;gal=$id\" class=\"DynPG_Gallery_tbl_ImgNavigation_link\"><img src=\"".$RootToTool.$plugin_dir."images/next.gif\" border=\"0\" alt=\"{$this->language[1]->str['lang_gallery_navigation_next']}\" title=\"{$this->language[1]->str['lang_gallery_navigation_next']}\" /></a></td>
    				</tr></table>
    			</div>
    			";
  			
  			$pictureStr = $this->getPicture($picture, $id, $extention, "big", "", 1, $settings);
  			$result .= $pictureStr;
  			$show_thumbs = FALSE;
  		}
  
  		if( $show_thumbs || $settings->G_SHOW_P == 1){
  			$limit = $settings->P_COLS * $settings->P_ROWS;
  			
  			$result .= "
    			<div class=\"DynPG_Gallery_Preview\">
    			";			
  
  			$counter = 0;
        $SQL="SELECT 
                dgp.id AS `id`, 
                dgp.picture_id AS `picture_id`, 
                dgp.POSITION AS `POSITION`, 
                dci.URL AS `URL`, 
                dci.DESCR AS `DESCR` 
              FROM 
                `dynpg_gallery_pictures` AS dgp 
              INNER JOIN 
                `dynpg_cms_images` AS dci ON dgp.picture_id = dci.id 
              WHERE dgp.gallery_id='$id' 
              ORDER BY `POSITION` ASC";
  			$RES = mysql_query($SQL);
        $index = 0;
  			while( $PICTURE = mysql_fetch_object($RES) ){
          $extention = strchr($PICTURE->URL, ".");
          $pathimage = FORMS_IMAGES_DESTINATIONURL_ROOT."/imgfile".$PICTURE->picture_id.$extention;
          $description = "";
          if( $settings->G_ALTTEXT == "TRUE" ){
            $description = $PICTURE->DESCR;
          }
    			if($index >= $start && $index < ($start + $limit)){
          
    				if( $settings->G_SHOW == 1 ){
    					$link = "<a href=\"" . $pathimage . "\" rel=\"lightbox[".$id."]\" title=\"".$description."\">";
    				} 
    				elseif ( $settings->G_SHOW == 2 ){
    					$link = "<a href=\"javascript:targetLink('" . $RootToTool . "plugins/DPGgallery/galerypopup.php?lang={$this->language[0]}&pg_id=".$PICTURE->id."&number=$id&set=$setting_id',$settings->G_WIDTH,$settings->G_HEIGHT)\">";
    				}
    				
    				if( $counter%$settings->P_COLS == 0 ){ 
    					$result .= "
          			<div class=\"DynPG_Gallery_P_row_".($counter/$settings->P_COLS)."\">
          					";
    				}
    				
    				$pictureStr = $this->getPicture($PICTURE, $id, $extention, "small", $link, ($counter%$settings->P_COLS), $settings);
    
    				$result .= $pictureStr;
    
    				if( ($counter+1)%$settings->P_COLS == 0 ){ 
    					$result .= "
          			</div><div class=\"DynPG_Gallery_clear\"></div>
          					";
    				}
    				
    				$counter++;
          }
          else{
          	$result .= "<a href=\"" . $pathimage . "\" rel=\"lightbox[".$id."]\" title=\"".$description."\"></a>";
          }
          $index++;
        }
  			
  			if( $counter%$settings->P_COLS != 0 ){ 
  				$result .= "
      			</div><div class=\"DynPG_Gallery_clear\"></div>
      				";
  			}
  
  			$result .= "
    			</div>
    			";			
  			
  			$pages = ceil( $total_pics / $limit );
        $actual = $start;
        $start = 0;
        if ( $pages != 1 ) {
          $result .= "
        		<div class=\"DynPG_Gallery_pageNavigation\">
        			<a><img src=\"".$RootToTool.$plugin_dir."images/page.gif\" alt=\"".$this->language[1]->str['lang_gallery_navigation_page_alt']."\" /></a> ".$this->language[1]->str['lang_gallery_navigation_page'];
          for( $i = 1;$i <= $pages;$i++ ) {
            if ( $actual == $start ) {
              $result .= "<a href=\"$PHP_SELF" . $get . "&amp;start=$start&amp;gal=$id\" class=\"DynPG_Gallery_PreviewNavigation_link\"><b>[$i]</b></a> ";
            } else {
              $result .= "<a href=\"$PHP_SELF" . $get . "&amp;start=$start&amp;gal=$id\" class=\"DynPG_Gallery_PreviewNavigation_link\">[$i]</a> ";
            }
            $start = $start + $limit;
          }
      		$result .= "
      		  </div>";
        }
  
  			if ( $settings->G_DIA == "TRUE" ){
  				$result .= "
  				<div class=\"DynPG_Gallery_Dia\">
  					<a href=\"javascript:targetLink('" . $RootToTool . "plugins/DPGgallery/diashow.php?lang={$this->language[0]}&number=$id&set=$setting_id',$settings->G_WIDTH,$settings->G_HEIGHT+25)\"> ".$this->language[1]->str['lang_gallery_dia']."</a>
  				</div>";
  			}
  		}
  
  		$result .= "
  			</div>
  		";
  
  		if ( $FromClass ) echo $result;
          
  		return $result;
    }

    function dynpg_gallery_HandlegalleryInText()
    {
        $result = $this->property_code;

        if (! preg_match('/<img([^<>]+)alt="GALERY=(\w+)"([^<>]+)\/>/', $result) ) {
            return $result;
        }

        $result = preg_replace( '/<img([^<>]+)alt="GALERY=(\w+)"([^<>]+)\/>/', "[GALERY ID=\\2]", $result );

        $i = 0;
        $tpos = 0;
        $pos = true;

        while ( $pos && $tpos < strlen( $result ) ) {
            $i++;
            $pos = strpos( $result, "[GALERY", $tpos );
            if ( $pos !== false ) {
                $votestr = substr( $result, $pos, strpos( $result, "]", $pos ) - $pos + 1 );
                $save_votestr = $votestr;

                $votestr = preg_replace( "'\[GALERY ID=([^\]]+)*?\]'si", "\\1", $votestr );

                $replacestring = $this->WriteGallery( $votestr );

                $result = str_replace( $save_votestr, $replacestring, $result );
            }

            $tpos = $pos + 1;
            $i++;
            if ( $i > 1000 ) {
                break;
            }
        }

        return $result;
    }
}
?>
