tinyMCEPopup.requireLangPack();

function init() {
	tinyMCEPopup.resizeToInnerSize();
	getFieldAttributes();
}

/*
 * @method: getFieldAttributes_compatible()
 * @description: function still reads old input fields
 *      to secure compatibility to older versions.
 * @author: Daniel, 2010-09-03
*/
function getFieldAttributes_compatible() {
    //
    // support old formular inputs
    //
	var action = "insert";
	var inst = tinyMCEPopup.editor, dom = inst.dom;
	var elm = inst.selection.getNode();
	elm = dom.getParent(elm, "input");

	if (elm != null && elm.nodeName == "INPUT")
		action = "update";

	if (action == "update") {
		var formfieldType = dom.getAttrib(elm, 'type');
		switch(formfieldType){
			case 'text':
			case 'password':
				var url = getURL();
				if(formfieldType=='text' && url=='popup.php'){
					location = location.href+"?fElType=1";
				}
				if(formfieldType=='password' && url=='popup.php'){
					location = location.href+"?fElType=2";
				}
				if(url=='popup.php?fElType=1' || url=='popup.php?fElType=2'){
					var inputnamefull = dom.getAttrib(elm, 'name');
					var namelegth = inputnamefull.indexOf('-');

					if(inputnamefull.indexOf('_') == -1){
						var inputname = inputnamefull.substr(0,namelegth);
					}
					else{
						var inputname = inputnamefull.substr(5,namelegth-5);
					}

					setFormValue('feldname', inputname);

					var maxlng = dom.getAttrib(elm, 'maxlength');
					if(maxlng=='2147483647'){
						maxlng = '';
					}
					setFormValue('maxchars', maxlng);

					setFormValue('val', dom.getAttrib(elm, 'value'));
					setFormValue('size', dom.getAttrib(elm, 'size'));
					setFormValue('tabindex', dom.getAttrib(elm, 'tabindex'));
					if(dom.getAttrib(elm, 'readonly') && (document.forms[0].elements['disable'])){
						document.forms[0].elements['disable'].checked = true;
					}

					var optcheck = inputnamefull.indexOf('/');
					if(optcheck != -1){
						var inputopt = inputnamefull.substr(optcheck+1);

						if(formfieldType=='text'){
							if(inputopt == 'required'){
								var index = 1;
								setFormDropdown('art', index);
								document.getElementById("isrequired").style.display="block";
							}
							else if(inputopt == 'mail'){
								var index = 2;
								setFormDropdown('art', index);
								document.getElementById("ismail").style.display="block";
							}
							else if(inputopt == 'usrmail'){
								var index = 3;
								setFormDropdown('art', index);
								document.getElementById("sendmail").style.display="block";
							}
						}
						else if(formfieldType=='password'){
							document.forms[0].elements['required'].checked = true;
						}
					}
				}
				return true;
				break;

			case 'submit':
			case 'reset':
				var url = getURL();
				if(formfieldType=='reset' && url=='popup.php'){
					location = location.href+"?fElType=8";
				}
				if(formfieldType=='submit' && url=='popup.php'){
					location = location.href+"?fElType=7";
				}

				if(url=='popup.php?fElType=7' || url=='popup.php?fElType=8'){
					setFormValue('val', dom.getAttrib(elm, 'value'));
					setFormValue('tabindex', dom.getAttrib(elm, 'tabindex'));
					if(dom.getAttrib(elm, 'disabled')=='disabled'){
						document.forms[0].elements['disable'].checked = true;
					}
				}
				return true;
				break;

			case 'radio':
			case 'checkbox':
				var url = getURL();
				if(formfieldType=='radio' && url=='popup.php'){
					location = location.href+"?fElType=4";
				}
				if(formfieldType=='checkbox' && url=='popup.php'){
					location = location.href+"?fElType=5";
				}

				if(url=='popup.php?fElType=4' || url=='popup.php?fElType=5'){
					document.getElementById("fieldsAdd").style.display="none";
					document.getElementById("fieldsEdit").style.display="block";

					var inputnamefull = dom.getAttrib(elm, 'name');
					var namelength = inputnamefull.indexOf('-');
					if(inputnamefull.indexOf('_') == -1){
						var inputname = inputnamefull.substr(0,namelength);
					}
					else{
						var inputname = inputnamefull.substr(5,namelength-5);
					}
					var code = inputnamefull.substr(namelength);

					document.sel_form2.elements['name'].value = inputname;
					document.sel_form2.elements['val'].value = dom.getAttrib(elm, 'value');
					document.sel_form2.elements['index'].value = dom.getAttrib(elm, 'tabindex');
					document.sel_form2.elements['singlefield'].value = "edited";
					document.sel_form2.elements['field'].value = formfieldType;
					document.sel_form2.elements['code'].value = code;

					if(dom.getAttrib(elm, 'checked')=='checked' || dom.getAttrib(elm, 'checked')){
						document.sel_form2.elements['sel'].checked = true;
					}

					if(dom.getAttrib(elm, 'disabled')=='disabled' || dom.getAttrib(elm, 'disabled')){
						document.sel_form2.elements['disable'].checked = true;
					}
				}
				return true;
				break;

			default:
				return false;
				break;

		}     //switch
	}      //if action==update

	// Dropdown
	if(action != 'update'){
		var elma = inst.selection.getNode();
		elma = dom.getParent(elma, "select");
		if (elma != null && elma.nodeName == "SELECT")
			action = "update";

		if (action == 'update') {
			var url = getURL();
			if(url=='popup.php'){
				location = location.href+"?fElType=6";
			}
			if(url=='popup.php?fElType=6'){
				document.getElementById("fieldsAdd").style.display="none";
				document.getElementById("selectEdit").style.display="block";

				var inputnamefull = elma.name;
				var namelength = inputnamefull.indexOf('-');

				if(inputnamefull.indexOf('_') == -1){
					var inputname = inputnamefull.substr(0,namelength);
				}
				else{
					var inputname = inputnamefull.substr(5,namelength-5);
				}

				document.sel_form3.elements['name'].value = inputname;
				document.sel_form3.elements['index'].value = elma.tabIndex;
				document.sel_form3.elements['fieldList'].value = "edited";
				document.sel_form3.elements['rows'].value = elma.options.length;

				for(var i = 0; i < elma.options.length; i++){
					if(elma.selectedIndex == i){
						var selected = 'checked="checked"';
					} else {
						var selected = '';
					}

					var moveUpDown = '<a href="#" onclick="return swapUp(' + (i + 1)  + ', ' + i + ');" title="' + inst.getLang('formular_dlg.one_position_up') + '">' +
									 '<img src="up.jpg" alt="up" border="0" /></a><a href="#" onclick="return swapDown(' + (i + 1) + ', ' + (i + 2) + ');" title="' + inst.getLang('formular_dlg.one_position_down') + '">' +
									 '<img src="down.jpg" alt="down" border="0" /></a>';

					document.getElementById("selectOptions").innerHTML += "Option " + (i+1) + ": <input type=\"text\" name=\"opt\" id=\"name_of_" + (i + 1) + "\" value=\"" + elma.options.item(i).value + "\" />" + moveUpDown + "&nbsp;<input type=\"radio\" id=\"selected_of_" + (i + 1) + "\" name=\"check\" value=\"" + i + "\" class=\"checkbox\" "+ selected +" /> " + inst.getLang('formular_dlg.selected') + "<br />";
				}
			}
			return true;
		}
	}

	return false;
}

/*
 * @method: getFieldAttributes()
 * @description: function reads values for formular
 *      input placeholder.
 * @author: Daniel, 2010-09-03
*/
function getFieldAttributes() {
	var action = "insert";
	var inst = tinyMCEPopup.editor, dom = inst.dom;
	var imageAltTag = "";

	if (getFieldAttributes_compatible()) {
	   return;
	}

    var elm = inst.selection.getNode();
	elm = dom.getParent(elm, "img");

	if (elm != null && elm.nodeName == "IMG") {
        imageAltTag = dom.getAttrib(elm, 'alt');
        if (getTypeFromImgAlt(imageAltTag) == 'input') {
            action = "update";
        }
	}

	if (action == "update") {
		var formfieldType = getAttrFromImgAlt(imageAltTag, 'type');
		switch(formfieldType){
			case 'text':
			case 'password':
				var url = getURL();
				if(formfieldType=='text' && url=='popup.php'){
					location = location.href+"?fElType=1";
				}
				if(formfieldType=='password' && url=='popup.php'){
					location = location.href+"?fElType=2";
				}
				if(url=='popup.php?fElType=1' || url=='popup.php?fElType=2'){
					var inputnamefull = getAttrFromImgAlt(imageAltTag, 'name');
					var namelegth = inputnamefull.indexOf('-');

					if(inputnamefull.indexOf('_') == -1){
						var inputname = inputnamefull.substr(0,namelegth);
					}
					else{
						var inputname = inputnamefull.substr(5,namelegth-5);
					}

					setFormValue('feldname', inputname);

					var maxlng = getAttrFromImgAlt(imageAltTag, 'maxlength');
					if(maxlng=='2147483647'){
						maxlng = '';
					}
					setFormValue('maxchars', maxlng);

					setFormValue('val', getAttrFromImgAlt(imageAltTag, 'value'));
					setFormValue('size', getAttrFromImgAlt(imageAltTag, 'size'));
					setFormValue('tabindex', getAttrFromImgAlt(imageAltTag, 'tabindex'));
					if(getAttrFromImgAlt(imageAltTag, 'readonly') && (document.forms[0].elements['disable'])){
						document.forms[0].elements['disable'].checked = true;
					}

					var optcheck = inputnamefull.indexOf('/');
					if(optcheck != -1){
						var inputopt = inputnamefull.substr(optcheck+1);

						if(formfieldType=='text'){
							if(inputopt == 'required'){
								var index = 1;
								setFormDropdown('art', index);
								document.getElementById("isrequired").style.display="block";
							}
							else if(inputopt == 'mail'){
								var index = 2;
								setFormDropdown('art', index);
								document.getElementById("ismail").style.display="block";
							}
							else if(inputopt == 'usrmail'){
								var index = 3;
								setFormDropdown('art', index);
								document.getElementById("sendmail").style.display="block";
							}
						}
						else if(formfieldType=='password'){
							document.forms[0].elements['required'].checked = true;
						}
					}
				}
				break;

			case 'submit':
			case 'reset':
				var url = getURL();
				if(formfieldType=='reset' && url=='popup.php'){
					location = location.href+"?fElType=8";
				}
				if(formfieldType=='submit' && url=='popup.php'){
					location = location.href+"?fElType=7";
				}

				if(url=='popup.php?fElType=7' || url=='popup.php?fElType=8'){
					setFormValue('val', getAttrFromImgAlt(imageAltTag, 'value'));
					setFormValue('tabindex', getAttrFromImgAlt(imageAltTag, 'tabindex'));
					if(getAttrFromImgAlt(imageAltTag, 'disabled')=='disabled'){
						document.forms[0].elements['disable'].checked = true;
					}
				}
				break;

			case 'radio':
			case 'checkbox':
				var url = getURL();
				if(formfieldType=='radio' && url=='popup.php'){
					location = location.href+"?fElType=4";
				}
				if(formfieldType=='checkbox' && url=='popup.php'){
					location = location.href+"?fElType=5";
				}

				if(url=='popup.php?fElType=4' || url=='popup.php?fElType=5'){
					document.getElementById("fieldsAdd").style.display="none";
					document.getElementById("fieldsEdit").style.display="block";

					var inputnamefull = getAttrFromImgAlt(imageAltTag, 'name');
					var namelength = inputnamefull.indexOf('-');
					if(inputnamefull.indexOf('_') == -1){
						var inputname = inputnamefull.substr(0,namelength);
					}
					else{
						var inputname = inputnamefull.substr(5,namelength-5);
					}
					var code = inputnamefull.substr(namelength);

					document.sel_form2.elements['name'].value = inputname;
					document.sel_form2.elements['val'].value = getAttrFromImgAlt(imageAltTag, 'value');
					document.sel_form2.elements['index'].value = getAttrFromImgAlt(imageAltTag, 'tabindex');
					document.sel_form2.elements['singlefield'].value = "edited";
					document.sel_form2.elements['field'].value = formfieldType;
					document.sel_form2.elements['code'].value = code;

					if(getAttrFromImgAlt(imageAltTag, 'checked')=='checked' || getAttrFromImgAlt(imageAltTag, 'checked')){
						document.sel_form2.elements['sel'].checked = true;
					}

					if(getAttrFromImgAlt(imageAltTag, 'disabled')=='disabled' || getAttrFromImgAlt(imageAltTag, 'disabled')){
						document.sel_form2.elements['disable'].checked = true;
					}
				}
				break;

			default:
				tinyMCEPopup.alert(inst.getLang('formular_dlg.unknown_fieldtype_error'));
				break;

		}     //switch
	}      //if action==update

	//Dropdown
	if (action != 'update') {
        var elma = inst.selection.getNode();
		elma = dom.getParent(elma, "select");

		if (getTypeFromImgAlt(imageAltTag) == 'select')
			action = "update";

		if (action == 'update') {
			var url = getURL();
			if(url=='popup.php'){
				location = location.href+"?fElType=6";
			}
			if(url=='popup.php?fElType=6'){
				document.getElementById("fieldsAdd").style.display="none";
				document.getElementById("selectEdit").style.display="block";

				var inputnamefull = getAttrFromImgAlt(imageAltTag, 'name');
				var namelength = inputnamefull.indexOf('-');

				if(inputnamefull.indexOf('_') == -1){
					var inputname = inputnamefull.substr(0,namelength);
				}
				else{
					var inputname = inputnamefull.substr(5,namelength-5);
				}

				var selectOptions = getSelectOptionsFromImgAlt(imageAltTag);

				document.sel_form3.elements['name'].value = inputname;
				document.sel_form3.elements['index'].value = getAttrFromImgAlt(imageAltTag, 'tabindex');
				document.sel_form3.elements['fieldList'].value = "edited";
				document.sel_form3.elements['rows'].value = selectOptions.length;

				for(var i = 0; i < selectOptions.length; i++){
					var selected = selectOptions[i]['selected']? 'checked="checked"': '';
					var moveUpDown = '<a href="#" onclick="return swapUp(' + (i + 1)  + ', ' + i + ');" title="' + inst.getLang('formular_dlg.one_position_up') + '">' +
									 '<img src="up.jpg" alt="up" border="0" /></a><a href="#" onclick="return swapDown(' + (i + 1) + ', ' + (i + 2) + ');" title="' + inst.getLang('formular_dlg.one_position_down') + '">' +
									 '<img src="down.jpg" alt="down" border="0" /></a>';

					document.getElementById("selectOptions").innerHTML += "Option " + (i+1) + ": <input type=\"text\" name=\"opt\" id=\"name_of_" + (i + 1) + "\" value=\"" + selectOptions[i]['value'] + "\" />" + moveUpDown + "&nbsp;<input type=\"radio\" id=\"selected_of_" + (i + 1) + "\" name=\"check\" value=\"" + i + "\" class=\"checkbox\" "+ selected +" /> " + inst.getLang('formular_dlg.selected') + "<br />";
				}
			}
		}
	}

	//Textarea
	if (action != 'update') {
		if (getTypeFromImgAlt(imageAltTag) == 'textarea')
			action = "update";

		if (action == 'update') {
            var elma = inst.selection.getNode();
            elma = dom.getParent(elma, "img");
			var url = getURL();
			if(url=='popup.php'){
				location = location.href+"?fElType=3";
			}
			if(url=='popup.php?fElType=3'){

				var altText = dom.getAttrib(elma, 'alt');

				var apos = altText.indexOf("'");
				var bpos = altText.indexOf("'", apos+1);
				var fullname = altText.substring(apos+1, bpos);

				var namelegth = fullname.indexOf('-');

				if(fullname.indexOf('_') == -1){
					var inputname = fullname.substr(0,namelegth);
				}
				else{
					var inputname = fullname.substr(5,namelegth-5);
				}

				apos = altText.indexOf("'", bpos+1);
				bpos = altText.indexOf("'", apos+1);
				var cols = altText.substring(apos+1, bpos);

				apos = altText.indexOf("'", bpos+1);
				bpos = altText.indexOf("'", apos+1);
				var rows = altText.substring(apos+1, bpos);

				apos = altText.indexOf("'", bpos+1);
				bpos = altText.indexOf("'", apos+1);
				var tabindex = altText.substring(apos+1, bpos);

				apos = altText.indexOf("=", bpos+1);
				var text = altText.substring(apos+1);

				var optcheck = fullname.indexOf('/');

				if(optcheck != -1){
					var inputopt = fullname.substr(optcheck+1);
					document.forms[0].elements['required'].checked = true;
				}

				setFormValue('feldname', inputname);
				setFormValue('val', text);
				setFormValue('rows', rows);
				setFormValue('cols', cols);
				setFormValue('tabindex', tabindex);
			}
		}
	}
}

function setFormValue(name, value)
{
	document.forms[0].elements[name].value = value;
}

function setFormDropdown(name, value)
{
	document.forms[0].elements[name].selectedIndex = value;
}

function getURL()
{
	var url = String(window.location);
	var slashpos = url.lastIndexOf('/');
	url = url.substr(slashpos+1);
	return url;
}

function addSelectfield(position)
{
	var inst = tinyMCEPopup.editor;
    var rows = parseInt(document.sel_form3.elements['rows'].value);
	if(position=='bottom'){
		document.sel_form3.elements['rows'].value = rows + 1;
		document.getElementById("selectOptions").innerHTML += "Option " + (rows + 1) + ": <input type=\"text\" name=\"opt\" value=\"\" />&nbsp;<input type=\"radio\" name=\"check\" value=\"" + rows + "\" class=\"checkbox\" /> (" + inst.getLang('formular_dlg.selecting') + ")<br />";
	}
	else if(position=='top'){
		document.sel_form3.elements['rows'].value = rows + 1;
		var j=3;
		for(var i = 0; i < rows; i++){
			document.sel_form3.elements[j].value = parseInt(document.sel_form3.elements[j].value) + 1;
			j=j+2;
		}
		var content = document.getElementById("selectOptions").innerHTML;
		document.getElementById("selectOptions").innerHTML = "Option " + (rows + 1) + ": <input type=\"text\" name=\"opt\" value=\"\" />&nbsp;<input type=\"radio\" name=\"check\" value=\"0\" class=\"checkbox\" /> (" + inst.getLang('formular_dlg.selecting') + ")<br />" + content;
	}

}

function justNumbers(el)
{
    var val = el.value.replace(/[^\d]/g, '');
    el.value = val;
}

function forbiddenchar(fch)
{
    var result = fch.value.search(/[^a-zA-Z0-9_]/);
    if ( result != -1 ) {
        var repl = fch.value.replace(/[^a-zA-Z0-9_]/g, '');
        fch.value = repl;
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.form_forbidden_char_error'));
    }
}

function createRandom()
{
    var code = Math.floor(Math.random() * 100000000);

    code = "-" + code + "-";
    return code;
}

function isitmail(obj)
{
    if( obj.selectedIndex==1 ) {
        document.getElementById("sendmail").style.display="none";
        document.getElementById("ismail").style.display="none";
        document.getElementById("isrequired").style.display="block";
    } else if(obj.selectedIndex==2) {
        document.getElementById("isrequired").style.display="none";
        document.getElementById("sendmail").style.display="none";
        document.getElementById("ismail").style.display="block";
    } else if(obj.selectedIndex==3) {
        document.getElementById("isrequired").style.display="none";
        document.getElementById("ismail").style.display="none";
        document.getElementById("sendmail").style.display="block";
	} else {
        document.getElementById("isrequired").style.display="none";
        document.getElementById("ismail").style.display="none";
        document.getElementById("sendmail").style.display="none";
    }
}

function insertTextbox()
{
    // Execute the mceTemplate command without UI this time

    ok = true;

    inputstr = "<input type=\"text\" class=\"input\" name=\"";

    if ( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error'));
        ok = false;
    }

    if( document.forms[0].art.value==2 ) {
        inputstr += name + "/required\" ";
    } else if( document.forms[0].art.value==3 ) {
        inputstr += name + "/mail\" ";
    } else if( document.forms[0].art.value==4 ) {
        inputstr += name + "/usrmail\" ";
    } else {
        inputstr += name + "\" ";
    }

    if( document.forms[0].size.value != "" ) {
        inputstr += "size=\""+document.forms[0].size.value+"\" ";
    }

    if(document.forms[0].maxchars.value != "") {
        inputstr += "maxlength=\""+document.forms[0].maxchars.value+"\" ";
    }

    if(document.forms[0].tabindex.value != "") {
        inputstr += "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    }

    if(document.forms[0].val.value != "") {
        inputstr += "value=\""+document.forms[0].val.value+"\" ";
    } else {
        inputstr += "value=\"\" ";
    }

	if((document.forms[0].disable) && document.forms[0].disable.checked) {
        inputstr += "readonly=\"readonly\" ";
    }

    inputstr += " />";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder(inputstr, 'text'));

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertPasswordbox()
{
    // Execute the mceTemplate command without UI this time
    ok = true;
    inputstr = "<input type=\"password\" class=\"input\" name=\"";

    if( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error'));
        ok = false;
    }

    if ( document.forms[0].required.checked ) {
        inputstr += name + "/required\" ";
    } else {
        inputstr += name + "\" ";
    }

    if ( document.forms[0].size.value != "" ) {
        inputstr += "size=\""+document.forms[0].size.value+"\" ";
    }

    if ( document.forms[0].maxchars.value != "" ) {
        inputstr += "maxlength=\""+document.forms[0].maxchars.value+"\" ";
    }

    if(document.forms[0].tabindex.value != "") {
        inputstr += "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    }

    if ( document.forms[0].val.value != "" ) {
        inputstr += "value=\""+document.forms[0].val.value+"\" ";
    } else {
        inputstr += "value=\"\" ";
    }

	/*
	if(document.forms[0].disable.checked) {
        inputstr += "disabled=\"disabled\" ";
    }
	*/

    inputstr += " />";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder(inputstr, 'password'));

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertTextarea() {
    // Execute the mceTemplate command without UI this time
    ok = true;
    inputstr = "<img src=\"js/tiny_mce/plugins/formular/img/el_textarea.gif\" alt=\"area ";

    if ( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error'));
        ok = false;
    }

    if ( document.forms[0].required.checked ) {
        inputstr += "name=\'" + name + "/required\' ";
    } else {
        inputstr += "name=\'" + name + "\' ";
    }

    if ( document.forms[0].cols.value != "" ) {
        inputstr += "cols=\'"+document.forms[0].cols.value+"\' ";
    } else {
        inputstr += "cols=\'20\' ";
    }

    if ( document.forms[0].rows.value != "" ) {
        inputstr += "rows=\'"+document.forms[0].rows.value+"\' ";
    } else {
        inputstr += "rows=\'3\' ";
    }

	if(document.forms[0].tabindex.value != "") {
        inputstr += "tabindex=\'"+document.forms[0].tabindex.value+"\' ";
    } else {
        inputstr += "tabindex=\'\' ";
    }

    inputstr += "text=" + document.forms[0].val.value;

    inputstr += "\" />";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, inputstr);

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertRadiobutton() {
    // Execute the mceTemplate command without UI this time
    ok = true;
    var rows = document.forms[0].rows.value;

    if( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error') + ' ' + tinyMCEPopup.editor.getLang('formular_dlg.one_step_back'));
        ok = false;
    }

	if(document.forms[0].tabindex.value != "") {
        var tabstat = "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    }
	else{
        var tabstat = "";
    }

    if ( document.forms[0].art.checked ) {
        var tag = "&nbsp;";
    } else {
        var tag = "<br />";
    }

    j = 0;
    k = 1;
	l = 2;
    var inputstr = "";
    var inputstr_ = "";

    for(i = 0; i < rows; i++) {
        var checked = false;

        inputstr_ = ""

        inputstr_ += "<input type=\"radio\" name=\"" + name + "\" value=\"" + document.forms[0].elements[j].value + "\" ";
        inputstr_ +=  tabstat;

		if ( document.forms[0].elements[k].checked ) {
            inputstr_ +=  " checked=\"checked\" ";
            checked = true;
        }

		if ( document.forms[0].elements[l].checked ) {
            inputstr_ +=  " disabled=\"disabled\" ";
        }

        inputstr_ += " />";
        inputstr_ = createImgPlaceholder(inputstr_, 'radio' + (checked? '_checked': ''));

        inputstr += inputstr_;
        inputstr += document.forms[0].elements[j].value + tag;
        j = j+3;
        k = k+3;
		l = l+3;
	}

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, inputstr);

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function editMultibutton() {
    // Execute the mceTemplate command without UI this time
    ok = true;

    if( document.sel_form2.name.value != "" ) {
        if(document.sel_form2.index.value != "") {
			var fillstr = 'F';
			var fieldnr = document.sel_form2.index.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = document.sel_form2.code.value;
        var name  = fillstr + document.sel_form2.name.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error'));
        ok = false;
    }

	if(document.sel_form2.index.value != "") {
        var tabstat = "tabindex=\""+document.sel_form2.index.value+"\" ";
    }
	else{
        var tabstat = "";
    }

    var inputstr = "";

    inputstr += "<input type=\"" + document.sel_form2.field.value + "\" name=\"" + name + "\" value=\"" + document.sel_form2.val.value + "\" ";
    inputstr +=  tabstat;

    var checked = false;

	if ( document.sel_form2.sel.checked ) {
            inputstr +=  " checked=\"checked\" ";
            checked = true;
    }

	if ( document.sel_form2.disable.checked ) {
            inputstr +=  " disabled=\"disabled\" ";
    }

    inputstr += " />";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder(inputstr, document.sel_form2.field.value + (checked? '_checked': '')));

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertCheckbox() {
    // Execute the mceTemplate command without UI this time
    ok = true;
    var rows = document.forms[0].rows.value;

    if ( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error') + ' ' + tinyMCEPopup.editor.getLang('formular_dlg.one_step_back'));
        ok = false;
    }

	if(document.forms[0].tabindex.value != "") {
        var tabstat = "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    }
	else{
        var tabstat = "";
    }

    if ( document.forms[0].art.checked ) {
        var tag = "&nbsp;";
    } else {
        var tag = "<br />";
    }

    j = 0;
    k = 1;
	l = 2;
    var inputstr = "";
    var inputstr_ = "";

    for(i = 0; i < rows; i++) {
        var checked = false;

        inputstr_ = "";
        inputstr_ += "<input type=\"checkbox\" name=\"" + name + "[]\" value=\"" + document.forms[0].elements[j].value + "\" ";
        inputstr_ +=  tabstat;

		if ( document.forms[0].elements[k].checked ) {
            inputstr_ +=  " checked=\"checked\" ";
            checked = true;
        }

		if ( document.forms[0].elements[l].checked ) {
            inputstr_ +=  " disabled=\"disabled\" ";
        }

        inputstr_ += " />";
        inputstr_  = createImgPlaceholder(inputstr_, 'checkbox' + (checked? '_checked': ''));

		inputstr += inputstr_;
        inputstr += document.forms[0].elements[j].value + tag;
        j = j+3;
        k = k+3;
		l=  l+3;
    }

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, inputstr);

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertListbox() {
    // Execute the mceTemplate command without UI this time
	ok = true;
    var rows = document.forms[0].rows.value;

    if ( document.forms[0].feldname.value != "" ) {
        if(document.forms[0].tabindex.value != "") {
			var fillstr = 'F';
			var fieldnr = document.forms[0].tabindex.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.forms[0].feldname.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error') + ' ' + tinyMCEPopup.editor.getLang('formular_dlg.one_step_back'));
        ok = false;
    }

	if(document.forms[0].tabindex.value != "") {
        var tabstat = "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    }
	else{
        var tabstat = "";
    }

    j = 0;
    var inputstr = "<select class=\"select\" " + tabstat + " name=\"" + name + "\" >";

    for(var i = 0; i < rows; i++) {
        var k = j+1;

        if (document.forms[0].elements[j].value != "") {
			inputstr += "<option value=\"" + document.forms[0].elements[j].value + "\"";
			if ( document.forms[0].elements[k].checked ) {
	            inputstr +=  "selected=\"selected\"";
	        }
	        inputstr +=  ">";
	        inputstr += document.forms[0].elements[j].value + "</option>";
	    }

        j = j+2;
	}

    inputstr += "</select>";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder(inputstr, 'dropdown'));

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function editListbox() {
    // Execute the mceTemplate command without UI this time
    ok = true;
    var rows = document.sel_form3.rows.value;

    if ( document.sel_form3.name.value != "" ) {
        if(document.sel_form3.index.value != "") {
			var fillstr = 'F';
			var fieldnr = document.sel_form3.index.value;
			var fillings = 3-fieldnr.length;
			for (var c = 0; c < fillings; c++){
				fillstr +=  '0';
			}
			fillstr += fieldnr + '_';
		}
		else {
			var fillstr = 'F000_';
		}
		var codex = createRandom();
        var name  = fillstr + document.sel_form3.name.value + codex;
    } else {
        tinyMCEPopup.alert(tinyMCEPopup.editor.getLang('formular_dlg.missing_fieldname_error'));
        ok = false;
    }

	if(document.sel_form3.index.value != "") {
        var tabstat = "tabindex=\""+document.sel_form3.index.value+"\" ";
    }
	else{
        var tabstat = "";
    }

    var inputstr = "<select class=\"select\" " + tabstat + " name=\"" + name + "\">";

	j = 2;
    for(i = 0; i < rows; i++) {
        var k = j+1;

        if (document.sel_form3.elements[j].value != "") {
			inputstr += "<option value=\"" + document.sel_form3.elements[j].value + "\"";
	        if ( document.sel_form3.elements[k].checked ) {
	            inputstr +=  "selected=\"selected\"";
	        }
	        inputstr +=  ">";
	        inputstr += document.sel_form3.elements[j].value+"</option>";
	    }

        j = j+2;
	}

    inputstr += "</select>";

    if ( ok ) {
        tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder(inputstr, 'dropdown'));

        // Close the dialog
        tinyMCEPopup.close();
    }
}

function insertSubmit() {
    // Execute the mceTemplate command without UI this time
	if(document.forms[0].tabindex.value != "") {
        var addstr = "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    } else { var addstr = ""; }

	if ( document.forms[0].disable.checked ) {
        var disable = " disabled=\"disabled\"";
    }
	else { var disable = ""; }

	tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder('<input type="submit" class=\"button\" name="submit" value="'+document.forms[0].val.value+'" '+ addstr + disable +' />', 'submit'));

    // Close the dialog
    tinyMCEPopup.close();
}

function insertReset() {
    // Execute the mceTemplate command without UI this time
    if(document.forms[0].tabindex.value != "") {
        var addstr = "tabindex=\""+document.forms[0].tabindex.value+"\" ";
    } else { var addstr = ""; }

	tinyMCEPopup.editor.execCommand('mceInsertContent', false, createImgPlaceholder('<input type="reset" class=\"button\" name="reset" value="'+document.forms[0].val.value+'" '+ addstr +' />', 'reset'));

    // Close the dialog
    tinyMCEPopup.close();
}

function cancelAction() {
    tinyMCEPopup.close();
}

/**
 *
 * @access public
 * @return void
 **/
function html2ImgAlt(str) {
    str = str.replace(/</g, '$leq');
    str = str.replace(/>/g, '$geq');
    str = str.replace(/"/g, '$quote');

    return str;
}

/**
 *
 * @access public
 * @return void
 **/
function imgAlt2Html(str) {
    str = str.replace(/\$leq/g, '<');
    str = str.replace(/\$geq/g, '>');
    str = str.replace(/\$quote/g, '"');

    return str;
}

/**
 *
 * @access public
 * @return void
 **/
function createImgPlaceholder(altStr, type) {
    return '<img src="js/tiny_mce/plugins/formular/img/el_' + type + '.gif" alt="dpgFormElement ' + html2ImgAlt(altStr) + '" />';
}

/**
 *
 * @access public
 * @return void
 **/
function getAttrFromImgAlt(imgAlt, attrName) {
    imgAlt = imgAlt2Html(imgAlt);
    var results = imgAlt.match(/(\w+)="([^"]*)"/gi);
    if (results) {
        for (i = 0; i < results.length; ++i) {
            regExpression = /(\w+)="([^"]*)"/i;
            regExpression.exec(results[i]);
            var _attrName = RegExp.$1;
            var _attrValue = RegExp.$2;
            if (_attrName.toLowerCase() == attrName.toLowerCase()) {
                return _attrValue;
            }
        }
    }
    return '';
}

/**
 *
 * @access public
 * @return void
 **/
function getTypeFromImgAlt(imgAlt) {
    imgAlt = imgAlt2Html(imgAlt);
    var results = imgAlt.match(/<input/gi);
    if (results)
        return 'input';

    var results = imgAlt.match(/<select/gi);
    if (results)
        return 'select';

    var results = imgAlt.match(/area/gi);
    if (results)
        return 'textarea';

    return '';
}

/**
 *
 * @access public
 * @return void
 **/
function getSelectOptionsFromImgAlt(imgAlt) {
    imgAlt = imgAlt2Html(imgAlt);
    var optionsArr = new Array();
    var results = imgAlt.match(/<option([^>]+)>([^<]+)<\/option>/gi);

    for (i = 0; i < results.length; ++i) {
        var regExpression = /<option([^>]+)>([^<]+)<\/option>/gi;
        regExpression.test(results[i]);
        regExpression.exec(results[i]);
        var _optionAttr = RegExp.$1;
        var _optionValue = RegExp.$2;
        optionsArr.push({value: _optionValue, selected: (_optionAttr.search(/selected="selected"/) != -1)});
    }
    return optionsArr;
}

/**
 *
 * @access public
 * @return void
 **/
function swapUp(downID, upID){
	var offset1 = '';
	var offset2 = false;
	var offset3 = false;

	if (document.getElementById('name_of_' + downID)) {
		if (document.getElementById('name_of_' + upID)) {
			offset1 = document.getElementById('name_of_' + upID).value;
			offset2 = document.getElementById('selected_of_' + upID).checked;
			if (document.getElementById('disabled_of_' + upID)) {
				offset3 = document.getElementById('disabled_of_' + upID).checked;
			}
		}
		else
			return false;

		document.getElementById('name_of_' + upID).value   	    = document.getElementById('name_of_' + downID).value;
		document.getElementById('selected_of_' + upID).checked  = document.getElementById('selected_of_' + downID).checked;

		if (document.getElementById('disabled_of_' + downID)) {
			document.getElementById('disabled_of_' + upID).checked  = document.getElementById('disabled_of_' + downID).checked;
		}

		document.getElementById('name_of_' + downID).value 	  	 = offset1;
		document.getElementById('selected_of_' + downID).checked = offset2;

		if (document.getElementById('disabled_of_' + upID)) {
			document.getElementById('disabled_of_' + downID).checked = offset3;
		}
	}

	return false;
}

/**
 *
 * @access public
 * @return void
 **/
function swapDown(upID, downID){
	var offset1 = '';
	var offset2 = false;
	var offset3 = false;

	if (document.getElementById('name_of_' + downID)) {
		if (document.getElementById('name_of_' + upID)) {
			offset1 = document.getElementById('name_of_' + upID).value;
			offset2 = document.getElementById('selected_of_' + upID).checked;
			if (document.getElementById('disabled_of_' + upID)) {
				offset3 = document.getElementById('disabled_of_' + upID).checked;
			}
		}
		else
			return false;

		document.getElementById('name_of_' + upID).value   	    = document.getElementById('name_of_' + downID).value;
		document.getElementById('selected_of_' + upID).checked  = document.getElementById('selected_of_' + downID).checked;

		if (document.getElementById('disabled_of_' + downID)) {
			document.getElementById('disabled_of_' + upID).checked  = document.getElementById('disabled_of_' + downID).checked;
		}

		document.getElementById('name_of_' + downID).value 	  	 = offset1;
		document.getElementById('selected_of_' + downID).checked = offset2;

		if (document.getElementById('disabled_of_' + upID)) {
			document.getElementById('disabled_of_' + downID).checked = offset3;
		}
	}

	return false;
}

tinyMCEPopup.onInit.add(init);