<?php
    session_start();

    // private functions

    require_once dirname(__FILE__) . "/../api/db_api.php";
    require_once dirname(__FILE__) . '/../functions.php';
    require_once dirname(__FILE__) . '/../plugins/plugins.php';

    $dpgcommunity_exists = dynpgPlugIn::plugin_Exists('DPGcommunity');

	if (!VerifyAccess()) {
		// check community login
		if ($dpgcommunity_exists && empty($_SESSION['dynpg_community_session_id'])) {
			header('Location: ./../index.php');
			exit;
		} elseif (!$dpgcommunity_exists) {
			header('Location: ./../index.php');
			exit;
		}
    }

    // connect db

        require_once '../config.php';
        require_once '../connectdb.php';

	// functions

    function popUpUrl()
    {
        $conformUri = Array('popUpResource' , 'orderby' , 'sort' , 'page' , 'limit' , 'query', 'refID', 'valueID', 'returnCall');

        $this_function_args = func_get_args();

        $query = implode('&amp;', array_map(create_function('$a, $b', 'return $a . "=" . urlencode($b);'), $conformUri, $this_function_args));

        foreach ($_GET as $param => $value) {
        	if (!in_array($param, $conformUri))
        		$query .= '&amp;' . $param . '=' . urlencode($value);
        }

        return $query;
    }

    /**
     * re_render_image()
     *
     * Renders the image $id using the global settings for uploaded
     * files and saves the new image under $pic_url or a copy.
     *
     * @param integer $id
     * @param boolean $community_file
     * @return boolean
     */
    function re_render_image($id, $community_file = false) {
        // check gd
            if (!extension_loaded("gd") || !function_exists("gd_info"))
                return false;

        // check wheater batch actions have to be applied
            if (empty($_POST['FILEUPLOAD_SIZE_X'])
                && empty($_POST['FILEUPLOAD_SIZE_Y'])
                && $_POST['FILEUPLOAD_SIZE_X_PC'] == 100
                && $_POST['FILEUPLOAD_SIZE_Y_PC'] == 100
                && $_POST['FILEUPLOAD_QUALITY'] == 100)
                return null;

        // read properties
            $new_x_px = empty($_POST['FILEUPLOAD_SIZE_X'])? 0: $_POST['FILEUPLOAD_SIZE_X'];
            $new_y_px = empty($_POST['FILEUPLOAD_SIZE_Y'])? 0: $_POST['FILEUPLOAD_SIZE_Y'];
            $new_x_pc = min(100, max($_POST['FILEUPLOAD_SIZE_X_PC'], 1));
            $new_y_pc = min(100, max($_POST['FILEUPLOAD_SIZE_Y_PC'], 1));
            $new_quality = min(100, max($_POST['FILEUPLOAD_QUALITY'], 1));
            $resize_rule = empty($_POST['FILEUPLOAD_SIZE_RULE'])? 'max': $_POST['FILEUPLOAD_SIZE_RULE'];
            $as_copy = !empty($_POST['FILEUPLOAD_AS_COPY']);

        // check gd version
            $GDinfo = gd_info();
            $GDversion = $GDinfo["GD Version"];
            $supported_types = Array();
            if (ImageTypes() & IMG_PNG)
                array_push($supported_types, "png");
            if (ImageTypes() & IMG_JPG)
                array_push($supported_types, "jpg", "jpeg");
            if (ImageTypes() & IMG_GIF)
                array_push($supported_types, "gif");
            if (empty($supported_types))
                return false;

        // deduce picture data
            $image = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='".mysql_real_escape_string($id)."'"));
            $pic_url = '../' . FORMS_IMAGES_DESTINATIONURL_ROOT . $image['URL'];
            $pic_type = strtolower(substr(strrchr($pic_url, '.'), 1));

            if (!file_exists($pic_url) || !in_array($pic_type, $supported_types))
                return false;

        // check if memory is available for image resizing
            if (!function_exists('setMemoryForImage')) {
                function setMemoryForImage(&$iInfo) {
                    // constants
                        $MB = 1048576;      // number of bytes in 1M
                        $K64 = 65536;       // number of bytes in 64K
                        $TWEAKFACTOR = 1.5; // threshold

                    // calculate necessary memory
                        $memoryNeeded = round(($iInfo[0] * $iInfo[1] * $iInfo['bits'] * $iInfo['channels'] / 8 + $K64) * $TWEAKFACTOR);

                    // if memory is less than 8 MB then always return true
                        if ($memoryNeeded / $MB < 8)
                            return true;

                    // try to get memory limit
                        $memoryLimit = @ini_get('memory_limit');
                        if (!empty($memoryLimit)) {
                            if (strpos(strtoupper($memoryLimit), 'M') !== false) {
                                $memoryLimit = preg_replace('/[^1-9]+/', '', $memoryLimit);
                                $memoryLimit = $memoryLimit * $MB;
                            }
                        } else {
                            // Memory limit is not available; we thus try to
                            // assume 64MB. This may be enought to rescale even large
                            // scale images. However, this is arbitrary.
                            $memoryLimit = 16 * $MB;
                        }

                    // try to increase memory limit
                        if (function_exists('memory_get_usage')
                            && (memory_get_usage() + $memoryNeeded) > $memoryLimit) {
                            $newLimit = round($memoryLimit
                                + ceil(memory_get_usage() + $memoryNeeded - $memoryLimit)) / $MB;

                            @ini_set('memory_limit', $newLimit . 'M');
                            return (@ini_get('memory_limit') == ($newLimit . 'M'));
                        } elseif (function_exists('memory_get_usage')) {
                            return ($memoryNeeded + memory_get_usage() < $memoryLimit);
                        } else {
                            return ($memoryNeeded < $memoryLimit - 2 * $MB);
                        }
                }
            }
            // get dimensions and data of image
            $size = getimagesize($pic_url);

            if (!setMemoryForImage($size))
                return -1;

        // everything is ok, we can apply the GD functionalities
            // create GD object
            if ($size[2] == 1)
    			$old_pic = ImageCreateFromGIF($pic_url);
    		elseif ($size[2] == 2)
                $old_pic = ImageCreateFromJPEG($pic_url);
            elseif ($size[2] == 3)
                $old_pic = ImageCreateFromPNG($pic_url);
            else
                return false;

            // change size of the image
            if ($new_x_px > 0 && $new_y_px > 0) {
                $width_px = $new_x_px;
                $height_px = $new_y_px;
                if ($resize_rule == 'max') {
                    if ($size[0] > $new_x_px) {
                        $width_px = $new_x_px;
                        $height_px = round(($width_px / $size[0]) * $size[1]);
                        if ($height_px > $new_y_px){
                            $height_px = $new_y_px;
                            $width_px = round(($height_px / $size[1]) * $size[0]);
                        }
                    }elseif ($size[1] > $new_y_px) {
                        $height_px = $new_y_px;
                        $width_px = round(($height_px / $size[1]) * $size[0]);
                        if ($width_px > $new_x_px){
                            $width_px = $new_x_px;
                            $height_px = round(($width_px / $size[0]) * $size[1]);
                        }
                    }
                }
            } elseif ($new_x_px > 0 || $new_y_px > 0) {
                if ($new_x_px > 0)
                    $width_px = $new_x_px;
                else
                    $width_px = round(($new_y_px / $size[1]) * $size[0]);
                if ($new_y_px > 0)
                    $height_px = $new_y_px;
                else
                    $height_px = round(($new_x_px / $size[0]) * $size[1]);
            } else {
                $width_px = round($size[0] * $new_x_pc / 100);
                $height_px = round($size[1] * $new_y_pc / 100);
            }

            // the image already has the correct size and quality is = 100
            $no_resize = false;
            if ($size[0] == $width_px && $size[1] == $height_px && $new_quality == 100)
                return true;
            if ($resize_rule == 'max' && $size[0] <= $width_px && $size[1] <= $height_px)
                if ($new_quality == 100)
                    return true;
                else
                    $no_resize = true;
            if ($no_resize) {
                $width_px = $size[0];
                $height_px = $size[1];
            }

            // check if memory is available for image resizing
            $_ = Array(
                0 => $width_px,
                1 => $height_px,
                'bits' => $size['bits'],
                'channels' => $size['channels']
            );
            if (!setMemoryForImage($_))
                return -1;

            // generate the new image
            $new_pic = ImageCreateTrueColor($width_px, $height_px);
            if ($size[2] == 3){   
                @imagealphablending( $new_pic, false );
                @imagesavealpha( $new_pic, true );
            }

            // change size
            ImageCopyResampled($new_pic, $old_pic, 0, 0, 0, 0, $width_px, $height_px, $size[0], $size[1]);

            // if copy is boolean true then create a dublicate of the current image
            if ($as_copy) {
                $dbh = new DBDynPGDatabaseHandle();
                $dbh->db_setTable('dynpg_cms_images');
                $dbh->db_insert(
                    Array(
                        $image['NAME'],
                        '',
                        $image['DESCR'] . $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_is_copy"],
                        $image['USERGROUP']
                    )
                );
                $iid = mysql_insert_id();
                $new_filename = '/' . ($community_file? 'community_': '') . 'imgfile' . $iid . '.' . $pic_type;
                $dbh->db_update(Array('URL' => $new_filename), $iid);
                $new_url = '../' . FORMS_IMAGES_DESTINATIONURL_ROOT . $new_filename;
            } else {
                $new_url = $pic_url;
            }

            // create new image
            if ($size[2] == 2) {
                ImageJPEG($new_pic, $new_url, $new_quality);
                imagedestroy($new_pic);
                imagedestroy($old_pic);
            } elseif ($size[2] == 3) {
                ImagePNG($new_pic, $new_url, $new_quality);
                imagedestroy($new_pic);
                imagedestroy($old_pic);
            } elseif ($size[2] == 1) {
                ImageGIF($new_pic, $new_url, $new_quality);
                imagedestroy($new_pic);
                imagedestroy($old_pic);
            } else {
                return false;
            }

        return true;
    }

    foreach ( $_GET as $key => $value ) {
        $_GET[$key] = addslashes(urldecode($value));
    }

    if ( empty( $_GET['popUpResource'] ) || preg_match('/[^a-zA-Z_]/', $_GET['popUpResource']) == 1 ) {
        $get_popUpResource = '__nil';
    } else {
        $get_popUpResource = $_GET['popUpResource'];
    }

	if(empty($_SESSION["LANGUAGE"])){ $_SESSION["LANGUAGE"]='de'; }

	include dirname(__FILE__) . '/../languages.inc.php';

	require './resources/' . $get_popUpResource . '/index.res.php';

    // validate _GET

    if ( empty( $_GET['sort'] ) ) {
        $get_alternate_sort = 'DESC';

        $_GET['sort'] = '';
    } else {
        $get_alternate_sort = $_GET['sort'] == 'DESC' ? 'ASC' : 'DESC';
    }

     if ( empty( $_GET['orderby'] ) ) {
        $get_orderby = $GLOBALS['_DPG_POPUP']['DEFAULT_ORDER_FIELD'];
    } else {
        $get_orderby = $_GET['orderby'];
    }

    if ( empty( $_GET['limit'] ) ) {
        $get_limit = '30';
    } else {
        $get_limit = $_GET['limit'];
    }

    if ( empty( $_GET['page'] ) ) {
        $get_page = '1';
    } else {
        $get_page = $_GET['page'];
    }

    if ( empty( $_GET['query'] ) ) {
        $get_search_query = '';
    } else {
        $get_search_query = $_GET['query'];
    }

    if ( empty( $_GET['refID'] ) ) {
        $get_refID = '';
    } else {
        $get_refID = $_GET['refID'];
    }

    if ( empty( $_GET['valueID'] ) ) {
        $get_valueID = '';
    } else {
        $get_valueID = $_GET['valueID'];
    }

    if ( empty( $_GET['returnCall'] ) ) {
        $get_returnCall = '';
    } else {
        $get_returnCall = $_GET['returnCall'];
    }

    if ( empty( $_GET['iFrameID'] ) ) {
        $get_iFrameID = '';
    } else {
        $get_iFrameID = $_GET['iFrameID'];
    }

    if ( !isset( $_GET['noEditor'] ) ) {
        $noEditor = false;
    } else {
        $noEditor = true;
    }

    // finished

    // maybe other ID fields

    if ( !empty( $_GET['refID'] ) ) {
        $GLOBALS['_DPG_POPUP']['REF_ID_ALIAS'] = $get_refID;
    }

    if ( !empty( $_GET['valueID'] ) ) {
        $GLOBALS['_DPG_POPUP']['VALUE_ID_ALIAS'] = $get_valueID;
    }

    // finished

    $SQL = Array('match' => '' , 'order' => '', 'limit' => '', 'group' => '');

    $SQL['order'] = 'ORDER BY `'.mysql_real_escape_string(str_replace('`','',$get_orderby)).'` ' . $get_alternate_sort;

    $SQL['limit'] = 'LIMIT ' . ( ( (integer)$get_page - 1) * (integer)$get_limit ) . ', ' .
                                   (integer)$get_limit;

    $SQL['group'] = (isset($_SESSION['popUp_list_filegroup']) && $_SESSION['popUp_list_filegroup'] != 'NULL' )? 'WHERE `USERGROUP` = \''.mysql_real_escape_string($_SESSION['popUp_list_filegroup']).'\'' : 'WHERE 1';

	$search_by_url = FALSE;

    if ( !empty($get_search_query) ) {
        $search_by_url = TRUE;

        $_POST['thisFormHash']      = md5('setOptions');
        $_POST['popUp_list_search'] = $get_search_query;
        $_POST['popUp_list_page']   = $get_page;
        $_POST['popUp_list_num']    = $get_limit;
    }

    if(!empty($_POST['thisFormHash'])){
        if ( $_POST['thisFormHash'] == md5('setOptions') ) {
            if ( !empty($_POST['popUp_list_search']) ) {
                array_walk($GLOBALS['_DPG_POPUP']['SQL_MATCH'], create_function('&$s', '$s = "`".mysql_real_escape_string(str_replace(\'`\', \'\', $s))."`";'));

                $SQL['match'] .= ', GREATEST( ';

                foreach ( $GLOBALS['_DPG_POPUP']['SQL_MATCH'] as $k => $row ) {
                    $SQL['like'][$k] = $row . ' LIKE ( \'%' . mysql_real_escape_string($_POST['popUp_list_search']) . '%\' )';
                }

                foreach ( $GLOBALS['_DPG_POPUP']['SQL_LIKE'] as $row ) {
                    $SQL['like'][] = $row . ' LIKE ( \'%' . mysql_real_escape_string($_POST['popUp_list_search']) . '%\' )';
                }

                $SQL['match'] .= implode(', ', $SQL['like']);

                if (count($GLOBALS['_DPG_POPUP']['SQL_MATCH']) > 0)
					$SQL['match'] .= ', MATCH ( '.implode(', ', $GLOBALS['_DPG_POPUP']['SQL_MATCH']).' ) AGAINST ( \''.mysql_real_escape_string($_POST['popUp_list_search']).'\' )';

                $SQL['match'] .= ' ) AS mySearch ';

                if ( !$search_by_url ) {
                    $SQL['order'] = 'ORDER BY mySearch DESC';
                }

                $SQL['order'] = ' HAVING mySearch > 0.001 ' . $SQL['order'];

                $get_search_query = $_POST['popUp_list_search'];

                $GLOBALS['_DPG_POPUP']['LIST_ROW_NAMES']['mySearch'] = Array($GLOBALS["lang_dpg"]->str["lang_popup_hits"], '');
            }

            $get_page  = $_POST['popUp_list_page'];

            $get_limit = $_POST['popUp_list_num'];

            $SQL['limit'] = 'LIMIT ' . ( ( (integer)$_POST['popUp_list_page'] - 1) * (integer)$_POST['popUp_list_num'] ) . ', ' .
                                           (integer)$_POST['popUp_list_num'] ;

			if( isset($_POST['popUp_list_group']) ){
				$SQL['group'] = ($_POST['popUp_list_group'] == 'NULL')? 'WHERE 1' : 'WHERE `USERGROUP` = \''.mysql_real_escape_string($_POST['popUp_list_group']).'\'';
				$_SESSION['popUp_list_filegroup'] = $_POST['popUp_list_group'];
			}

		}
    }

    $GLOBALS['_DPG_POPUP']['SQL_QUERY'] = str_replace('$$MATCH', $SQL['match'], $GLOBALS['_DPG_POPUP']['SQL_QUERY']);
    $GLOBALS['_DPG_POPUP']['SQL_QUERY'] = str_replace('$$ORDERBY', $SQL['order'], $GLOBALS['_DPG_POPUP']['SQL_QUERY']);
    $GLOBALS['_DPG_POPUP']['SQL_QUERY'] = str_replace('$$LIMIT', $SQL['limit'], $GLOBALS['_DPG_POPUP']['SQL_QUERY']);
    $GLOBALS['_DPG_POPUP']['SQL_QUERY'] = str_replace('$$GROUP', $SQL['group'], $GLOBALS['_DPG_POPUP']['SQL_QUERY']);

    $Sucessfull = TRUE;

    $_mysql_Tbl_cms_bin = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_bin` WHERE `bin_id` = 1"), MYSQL_ASSOC);
    $_mysql_Tbl_cms_bin['set_filetypes'] = explode(', ', $_mysql_Tbl_cms_bin['set_filetypes']);

    if(!empty($_POST["STATUS"]) && ($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx')){
        switch($_POST["TYPE"]){
            case $GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"]:

                $Uploaded_file      = FALSE;
                $add_to_group       = mysql_real_escape_string((($_POST["popUp_list_group"] == 'NULL') ? 1: $_POST["popUp_list_group"]));
                $NewImageNumber_all = "";
                $output             = "";

                $n = 0;

                while($_POST["FILE_COUNT"] > $n) {
                    $img = $_FILES["NEW_IMAGE_URL"]["name"][$n];
                    $file_extension = strtolower(substr($img, (strpos(strrev($img), ".")*(-1)) ));
                    unset($img);

                    $description_check = empty($_POST["NEW_IMAGE_DESCR_".$n])? "add for CheckSlashes" : $_POST["NEW_IMAGE_DESCR_".$n];

                    if(!(empty($_FILES["NEW_IMAGE_URL"]["name"][$n])) && CheckSlashes($_POST["NEW_IMAGE_NAME_".$n]) && CheckSlashes($description_check) ) {
                        if ( ($_FILES["NEW_IMAGE_URL"]["size"][$n]>=($_mysql_Tbl_cms_bin['set_maxupload_kb']*1024)) ) {
                            $output.="<br />- ".$_FILES["NEW_IMAGE_URL"]["name"][$n]." (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." ".($n+1).": ".$GLOBALS["lang_dpg"]->str["lang_fileupload_reason_1"].")";
                            $Sucessfull = TRUE;
                        }
                        else if ( !in_array($file_extension, $_mysql_Tbl_cms_bin['set_filetypes']) ) {
                            $output.="<br />- ".$_FILES["NEW_IMAGE_URL"]["name"][$n]." (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." ".($n+1).": ".$GLOBALS["lang_dpg"]->str["lang_fileupload_reason_2"].")";
                            $Sucessfull = TRUE;
                        } else {
                            $file_extension = "." . mysql_real_escape_string($file_extension);

                            $file_name = mysql_real_escape_string($_POST["NEW_IMAGE_NAME_".$n]);
                            $file_desc = mysql_real_escape_string($_POST["NEW_IMAGE_DESCR_".$n]);

                            if(empty($_POST["NEW_IMAGE_ORIGNAME_{$n}"])) {
                                $RES = mysql_query("INSERT INTO `dynpg_cms_images` (`NAME`, `URL`, `DESCR`, `USERGROUP`)
                                                        VALUES ('".$file_name."','/".(empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"])?'':'community_')."imgfile[-]".$file_extension."','".$file_desc."','".$add_to_group."')");

                                $NewImageNumber = mysql_insert_id();
                                $ROW = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='$NewImageNumber'"));
                                $new_filename = mysql_real_escape_string(str_replace("[-]", $NewImageNumber, $ROW->URL));
                                mysql_query("UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`URL`='$new_filename' WHERE `id`='$NewImageNumber'");
                                $file_path = $new_filename;
                            } else {
                                $file_path = (empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"])?'':'community_').$_FILES["NEW_IMAGE_URL"]["name"][$n];
                                if (file_exists("./../" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" .$file_path)) {
                                    $file_path = str_replace($file_extension, '', $file_path) . '_' . uniqid('') . $file_extension;
                                }

                                $RES = mysql_query("INSERT INTO `dynpg_cms_images` (`NAME`, `URL`, `DESCR`, `USERGROUP`)
                                                        VALUES ('".$file_name."','/".mysql_real_escape_string($file_path)."','" . $file_desc . "','".$add_to_group."')");
                                $NewImageNumber = mysql_insert_id();
                             }

                            @mysql_free_result($RES);

                            mysql_query("INSERT INTO `dynpg_cms_images_rights`(`USERID`, `PARENT`, `SECTION`, `CREATE`, `DELETE`, `CHANGE`)
                                            VALUES ('".$_SESSION["ID"]."', 'ARTICLE', '{$NewImageNumber}', 'TRUE', 'TRUE', 'TRUE')");

                            $res = move_uploaded_file($_FILES["NEW_IMAGE_URL"]["tmp_name"][$n],
                                    "./../" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" . $file_path);

                            chmod("./../" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" . $file_path, 0644);

                            $render = re_render_image($NewImageNumber, !empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"]));

                            if ($render < 0)
							    $output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_4"] . ")";
							elseif($render === false)
    							$output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_5"] . ")";

                            $NewImageNumber_all .= $NewImageNumber . ", ";
                            $Uploaded_file = TRUE;
                            $Sucessfull    = TRUE;
                        }
                    } else {
                        $output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_3"] . ")";
                        $Sucessfull = TRUE;
                    }
                    $n++;
                }

                if ($n == 0){
                    $Sucessfull = FALSE;
                }

            // end case
            break;
            default:
                // Default ~ User has no rights
                $Sucessfull = FALSE;
            break;
        }
    }
?>
<!DOCTYPE html>

<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">

		<title>
			DynPG - Dynamic Pages - <?php echo $GLOBALS['_DPG_POPUP']['TITLE']; ?>
		</title>

        <!-- TinyMCE PopUp functions -->
        <?php
        if(!$noEditor){
            echo '<script type="text/javascript" src="../js/tiny_mce/tiny_mce_popup.js"></script>';
        }
        ?>
		<link rel="stylesheet" type="text/css" href="../css/tool.css">
		<link rel="stylesheet" type="text/css" href="resources/<?php echo $get_popUpResource; ?>/style.css">

		<!-- different JavaScript functions -->
        <script src="../js/java.js" type="text/javascript"></script>

		<!-- jQuery repository -->
        <script src="../js/jquery.js" type="text/javascript"></script>
        <script src="../js/jquery-loading-effects.js" type="text/javascript"></script>
        <script src="../js/jquery.md5.js" type="text/javascript"></script>

        <!-- JavaScript sorting and dynamic layers -->
        <script src="../js/hwnd.js" type="text/javascript"></script>
        <script src="../js/table-sort.js" type="text/javascript"></script>

		<!-- popup JS -->
        <script src="resources/<?php echo $get_popUpResource; ?>/script.js" type="text/javascript"></script>

        <script type="text/javascript">
        <!--
            var iFrameID = '<?php print $get_iFrameID; ?>';

            var FileBrowserDialogue = {
                init : function () {
                    $("#container").css('opacity', 0.2);
                    $("#loadingBar").css('top', 50);
                    $("#loadingBar").css('left', Math.max(50, Math.floor($(window).width() / 2) + $(window).scrollLeft() - $("#loadingBar").width() / 2));
                    $("#loadingBar").css('display', 'block');
                }
            }
            if(!/msie/.test(navigator.userAgent.toLowerCase()) && typeof tinyMCEPopup !== "undefined" && typeof tinyMCEPopup.getWindowArg("tinymce") !== "undefined") {
                tinyMCEPopup.onInit.add(FileBrowserDialogue.init, FileBrowserDialogue);
            }

            $(document).ready(function() {
                if (iFrameID != '') {
                    $(this).bind('dpgCloseBackendPopup', function(e){
                        $('#CONTAINER_' + iFrameID, parent.document).fadeOut('fast', function(){
                            $('#CONTAINER_' + iFrameID, parent.document).remove();
                        });
                        if ($('.multifunctionLayer:visible', parent.document).size() <= 1) {
                            $('#dynamic-container', parent.document).fadeOut('fast');
                        }
                    });
                }
                if (!/msie/.test(navigator.userAgent.toLowerCase()) && typeof tinyMCEPopup !== "undefined" && typeof tinyMCEPopup.getWindowArg("tinymce") === "undefined") {
                    FileBrowserDialogue.init();
                }
            });

            $(window).load(function() {
                if (!/msie/.test(navigator.userAgent.toLowerCase()))
                    showContent();
            });

            function showContent() {
                $('#loadingBar').fadeOut(500);
                $('#container').fadeTo('fast', 1);
            }

            function closePopup() {
                if(typeof tinyMCEPopup !== "undefined" && typeof tinyMCEPopup.getWindowArg("tinymce") !== "undefined"){
                    tinyMCEPopup.close();
                }else{
                    if (iFrameID != '') {
                        $(document).trigger('dpgCloseBackendPopup');
                    } else {
                        window.close();
                    }
                }
                return false;
            }

            function insertContentToParent(param1, param2, param3, param4, param5, param6) {
                if(typeof tinyMCEPopup !== "undefined" && typeof tinyMCEPopup.getWindowArg("tinymce") !== "undefined"){
                    InsertTextToParent(param1, param2, param3, param4, param5, param6);
                }else{
                    try {
                        InsertTextToParent(param1, param2, param3, param4, param5, param6);
                    } catch(e) {
                        alert('ERROR\r\nAn error occured. Reason: the popup is deprecated and thus inserting chosen content failed.\r\n' + e.message);
                    }
                }
                return false;
            }

            function jv_open_file_upload_settings() {
                var formObj = document.forms['SUBMIT_NEW_IMAGE'];

                formObj.FILEUPLOAD_SIZE_X.value = $('#save_size_x').val();
                formObj.FILEUPLOAD_SIZE_Y.value = $('#save_size_y').val();
                formObj.FILEUPLOAD_SIZE_X_PC.value = $('#save_size_x_pc').val();
                formObj.FILEUPLOAD_SIZE_Y_PC.value = $('#save_size_y_pc').val();
                formObj.FILEUPLOAD_QUALITY.value = $('#save_size_quality').val();
                formObj.FILEUPLOAD_SIZE_RULE[0].checked = $('#save_size_rule').val() == 'max';
                formObj.FILEUPLOAD_SIZE_RULE[1].checked = $('#save_size_rule').val() == 'exa';
                formObj.FILEUPLOAD_AS_COPY.checked = $('#save_size_copy').val() == 1;

                $("#dynamic-container").css('height', $(document).height() + 'px');
                $("#dynamic-container").css('width', $(document).width()-20 + 'px');
                $("#dynamic-container").css('display', 'block');
                $('#dynamic-container').fadeTo('fast', 0.7);

            	$("#fileupload_settings").css('top', 50);
                $("#fileupload_settings").css('left', Math.max(50, Math.floor($(window).width() / 2) - 20 + $(window).scrollLeft() - $("#fileupload_settings").width() / 2));

                $('#fileupload_settings').slideDown('slow');

                return false;
            }

            function jv_save_dialog() {
                var formObj = document.forms['SUBMIT_NEW_IMAGE'];

                $('#save_size_x').val(formObj.FILEUPLOAD_SIZE_X.value);
                $('#save_size_y').val(formObj.FILEUPLOAD_SIZE_Y.value);
                $('#save_size_x_pc').val(formObj.FILEUPLOAD_SIZE_X_PC.value);
                $('#save_size_y_pc').val(formObj.FILEUPLOAD_SIZE_Y_PC.value);
                $('#save_size_quality').val(formObj.FILEUPLOAD_QUALITY.value);
                $('#save_size_rule').val(formObj.FILEUPLOAD_SIZE_RULE[0].checked? 'max': 'exa');
                $('#save_size_copy').val(formObj.FILEUPLOAD_AS_COPY.checked? '1': '');
                return close_dialog('fileupload_settings');
            }
        //-->
        </script>
	</head>

	<body>

	<div id="loadingBar" style="display:none;"><img src="../pictures/loading_bar.gif" alt="loading..." /></div>

	<div id="dynamic-container" style="filter:alpha(opacity=10); -moz-opacity: 0.1; opacity: 0.1; width: 100%; position: absolute; z-index: 100; background-color: white; display: none;"></div>

    <div id="container">

    <div id="dynpg_popup_title"><?php echo $GLOBALS['_DPG_POPUP']['TITLE']; ?><a href="#" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_close"]; ?>" onclick="return closePopup();"><img src="../pictures/imgbtn_closepopup.gif" alt="close popup" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_close"]; ?>" /></a></div>

    <?php echo $GLOBALS["lang_dpg"]->str["lang_popup_howtoSelect"]; ?>

    <div id="dynpg_popup_navigation">
        <table cellspacing="0" class="Table_popUp_ListOptions">
				<tr class="Table_popUp_ListOptions01">
					<td class="Table_popUp_ListOptions_01" id="ListOptions_01" <?php if($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx'){ echo 'onclick="document.getElementById(\'fileUpload\').style.display = \'none\';document.getElementById(\'ListOptions_02\').style.backgroundColor = \'e7f3ff\';document.getElementById(\'searchForm\').style.display = \'block\';document.getElementById(\'ListOptions_01\').style.backgroundColor = \'c6e7ff\';"'; }?>>
						<?php
                            $text = $GLOBALS["lang_dpg"]->str["lang_popup_showOptions"];
                            if($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx'){
                            	$text = '<a href="#" onclick="return false;">'.$text.'</a>';
                            }
                            echo $text;
                        ?>
					</td>
					<td class="Table_popUp_ListOptions_02" id="ListOptions_02" <?php if($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx'){ echo 'onclick="document.getElementById(\'fileUpload\').style.display = \'block\';document.getElementById(\'ListOptions_02\').style.backgroundColor = \'c6e7ff\';document.getElementById(\'searchForm\').style.display = \'none\';document.getElementById(\'ListOptions_01\').style.backgroundColor = \'e7f3ff\';"'; }?>>
                        <?php
                        if($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx'){
                        	echo '<a href="#" onclick="return false;">';
                            echo $GLOBALS["lang_dpg"]->str["lang_fileupload_fileUpload"];
                            echo '</a>';
                        }else{
                        	echo '&nbsp;';
                        }
                        ?>
                    </td>
				</tr>
				<tr>
					<td nowrap="nowrap" colspan="2" class="Table_popUp_ListOptions_03">
					   <?php
                       if($get_popUpResource == 'imagesURL' || $get_popUpResource == 'images' || $get_popUpResource == 'imagesEx'){
                         if($Sucessfull && !empty($_POST["STATUS"]) && !empty($output)){
                                echo "
                                <table border=\"0\" cellpadding=\"8\" cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
                                <tr>
                                    <td bgcolor=\"#e5f3fb\" valign=\"top\">
                                        <img src=\"../pictures/innertext_info.jpg\"><br />";
                                        if($Uploaded_file){
                                            echo "
                                            <span class=\"green\">
                                            <i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1a"].   $NewImageNumber_all.$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1b"]."</i></span><br /><br /><span class=\"red\"><i>";
                                        }
                                        else {
                                            echo "
                                            <span class=\"red\"><i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_2"]."<br /><br />";
                                        }
                                        echo
                                        $GLOBALS["lang_dpg"]->str["lang_fileupload_message_3a"].$output." <br /><br />".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_3b"]."</span>
                                    </td>
                                </tr>
                                </table><br />
                                ";
                            }elseif($Sucessfull && !empty($_POST["STATUS"])){
                                echo "
                                <table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
                                <tr>
                                    <td bgcolor=\"#e5f3fb\" valign=\"top\">
                                        <img src=\"../pictures/innertext_info.jpg\"><br />
                                        <span class=\"green\">
                                         <i>
                                            ".$GLOBALS["lang_dpg"]->str["lang_message_success"]."<br />";
                                            if(!empty($NewImageNumber) )
                                                echo $GLOBALS["lang_dpg"]->str["lang_fileupload_message_4a"].$NewImageNumber_all.$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1b"];
                                            echo "
                                         </i>
                                        </span>
                                    </td>
                                </tr>
                                </table><br />
                                ";
                            }elseif(!empty($_POST["STATUS"])){
                                echo "
                                <table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
                                <tr>
                                    <td bgcolor=\"#e5f3fb\" valign=\"top\">
                                        <img src=\"../pictures/innertext_info.jpg\"><br />
                                        <span class=\"red\"><i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5a"].$_mysql_Tbl_cms_bin['set_maxupload_kb'].$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5b"].strtoupper(implode(", ",$_mysql_Tbl_cms_bin['set_filetypes'])).$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5c"]."</i></span>
                                         <br />
                                         <span class=\"red\">&raquo;<span class=\"CourierNewFont\"> <i>Debug:</i> ";print_r($_FILES);echo"</span>&laquo;<br /><br />
                                         <b></b><br />
                                         </i>
                                         </span>
                                    </td>
                                </tr>
                                </table><br />
                                ";
                            }
                         ?>
                       <div id="fileUpload" style="display:none;">
                            <form action="<?php echo $_SERVER['PHP_SELF']?>?<?php echo popUpUrl($get_popUpResource, '', '', '', '', '', $get_refID, $get_valueID, $get_returnCall); ?>" enctype="multipart/form-data" method="post" name="SUBMIT_NEW_IMAGE" accept-charset="ISO-8859-1" style="margin: 0;">
                             <div id="fileupload_settings" class="multifunctionLayer">
                                <input type="hidden" id="save_size_x" value="" />
                                <input type="hidden" id="save_size_y" value="" />
                                <input type="hidden" id="save_size_x_pc" value="100" />
                                <input type="hidden" id="save_size_y_pc" value="100" />
                                <input type="hidden" id="save_size_rule" value="max" />
                                <input type="hidden" id="save_size_quality" value="100" />
                                <input type="hidden" id="save_size_copy" value="" />

                                <fieldset>
                                    <legend><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_settings"]; ?></legend>

                                    <table border="0" Cellpadding="2" Cellspacing="0" style="width: 98%;" class="InnerWebsiteTableTransparent">
                                     <tr bgcolor="#c3e6fa">
                                      <td width="100" valign="top"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_size"]; ?></b></td>
                                      <td nowrap="nowrap">
                                        <p style="margin: 1px;"><input type="text" value="" name="FILEUPLOAD_SIZE_X" style="width: 40px;" class="TextFieldStyleWhite" /> X
                                        <input type="text" value="" name="FILEUPLOAD_SIZE_Y" style="width: 40px;" class="TextFieldStyleWhite" /> px</p>

                                        <p style="margin: 1px;"><input type="text" value="100" name="FILEUPLOAD_SIZE_X_PC" style="width: 40px;" class="TextFieldStyleWhite" /> X
                                        <input type="text" value="100" name="FILEUPLOAD_SIZE_Y_PC" style="width: 40px;" class="TextFieldStyleWhite" /> %</p>
                                      </td>
                                      <td align="left" valign="top" nowrap="nowrap" width="100%">
                                        <p style="margin: 1px;">
                                            <input type="radio" name="FILEUPLOAD_SIZE_RULE" value="max" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_size_max"]; ?><br />
                                            <input type="radio" name="FILEUPLOAD_SIZE_RULE" value="exa" checked="checked" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_size_exa"]; ?>
                                        </p>
                                      </td>
                                     </tr>
                                     <tr bgcolor="#e5f3fb">
                                      <td width="100"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_quality"]; ?></b></td>
                                      <td colspan="2">
                                        <?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_value"]; ?>
                                        <input type="text" value="100" maxlength="3" name="FILEUPLOAD_QUALITY" style="width: 35px; text-align: center;" class="TextFieldStyleWhite" />
                                      </td>
                                     </tr>
                                     <tr bgcolor="#c3e6fa">
                                      <td colspan="3">
                                        <input type="checkbox" value="1" name="FILEUPLOAD_AS_COPY" />
                                        <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_copy"]; ?>
                                      </td>
                                     </tr>
                                     <tr bgcolor="#e5f3fb">
                                      <td align="left" style="padding-top: 5px;"><input type="button" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_abort_button"]; ?>" onclick="return close_dialog('fileupload_settings');"></td>
                                      <td align="right" style="padding-top: 5px;" colspan="2"><input type="button" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_ok_button"]; ?>" onclick="return jv_save_dialog();"></td>
                                     </tr>
                                    </table>
                                </fieldset>
                             </div>

                             <span id="upload">
                                <table border="0" Cellpadding="3" Cellspacing="0" style="width: 100%;" class="InnerWebsiteTableTransparent">
                                    <tr bgcolor="#c3e6fa">
                                        <td>
                                            <b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_uploadField"]; ?></b>
                                        </td>
                                        <td style="width: 100%;">
                                            <input type="file" size="40" name="NEW_IMAGE_URL[0]" style="float: left;" class="TextFieldStyleWhite" onchange="var file_name = this.value;var pos = file_name.lastIndexOf('\\');if(pos == -1){pos = file_name.lastIndexOf('/');}var pos2 = file_name.lastIndexOf('.');var num = pos2 - pos;var name = file_name.substr(pos+1, num-1);document.SUBMIT_NEW_IMAGE['NEW_IMAGE_NAME_'+ document.SUBMIT_NEW_IMAGE.FILE_COUNT.value].value = name;document.SUBMIT_NEW_IMAGE.FILE_COUNT.value++;" />
                                        </td>
                                        <td>
                                            <div style="float: right; margin: 0;">
                                                <img src="../pictures/btn_config_fileupload.png" title="<?php print $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_settings"]; ?>" alt="settings" style="cursor: pointer;" onclick="return jv_open_file_upload_settings();" />
                                            </div>
                                        </td>
                                    </tr>
                                    <tr bgcolor="#e5f3fb">
                                        <td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_titleField"]; ?></b></td><td colspan="2"><input type="text" size="55" name="NEW_IMAGE_NAME_0" class="TextFieldStyleWhite" /></td>
                                    </tr>
                                    <tr bgcolor="#c3e6fa">
                                        <td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_descField"]; ?></b></td><td colspan="2"><input type="text" size="55" name="NEW_IMAGE_DESCR_0"  class="TextFieldStyleWhite" />
                                        </td>
                                    </tr>
                                    <tr bgcolor="#e5f3fb">
                                        <td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_groupField"]; ?></b></td>
                                        <td colspan="2">
                                            <?php
                                                $tmpText = $GLOBALS["lang_dpg"]->str["lang_popup_all_groups"];
                                                $GLOBALS["lang_dpg"]->str["lang_popup_all_groups"] = $GLOBALS["lang_dpg"]->str["lang_filegroups_no_maingroup"];
                                                if (file_exists('./resources/' . $get_popUpResource . '/group_treestruct.php'))
                                                        include './resources/' . $get_popUpResource . '/group_treestruct.php';
                                                $GLOBALS["lang_dpg"]->str["lang_popup_all_groups"] = $tmpText;
                                            ?>
                                        </td>
                                    </tr>
                                    <tr bgcolor="#c3e6fa">
                                        <td>&nbsp;</td>
                                        <td colspan="2">
                                            <input type="checkbox" value="1" name="NEW_IMAGE_ORIGNAME_0" style="margin: 0;" />
                                            <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_origName"]; ?>
                                        </td>
                                    </tr>
                                    <?php
                                    if($dpgcommunity_exists){
                                    ?>
                                        <tr bgcolor="e5f3fb">
                                            <td>&nbsp;</td>
                                            <td colspan="2">
                                                <input type="checkbox" value="1" name="NEW_IMAGE_COMMUNITY_0" style="margin: 0;" />
                                                <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_communityName"]; ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    ?>
                                </table>
                            </span>

                            <table width="100%">
                                <tr>
                                    <td align="right">
                                        <input type="submit" name="submit" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"]; ?>" />
                                    </td>
                                </tr>
                            </table>

                            <input type="hidden" name="FILE_COUNT" value="0" />
                            <input type="hidden" value="<?php echo dynpg_htmlentities_rigid($GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"],ENT_COMPAT,true); ?>" name="TYPE">
                            <input type="hidden" value="<?php if (!empty($aid)) echo $aid; ?>" name="CHGID">
                            <input type="hidden" value="SUBMITTED" name="STATUS">
                            </form>
                       </div>
                       <?php
                       }
                       ?>
                       <div id="searchForm">
                            <form action="<?php echo $_SERVER['PHP_SELF']?>?<?php echo popUpUrl($get_popUpResource, '', '', '', '', '', $get_refID, $get_valueID, $get_returnCall); ?>" method="post" name="dynpg_popUp_listOptions" accept-charset="ISO-8859-1">
                            <?php echo $GLOBALS["lang_dpg"]->str["lang_popup_gotoPage"]; ?> <input type="text" value="<?php echo (string)$get_page ?>" name="popUp_list_page" id="popUp_list_page" maxlength="5" class="Table_popUp_ListOptions_textfield" />,
    						<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_show"]; ?> <input type="text" value="<?php echo (string)$get_limit ?>" name="popUp_list_num" id="popUp_list_num" maxlength="10" class="Table_popUp_ListOptions_textfield" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_popup_entries"]; ?>
    						<input type="image" align="middle" src="../pictures/_all_refresh.gif" alt="Absenden" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_reload"]; ?>" name="popUp_list_submit" id="popUp_list_submit" class="Table_popUp_ListOptions_button" />
    						<p style="margin : 3px;"></p>
    						<table id="transparentHelper" border="0" cellpadding="0" cellspacing="0" style="font-size : 10px;">
    							<?php if (file_exists('./resources/' . $get_popUpResource . '/group_treestruct.php')) { ?>
    							<tr>
    								<td>
    									<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_searchgroup"]; ?>
    								</td>
    								<td style="padding-left:10px;">
    									<?php
    										if (file_exists('./resources/' . $get_popUpResource . '/group_treestruct.php'))
    											include './resources/' . $get_popUpResource . '/group_treestruct.php';
    									?>
    									<p style="margin : 3px;"></p>
    								</td>
    							</tr>
    							<?php } ?>
    							<tr>
    								<td>
    									<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_searchkey"]; ?>
    								</td>
    								<td style="padding-left:10px;">
    									<p style="margin : 3px;"></p><input type="text" value="<?php echo $get_search_query; ?>" name="popUp_list_search" id="popUp_list_search" maxlength="255" style="width: 180px;" class="Table_popUp_ListOptions_textfield" />
    									<input type="image" align="middle" src="../pictures/_all_search.gif" alt="Absenden" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_search"]; ?>" height="24" width="24" name="popUp_list_submit" id="popUp_list_submit" class="Table_popUp_ListOptions_button" />
    								</td>
    							</tr>
    						</table>
    						<a href="<?php echo $_SERVER['PHP_SELF'] ?>?<?php echo popUpUrl($get_popUpResource, $get_orderby, $_GET['sort'], ($get_page > 1) ? $get_page - 1 : 1, $get_limit, $get_search_query, $get_refID, $get_valueID, $get_returnCall); ?>" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_back"]; ?>" target="_self"><?php echo $GLOBALS["lang_dpg"]->str["lang_popup_back"]; ?></a> | <a href="<?php echo $_SERVER['PHP_SELF'] ?>?<?php echo popUpUrl($get_popUpResource, $get_orderby, $_GET['sort'], $get_page + 1, $get_limit, $get_search_query, $get_refID, $get_valueID, $get_returnCall); ?>" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_next"]; ?>" target="_self"><?php echo $GLOBALS["lang_dpg"]->str["lang_popup_next"]; ?></a>
                            <input type="hidden" name="thisFormHash" id="thisFormHash" value="<?php echo md5('setOptions'); ?>" />
                            </form>
					   </div>
                    </td>
				</tr>
        </table>
    </div>

    <div id="dynpg_popup_dboutput">
        <table cellspacing="1" class="popUp_Custom_FileList">

            <?php
                $mysql_result = mysql_query( $GLOBALS['_DPG_POPUP']['SQL_QUERY'] );

                $nl = "\n";

                echo '<tr class="popUp_Custom_FileList_Head">' . $nl;

                foreach ( $GLOBALS['_DPG_POPUP']['LIST_ROW_NAMES'] as $key => $value ) {
                    echo '	<td class="popUp_Custom_FileList">' . $nl .
                    	 '		<p style="font-weight:bold;"><a href="'.$_SERVER['PHP_SELF'].'?' . popUpUrl($get_popUpResource, $key, $get_alternate_sort, $get_page, $get_limit, $get_search_query, $get_refID, $get_valueID, $get_returnCall) . '">'. $value[0] .'</a></p>' . $nl .
                    	 '	</td>';
                }

                echo '</tr>';

                echo '<tr onMouseOver="switchCssClass(this, \'popUp_Custom_FileList_Alt_02\');" onMouseOut="switchCssClass(this, \'popUp_Custom_FileList_Alt_01\');" class="popUp_Custom_FileList_Alt_01">' . $nl;
                echo '	<td colspan="' . count($GLOBALS['_DPG_POPUP']['LIST_ROW_NAMES']) . '" nowrap="nowrap" class="popUp_Custom_FileList" onclick="return insertContentToParent(\''.$GLOBALS["lang_dpg"]->str["lang_popup_pleaseChoose"].'\', \''.$GLOBALS['_DPG_POPUP']['VALUE_ID_ALIAS'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_EMPTY'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_ALIAS'].'\', '.(($_GET['popUpResource'] == 'texts') ? '\'\', \'NEWCHG_TEXT\', ': '').' new Array() );"><a href="#" onclick="return insertContentToParent(\''.$GLOBALS["lang_dpg"]->str["lang_popup_pleaseChoose"].'\', \''.$GLOBALS['_DPG_POPUP']['VALUE_ID_ALIAS'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_EMPTY'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_ALIAS'].'\','.(($_GET['popUpResource'] == 'texts') ? '\'\', \'NEWCHG_TEXT\', ': '').' new Array() );"><strong>'.$GLOBALS["lang_dpg"]->str["lang_popup_noEntry"].'</strong></a></td>' . $nl;
                echo '</tr>';

                if ( !mysql_num_rows($mysql_result) ) {
                    if ( (integer)$get_page > 1 ) {
                        $mayWrongPage = ' <br />' . $GLOBALS["lang_dpg"]->str["lang_popup_message_2"] . ' ' . $get_page . '.';
                    } else {
                        $mayWrongPage = '';
                    }

                    echo '<tr onMouseOver="switchCssClass(this, \'popUp_Custom_FileList_Alt_02\');" onMouseOut="switchCssClass(this, \'popUp_Custom_FileList_Alt_01\');" class="popUp_Custom_FileList_Alt_01">' . $nl;
                    echo '	<td colspan="' . count($GLOBALS['_DPG_POPUP']['LIST_ROW_NAMES']) . '" nowrap="nowrap" class="popUp_Custom_FileList">' . $GLOBALS["lang_dpg"]->str["lang_popup_message_1"] . $mayWrongPage . '</td>' . $nl;
                    echo '</tr>';
                }

                while ( $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC) ) {
                    echo '<tr onMouseOver="switchCssClass(this, \'popUp_Custom_FileList_Alt_02\');" onMouseOut="switchCssClass(this, \'popUp_Custom_FileList_Alt_01\');" class="popUp_Custom_FileList_Alt_01">' . $nl;

                    $GLOBALS['_DPG_POPUP']['RETURN_ALIASES']
                        = call_user_func(
                                // reform to JS Array
                                create_function(

                                    // paramters: array
                                    '$arr, $dB_Row',

                                    '$return = Array();

                                    foreach ( $arr as $key => $value ) {
                                        if ( !preg_match("/([^\>]+)\>(.*)/sim", $value, $regEx) ) {
                                            continue;
                                        }
                                        $return[] = "\'" . $regEx[1] . ">" . dynpg_htmlentities_rigid(stripslashes($dB_Row[ $regEx[2] ]),ENT_QUOTES,true) . "\'";
                                    }

                                    return "new Array( " . implode(", ", $return) . " ) ";'),

                                // get data from _GET
                                explode('|' , trim(urldecode($get_returnCall))) ,

                                $mysql_row

                              );

                    foreach ( $GLOBALS['_DPG_POPUP']['LIST_ROW_NAMES'] as $key => $value ) {
                        if ( $key == 'mySearch' ) {
                            $printQs = Array(0.2, 0.5, 1, 2);
                            $printAs = Array($GLOBALS["lang_dpg"]->str["lang_popup_bad"], $GLOBALS["lang_dpg"]->str["lang_popup_soso"], $GLOBALS["lang_dpg"]->str["lang_popup_good"], $GLOBALS["lang_dpg"]->str["lang_popup_verygood"]);

                            $offset = $printAs[3];

                            foreach ( $printQs as $i => $v ) {
                                if ( $mysql_row[$key] <= $v ) {
                                    $offset = $printAs[$i];
                                    break;
                                }
                            }

                            $mysql_row[$key] = $offset;
                        }

                        if ( array_key_exists($key, $mysql_row) ) {
                            if ( $value[1] != '$$HTML' ) {
                                $mysql_row[$key] = dynpg_htmlentities_rigid($mysql_row[$key],ENT_COMPAT,true);
                            }

                            if ( $value[1] == '$$NL2BR' ) {
                                $mysql_row[$key] = nl2br($mysql_row[$key]);
                            }

                            if ( $value[1] == '$$HIDDENVAL' ) {
                                $mysql_row[$key] .= $nl . '<input type="hidden" name="' . $key . '_' . $mysql_row['refId'] . '" id="' . $key . '_' . $mysql_row['refId'] . '" value="' . dynpg_htmlentities_rigid($mysql_row[$key],ENT_COMPAT,true) . '" />';
                            }

                            $mysql_row['resumeVal'] = str_replace("\n", " ", $mysql_row['resumeVal']);
                            $mysql_row['resumeVal'] = str_replace("\r", " ", $mysql_row['resumeVal']);

                            $mysql_row[$key] = stripslashes($mysql_row[$key]);

                            $tmp_output_text = $mysql_row[$key];
                            if($_GET['popUpResource'] == 'texts' && $key == 'MYTEXT'){
                            	$tmp_output_text = trim(substr(ReplaceDummyCodeNil(strip_tags($mysql_row['CONTENT'])), 0, 100));
                                if(empty($tmp_output_text))
                                    $tmp_output_text =  '<span style="font-style:italic; color:#666666;">'.$GLOBALS["lang_dpg"]->str["lang_texts_formated"].'</span>';
                            }elseif(($_GET['popUpResource'] == 'images' || $_GET['popUpResource'] == 'imagesEx' || $_GET['popUpResource'] == 'imagesURL') && $key == 'imgStr'){
                                //remove not valid img src from html string
                                $filetypes = str_replace(array('jpg','jpeg','jpe','gif','png'),'',$_mysql_Tbl_cms_bin['set_filetypes']);
                                $filetypes = empty($filetypes)?array():array_filter($filetypes);
                                $tmp_output_text = preg_replace('/<img([^>])*src="..\/(.*?).('.implode('|',$filetypes).')"([^>])*>/','',$mysql_row[$key]);
                                if($dpgcommunity_exists)
                                    $tmp_output_text = preg_replace('/<img([^>])*src="..\/(.*?)(community_)(.*?).(.*?)"([^>])*>/','Secured',$tmp_output_text);
                            }

                            echo '	<td nowrap="nowrap" class="popUp_Custom_FileList" onclick="return insertContentToParent(\''.dynpg_htmlentities_rigid($mysql_row['resumeVal'],ENT_COMPAT,true).'\', \''.$GLOBALS['_DPG_POPUP']['VALUE_ID_ALIAS'].'\', \''.$mysql_row['refId'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_ALIAS'].'\', '.(($_GET['popUpResource'] == 'texts') ? '\''.str_replace("'", "\'", dynpg_htmlentities_rigid(dynpg_public_replaceImageWildcarts_PrivToPub(stripslashes(str_replace("\n", '', str_replace("\r\n", '', $mysql_row['CONTENT'])))),ENT_COMPAT,true)).'\', \'NEWCHG_TEXT\', ': '').' ' . $GLOBALS['_DPG_POPUP']['RETURN_ALIASES'] . ');"><a href="#" onclick="return insertContentToParent(\''.dynpg_htmlentities_rigid($mysql_row['resumeVal'],ENT_COMPAT,true).'\', \''.$GLOBALS['_DPG_POPUP']['VALUE_ID_ALIAS'].'\', \''.$mysql_row['refId'].'\', \''.$GLOBALS['_DPG_POPUP']['REF_ID_ALIAS'].'\','.(($_GET['popUpResource'] == 'texts') ? '\''.str_replace("'", "\'", dynpg_htmlentities_rigid(dynpg_public_replaceImageWildcarts_PrivToPub(stripslashes(str_replace("\n", '', str_replace("\r\n", '', $mysql_row['CONTENT'])))),ENT_COMPAT,true)).'\', \'NEWCHG_TEXT\', ': '').' ' . $GLOBALS['_DPG_POPUP']['RETURN_ALIASES'] . ');">'.$tmp_output_text.'</a></td>' . $nl;
                        }
                    }

                    echo '</tr>';
                }
            ?>

        </table>

        <p class="dynpg_popup_close"><a href="#" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_popup_closeW"] ?>" onclick="return closePopup();"><?php echo $GLOBALS["lang_dpg"]->str["lang_popup_closeW"] ?></a></p>
    </div>

    </div>

	</body>
</html>