<?php
    // import
    require_once dirname(__FILE__) . "/api/db_api.php";
    require_once "connectdb.php";

    // community modul selector
    $dpgcommunity_exists = dynpgPlugIn::plugin_Exists('DPGcommunity');
?>

<script language="javascript">
<!--
    /**
     * jv_open_file_upload_settings()
     *
     * @access private
     * @return false
     **/
    function jv_open_file_upload_settings() {
        var formObj = document.forms['SUBMIT_NEW_IMAGE'];

        formObj.FILEUPLOAD_SIZE_X.value = $('#save_size_x').val();
        formObj.FILEUPLOAD_SIZE_Y.value = $('#save_size_y').val();
        formObj.FILEUPLOAD_SIZE_X_PC.value = $('#save_size_x_pc').val();
        formObj.FILEUPLOAD_SIZE_Y_PC.value = $('#save_size_y_pc').val();
        formObj.FILEUPLOAD_QUALITY.value = $('#save_size_quality').val();
        formObj.FILEUPLOAD_SIZE_RULE[0].checked = $('#save_size_rule').val() == 'max';
        formObj.FILEUPLOAD_SIZE_RULE[1].checked = $('#save_size_rule').val() == 'exa';
        formObj.FILEUPLOAD_AS_COPY.checked = $('#save_size_copy').val() == 1;
        formObj.FILEUPLOAD_WATERMARK.value = $('#save_watermark').val();
        formObj.resume_input.value = $('#save_watermark_descr').val();
        formObj.FILEUPLOAD_WATERMARK_POS.selectedIndex = $('#save_watermark_pos_idx').val();

        show_presentation_effect();

    	$("#fileupload_settings").css('top', Math.max(50, Math.floor($(window).height() / 2) + $(window).scrollTop() - $("#fileupload_settings").height() / 2 - 100));
        $("#fileupload_settings").css('left', Math.max(50, Math.floor($(window).width() / 2) + $(window).scrollLeft() - $("#fileupload_settings").width() / 2));

        $('#fileupload_settings').slideDown('slow');

        return false;
    }

    /**
     * jv_save_dialog()
     *
     * @access private
     * @return boolean
     **/
    function jv_save_dialog() {
        var formObj = document.forms['SUBMIT_NEW_IMAGE'];

        $('#save_size_x').val(formObj.FILEUPLOAD_SIZE_X.value);
        $('#save_size_y').val(formObj.FILEUPLOAD_SIZE_Y.value);
        $('#save_size_x_pc').val(formObj.FILEUPLOAD_SIZE_X_PC.value);
        $('#save_size_y_pc').val(formObj.FILEUPLOAD_SIZE_Y_PC.value);
        $('#save_size_quality').val(formObj.FILEUPLOAD_QUALITY.value);
        $('#save_size_rule').val(formObj.FILEUPLOAD_SIZE_RULE[0].checked? 'max': 'exa');
        $('#save_size_copy').val(formObj.FILEUPLOAD_AS_COPY.checked? '1': '');
        $('#save_watermark').val(formObj.FILEUPLOAD_WATERMARK.value);
        $('#save_watermark_descr').val(formObj.resume_input.value);
        $('#save_watermark_pos').val(formObj.FILEUPLOAD_WATERMARK_POS.options[formObj.FILEUPLOAD_WATERMARK_POS.selectedIndex].value);
        $('#save_watermark_pos_idx').val(formObj.FILEUPLOAD_WATERMARK_POS.selectedIndex);
        return close_dialog('fileupload_settings');
    }

    /**
     * more_files()
     *
     * @access private
     * @return void
     **/
    function more_files() {
    	var file_name = document.SUBMIT_NEW_IMAGE['NEW_IMAGE_URL['+ document.SUBMIT_NEW_IMAGE.FILE_COUNT.value +']'].value;
    	var pos = file_name.lastIndexOf("\\");

    	if(pos == -1) {
    		pos = file_name.lastIndexOf("/");
    	}

    	var pos2 = file_name.lastIndexOf(".");
    	var num = pos2 - pos;
    	var name = file_name.substr(pos+1, num-1);

    	document.SUBMIT_NEW_IMAGE['NEW_IMAGE_NAME_'+ document.SUBMIT_NEW_IMAGE.FILE_COUNT.value].value = name;

    	document.SUBMIT_NEW_IMAGE['NEW_IMAGE_URL['+ document.SUBMIT_NEW_IMAGE.FILE_COUNT.value +']'].onchange = null;

    	var new_total = Math.round(document.SUBMIT_NEW_IMAGE.FILE_COUNT.value) + 1;

    	document.getElementById('upload_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<table border=\"0\" Cellpadding=\"3\" Cellspacing=\"0\" style='width: 100%;' class='InnerWebsiteTableTransparent'><tr bgcolor=\"<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>\"><td id='desc1_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td><td style='width: 100%;' id='attach_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td></tr><tr bgcolor=\"<?php echo C_WEBSITE_MAINBACKGROUND ?>\"><td id='desc2_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td><td id='attachname_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td></tr><tr bgcolor=\"<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>\"><td id='desc3_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td><td id='descname_" + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value + "'></td></tr><tr bgcolor=\"<?php echo C_WEBSITE_MAINBACKGROUND ?>\"><td>&nbsp;</td><td><input type=\"checkbox\" value=\"1\" name=\"NEW_IMAGE_ORIGNAME_" + new_total + "\" style=\"margin: 0;\" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_origName"]; ?></td></tr><?php echo (($dpgcommunity_exists)?'<tr bgcolor=\"'.C_WEBSITE_MAINBACKGROUND_ALT.'\"><td>&nbsp;</td><td><input type=\"checkbox\" value=\"1\" name=\"NEW_IMAGE_COMMUNITY_" + new_total + "\" style=\"margin: 0;\" /> '.$GLOBALS["lang_dpg"]->str["lang_fileupload_communityName"].'</td></tr>':''); ?></table></div><div id='upload_" + new_total + "'>";

    	document.getElementById('desc1_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<b><?php echo $GLOBALS['lang_dpg']->str['lang_fileupload_uploadField']; ?></b>";

    	document.getElementById('attach_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<input type=\"file\" size=\"40\" name=\"NEW_IMAGE_URL[" + new_total + "]\" onchange=\"more_files();\" class=\"TextFieldStyleWhite\"/>";

    	document.getElementById('desc2_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<b><?php echo $GLOBALS['lang_dpg']->str['lang_fileupload_titleField']; ?></b>";

    	document.getElementById('attachname_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<input type='text' size='55' name='NEW_IMAGE_NAME_" + new_total + "' class='TextFieldStyleWhite' />";

    	document.getElementById('desc3_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<b><?php echo $GLOBALS['lang_dpg']->str['lang_fileupload_descField']; ?></b>";

    	document.getElementById('descname_' + document.SUBMIT_NEW_IMAGE.FILE_COUNT.value).innerHTML = "<input type='text' size='55' name='NEW_IMAGE_DESCR_" + new_total + "' class='TextFieldStyleWhite' />";

    	document.SUBMIT_NEW_IMAGE.FILE_COUNT.value++;
    }
-->
</script>

<?php

// -----------------------------------------------------------------------------
// functions

function unzipFiles($filename, $allowed_extensions, $group) {
	if( !function_exists("zip_open") ) {
		function ShellFix($s)
		{
		  return "'".str_replace("'", "'''", $s)."'";
		}

		function zip_open($s)
		{
			$fp = @fopen($s, 'rb');
			if(!$fp) return false;

			$lines = Array();
			$cmd = 'unzip -v '.shellfix($s);
			exec($cmd, $lines);
			$contents = Array();
			$ok=false;
			foreach($lines as $line)
			{
				if($line[0]=='-') { $ok=!$ok; continue; }
				if(!$ok) continue;
				$length = (int)$line;
				$fn = trim(substr($line,58));
				$contents[] = Array('name' => $fn, 'length' => $length);
			}
			return
			Array('fp' => $fp,
			'name' => $s,
			'contents' => $contents,
			'pointer' => -1);
		}

		function zip_read(&$fp)
		{
			if(!$fp) return false;
			$next = $fp['pointer'] + 1;
			if($next >= count($fp['contents'])) return false;
			$fp['pointer'] = $next;
			return $fp['contents'][$next];
		}

		function zip_entry_name(&$res)
		{
			if(!$res) return false;
			return $res['name'];
		}

		function zip_entry_filesize(&$res)
		{
			if(!$res) return false;
			return $res['length'];
		}

		function zip_entry_open(&$fp, &$res, $xy)
		{
			if(!$res) return false;
			$cmd = 'unzip -p '.shellfix($fp['name']).' '.shellfix($res['name']);
			$res['fp'] = popen($cmd, 'r');
			return !!$res['fp'];
		}

		function zip_entry_read(&$res, $nbytes)
		{
			$contents = '';
			while (!feof($res['fp'])) {
				$contents .= fread($res['fp'], 8192);
			}
			return $contents;
		}

		function zip_entry_close(&$res)
		{
			fclose($res['fp']);
			unset($res['fp']);
		}

		function zip_close(&$fp)
		{
			fclose($fp['fp']);
		}
	}

	$error_files = "";
	$zip = zip_open($filename);

    if ($zip) {
        $sort_order_name = Array();
        $zip_contents = Array();
        while ($zip_file = zip_read($zip)){
    		if (zip_entry_open($zip, $zip_file, "r")){
    			$buffer = zip_entry_read($zip_file, zip_entry_filesize($zip_file));
    			$file_name = StrToLower(zip_entry_name($zip_file));
    			$extension = substr(strrchr($file_name, "."), 1);
    			if(in_array($extension, $allowed_extensions)){
                    if(strpos($file_name,'/')>0){ $file_name_short = substr($file_name,strrpos($file_name,'/')+1); }
                    else { $file_name_short = $file_name; }

                    $file_name_short = substr($file_name_short,0,strlen($file_name_short)-strlen($extension)-1);

                    $zip_contents[] = array('file_name' => $file_name, 'extension' => $extension, 'file_name_short' => $file_name_short, 'buffer' => $buffer);
                    $sort_order_name[]  = $file_name;
    			}
    			elseif(strpos($file_name, ".")>0){
    				$error_files .= "- ".$file_name."<br />";
    			}
    			zip_entry_close($zip_file);
    		}
    	}
        array_multisort($sort_order_name, SORT_ASC, $zip_contents);
        foreach($zip_contents as $zip_content){
            $SQL = "INSERT INTO `dynpg_cms_images` (`NAME`, `URL`, `DESCR`, `USERGROUP`) VALUES ('" . mysql_real_escape_string($zip_content['file_name_short'] . $GLOBALS["lang_dpg"]->str["lang_fileupload_zip_extension"])
                . "', '', '".mysql_real_escape_string($zip_content['file_name_short'])."','".mysql_real_escape_string($group)."')";
            $RES = mysql_query($SQL);
            $id = mysql_insert_id();
            @mysql_free_result($RES);

            mysql_query("INSERT INTO `dynpg_cms_images_rights`(`USERID`, `PARENT`, `SECTION`, `CREATE`, `DELETE`, `CHANGE`)
            VALUES ('".mysql_real_escape_string($_SESSION["ID"])."', 'ARTICLE', '{$id}', 'TRUE', 'TRUE', 'TRUE')");

            $imgFilePath = FORMS_IMAGES_DESTINATIONURL_ROOT."/" . (empty($_POST["NEW_ZIP_COMMUNITY"])?'':'community_') . "imgfile".$id.".".$zip_content['extension'];
            $open = fopen($imgFilePath, "w");
            fwrite($open, $zip_content['buffer']);
            fclose($open);

            $exif = array();
            $file_desc = '';

            // try to get iptc data from tmp before image copy or save
            if(is_callable('iptcparse') && ($zip_content['extension'] == 'jpeg' || $zip_content['extension'] == 'jpg')){
                $size = getimagesize($imgFilePath, $exif);
                if (isset($exif["APP13"])) {
                    if($exif = iptcparse( $exif["APP13"] ) ) {
                        $file_desc = str_replace(array("\000","'","\\",'"','`'), '', $exif["2#120"][0] );
                        if(isset($exif["1#090"]) && $exif["1#090"][0] == "\x1B%G")
                            $file_desc = utf8_decode($file_desc);
                    }
                }
            }

            // try to get exif data from tmp before image copy or save
            if(empty($file_desc) && is_callable('exif_read_data') && ($zip_content['extension'] == 'jpeg' || $zip_content['extension'] == 'jpg')){
                $exif = exif_read_data($imgFilePath);
                if(isset($exif['ImageDescription'])){
                    $file_desc = str_replace(array("'","\\",'"','`'),array(''),$exif['ImageDescription']);
                }
            }
            $exif = (empty($file_desc)?$zip_content['file_name_short']:$file_desc);

            $SQL = "UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`DESCR`= '".mysql_real_escape_string($exif)."', `dynpg_cms_images`.`URL`='/" . mysql_real_escape_string((empty($_POST["NEW_ZIP_COMMUNITY"])?'':'community_') . "imgfile".$id.".".$zip_content['extension'])."' WHERE `id`='".$id."'";
            $RES = mysql_query($SQL);
            @mysql_free_result($RES);

            $render = re_render_image($id, !empty($_POST['NEW_ZIP_COMMUNITY']));

            if ($render < 0) {
                $error_files .= "- ".$file_name . " (" . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_4"] . ")<br />";
            } elseif($render === false) {
                $error_files .= "- ".$file_name . " (" . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_5"] . ")<br />";
            }
        }
    	zip_close($zip);
	}
	return $error_files;
}

function getGroupNaviTreestruct($id, $id_before, $return)
{
	$mysql="SELECT A.*, B.* FROM `dynpg_cms_imagegroup_treestruct` A, `dynpg_cms_imagegroups` B WHERE A.`element_id_fk`='".mysql_real_escape_string($id)."' AND A.`element_id_fk`=B.`id` AND A.`successor_id_fk`='".mysql_real_escape_string($id_before)."'";
	$mysql_result=mysql_query($mysql);
	$res=mysql_fetch_object($mysql_result);
	$return = $res->NAME." - ".$return;
	if(!empty($res->root_id_fk)){
		$return=getGroupNaviTreestruct($res->root_id_fk,$res->element_id_fk,$return);
	}
	return $return;
}

function getGroupNavi($group)
{
	$return="";

	$mysql="SELECT A.*, B.* FROM `dynpg_cms_imagegroup_treestruct` A, `dynpg_cms_imagegroups` B WHERE A.`successor_id_fk`='".mysql_real_escape_string($group)."' AND A.`successor_id_fk`=B.`id`";
	$mysql_result=mysql_query($mysql);

	if(mysql_num_rows($mysql_result)){
		$res=mysql_fetch_object($mysql_result);
		$return = "<b>".$res->NAME."</b>";

		if(empty($res->root_id_fk)){
			$mysql="SELECT A.*, B.* FROM `dynpg_cms_imagegroup_treestruct` A, `dynpg_cms_imagegroups` B WHERE A.`element_id_fk`='".mysql_real_escape_string($res->element_id_fk)."' AND A.`element_id_fk`=B.`id`";
			$mysql_result=mysql_query($mysql);
			$res=mysql_fetch_object($mysql_result);
			$return = $res->NAME." - ".$return;
		}
		else {
			$result = getGroupNaviTreestruct($res->element_id_fk,$res->successor_id_fk,"");
			$return = $result.$return;
		}
	}
	else{
		$mysql="SELECT A.*, B.* FROM `dynpg_cms_imagegroup_treestruct` A, `dynpg_cms_imagegroups` B WHERE A.`element_id_fk`='".mysql_real_escape_string($group)."' AND A.`element_id_fk`=B.`id` AND A.`successor_id_fk` IS NULL AND A.`root_id_fk` IS NULL";
		$mysql_result=mysql_query($mysql);

		if(mysql_num_rows($mysql_result)){
			$res=mysql_fetch_object($mysql_result);
			$return = "<b>".dynpg_htmlentities_rigid($res->NAME,ENT_COMPAT,true)."</b>";
		}
	}
	return $return;
}

/**
 * re_render_image()
 *
 * Renders the image $id using the global settings for uploaded
 * files and saves the new image under $pic_url or a copy.
 *
 * @param integer $id
 * @param boolean $community_file
 * @return boolean
 */
function re_render_image($id, $community_file = false, $batch = false) {
    // check gd
        if (!extension_loaded("gd") || !function_exists("gd_info"))
            return false;

    // if batch action, take saved inputs
        if ($batch) {
            $_POST['FILEUPLOAD_SIZE_X'] = $_POST['save_size_x'];
            $_POST['FILEUPLOAD_SIZE_Y'] = $_POST['save_size_y'];
            $_POST['FILEUPLOAD_SIZE_X_PC'] = $_POST['save_size_x_pc'];
            $_POST['FILEUPLOAD_SIZE_Y_PC'] = $_POST['save_size_y_pc'];
            $_POST['FILEUPLOAD_QUALITY'] = $_POST['save_size_quality'];
            $_POST['FILEUPLOAD_SIZE_RULE'] = $_POST['save_size_rule'];
            $_POST['FILEUPLOAD_AS_COPY'] = $_POST['save_size_copy'];
            $_POST['FILEUPLOAD_WATERMARK'] = $_POST['save_watermark'];
            $_POST['FILEUPLOAD_WATERMARK_POS'] = $_POST['save_watermark_pos'];
        }

    // check wheater batch actions have to be applied
        if (empty($_POST['FILEUPLOAD_SIZE_X'])
            && empty($_POST['FILEUPLOAD_SIZE_Y'])
            && $_POST['FILEUPLOAD_SIZE_X_PC'] == 100
            && $_POST['FILEUPLOAD_SIZE_Y_PC'] == 100
            && $_POST['FILEUPLOAD_QUALITY'] == 100
            && empty($_POST['FILEUPLOAD_WATERMARK']))
            return null;

    // read properties
        $new_x_px = empty($_POST['FILEUPLOAD_SIZE_X'])? 0: $_POST['FILEUPLOAD_SIZE_X'];
        $new_y_px = empty($_POST['FILEUPLOAD_SIZE_Y'])? 0: $_POST['FILEUPLOAD_SIZE_Y'];
        $new_x_pc = min(100, max($_POST['FILEUPLOAD_SIZE_X_PC'], 1));
        $new_y_pc = min(100, max($_POST['FILEUPLOAD_SIZE_Y_PC'], 1));
        $new_quality = min(100, max($_POST['FILEUPLOAD_QUALITY'], 1));
        $resize_rule = empty($_POST['FILEUPLOAD_SIZE_RULE'])? 'max': $_POST['FILEUPLOAD_SIZE_RULE'];
        $as_copy = !empty($_POST['FILEUPLOAD_AS_COPY']);
        $watermark = !empty($_POST['FILEUPLOAD_WATERMARK'])? (integer)$_POST['FILEUPLOAD_WATERMARK']: false;
        $watermark_pos = !empty($_POST['FILEUPLOAD_WATERMARK_POS'])? $_POST['FILEUPLOAD_WATERMARK_POS']: 'RD';

    // check gd version
        $GDinfo = gd_info();
        $GDversion = $GDinfo["GD Version"];
        $supported_types = Array();
        if (ImageTypes() & IMG_PNG)
            array_push($supported_types, "png");
        if (ImageTypes() & IMG_JPG)
            array_push($supported_types, "jpg", "jpeg");
        if (ImageTypes() & IMG_GIF)
            array_push($supported_types, "gif");
        if (empty($supported_types))
            return false;

    // deduce picture data
        $image = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='".mysql_real_escape_string($id)."'"));
        $pic_url = FORMS_IMAGES_DESTINATIONURL_ROOT . $image['URL'];
        $pic_type = strtolower(substr(strrchr($pic_url, '.'), 1));

        if (!file_exists($pic_url) || !in_array($pic_type, $supported_types))
            return false;

    // deduce watermark data
        if ($watermark) {
            $dbh = new DBDynPGDatabaseHandle();
            $dbh->db_setTable('dynpg_cms_images');
            $dbh->db_setQuery("SELECT * FROM `dynpg_cms_images` WHERE `id` = '".mysql_real_escape_string($watermark)."'");
            $dbh->db_fetch_row();
            $watermark_url = FORMS_IMAGES_DESTINATIONURL_ROOT . $dbh->row['URL'];
            $watermark_type = strtolower(substr(strrchr($watermark_url, '.'), 1));
            $watermark = true;

            if (!file_exists($watermark_url) || !in_array($watermark_type, $supported_types))
                return false;
        }

    // check if memory is available for image resizing
        if (!function_exists('setMemoryForImage')) {
            function setMemoryForImage(&$iInfo) {
                // constants
                    $MB = 1048576;      // number of bytes in 1M
                    $K64 = 65536;       // number of bytes in 64K
                    $TWEAKFACTOR = 1.5; // threshold

                // check info
                    $iInfo['bits'] = empty($iInfo['bits'])? 8: $iInfo['bits'];
                    $iInfo['channels'] = empty($iInfo['channels'])? 4: $iInfo['channels'];

                // calculate necessary memory
                    $memoryNeeded = round(($iInfo[0] * $iInfo[1] * $iInfo['bits'] * $iInfo['channels'] / 8 + $K64) * $TWEAKFACTOR);

                // if memory is less than 8 MB then always return true
                    if ($memoryNeeded / $MB < 8)
                        return true;

                // try to get memory limit
                    $memoryLimit = @ini_get('memory_limit');
                    if (!empty($memoryLimit)) {
                        if (strpos(strtoupper($memoryLimit), 'M') !== false) {
                            $memoryLimit = preg_replace('/[^0-9]+/', '', $memoryLimit);
                            $memoryLimit = $memoryLimit * $MB;
                        }
                    } else {
                        // Memory limit is not available; we thus try to
                        // assume 64MB. This may be enought to rescale even large
                        // scale images. However, this is arbitrary.
                        $memoryLimit = 16 * $MB;
                    }

                // try to increase memory limit
                    if (function_exists('memory_get_usage')
                        && (memory_get_usage() + $memoryNeeded) > $memoryLimit) {
                        $newLimit = round($memoryLimit
                            + ceil(memory_get_usage() + $memoryNeeded - $memoryLimit)) / $MB;

                        @ini_set('memory_limit', $newLimit . 'M');
                        return (@ini_get('memory_limit') == ($newLimit . 'M'));
                    } elseif (function_exists('memory_get_usage')) {
                        return ($memoryNeeded + memory_get_usage() < $memoryLimit);
                    } else {
                        return ($memoryNeeded < $memoryLimit - 2 * $MB);
                    }
            }
        }
        // get dimensions and data of image
        $size = getimagesize($pic_url);

        if (!setMemoryForImage($size))
            return -1;

    // everything is ok, we can apply the GD functionalities
        // create GD object
        if ($size[2] == 1)
			$old_pic = ImageCreateFromGIF($pic_url);
		elseif ($size[2] == 2)
            $old_pic = ImageCreateFromJPEG($pic_url);
        elseif ($size[2] == 3)
            $old_pic = ImageCreateFromPNG($pic_url);
        else
            return false;

        // change size of the image
        if ($new_x_px > 0 && $new_y_px > 0) {
            $width_px = $new_x_px;
            $height_px = $new_y_px;
            if ($resize_rule == 'max') {
                if ($size[0] > $new_x_px) {
                    $width_px = $new_x_px;
                    $height_px = round(($width_px / $size[0]) * $size[1]);
                    if ($height_px > $new_y_px){
                        $height_px = $new_y_px;
                        $width_px = round(($height_px / $size[1]) * $size[0]);
                    }
                }elseif ($size[1] > $new_y_px) {
                    $height_px = $new_y_px;
                    $width_px = round(($height_px / $size[1]) * $size[0]);
                    if ($width_px > $new_x_px){
                        $width_px = $new_x_px;
                        $height_px = round(($width_px / $size[0]) * $size[1]);
                    }
                }
            }
        } elseif ($new_x_px > 0 || $new_y_px > 0) {
            if ($new_x_px > 0)
                $width_px = $new_x_px;
            else
                $width_px = round(($new_y_px / $size[1]) * $size[0]);
            if ($new_y_px > 0)
                $height_px = $new_y_px;
            else
                $height_px = round(($new_x_px / $size[0]) * $size[1]);
        } else {
            $width_px = round($size[0] * $new_x_pc / 100);
            $height_px = round($size[1] * $new_y_pc / 100);
        }

        // the image already has the correct size and quality is = 100
        $no_resize = false;
        if ($size[0] == $width_px && $size[1] == $height_px && $new_quality == 100 && !$watermark)
            return true;
        if ($resize_rule == 'max' && $size[0] <= $width_px && $size[1] <= $height_px)
            if (!$watermark && $new_quality == 100)
                return true;
            else
                $no_resize = true;
        if ($no_resize) {
            $width_px = $size[0];
            $height_px = $size[1];
        }

        // check if memory is available for image resizing
        $_ = Array(
            0 => $width_px,
            1 => $height_px,
            'bits' => $size['bits'],
            'channels' => $size['channels']
        );
        if (!setMemoryForImage($_))
            return -1;

        // generate the new image
        $new_pic = ImageCreateTrueColor($width_px, $height_px);
        if ($size[2] == 3){   
            @imagealphablending( $new_pic, false );
            @imagesavealpha( $new_pic, true );
        }

        // change size
        ImageCopyResampled($new_pic, $old_pic, 0, 0, 0, 0, $width_px, $height_px, $size[0], $size[1]);

        // apply watermark if chosen
        if ($watermark) {
            // get dimensions and data of image
                $size_wm = getimagesize($watermark_url);
                if (!setMemoryForImage($size_wm))
                    return -1;

            // everything is ok, we can apply the GD functionalities
                // create GD object
                if ($size_wm[2] == 1)
        			$watermark_pic = ImageCreateFromGIF($watermark_url);
        		elseif ($size_wm[2] == 2)
                    $watermark_pic = ImageCreateFromJPEG($watermark_url);
                elseif ($size_wm[2] == 3)
                    $watermark_pic = ImageCreateFromPNG($watermark_url);
                else
                    return false;

            // insert watermark
                $pos_x = 0;
                $pos_y = 0;
                if ($watermark_pos != 'CU' && $watermark_pos != 'CD' && $watermark_pos != 'CC') {
                    if ($watermark_pos == 'RU' || $watermark_pos == 'RD')
                        $pos_x = max(0, $width_px - $size_wm[0]);
                    if ($watermark_pos == 'LD' || $watermark_pos == 'RD')
                        $pos_y = max(0, $height_px - $size_wm[1]);
                } else {
                    $pos_x = max(0, round(($width_px - $size_wm[0]) / 2));
                    if ($watermark_pos == 'CD')
                        $pos_y = max(0, $height_px - $size_wm[1]);
                    if ($watermark_pos == 'CC')
                        $pos_y = max(0, round(($height_px - $size_wm[1]) / 2));
                }
                ImageCopy($new_pic, $watermark_pic, $pos_x, $pos_y, 0, 0, $size_wm[0], $size_wm[1]);
                imagedestroy($watermark_pic);
        }

        // if copy is boolean true then create a dublicate of the current image
        if ($as_copy) {
            $dbh = new DBDynPGDatabaseHandle();
            $dbh->db_setTable('dynpg_cms_images');
            $dbh->db_insert(
                Array(
                    $image['NAME'],
                    '',
                    $image['DESCR'] . $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_is_copy"],
                    $image['USERGROUP']
                )
            );
            $iid = mysql_insert_id();
            $new_filename = '/' . ($community_file? 'community_': '') . 'imgfile' . $iid . '.' . $pic_type;
            $dbh->db_update(Array('URL' => $new_filename), $iid);
            $new_url = FORMS_IMAGES_DESTINATIONURL_ROOT . $new_filename;
        } else {
            $new_url = $pic_url;
        }

        // create new image
        if ($size[2] == 2) {
            ImageJPEG($new_pic, $new_url, $new_quality);
            imagedestroy($new_pic);
            imagedestroy($old_pic);
        } elseif ($size[2] == 3) {
            ImagePNG($new_pic, $new_url, 9 - ceil(min(90, $new_quality) / 10));
            imagedestroy($new_pic);
            imagedestroy($old_pic);
        } elseif ($size[2] == 1) {
            ImageGIF($new_pic, $new_url);
            imagedestroy($new_pic);
            imagedestroy($old_pic);
        } else {
            return false;
        }

    return true;
}

// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------
// init $_GET vars and preload variables

    // GET
    $group		= empty($_GET["group"]) ? 0 : $_GET["group"];
    $ug			= empty($_GET["ug"]) ? 0 : $_GET["ug"];
	$take       = empty($_GET["take"]) ? 1 : $_GET["take"];
	$show       = empty($_GET["show"]) ? 1 : $_GET["show"];
	$sort       = empty($_GET["sort"]) ? "" : $_GET["sort"];
	$orderby    = empty($_GET["orderby"]) ? 1 : $_GET["orderby"];
	$tblexp     = empty($_GET["tblexp"]) ? "bound" : $_GET["tblexp"];
	$aid        = empty($_GET["aid"]) ? 0 : $_GET["aid"];
	$PHP_SELF   = $_SERVER["PHP_SELF"];
	$zip_fault  = FALSE;

	if (isset($_GET["acttype"]))
        $acttype = $_GET["acttype"];


    // load settings of dynpg for formular default values
    $_mysql_Tbl_cms_bin = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_bin` WHERE `bin_id` = 1"), MYSQL_ASSOC);
    $_mysql_Tbl_cms_bin['set_filetypes'] = explode(', ', $_mysql_Tbl_cms_bin['set_filetypes']);
	// end

	$Page = array();

	if ( empty($_GET["p"]) && empty($_GET["s"]) )
	{
		if (!empty($_POST["SHOWNUM"])) {
            $Page["EachPage"] = $_POST["SHOWNUM"];
            }
		else if (empty($Page["EachPage"])) {
                $Page["EachPage"] = C_MAXIMUM_SHOW_IMAGES;
                }

		if (!empty($_POST["PAGE"])) {
            $Page["NumPage"] = $_POST["PAGE"];
            }
		else if ( empty($Page["NumPage"]) ) {
                $Page["NumPage"] = 0;
                }

	}
    else {
            $Page["EachPage"]   = $_GET["s"];
            $Page["NumPage"]    = $_GET["p"];
            }

    $Page["EachPage"] = max(0, $Page["EachPage"]);
    $Page["NumPage"] = max(0, $Page["NumPage"]);

	if ( empty($_GET["type"]) && empty($_GET["nr"]) )
	{
		if (!empty($_POST["SHOWTYPE"])) {
            $Page["type"] = $_POST["SHOWTYPE"];
            }
		else if (empty($Page["type"])) {
            $Page["type"] = "ALL";
            }

        if ( !empty($_POST["SHOWTYPE"]) )
        {
            switch ( $_POST["SHOWTYPE"] )
            {
                case 'CATEGORY':
                    $Page["nr"] = $_POST["SELCAT"];
                break;
                case 'GROUP':
                    $Page["nr"] = $_POST["SELGRP"];
                break;
                case 'SEARCH':
                    $Page["nr"] = $_POST["SRCHQUERY"];
                break;
                default:
                    $Page["nr"] = "NIL";
                break;
            }
         } else {
            $Page["nr"] = "NIL";
            }

	} else {
        $Page["type"]   = $_GET["type"];
        $Page["nr"]     = $_GET["nr"];
    }

	$sortarray = Array(
        "ASC"=>"DESC",
        "DESC"=>"ASC"
    );

	$orderbyarray = Array(
    	"id"=>0,
    	"NAME"=>1,
    	"DESCR"=>2
	);

	if ( empty($sort) || empty($orderby) ) {
		$orderby = "id";
		$sort    = "DESC";
	}

	if (empty($sortarray[$sort]))
        $sort = "DESC";

    if (empty($orderbyarray[$orderby]))
        $orderby = "id";

	foreach ($orderbyarray as $i)
    {
		if ($i!=$orderbyarray[$orderby])
            $actualsortarray[$i] = $sortarray["DESC"];
		else
            $actualsortarray[$i] = $sortarray[$sort];
    }

	if ( (empty($_POST["BTN_SUBMIT_SHOW"]) || $_POST["SHOWTYPE"]=="ALL") && ( (empty($_GET["type"]) && empty($_GET["nr"]) || $_GET["type"]=="ALL") ) )
    {
		$where_select = ($group > 0)? "A.`USERGROUP` = '".mysql_real_escape_string($group)."'": "1";
		if (dynpg_getRightsToUser(null, 'ADMIN', 'NULL', 'asArray', true) != Array('FALSE', 'FALSE', 'FALSE'))
            $Clausel = "SELECT * FROM `dynpg_cms_images` AS A WHERE {$where_select} ORDER BY `".mysql_real_escape_string(str_replace('`', '', $orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC');
		else
            $Clausel =
                "SELECT DISTINCT
                    A.*,
                    B.`id` AS `right_id`,
                    B.`CREATE`,
                    B.`DELETE`,
                    B.`CHANGE`
                FROM
                    `dynpg_cms_images` AS A LEFT JOIN `dynpg_cms_images_rights` AS B
                    ON (B.`PARENT` = 'ARTICLE' AND B.`USERID` = '".mysql_real_escape_string($_SESSION['ID'])."' AND A.`id` = B.`SECTION`)
                WHERE
                    {$where_select} AND (
                    (B.`CREATE` IS NOT NULL AND B.`CREATE` = 'TRUE') OR
                    (B.`DELETE` IS NOT NULL AND B.`DELETE` = 'TRUE') OR
                    (B.`CHANGE` IS NOT NULL AND B.`CHANGE` = 'TRUE'))
                ORDER BY A.`".mysql_real_escape_string(str_replace('`', '', $orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC');
    }
    else
    {
            if (empty($_POST["SHOWTYPE"]))
			{
				$_POST["SHOWTYPE"]  = $_GET["type"];
				$_POST["SELCAT"]    = $_GET["nr"];
				$_POST["SELGRP"]    = $_GET["nr"];
                $_POST["SRCHQUERY"] = $_GET["nr"];
			}
			switch ($_POST["SHOWTYPE"])
			{
                case "SEARCH":
                    $query = mysql_real_escape_string($_POST['SRCHQUERY']);

                    $where_select = ($group > 0)? "A.`USERGROUP` = '".mysql_real_escape_string($group)."'": "1";

                    if (dynpg_getRightsToUser(null, 'ADMIN', 'NULL', 'asArray', true) != Array('FALSE', 'FALSE', 'FALSE')) {
                        $Clausel =
    						"SELECT DISTINCT
    							A.*,
    							A.`NAME` LIKE '%{$query}%' as mtch01,
    							A.`DESCR` LIKE '%{$query}%' as mtch02,
    							MATCH ( A.`NAME`, A.`DESCR` ) AGAINST ('{$query}') as mtch03
    						 FROM
    							`dynpg_cms_images` AS A
    						 WHERE {$where_select}
    						 HAVING
    							mtch01 > 0.001 OR
    							mtch02 > 0.001 OR
    							mtch03 > 0.001
    						 ORDER BY
    							A.`".mysql_real_escape_string(str_replace('`', '', $orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC');
    				} else {
    				    $Clausel =
    						"SELECT DISTINCT
    							A.*,
    							B.`id` AS `right_id`,
                                B.`CREATE`,
                                B.`DELETE`,
                                B.`CHANGE`,
    							A.`NAME` LIKE '%{$query}%' as mtch01,
    							A.`DESCR` LIKE '%{$query}%' as mtch02,
    							MATCH ( A.`NAME`, A.`DESCR` ) AGAINST ('{$query}') as mtch03
    						 FROM
    							`dynpg_cms_images` AS A LEFT JOIN `dynpg_cms_images_rights` AS B
                                ON (B.`PARENT` = 'ARTICLE' AND B.`USERID` = '".mysql_real_escape_string($_SESSION['ID'])."' AND A.`id` = B.`SECTION`)
    						 WHERE
    						    {$where_select} AND (
                                (B.`CREATE` IS NOT NULL AND B.`CREATE` = 'TRUE') OR
                                (B.`DELETE` IS NOT NULL AND B.`DELETE` = 'TRUE') OR
                                (B.`CHANGE` IS NOT NULL AND B.`CHANGE` = 'TRUE'))
    						 HAVING
    							mtch01 > 0.001 OR
    							mtch02 > 0.001 OR
    							mtch03 > 0.001
    						 ORDER BY
    							A.`".mysql_real_escape_string(str_replace('`', '', $orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC');
    				}
                break;
			}

	    }
?>

<h3><?php echo $GLOBALS["lang_dpg"]->str["lang_file_management_title"]; ?></h3>

<?php
    if ( empty($acttype) || $acttype=="del" )
	{
		$_get_ImageName = "";
		$_get_ImageDesc = "";
		$_get_ImageUrl	= "";
		$_get_realImageUrl = "";
		$SubmitButtonValue = $GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"];
	}
	else if ( !empty($acttype) && $acttype=="zip" )
	{
		$SubmitButtonValue = $GLOBALS["lang_dpg"]->str["lang_fileupload_unzip_button"];
	}
	else if ( !empty($acttype) && $acttype=="chg" && !empty($aid) )
	{

		$SQL = "SELECT * FROM `dynpg_cms_images` WHERE `id`='".(int)$aid."'";
		$RES = mysql_query($SQL);
		$ROW = mysql_fetch_object($RES);

		$_get_ImageName 	= dynpg_htmlentities_rigid($ROW->NAME,ENT_COMPAT,true);
		$_get_ImageDesc 	= dynpg_htmlentities_rigid($ROW->DESCR,ENT_COMPAT,true);
		$_get_ImageGroup 	= dynpg_htmlentities_rigid($ROW->USERGROUP,ENT_COMPAT,true);
		$_get_ImageUrl 		= "<BR>".$GLOBALS["lang_dpg"]->str["lang_fileupload_available_1"].$aid.$GLOBALS["lang_dpg"]->str["lang_fileupload_available_2"]."";
		$_get_realImageUrl  = $ROW->URL;
		$_get_GroupParent   = $ug;

		@mysql_free_result($RES);

		$SubmitButtonValue = $GLOBALS["lang_dpg"]->str["lang_fileupload_change_button"];
	}


	if (!empty($_POST["BATCH_ACTION"]))
	{
		switch($_POST["SEL_ACTION"]){
			case 'MODIFY':
				$Sucessfull = TRUE;
                for ($i=1; $i<=$_POST["BATCH_ACTION"]; $i++)
				{
					if (!empty($_POST["Check?$i"]))
					{
                        if (dynpg_getRightsToUser(C_RIGHTS_CHANGE, 'ARTICLE', $i, 'asValue', true)) {
                            $render = re_render_image($i, false, true);

                            if ($render < 0 || $render === false)
                                $Sucessfull = FALSE;
                        } else {
                            $Sucessfull = FALSE;
                        }
					}
				}
				break;

            case 'DEL':
				$Sucessfull = TRUE;
                for ($i=1; $i<=$_POST["BATCH_ACTION"]; $i++)
				{
					if (!empty($_POST["Check?$i"]))
					{
						if (dynpg_getRightsToUser(C_RIGHTS_DELETE, 'ARTICLE', $i, 'asValue', true) ) {
                            $RES = mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='".(int)$i."'");
    						$ROW = mysql_fetch_object($RES);
    			            @mysql_free_result($RES);

    						if ( file_exists("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . $ROW->URL) ) {
    							unlink("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . $ROW->URL);
    			            }
                            mysql_query("DELETE FROM `dynpg_cms_images` WHERE `id`='".(int)$i."'");
                        } else {
                            $Sucessfull = FALSE;
                        }
					}
				}
				break;

			case 'MOVE':
				echo "
				<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
				<tr>
					<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
						<span class=\"yellow\">
							<i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_ask_grp"]."</i>
							<table border=\"0\" Cellspadding=\"0\" Cellspacing=\"0\">
							 <tr>
							  <form action=\"".$PHP_SELF."?".((!getenv("QUERY_STRING")) ? $_SERVER['QUERY_STRING'] : getenv("QUERY_STRING"))."\" method=\"post\" name=\"SUBMIT_NEW-CHG_MULTIACTION\">
							  <td>
				";
				?>
								<br />
								<select size="1" name="NEW_IMAGE_GROUP" class="TextFieldStyleWhite">
									<?php

										$mysql_result = mysql_query("SELECT DISTINCT
																		A.*,
																		B.*
																	 FROM
																		`dynpg_cms_imagegroup_treestruct` AS A
																		INNER JOIN `dynpg_cms_imagegroups` AS B
																		ON A.`element_id_fk` = B.`id`
																	 WHERE
																		A.`root_id_fk` IS NULL
																	 GROUP BY
																		A.`element_id_fk`
																	 ORDER BY
																		B.`".mysql_real_escape_string(str_replace('`', '', $orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC'));
								$GLOBALS['__HTML_OUT_ROW'] = '<option value="%ID%" selected="selected">%SYMB% %NAME%</option>';

								while ( $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC) ) {
									$_ouput = $GLOBALS['__HTML_OUT_ROW'];

									if ( !is_null($mysql_row['successor_id_fk']) ) {
										$__grp_has_Successors = TRUE;
									} else {
										$__grp_has_Successors = FALSE;
									}

									if ( $__grp_has_Successors ) {
										$_ouput = str_replace('%SYMB%', '', $_ouput);
									} else {
										$_ouput = str_replace('%SYMB%', '', $_ouput);
									}

									foreach ( $mysql_row as $key => $value ) {
										$value = dynpg_htmlentities_rigid($value,ENT_COMPAT,true);

										$_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
									}

									if ( $group != $mysql_row['id'] ) {
										$_ouput = str_replace(' selected="selected"', '', $_ouput);
									}

									/*if ( $take != $mysql_row['element_id_fk'] ) {
										$_ouput = str_replace(' selected="selected"', '', $_ouput);
									}*/

									if (dynpg_getRightsToUser(null, 'GROUP', $mysql_row['element_id_fk'], 'asArray', true) != Array('FALSE', 'FALSE', 'FALSE')) {
                                        echo $_ouput;

    									if ( !is_null($mysql_row['element_id_fk']) ) {
    											dnypg_interna_List_Successors_img($mysql_row['element_id_fk'], 1, $GLOBALS['__HTML_OUT_ROW'], 'NAME', 'ASC', FALSE, $group, TRUE);
    									}
    								}
								}

										@mysql_free_result($RES);
									 ?>
								</select>
								<?php
								for ($i=1; $i<=$_POST["BATCH_ACTION"]; $i++){
									if (!empty($_POST["Check?$i"])){
										echo "<input type=\"hidden\" value=\"1\" name=\"Check?$i\">";
									}
								}
				echo "
								<input type=\"hidden\" value=\"".$_POST["BATCH_ACTION"]."\" name=\"BATCH_ACTION\">
								<input type=\"hidden\" value=\"DO_MOVE\" name=\"SEL_ACTION\">
								<p align=\"right\"><input type=\"submit\" class=\"ButtonStyleWhite\" value=\"".$GLOBALS["lang_dpg"]->str["lang_fileupload_ok_button"]."\"></p>
							  </td>
							  </form>
							 </tr>
							</table>
						</span>
					</td>
				</tr>
				</table><br />
				";
				break;

			case 'DO_MOVE':
                if (dynpg_getRightsToUser(C_RIGHTS_CREATE, 'GROUP', $_POST["NEW_IMAGE_GROUP"], 'asValue', true)) {
                    $SQL = "SELECT * FROM `dynpg_cms_imagegroup_treestruct` WHERE `element_id_fk`=".mysql_real_escape_string($_POST["NEW_IMAGE_GROUP"]);
    				$RES = mysql_query($SQL);
    				if(!mysql_num_rows($RES)){
    					$allowed=TRUE;
    				}
    				else{
    					while($ROW=mysql_fetch_array($RES)){
    						if(is_null($ROW["successor_id_fk"])){
    							$allowed=TRUE;
    						}
    						else{
    							$allowed=FALSE;
    						}
    					}
    				}
    				@mysql_free_result($RES);

    				if($allowed){
    					$movestr="";
    					for ($i=1; $i<=$_POST["BATCH_ACTION"]; $i++)
    						if ( isset($_POST["Check?$i"]) && $_POST["Check?$i"]=="1" )
    							$movestr.=$i.";";

    					$move_array = explode(";", $movestr);

    					foreach ($move_array as $i)
    					{
    						$SQL = "UPDATE `dynpg_cms_images` SET `USERGROUP`='".mysql_real_escape_string($_POST["NEW_IMAGE_GROUP"])."' WHERE `id`='".mysql_real_escape_string($i)."'";
    						mysql_query($SQL);

    						$Sucessfull=TRUE;
    					}
    					echo "
    					<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
    					<tr>
    						<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
    							<img src=\"pictures/innertext_info.jpg\"><br />
    							<span class=\"green\">
    							 <i>".$GLOBALS["lang_dpg"]->str["lang_message_success"]."<br /></i>
    							</span>
    						</td>
    					</tr>
    					</table><br />
    					";
    				}
    				else{
    					echo "
    					<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
    					<tr>
    						<td bgcolor=".C_WEBSITE_MAINBACKGROUND." valign=top>
    							<img src=\"pictures/innertext_info.jpg\"><br />
    							<span class=\"yellow\">
    								<i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_error_1"]."</i>
    							</span>
    						</td>
    					</tr>
    					</table><br />
    					";
    				}
    			} else {
    			    $Sucessfull=FALSE;
                    echo "
    					<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
    					<tr>
    						<td bgcolor=".C_WEBSITE_MAINBACKGROUND." valign=top>
    							<img src=\"pictures/innertext_info.jpg\"><br />
    							<span class=\"yellow\">
    								<i>".$GLOBALS["lang_dpg"]->str["lang_message_failure"]."</i>
    							</span>
    						</td>
    					</tr>
    					</table><br />
    					";
    			}
				break;
		}
	}

	$Sucessfull = TRUE;

    // When a file exeeds the max_file_size value php sometimes aborts the script
    // yielding empty _FILES and _POST arrays. We then have to throw an error
    // when there is a post request anyway.
    // @see http://php.net/manual/en/features.file-upload.php
    if (empty($_FILES) && empty($_POST) && isset($_SERVER['REQUEST_METHOD']) && strtolower($_SERVER['REQUEST_METHOD']) == 'post') {
        $Sucessfull = FALSE;
        $_POST["STATUS"] = 'ERROR';
        $_POST["TYPE"] = 'ERROR';
        $output = $GLOBALS["lang_dpg"]->str["lang_fileupload_message_5a"];
    }

	if ( !empty($_POST["STATUS"]) )
	{
		if ( $_POST["TYPE"]=="delete_verified" )
		{
			if (dynpg_getRightsToUser(C_RIGHTS_DELETE, 'ARTICLE', $_POST['DELID'], 'asValue', true)) {
                $SQL = "SELECT * FROM `dynpg_cms_images` WHERE `id`='".mysql_real_escape_string($_POST['DELID'])."'";
    			$RES = mysql_query($SQL);
    			$ROW = mysql_fetch_object($RES);

                @mysql_free_result($RES);

    			$SQL = "DELETE FROM `dynpg_cms_images` WHERE `id`='".mysql_real_escape_string($_POST['DELID'])."'";
    			$RES = mysql_query($SQL);

    			mysql_query("DELETE FROM `dynpg_cms_images_rights` WHERE `USERID` = '".mysql_real_escape_string($_SESSION['ID'])."' AND `PARENT` = 'ARTICLE' AND `SECTION` = ".mysql_real_escape_string($_POST['DELID']));

    			if ( file_exists("./".FORMS_IMAGES_DESTINATIONURL_ROOT.$ROW->URL) ) {
    				unlink("./".FORMS_IMAGES_DESTINATIONURL_ROOT.$ROW->URL);
                }

    			@mysql_free_result($RES);
    		} else {
                $Sucessfull = FALSE;
    		}
		}
		else
		{
            switch ($_POST["TYPE"])
			{
				case $GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"]:

					if (dynpg_getRightsToUser(C_RIGHTS_CREATE, 'GROUP', $_POST["GROUP"], 'asValue', true)) {
                        // upload files, no archives

    					$Uploaded_file 		= FALSE;
    					$add_to_group 		= $_POST["GROUP"];
    					$NewImageNumber_all = "";
    					$output 			= "";

    					$n = 0;

    					while($_POST["FILE_COUNT"] > $n) {

    						$img = $_FILES["NEW_IMAGE_URL"]["name"][$n];
    						$file_extension = strtolower(substr($img, (strpos(strrev($img), ".")*(-1)) ));
    						unset($img);

    						$description_check = empty($_POST["NEW_IMAGE_DESCR_".$n])? "add for CheckSlashes" : $_POST["NEW_IMAGE_DESCR_".$n];

    						if ( !(empty($_FILES["NEW_IMAGE_URL"]["name"][$n])) && CheckSlashes($_POST["NEW_IMAGE_NAME_".$n]) && CheckSlashes($description_check) ) {
    							if ( ($_FILES["NEW_IMAGE_URL"]["size"][$n]>=($_mysql_Tbl_cms_bin['set_maxupload_kb']*1024)) ) {
    								$output.="<br />- ".$_FILES["NEW_IMAGE_URL"]["name"][$n]." (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." ".($n+1).": ".$GLOBALS["lang_dpg"]->str["lang_fileupload_reason_1"].")";
    								$Sucessfull = TRUE;
    							}
    							else if ( !in_array($file_extension, $_mysql_Tbl_cms_bin['set_filetypes']) ) {
    								$output.="<br />- ".$_FILES["NEW_IMAGE_URL"]["name"][$n]." (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." ".($n+1).": ".$GLOBALS["lang_dpg"]->str["lang_fileupload_reason_2"].")";
    								$Sucessfull = TRUE;
    							} else {
    								$file_extension = "." . $file_extension;

    								$file_name = mysql_real_escape_string($_POST["NEW_IMAGE_NAME_".$n]);
    								$file_desc = $_POST["NEW_IMAGE_DESCR_".$n];

                                    // try to get iptc data from tmp before image copy or save
                                    if(empty($file_desc) && is_callable('iptcparse') && ($_FILES["NEW_IMAGE_URL"]["type"][$n] == 'image/jpeg' || $_FILES["NEW_IMAGE_URL"]["type"][$n] == 'image/pjpeg')){
                                        $size = getimagesize($_FILES["NEW_IMAGE_URL"]["tmp_name"][$n], $exif);
                                        if (isset($exif["APP13"])) {
                                            if($exif = iptcparse( $exif["APP13"] ) ) {
                                                $file_desc = str_replace(array("\000","'","\\",'"','`'), '', $exif["2#120"][0] );
                                                if(isset($exif["1#090"]) && $exif["1#090"][0] == "\x1B%G")
                                                    $file_desc = utf8_decode($file_desc);
                                            }
                                        }
                                    }
                                    // try to get exif data from tmp before image copy or save
                                    if(empty($file_desc) && is_callable('exif_read_data') && ($_FILES["NEW_IMAGE_URL"]["type"][$n] == 'image/jpeg' || $_FILES["NEW_IMAGE_URL"]["type"][$n] == 'image/pjpeg')){
                                        $exif = exif_read_data($_FILES["NEW_IMAGE_URL"]["tmp_name"][$n]);
                                        if(isset($exif['ImageDescription'])){
                                            $file_desc = str_replace(array("'","\\",'"','`'), '', $exif['ImageDescription']);
                                        }
                                    }
                                    $file_desc = mysql_real_escape_string($file_desc);

    								if (empty($_POST["NEW_IMAGE_ORIGNAME_{$n}"])) {
    									$RES = mysql_query("INSERT INTO `dynpg_cms_images` (`NAME`, `URL`, `DESCR`, `USERGROUP`)
    															VALUES ('".$file_name."','/".mysql_real_escape_string((empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"])?'':'community_')."imgfile[-]".$file_extension)."','".$file_desc."','".mysql_real_escape_string($add_to_group)."')");

    									$NewImageNumber = mysql_insert_id();
    									$ROW = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='$NewImageNumber'"));
    									$new_filename = str_replace("[-]", $NewImageNumber, $ROW->URL);
    									mysql_query("UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`URL`='".mysql_real_escape_string($new_filename)."' WHERE `id`='$NewImageNumber'");
    									$file_path = $new_filename;
    								} else {
    									$file_path = (empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"])?'':'community_').$_FILES["NEW_IMAGE_URL"]["name"][$n];
    									if (file_exists("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" .$file_path)) {
    										$file_path = str_replace($file_extension, '', $file_path) . '_' . uniqid('') . $file_extension;
    									}

    									$RES = mysql_query("INSERT INTO `dynpg_cms_images` (`NAME`, `URL`, `DESCR`, `USERGROUP`)
    															VALUES ('".$file_name."','/".mysql_real_escape_string($file_path)."','" . $file_desc . "','".mysql_real_escape_string($add_to_group)."')");
    									$NewImageNumber = mysql_insert_id();
    								 }

    								 @mysql_free_result($RES);

                                     mysql_query("INSERT INTO `dynpg_cms_images_rights`(`USERID`, `PARENT`, `SECTION`, `CREATE`, `DELETE`, `CHANGE`)
                                            VALUES ('".mysql_real_escape_string($_SESSION["ID"])."', 'ARTICLE', '{$NewImageNumber}',
                                            'TRUE', 'TRUE', 'TRUE')");

                                    $res = move_uploaded_file($_FILES["NEW_IMAGE_URL"]["tmp_name"][$n],
    										"./" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" . $file_path);

    								chmod("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . "/" . $file_path, 0644);

    								$render = re_render_image($NewImageNumber, !empty($_POST["NEW_IMAGE_COMMUNITY_{$n}"]));

    								if ($render < 0)
    								    $output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_4"] . ")";
    								elseif($render === false)
    								    $output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_5"] . ")";

    								$NewImageNumber_all .= $NewImageNumber . ", ";
    								$Uploaded_file = TRUE;
    								$Sucessfull    = TRUE;
    							}
    						} else {
    							$output .= "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"][$n] . " (".$GLOBALS["lang_dpg"]->str["lang_fileupload_file"]." " . ($n+1) . ": " . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_3"] . ")";
    							$Sucessfull = TRUE;
    						}
    						$n++;
    					}

    					if ($n == 0){
    						$Sucessfull = FALSE;
    					}
    				} else {
    				    $Sucessfull = FALSE;
    				}

                // end case
				break;

				case $GLOBALS["lang_dpg"]->str["lang_fileupload_change_button"]:
                    // begin case

                    if (dynpg_getRightsToUser(C_RIGHTS_CHANGE, 'ARTICLE', $_POST["CHGID"], 'asValue', true)) {
        				$description_check = empty($_POST["NEW_IMAGE_DESCR"])? "add for CheckSlashes" : $_POST["NEW_IMAGE_DESCR"];
        				if ( CheckSlashes($_POST["NEW_IMAGE_NAME"]) && CheckSlashes($description_check) )
        				{

        					$SQL = "UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`NAME`='".mysql_real_escape_string($_POST["NEW_IMAGE_NAME"])."' WHERE `dynpg_cms_images`.`id`='".mysql_real_escape_string($_POST['CHGID'])."'";
        					$RES = mysql_query($SQL);

        					$SQL = "UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`DESCR`='".mysql_real_escape_string($_POST["NEW_IMAGE_DESCR"])."' WHERE `dynpg_cms_images`.`id`='".mysql_real_escape_string($_POST['CHGID'])."'";
        					$RES = mysql_query($SQL);

        					$SQL = "UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`USERGROUP`='".mysql_real_escape_string($_POST["NEW_IMAGE_GROUP"])."' WHERE `dynpg_cms_images`.`id`='".mysql_real_escape_string($_POST['CHGID'])."'";
        					$RES = mysql_query($SQL);

        					if ( !empty($_FILES["NEW_IMAGE_URL"]["name"]) )
        					{
        						$img = $_FILES["NEW_IMAGE_URL"]["name"];
        						$file_extension = strtolower(substr($img, (strpos(strrev($img), ".")*(-1)) ));
        						unset($img);

        						if ( !in_array($file_extension,$_mysql_Tbl_cms_bin['set_filetypes']) ) {
                                    $Sucessfull = FALSE;
                                } else {
        							$IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='".mysql_real_escape_string($_POST['CHGID'])."'"));

        							@unlink("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . $IMG['URL']);

        							$file_extension = "." . $file_extension;

        							if (empty($_POST["NEW_IMAGE_ORIGNAME"])) {
        								$file_path = "/" . (empty($_POST["NEW_IMAGE_COMMUNITY"])? '': 'community_') . "imgfile".(int)$_POST['CHGID']."{$file_extension}";
        							} else {
        								$file_path = "/" . (empty($_POST["NEW_IMAGE_COMMUNITY"])? '': 'community_') . $_FILES["NEW_IMAGE_URL"]["name"];
        								if (file_exists("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . $file_path)) {
        									$file_path = str_replace($file_extension, '', $file_path) . '_' . uniqid('') . $file_extension;
        								}
        							}

        							$SQL = "UPDATE `dynpg_cms_images` SET `dynpg_cms_images`.`URL`='".mysql_real_escape_string($file_path)."' WHERE `id`='".mysql_real_escape_string($_POST['CHGID'])."'";
        							$RES = mysql_query($SQL);

        							@mysql_free_result($RES);

        							$res = move_uploaded_file($_FILES["NEW_IMAGE_URL"]["tmp_name"], "./" . FORMS_IMAGES_DESTINATIONURL_ROOT . "{$file_path}");
        							chmod("./" . FORMS_IMAGES_DESTINATIONURL_ROOT . "{$file_path}", 0644);

                                    $render = re_render_image($_POST['CHGID'], !empty($_POST["NEW_IMAGE_COMMUNITY"]));

                                    if ($render < 0) {
    								    $output = "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"] . " (" . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_4"] . ")";
    								    $NewImageNumber_all = $_POST['CHGID'];
                                        $Uploaded_file = TRUE;
    								} elseif($render === false) {
    								    $output = "<br />- " . $_FILES["NEW_IMAGE_URL"]["name"] . " (" . $GLOBALS["lang_dpg"]->str["lang_fileupload_reason_5"] . ")";
    								    $NewImageNumber_all = $_POST['CHGID'];
                                        $Uploaded_file = TRUE;
    								}

        							$Sucessfull = TRUE;
        						}
        					} else {
                                $Sucessfull = TRUE;
                                }

        					@mysql_free_result($RES);

        				} else {
                            $Sucessfull = FALSE;
                        }
                    } else {
                        $Sucessfull = FALSE;
                    }
                // end case
				break;

				case $GLOBALS["lang_dpg"]->str["lang_fileupload_unzip_button"]:
				//begin case
				    if (dynpg_getRightsToUser(C_RIGHTS_CREATE, 'GROUP', $group, 'asValue', true)) {
    					$output = "";
    					$save_as = FORMS_IMAGES_DESTINATIONURL_ROOT."/userpack.zip";
    					$extension = strtolower(substr($_FILES["NEW_ZIP"]["name"], (strpos(strrev($_FILES["NEW_ZIP"]["name"]), ".")*(-1)) ));
    					$maxFilesize = substr(ini_get('upload_max_filesize'),0,-1);
    					if(empty($maxFilesize)){ $maxFilesize = 8; }

    					if(empty($_FILES["NEW_ZIP"]["name"]) || !in_array($extension,$_mysql_Tbl_cms_bin['set_filetypes']) || $extension!="zip"){
    						$output.= $GLOBALS["lang_dpg"]->str["lang_fileupload_message_6a"];
    						$zip_fault = TRUE;
    					}
    					else if( ($_FILES["NEW_ZIP"]["size"]/1024) > ($maxFilesize*1024) ){
    						$output.= $GLOBALS["lang_dpg"]->str["lang_fileupload_message_6b"]." ".round($_FILES["NEW_ZIP"]["size"]/1024)." Kb (max. ".($maxFilesize*1024)." Kb)";
    						$zip_fault = TRUE;
    					}
    					else{
    						move_uploaded_file($_FILES["NEW_ZIP"]["tmp_name"],$save_as);
    						if(file_exists($save_as)){
                                $noSuccess = unzipFiles(realpath($save_as), $_mysql_Tbl_cms_bin['set_filetypes'], $group);
    							unlink($save_as);
    							if(!empty($noSuccess)){
    								$output .= $GLOBALS["lang_dpg"]->str["lang_fileupload_message_6c"]."<br />".$noSuccess;
    								$zip_fault = TRUE;
    							}
    						}
    						else{
    							$output.= $GLOBALS["lang_dpg"]->str["lang_fileupload_message_6d"];
    							$zip_fault = TRUE;
    						}
    					}
    					$Sucessfull = TRUE;
    				} else {
    				    $Sucessfull = FALSE;
    				}
    			// end case
				break;

				default:
					// Default ~ User has no rights
					$Sucessfull = FALSE;
				break;
			}
		}
	} // end if block @ [!empty($_POST["STATUS"])]

	if ( $Sucessfull && !empty($_POST["STATUS"]) && !$zip_fault && !empty($output) )
	{
		echo "
		<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
		<tr>
			<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
				<img src=\"pictures/innertext_info.jpg\"><br />";
				if($Uploaded_file){
		echo "
				<span class=\"green\">
				<i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1a"].	$NewImageNumber_all.$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1b"]."</i></span><br /><br /><span class=\"red\"><i>";
				}
				else {
		echo "
				<span class=\"red\"><i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_2"]."<br /><br />";
				}
		echo
			$GLOBALS["lang_dpg"]->str["lang_fileupload_message_3a"].$output." <br /><br />".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_3b"]."</span>
			</td>
		</tr>
		</table><br />
		";
	}
	elseif ( $Sucessfull && !empty($_POST["STATUS"]) && $zip_fault && !empty($output) )
	{
		echo "
		<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
		<tr>
			<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
				<img src=\"pictures/innertext_info.jpg\"><br />
				<span class=\"red\">
					<i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_2b"]."</i><br /><br />$output
				</span>
			</td>
		</tr>
		</table><br />
		";
	}
	elseif ( $Sucessfull && !empty($_POST["STATUS"]) )
	{
		echo "
		<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
		<tr>
			<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
				<img src=\"pictures/innertext_info.jpg\"><br />
				<span class=\"green\">
				 <i>
					".$GLOBALS["lang_dpg"]->str["lang_message_success"]."<br />";
					if ( !empty($NewImageNumber) )
					echo $GLOBALS["lang_dpg"]->str["lang_fileupload_message_4a"].$NewImageNumber_all.$GLOBALS["lang_dpg"]->str["lang_fileupload_message_1b"];
		echo "
				 </i>
				</span>
			</td>
		</tr>
		</table><br />
		";
	}
	else if ( !empty($_POST["STATUS"]) )
	{
		echo "
		<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
		<tr>
			<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
				<img src=\"pictures/innertext_info.jpg\"><br />
				<span class=\"red\"><i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5a"].$_mysql_Tbl_cms_bin['set_maxupload_kb'].$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5b"].strtoupper(implode(", ",$_mysql_Tbl_cms_bin['set_filetypes'])).$GLOBALS["lang_dpg"]->str["lang_fileupload_message_5c"]."</i></span>
				 <br />
				 <span class=\"red\">&raquo;<span class=\"CourierNewFont\"> <i>Debug:</i> ";print_r($_FILES);echo"</span>&laquo;<br /><br />
				 <b></b><br />
				 </i>
				 </span>
			</td>
		</tr>
		</table><br />
		";
	}
	else if (!empty($acttype) && $acttype=="del" && !empty($aid))
	{
		echo "
		<table border=\"0\" Cellpadding=\"8\" Cellspacing=\"0\" class=\"InnerWebsiteTable\" width=\"400\">
		<tr>
			<td bgcolor=\"".C_WEBSITE_MAINBACKGROUND."\" valign=\"top\">
				<img src=\"pictures/innertext_info.jpg\"><br />
				<span class=\"yellow\">
					<i>".$GLOBALS["lang_dpg"]->str["lang_fileupload_ask_delete"]."</i>
					<p align=\"right\">
					<table border=\"0\" Cellspadding=\"0\" Cellspacing=\"0\">
					 <tr>
					  <form action=\"$PHP_SELF?show=$show&group=$group\" method=\"post\" name=\"SUBMIT_DEL_IMAGE\">
					  <td>
						<input type=\"hidden\" value=\"{$aid}\" name=\"DELID\">
				 		<input type=\"hidden\" value=\"SUBMITTED\" name=\"STATUS\">
						<input type=\"hidden\" value=\"delete_verified\" name=\"TYPE\">
						<input type=\"submit\" class=\"ButtonStyleWhite\" value=\" ".$GLOBALS["lang_dpg"]->str["lang_fileman_yes"]." \">
					  </td>
					  </form>
					  <form action=\"$PHP_SELF?show=$show&group=$group\" method=\"post\" name=\"SUBMIT_DEL_IMAGE\">
					  <td>
					  	<input type=\"submit\" class=\"ButtonStyleWhite\" value=\"".$GLOBALS["lang_dpg"]->str["lang_fileman_no"]."\">
					  </td>
					  </form>
					 </tr>
					</table>
					</p>
				</span>
			</td>
		</tr>
		</table><br />
		";
	}
?>

<?php if ($group > 0 || (isset($acttype) && $acttype=="chg")) { ?>

    <div style="float: right; margin: 0;">
        <img src="pictures/btn_config_fileupload.png" title="<?php print $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_settings"]; ?>" alt="settings" style="cursor: pointer;" onclick="return jv_open_file_upload_settings();" />
    </div>

    <table border="0" Cellpadding="6" Cellspacing="0" class="WebsiteTable" width="500">
		<tr>
			<td bgcolor="<?php if (!isset($acttype)||($acttype=="del")) echo C_WEBSITE_AKTBACKGROUND; else echo C_WEBSITE_MAINBACKGROUND; ?>">
				<img src="pictures/imgbtn_upload.gif">
				<a href="<?php echo $PHP_SELF."?show=$show&group=$group&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]"; ?>"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_fileUpload"]; ?><b></a>
			</td>
			<td bgcolor="<?php if (isset($acttype)&&($acttype=="zip")) echo C_WEBSITE_AKTBACKGROUND; else echo C_WEBSITE_MAINBACKGROUND; ?>">
				<img src="pictures/imgbtn_upload.gif">
				<a href="<?php echo $PHP_SELF."?show=$show&group=$group&acttype=zip"; ?>"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_zipUpload"]; ?><b></a>
			</td>
			<td bgcolor="<?php if (isset($acttype)&&($acttype=="chg")) echo C_WEBSITE_AKTBACKGROUND; else echo C_WEBSITE_MAINBACKGROUND; ?>">
				<img src="pictures/imgbtn_edit.gif">
				<b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_fileChange"]; ?></b>
			</td>
			<td></td>
		</tr>
	</table>

	<table border="0" Cellpadding="8" Cellspacing="0" width="100%" class="InnerWebsiteTable">
		<tr>
			<td bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>" valign="top">

                <form action="<?php echo $PHP_SELF . "?show={$show}&amp;group={$group}"; ?>" enctype="multipart/form-data" method="post" name="SUBMIT_NEW_IMAGE" accept-charset="ISO-8859-1" style="margin: 0;">
                    <div id="fileupload_settings" style="width: 540px;" class="multifunctionLayer">
                        <fieldset>
                            <legend><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_settings"]; ?></legend>

                            <table border="0" Cellpadding="2" Cellspacing="0" style="width: 98%;" class="InnerWebsiteTableTransparent">
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                              <td width="100" valign="top"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_size"]; ?></b></td>
                              <td nowrap="nowrap">
                                <p style="margin: 1px;"><input type="text" value="" name="FILEUPLOAD_SIZE_X" style="width: 40px;" class="TextFieldStyleWhite" /> X
                                <input type="text" value="" name="FILEUPLOAD_SIZE_Y" style="width: 40px;" class="TextFieldStyleWhite" /> px</p>

                                <p style="margin: 1px;"><input type="text" value="100" name="FILEUPLOAD_SIZE_X_PC" style="width: 40px;" class="TextFieldStyleWhite" /> X
                                <input type="text" value="100" name="FILEUPLOAD_SIZE_Y_PC" style="width: 40px;" class="TextFieldStyleWhite" /> %</p>
                              </td>
                              <td align="left" valign="top" nowrap="nowrap" width="100%">
                                <p style="margin: 1px;">
                                    <input type="radio" name="FILEUPLOAD_SIZE_RULE" value="max" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_size_max"]; ?><br />
                                    <input type="radio" name="FILEUPLOAD_SIZE_RULE" value="exa" checked="checked" /> <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_size_exa"]; ?>
                                </p>
                              </td>
                             </tr>
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
                              <td width="100"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_quality"]; ?></b></td>
                              <td colspan="2">
                                <?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_value"]; ?>
                                <input type="text" value="100" maxlength="3" name="FILEUPLOAD_QUALITY" style="width: 35px; text-align: center;" class="TextFieldStyleWhite" />
                              </td>
                             </tr>
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                              <td width="100" valign="middle"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark"]; ?></b></td>
                              <td colspan="2">
                                <input type="hidden" name="FILEUPLOAD_WATERMARK" id="FILEUPLOAD_WATERMARK" value="" />
                                <input type="text" name="resume_input" id="resume_input" value="" style="width: 250px;" class="TextFieldStyleWhite" />

                                <a href="javascript: LoadPopUp('backendpopup/popup.php?popUpResource=images&refID=FILEUPLOAD_WATERMARK', '800', '600', 'yes');"><img src="pictures/imgbtn_openpopup.gif" alt="<?php echo $GLOBALS["lang_dpg"]->str["lang_group_choseFile"]; ?>" title="<?php echo $GLOBALS["lang_dpg"]->str["lang_group_choseFile"]; ?>" border="0" /></a>
                              </td>
                             </tr>
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
                              <td width="100" valign="middle"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos"]; ?></b></td>
                              <td colspan="2">
                                <select name="FILEUPLOAD_WATERMARK_POS" class="TextFieldStyleWhite">
                                    <option value="LU"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_lu"]; ?></option>
                                    <option value="LD"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_ld"]; ?></option>
                                    <option value="RU"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_ru"]; ?></option>
                                    <option value="RD"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_rd"]; ?></option>
                                    <option value="CU"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_cu"]; ?></option>
                                    <option value="CD"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_cd"]; ?></option>
                                    <option value="CC"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_watermark_pos_cc"]; ?></option>
                                </select>
                              </td>
                             </tr>
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                              <td colspan="3">
                                <input type="checkbox" value="1" name="FILEUPLOAD_AS_COPY" />
                                <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batch_copy"]; ?>
                              </td>
                             </tr>
                             <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
                              <td align="left" style="padding-top: 5px;"><input type="button" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_abort_button"]; ?>" onclick="return close_dialog('fileupload_settings');"></td>
                              <td align="right" style="padding-top: 5px;" colspan="2"><input type="button" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileedit_ok_button"]; ?>" onclick="return jv_save_dialog();"></td>
                             </tr>
                            </table>
                        </fieldset>
                    </div>

                <?php if ($SubmitButtonValue == $GLOBALS["lang_dpg"]->str["lang_fileupload_upload_button"]) { ?>

                    <div id="upload">
					   <table border="0" Cellpadding="3" Cellspacing="0" style="width: 100%;" class="InnerWebsiteTableTransparent">
							<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
								<td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_uploadField"]; ?></b></td><td style="width: 100%;"><input type="file" size="40" name="NEW_IMAGE_URL[0]" onchange="more_files();" class="TextFieldStyleWhite" /></td>
							</tr>
							<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
								<td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_titleField"]; ?></b></td><td><input type="text" size="55" name="NEW_IMAGE_NAME_0" class="TextFieldStyleWhite" /></td>
							</tr>
							<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
								<td><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_descField"]; ?></b></td><td><input type="text" size="55" name="NEW_IMAGE_DESCR_0"  class="TextFieldStyleWhite" />
								</td>
							</tr>
							<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
								<td>&nbsp;</td>
								<td>
									<input type="checkbox" value="1" name="NEW_IMAGE_ORIGNAME_0" style="margin: 0;" />
									<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_origName"]; ?>
								</td>
							</tr>
                            <?php
                            if($dpgcommunity_exists){
                            ?>
                                <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                                    <td>&nbsp;</td>
                                    <td>
                                        <input type="checkbox" value="1" name="NEW_IMAGE_COMMUNITY_0" style="margin: 0;" />
                                        <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_communityName"]; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
						</table>
                    </div>

					<div id="upload_0"></div>

					<table width="100%">
						<tr>
							<td align="right" bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>"><input type="hidden" name="GROUP" value="<?php echo $group; ?>" /><input type="submit" name="submit" class="ButtonStyleWhite" value="<?php echo $SubmitButtonValue; ?>" /></TD>
						</tr>
					</table>

					<input type="hidden" name="FILE_COUNT" value="0" />
					<input type="hidden" value="<?php echo dynpg_htmlentities_rigid($SubmitButtonValue,ENT_COMPAT,true); ?>" name="TYPE">
					<input type="hidden" value="<?php if (!empty($aid)) echo $aid; ?>" name="CHGID">
					<input type="hidden" value="SUBMITTED" name="STATUS">

                <?php } elseif ($SubmitButtonValue == $GLOBALS["lang_dpg"]->str["lang_fileupload_unzip_button"]) { ?>

					 <table width="100%" border="0" Cellpadding="3" Cellspacing="0" class="InnerWebsiteTableTransparent">
						<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
							<td>
								<b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_zipField"]; ?></b>
							</td>
							<td width="100%">
								<input type="file" size="100" name="NEW_ZIP" class="TextFieldStyleWhite" />
							</td>
						</tr>
						<tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
							<td width="92">
							</td>
							<td>
								<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_zipInfo"]; ?>
							</td>
						</tr>
						<?php
                        if($dpgcommunity_exists){
                        ?>
                            <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
                                <td>&nbsp;</td>
                                <td>
                                    <input type="checkbox" value="1" name="NEW_ZIP_COMMUNITY" style="margin: 0;" />
                                    <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_communityName"]; ?>
                                </td>
                            </tr>
                        <?php
                        }
                        ?>
					</table>

					<table width="100%">
						<tr>
							<td align="right" bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>"><input type="hidden" name="GROUP" value="<?php echo $group; ?>" /><input type="submit" name="submit" class="ButtonStyleWhite" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_unzip_button"]; ?>" /></td>
						</tr>
					</table>

                    <input type="hidden" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_unzip_button"]; ?>" name="TYPE">
					<input type="hidden" value="SUBMITTED" name="STATUS">

                <?php } else { ?>

                    <table border="0" Cellpadding="3" Cellspacing="0" style="width: 100%" class="InnerWebsiteTableTransparent">
    				    <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
    						<td valign="top"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_uploadField"]; ?></b></td>
    						<td style="width: 100%"><input type="file" size=40 name="NEW_IMAGE_URL" class="TextFieldStyleWhite">
    							<b><?php echo $_get_ImageUrl; ?></b>
    							</td>
    					 </tr>
    					 <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
    						<td width="100"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_titleField"]; ?></b></td>
    						<td><input type="text" size=55 name="NEW_IMAGE_NAME" class="TextFieldStyleWhite" maxlength="255" value="<?php echo $_get_ImageName; ?>">
    							</td>
    					 </tr>
    					 <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
    						<td width="70" valign="top"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_descField"]; ?></b></td>
    						<td><input type="text" size=55 name="NEW_IMAGE_DESCR" class="TextFieldStyleWhite" maxlength="255" value="<?php echo $_get_ImageDesc; ?>">
    							</td>
    					 </tr>
    					 <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
    						<td width="100"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_groupField"]; ?></b></td>
    						<td><select size="1" name="NEW_IMAGE_GROUP" class="TextFieldStyleWhite">
    								<option value="NULL"<?php if ( $_get_GroupParent == 'NULL' ) { echo ' selected="selected"'; } ?>><?php echo $GLOBALS["lang_dpg"]->str["lang_filegroups_no_maingroup"]; ?></option>
    								 <?php

    									$mysql_result = mysql_query("SELECT DISTINCT
    																	A.*,
    																	B.*
    																 FROM
    																	`dynpg_cms_imagegroup_treestruct` AS A
    																	INNER JOIN `dynpg_cms_imagegroups` AS B
    																	ON A.`element_id_fk` = B.`id`
    																 WHERE
    																	A.`root_id_fk` IS NULL
    																 GROUP BY
    																	A.`element_id_fk`
    																 ORDER BY
    																	B.`".mysql_real_escape_string(str_replace('`','',$orderby))."` ".((strtoupper($sort) == 'ASC')?'ASC':'DESC'));
    	                        $GLOBALS['__HTML_OUT_ROW'] = '<option value="%ID%" selected="selected">%SYMB% %NAME%</option>';

    	                        while ( $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC) ) {
    	                            $_ouput = $GLOBALS['__HTML_OUT_ROW'];

    	                            if ( !is_null($mysql_row['successor_id_fk']) ) {
    	                                $__grp_has_Successors = TRUE;
    	                            } else {
    	                                $__grp_has_Successors = FALSE;
    	                            }

    	                            if ( $__grp_has_Successors ) {
    	                                $_ouput = str_replace('%SYMB%', '', $_ouput);
    	                            } else {
    	                                $_ouput = str_replace('%SYMB%', '', $_ouput);
    	                            }

    	                            foreach ( $mysql_row as $key => $value ) {
    	                                $value = dynpg_htmlentities_rigid($value,ENT_COMPAT,true);

    	                                $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
    	                            }

    	                            if ( $_get_GroupParent != $mysql_row['id'] ) {
    	                                $_ouput = str_replace(' selected="selected"', '', $_ouput);
    	                            }

    	                            /*if ( $take != $mysql_row['element_id_fk'] ) {
    	                                $_ouput = str_replace(' selected="selected"', '', $_ouput);
    	                            }*/

    	                            if (dynpg_getRightsToUser(null, 'GROUP', $mysql_row['element_id_fk'], 'asArray', true) != Array('FALSE', 'FALSE', 'FALSE')) {
                                        echo $_ouput;

        	                            if ( !is_null($mysql_row['element_id_fk']) ) {
        	                                    dnypg_interna_List_Successors_img($mysql_row['element_id_fk'], 1, $GLOBALS['__HTML_OUT_ROW'], 'NAME', 'ASC', FALSE, $_get_GroupParent, TRUE);
        	                            }
        	                        }
    	                        }

    									@mysql_free_result($RES);
    								 ?>
    								</select></td>
    					 </tr>
    					 <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
    						<td>&nbsp;</td>
    						<td>
    							<input type="checkbox" value="1" name="NEW_IMAGE_ORIGNAME" style="margin: 0;" />
    							<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_origName"]; ?>
    						</td>
    					</tr>
    					<?php
                        if($dpgcommunity_exists){
                        ?>
                            <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                                <td>&nbsp;</td>
                                <td>
                                    <input type="checkbox" value="1" name="NEW_IMAGE_COMMUNITY" style="margin: 0;" <?php print preg_match('/^\/community_/', $_get_realImageUrl)? 'checked="checked"': ''; ?> />
                                    <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_communityName"]; ?>
                                </td>
                            </tr>
                        <?php
                        }
                        ?>
                    </table>

                    <p align="right" style="margin: 5px 0 0 0;"><input type="submit" class="ButtonStyleWhite" value="<?php echo $SubmitButtonValue; ?>"></p>

                    <input type="hidden" value="<?php echo dynpg_htmlentities_rigid($SubmitButtonValue,ENT_COMPAT,true); ?>" name="TYPE">
                    <input type="hidden" value="<?php if (!empty($aid)) echo $aid; ?>" name="CHGID">
                    <input type="hidden" value="SUBMITTED" name="STATUS">

                <?php } ?>

                </form>

			</td>
		</tr>
	</table>

<?php } ?>

<br />

<table border="0" Cellpadding="8" Cellspacing="0" width="100%" class="InnerWebsiteTable">
<tr>
	<td bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>" valign="top">

 	<table border="0" Cellpadding="5" Cellspacing="0" class="InnerWebSiteTableWhite" width="100%">
		<form action="<?php echo $PHP_SELF."?show=$show&group=$group"; ?>" method="post" name="SUBMIT_SHOW">
		<tr>
		 <td valign="top" align="left">
			<p><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_ask_selection"]; ?></b></p>
				<table border="0" Cellpadding="5" Cellspacing="0" width="100%">
				<tr>
				 <?php
				 	$selected = array("","","","");

					switch ($Page["type"])
					{
						case "ALL": 		$selected[0]="checked"; break;
						case "CATEGORY": 	$selected[1]="checked"; break;
						case "GROUP": 		$selected[2]="checked"; break;
                        case "SEARCH": 		$selected[3]="checked"; break;
					}
				 ?>
				 <td width="20"><input type="radio" name="SHOWTYPE" value="ALL" <?php echo $selected[0]; ?>></td>
				 <td><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_sel_1"]; ?></td>
				</tr>
				<tr>
				 <td width="20"><input type="radio" id="SRCHSHOW" name="SHOWTYPE" value="SEARCH" <?php echo $selected[3]; ?>></td>
				 <td>
				 	<input type="text" name="SRCHQUERY" value="<?php echo ( !empty($_POST['SRCHQUERY']) ? $_POST['SRCHQUERY'] : ' '.$GLOBALS["lang_dpg"]->str["lang_fileupload_sel_2"] ); ?>" style="width:500px; background-color: rgb(198, 231, 255);" class="TextFieldStyleWhite" onFocus="javascript: document.getElementById('SRCHSHOW').checked = true; if(this.value == ' <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_sel_2"]; ?>'){ this.value = '';}" onBlur="javascript: if(this.value == ''){ this.value = ' <?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_sel_2"]; ?>';}">
				 </td>
				</tr>
				</table>
					<br />
				<table border="0" Cellpadding="5" Cellspacing="0" class="InnerWebSiteTableWhite" width="100%">
				<tr>
					<td valign="top" align="right">
					<?php
						$SQL = $Clausel;
						$RES = mysql_query($SQL);
					?>
						<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_page"]; ?>
						<select size="1" name="PAGE" class="TextFieldStyleWhite">
							<?php
								$_num_image_pages = (ceil(mysql_num_rows($RES)/$Page["EachPage"]));

                                for ($i=1; $i<=$_num_image_pages; $i++)
									if (($i-1)==$Page["NumPage"])
										echo "<option value=\"".($i-1)."\" selected>$i</option>";
											else echo "<option value=\"".($i-1)."\">$i</option>";
							?>
						</select>
						<select size=1 name="SHOWNUM" class="TextFieldStyleWhite">
							<?php
								for ($i=10; $i <= 200; $i += 10)
									if ($i==$Page["EachPage"])
										echo "<option value=\"$i\" selected>$i</option>";
											else echo "<option value=\"$i\">$i</option>";
							?>
						</select>
						<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_entry"]; ?> <input type="submit" name="BTN_SUBMIT_SHOW" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_show_button"]; ?>" class="ButtonStyleWhite">
						<?php
                            @mysql_free_result($RES);
                        ?>
					</td>
				</tr>
			</table>
		 </td>
		</tr>
		</form>
		</table>
			<br />
	<table border="0" Cellpadding="5" Cellspacing="0" class="InnerWebSiteTableWhite" width="100%">
			<tr>
				<td valign=top>
					<a HREF="<?php echo $PHP_SELF."?show=100"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_file_management_title"]; ?></a> -
					<?php if($group>0){ $GroupNavi=getGroupNavi($group); echo $GroupNavi; }
							else { echo $GLOBALS["lang_dpg"]->str["lang_fileupload_allFiles"]; }
					?>
				</td>
			</tr>
	</table>
	<br />
	<table border="0" Cellpadding="5" Cellspacing="0" class="InnerWebSiteTableWhite" width="100%">
			<tr>
				<td valign="top" align="left" style="font-weight:bold;">
				    <a href="#" style="text-decoration: none; font-weight: bold;" onclick="selectAll('SUBMIT_NEW-CHG_MULTIACTION'); return false;"><?php echo $GLOBALS["lang_dpg"]->str["lang_articles_selectAllArticles"]; ?></a> |
                    <a href="#" style="text-decoration: none; font-weight: bold;" onclick="unselectAll('SUBMIT_NEW-CHG_MULTIACTION'); return false;"><?php echo $GLOBALS["lang_dpg"]->str["lang_articles_unselectAllArticles"]; ?></a>
				</td>
                <td valign="top" align="right" style="font-weight:bold;">
					<?php
                        if ( (integer)$Page["NumPage"]>0 ) {
                        ?>
						<a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=$sort&orderby=$orderby&p=".((integer)$Page["NumPage"]-1)."&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_back"]; ?></a>
					<?php
                        } else {
                        echo $GLOBALS["lang_dpg"]->str["lang_fileupload_back"];
						} ?>
					|
					<?php
                        if ( (integer)$Page["NumPage"]<($_num_image_pages-1) ) {
                        ?>
						<a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=$sort&orderby=$orderby&p=".((integer)$Page["NumPage"]+1)."&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_next"]; ?></a>
					<?php
                        } else {
                        echo $GLOBALS["lang_dpg"]->str["lang_fileupload_next"];
						} ?>
				</td>
			</tr>
		</table>
			<br />
		<a name="TableHead"></a>
		<table border="0" Cellpadding="5" Cellspacing="0" width="100%" class="InnerWebSiteTableWhite">
			<tr>
				<th nowrap valign="center" align="center" width="30" class="seperated">
					<span class="Large"><img src="pictures/space.gif" height="1" width="1"></span>
				</th>
				<th valign="center" align="center" width="10" class="seperated">
					<span class="Large"><b><a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=".$actualsortarray[0]."&orderby=id&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_tbl_ID"]; ?></a></b></span>
				</th>
				<th valign="center" align="center" width="360" class="seperated">
					<span class="Large"><a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=".$actualsortarray[1]."&orderby=NAME&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_tbl_name"]; ?></b></a></span>
				</th>
				<th valign="center" align="center" class="seperated">
					<span class="Large"><a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=".$actualsortarray[1]."&orderby=DESCR&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_tbl_desc"]; ?></b></a></span>
				</th>
				<th valign="center" align="center" class="seperated" width="170" >
					<span class="Large"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_tbl_type"]; ?></b></span>
				</th>
				<th valign="center" align="center" width="150" class="seperated_bottom" colspan="4">
					<span class="Large"><b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_tbl_action"]; ?></b></span>
				</th>
			</tr>

			<?php

				$SQL = "$Clausel LIMIT ".(int)($Page["NumPage"]*$Page["EachPage"]).", ".(int)$Page['EachPage'];
				$RES = mysql_query($SQL);
				if (mysql_num_rows($RES)==0) $RES = mysql_query("$Clausel LIMIT 0, ".(int)$Page['EachPage']);

				$NumImages = 0;
			?>
			<form action="<?php echo $PHP_SELF."?".((!getenv("QUERY_STRING")) ? $_SERVER['QUERY_STRING'] : getenv("QUERY_STRING")); ?>" method="post" name="SUBMIT_NEW-CHG_MULTIACTION">
			<?php
				while ($ROW = mysql_fetch_object($RES))
				{
					if ($ROW->id > $NumImages) $NumImages = $ROW->id;

					echo "
					<tr>
					 <td valign=\"center\" align=\"center\" class=\"seperated\">
						<input type=\"checkbox\" name=\"Check?".$ROW->id."\" value=\"1\">
					 </td>
					 <td valign=\"center\" align=\"center\" class=\"seperated\">
						<b>".$ROW->id."</b>
					 </td>
					 <td valign=\"center\" align=\"left\" class=\"seperated\">
						".dynpg_htmlentities_rigid($ROW->NAME,ENT_COMPAT,true)."<img src=\"pictures/space.gif\" height=\"1\" width=\"1\">
					 </td>
					 <td valign=\"center\" align=\"left\" class=\"seperated\">
						".nl2br(dynpg_htmlentities_rigid($ROW->DESCR,ENT_COMPAT,true))."<img src=\"pictures/space.gif\" height=\"1\" width=\"1\">
					 </td>
					 <td valign=center align=left class=\"seperated\">
						".substr(strrchr(strtoupper($ROW->URL), '.'), 1)." (".round(@filesize("./".FORMS_IMAGES_DESTINATIONURL_ROOT.$ROW->URL)/1024, 1)." Kb)<img src=\"pictures/space.gif\" height=1 width=1>
					 </td>
					 <td valign=\"center\" align=\"center\" class=\"seperated\" width=\"37\">
					 	<a href=\"$PHP_SELF?show=$show&group=$group&ug=".$ROW->USERGROUP."&acttype=chg&aid=".$ROW->id."&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]\" title=\"".$GLOBALS["lang_dpg"]->str["lang_fileupload_doChange"]."\"><img src=\"pictures/imgbtn_edit.jpg\" border=\"0\"></a>
					 </td>
					 <td valign=\"center\" align=\"center\" class=\"seperated\" width=\"37\">
					 	<a href=\"$PHP_SELF?show=$show&group=$group&acttype=del&aid=".$ROW->id."&p=$Page[NumPage]&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]\" title=\"".$GLOBALS["lang_dpg"]->str["lang_fileupload_doDelete"]."\"><img src=\"pictures/imgbtn_delete.jpg\" border=\"0\"></a>
					 </td>
					 <td valign=\"center\" align=\"center\" class=\"seperated\" width=\"37\">
					 	<a href=\"#\" OnClick=\"javascript:window.open('".FORMS_IMAGES_DESTINATIONURL_ROOT.$ROW->URL."','FilePrevPopUp','width=525,height=500,scrollbars=yes,resizable=yes'); return false;\" title=\"".$GLOBALS["lang_dpg"]->str["lang_fileupload_doShow"]."\"><img src=\"pictures/imgbtn_view.jpg\" border=\"0\"></a>
					 </td>";
					 $f_type = substr(strrchr($ROW->URL, '.'), 1);
					 $supported_types = array( "jpg", "jpeg", "png", "gif" );

					 if(file_exists("_file_edit.php") && in_array($f_type, $supported_types) && dynpg_getRightsToUser(C_RIGHTS_CHANGE, 'ARTICLE', $ROW->id, 'asValue', true)){
						 echo "
						<td valign=\"center\" align=\"center\" class=\"seperated_bottom\" width=\"37\">
					 	<a href=\"#\" onclick=\"javascript:window.open('_file_edit.php?picID=".$ROW->id."&function=1','FileEditPopUp','width=800,height=600,scrollbars=yes,resizable=yes'); return false;\" title=\"".$GLOBALS["lang_dpg"]->str["lang_fileupload_doEdit"]."\"><img src=\"pictures/imgbtn_edit_file.gif\" border=\"0\"></a>
						</td>";
					 }
					 else{
						 echo "<td valign=\"center\" align=\"center\" class=\"seperated_bottom\" width=\"37\">-</td>";
					 }
					 echo "
					</tr>";
				}
				echo mysql_error();

                @mysql_free_result($RES);
				clearstatcache();
			?>
		</table>
			<br />
		<table border="0" Cellpadding="5" Cellspacing="0" class="InnerWebSiteTableWhite" width="100%">
			<tr>
				<td valign="top" align="right" style="font-weight:bold;">
					<?php
                        if ( (integer)$Page["NumPage"]>0 ) {
                        ?>
						<a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=$sort&orderby=$orderby&p=".((integer)$Page["NumPage"]-1)."&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_back"]; ?></a>
					<?php
                        } else {
                        echo $GLOBALS["lang_dpg"]->str["lang_fileupload_back"];
						} ?>
					|
					<?php
                        if ( (integer)$Page["NumPage"]<($_num_image_pages-1) ) {
                        ?>
						<a href="<?php echo $PHP_SELF."?show=$show&group=$group&sort=$sort&orderby=$orderby&p=".((integer)$Page["NumPage"]+1)."&s=$Page[EachPage]&type=$Page[type]&nr=$Page[nr]#TableHead"; ?>"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_next"]; ?></a>
					<?php
                        } else {
						echo $GLOBALS["lang_dpg"]->str["lang_fileupload_next"];
						} ?>
				</td>

			</tr>
		</table>

            <br />

        <fieldset style="margin: 5px 1px 1px 1px; padding: 10px; border: 1px #95acc0 solid;">
            <legend style="font-size: 11px; font-family: Verdana; font-weight: normal; color: #004a8e;"><strong><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_batchProcessing"]; ?></strong></legend>

            <a href="#" style="text-decoration: none; font-weight: bold;" onclick="selectAll('SUBMIT_NEW-CHG_MULTIACTION'); return false;"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_selectAllArticles"]; ?></a> |
            <a href="#" style="text-decoration: none; font-weight: bold;" onclick="unselectAll('SUBMIT_NEW-CHG_MULTIACTION'); return false;"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_unselectAllArticles"]; ?></a> |
            <b><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_chosenFiles"]; ?> </b>
            <select size="1" name="SEL_ACTION" class="TextFieldStyleWhite">
				<option value="MOVE"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_otherGrp"]; ?></option>
				<option value="MODIFY"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_modify"]; ?></option>
				<option value="DEL"><?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_deleteFast"]; ?></option>
			</select>
			<input type="hidden" name="BATCH_ACTION" value="<?php echo $NumImages; ?>">
			<input type="submit" value="<?php echo $GLOBALS["lang_dpg"]->str["lang_fileupload_doit"]; ?>" class="ButtonStyleWhite">
        </fieldset>
	</td>

    <input type="hidden" name="save_size_x" id="save_size_x" value="" />
    <input type="hidden" name="save_size_y" id="save_size_y" value="" />
    <input type="hidden" name="save_size_x_pc" id="save_size_x_pc" value="100" />
    <input type="hidden" name="save_size_y_pc" id="save_size_y_pc" value="100" />
    <input type="hidden" name="save_size_rule" id="save_size_rule" value="max" />
    <input type="hidden" name="save_size_quality" id="save_size_quality" value="100" />
    <input type="hidden" name="save_size_copy" id="save_size_copy" value="" />
    <input type="hidden" name="save_watermark" id="save_watermark" value="" />
    <input type="hidden" name="save_watermark_descr" id="save_watermark_descr" value="<?php print $GLOBALS["lang_dpg"]->str["lang_group_valueText2"]; ?>" />
    <input type="hidden" name="save_watermark_pos" id="save_watermark_pos" value="" />
    <input type="hidden" name="save_watermark_pos_idx" id="save_watermark_pos_idx" value="" />

	</form>
</tr>
</table>