<?php
	/**
	* dynpg_cms_index_hasUpdate(): ->boolean
	*
	* determines whether there is an available update in the update directory
	*
	* @package DynPG Index.php
	* @author Sebastian Bauersfeld
	* @return boolean
	*/
    function dynpg_cms_index_hasUpdate() {
	 	$dir = opendir('update/');
	 	while ($file = readdir($dir)) {
	 		if(substr($file, 0, 7) == 'plugin_' ){
	 			closedir($dir);
				return true;
			}
			if(substr($file, 0, 7) == 'update_' ){
	 			closedir($dir);
				return true;
			}
		}
	 	closedir($dir);
		return false;
	}


	// workflow for older update routines

        if ( is_dir('install/') && file_exists('configuration.php-dist') ) {
            header('Location: install/start.php');
            exit;
        }

        if ( is_dir('update/') && dynpg_cms_index_hasUpdate() ) {
            header('Location: update/bin/start.php');
            exit;
        }

        if ( is_dir('install/')  && !file_exists('configuration.php-dist') ||
             !is_dir('install/') && file_exists('configuration.php-dist') ) {
            header('Location: incomplete.php');
            exit;
        }

    // require header file for session-handling and backend-header output

        ob_start();

        if (!isset($_GET['show'])) {
    	   $_GET['show'] = md5('lastModified');
    	}

    	require "header.php";

	// implement login-logic

    	if ( !VerifyAccess() ) {
    		require 'loginpage.php';

    		require "fooder.php";

    		exit;
    	}

	// connect to database

	   require_once "connectdb.php";
?>

<table border="0" cellpadding="10" cellspacing="0" width="100%" height="100%">
	<tr>
		<td width="100%" height="100%" valign="top" align="left" style="padding-left: 30px;">

			<?php
				switch ( (string)$_GET["show"] ) {

					case '0':
                        require "_settings.php";
                        break;
					case '1':
                        require "_groups.php";
                        break;
					case '2':
                        require "_fileupload.php";
                        break;
					case '100':
                        require "_filegroups.php";
                        break;
					case '3':
                        require "_articles.php";
                        break;
					case '4':
                        require "_texts.php";
                        break;
					case '5':
                        require "_help.php";
                        break;
					case '6':
                        require "_votes.php";
                        break;
					case '7':
                        require "_impressum.php";
                        break;

					//  8: as plugin
                    //  9: as plugin

					case '10':
                        require "_forum.php";
                        break;

					// 11: as plugin

                    case '999':
                        require "_search.php";
                        break;

                    case md5('rights'):
                        require '_rights.php';
                        break;
                    case md5('rights_1'):
                        require '_rights_1.php';
                        break;
                    case md5('rights_2'):
                        require '_rights_2.php';
                        break;

                    case md5('lastModified'):
                        require '_lastModified.php';
                        break;

                    case md5('deleteStack'):
                        require '_deleteStack.php';
                        break;

					default:
						dynpg_handle_plugins('extensionfiles');
						break;

				}
			?>

		</td>
	</tr>
</table>

<?php
	require "fooder.php";
    ob_end_flush();
?>