<?php
    /**
    * This file performs a user defined workflow (as plugin) over a
    * current code in the DynPG Engine.
    *
    * PLUGIN: Example
    *
    * @package DynPG PlugIn Engine
    * @author Daniel Schliebner
    * @return modified source code as string
    */

    // require user-defined plugin class from source

    require_once dirname(__FILE__) . '/PLUGINNAME.class.php';

    // require extending classes, that implement new logic

    if (file_exists(dirname(__FILE__) . '/PLUGINNAME.class.extend.php'))
		require_once (dirname(__FILE__) . '/PLUGINNAME.class.extend.php');


    // USERFUNCTION
    // manage some things which need to send header information
    // PlugIn_preInitialize_dpgplugin: return null

    function PlugIn_preInitialize_dpgplugin() {
		// return dumb
			return null;
    }


    // USERFUNCTION
    // replaces plugin-specific Code in text
    // callback_DynPG_PlugIn_dpgplugin: string -> string

    function callback_DynPG_PlugIn_dpgplugin( $source = '' ) {
		// check if there exists a lambda class for
		// plugin mutation

			if (isset($GLOBALS['dynPG_PLUGINNAME_Class_ID'])) {
				// create new instance of plugin-class
				if (class_exists($GLOBALS['dynPG_PLUGINNAME_Class_ID']))
					eval('$my_dpgplugin_plugin = new ' . $GLOBALS['dynPG_PLUGINNAME_Class_ID'] . '();');
				else {
					trigger_error('Class "' . $GLOBALS['dynPG_PLUGINNAME_Class_ID'] . '" not found!', E_USER_ERROR);
					exit;
				}
			} else {
				// create new instance of plugin-class
				$my_dpgplugin_plugin = new dynPG_PLUGINNAME();
			}

		// embed extending file if exists
			if (file_exists(dirname(__FILE__) . '/handle.extend.php'))
				eval(str_replace('<?php', '', str_replace('?>', '', implode('', file(dirname(__FILE__) . '/handle.extend.php')))));

		// perform parsing

	        $my_dpgplugin_plugin->property_code = $source;

	        $my_dpgplugin_plugin->perform();

        return $my_dpgplugin_plugin->property_code;
    }


    // USERFUNCTION
    // returns a string, which contains the plugin
    // write_DynPG_PlugIn_dpgplugin: [] -> class dynPG_PLUGINNAME

    function write_DynPG_PlugIn_dpgplugin() {

        // create new instance of plugin-class

        if (isset($GLOBALS['dynPG_PLUGINNAME_Class_ID'])) {
			// create new instance of plugin-class
			if (class_exists($GLOBALS['dynPG_PLUGINNAME_Class_ID']))
				eval('$my_dpgplugin_plugin = new ' . $GLOBALS['dynPG_PLUGINNAME_Class_ID'] . '();');
			else {
				trigger_error('Class "' . $GLOBALS['dynPG_PLUGINNAME_Class_ID'] . '" not found!', E_USER_ERROR);
				exit;
			}
		} else {
			// create new instance of plugin-class
			$my_dpgplugin_plugin = new dynPG_PLUGINNAME();
		}


        // return changed code to DynPG Engine

        return $my_dpgplugin_plugin;
    }
?>