<?php
/**
* This file includes the class, that loads several extensions, specified or
* loaded in extension.loader.php.
*
* PLUGIN: Plugin pattern
*
* @package DynPG PlugIn Engine
* @author Daniel Schliebner
*/
class dynPG_dpgplugin_extensions {
	// property type: dynpgPlugIn (class)
	var $plugin;

	// property type: array of dynPG_dpgplugin_extensions (class)
	var $extensions;

	// constructor
	function dynPG_dpgplugin_extensions(&$plugin) {
		$this->plugin = &$plugin;
		$this->extensions = Array();

		register_shutdown_function(array(&$this, 'destruct'));
	}

	function add(
		/* name of extension */
		$identVal,

		/* backend */
		$extensionFile,
		$menu = true,
		$menuEntry = '',
		$menuType = C_DYNPG_PLUGIN_SUBMENU,

		/* editorplugins */
		$editorplugins = Array(),
		$internal_editorplugins = Array()
		) {

		$ext = new dynPG_dpgplugin_extension();

		$ext->identVal = $identVal;
		$ext->menu = $menu;
		$ext->menuEntry = $menuEntry;
		$ext->menuType = $menuType;
		$ext->extensionFile = $extensionFile;
		$ext->editorplugins = $editorplugins;
		$ext->internal_editorplugins = $internal_editorplugins;

		$this->extensions []= $ext;


		unset($ext);
	}

	function exists($identVal) {
		foreach ($this->extensions as $extension) {
			if (strtolower($extension->identVal) == strtolower($identVal))
				return true;
		}
		return false;
	}

	function insert_verticalmenu_entries() {
		foreach ($this->extensions as $extension) {
			if ($extension->menu) {
				$this->plugin->menuAdd(
					$extension->menuType,
					$extension->menuEntry,
					md5("DPGPlugin_{$extension->identVal}")
				);
			}
		}
	}

	function insert_editorplugins($intern = true) {
		$editorplugins = Array();
		foreach ($this->extensions as $extension) {
			$editorplugins = array_merge($editorplugins, $extension->editorplugins);
			if ($intern)
				$editorplugins = array_merge($editorplugins, $extension->internal_editorplugins);
		}
		return $editorplugins;
	}

	function insert_extensionfiles() {
		foreach ($this->extensions as $extension) {
			$this->plugin->relate_Selector_Menu(
				md5("DPGPlugin_{$extension->identVal}"),
				$extension->extensionFile
			);
		}
	}

	// destructor
	function destruct() {}
}

/**
* This class represents a single extension.
*
* PLUGIN: Plugin pattern
*
* @package DynPG PlugIn Engine
* @author Daniel Schliebner
*/
class dynPG_dpgplugin_extension {
	/* name of extension */
	var $identVal;

	/* backend */
	var $menu;
	var $menuEntry;
	var $menuType;
	var $extensionFile;

	/* editorplugins */
	var $editorplugins;
	var $internal_editorplugins;

	function dynPG_dpgplugin_extension() {register_shutdown_function(array(&$this, 'destruct'));}
	function destruct() {}
}
?>