<?php
if (! class_exists('Generic_DB')) {
/**
 * Generic_DB
 * (ABSTRACT CLASS)
 *
 * This class is a generic mysql-database wrapper to handle the main database
 * operations.
 *
 * This "class" should work as an interface or abstract class, from which
 * subclasses are abstracted and used as pattern classes.
 *
 * @package: generic_db_inc.php
 * @author Daniel Schliebner
 * @copyright Copyright (c) 2007
 * @version 1.6 (as at 2007-09-06)
 * @access public
 */
class Generic_DB {

	// private

		/**
		 * @access private
		 */
		var $_db_resource = false; // The MySQL-DB-Host.

		/**
		 * @access private
		 */
		var $_db_result = false; // Current MySQL result resource.


	// public

		var $db_host = 'localhost'; // The MySQL-DB-Host.

		var $db_user = ''; // The MySQL-DB-User.

		var $db_password = ''; // The MySQL-DB-Password.

		var $db_port = ''; // The MySQL-DB-Port.

		var $db_connect_type = 'tcp'; // Kind of {tcp | socket}

		var $db_socket = ''; // The MySQL-Socket.

		var $db_name = ''; // The MySQL-DB-Name.

		var $db_table = ''; // Current used table


		var $fetch_by = 'assoc'; // Kind of {"assoc" | "object" | "array"}.

		var $query = ''; // Query for execution.

		var $row = null; // Current fetched row.

		var $tbl_container = Array(); // Detail specifications of each table := associative Array of Array('rows' => Array(), 'indexes' => Array(), 'increment_key' => '');

		var $debug = false; // Current debug setting.



	// METHODS


	// private

		/**
		 * Generic_DB::connect()
		 *
		 * Tries to connect to a mysql database, using the current
		 * parameters;
		 *
		 * @return {resource | boolean false}
		 * @access private
		 */
		function connect() {
			$this->_db_resource = mysql_connect($this->db_host . ($this->db_port == ''? '': ':' . $this->db_port) .
										($this->db_socket == ''? '': ':' . $this->db_socket), $this->db_user, $this->db_password)

										or trigger_error(htmlentities("Cannot connect to MySQL Server. Please contact your administrator."));

			if ($this->db_name !== '')
				if (mysql_select_db($this->db_name)
					or trigger_error(htmlentities("No connection to database '" . $this->db_name . "'. Please contact your administrator.")) ) {

					return false;

				}

			return $this->_db_resource;
		}



	// public

		/**
		 * Generic_DB::Generic_DB()
		 *
		 * Constructor for class Generic_DB.
		 *
		 * The parameters, listed below, are optional.
		 *
		 * @access public
		 */
		function Generic_DB() {
		// constructor //

		// initialize properties

			settype($this->_db_resource, 'string');
			settype($this->_db_result, 'string');
			settype($this->debug, 'object');

			settype($this->db_host, 'string');
			settype($this->db_user, 'string');
			settype($this->db_password, 'string');
			settype($this->db_port, 'string');
			settype($this->db_connect_type, 'string');
			settype($this->db_socket, 'string');
			settype($this->db_name, 'string');
			settype($this->db_fetch_by, 'string');
			settype($this->db_table, 'string');

			settype($this->fetch_by, 'string');
			settype($this->query, 'string');
			settype($this->row, 'object');

			settype($this->tbl_container, 'array');

			if ($this->db_connect_type == 'tcp') {
				$this->db_socket = '';
			}

		// register pseudo-destructor for php-versions < 5

			register_shutdown_function(array(&$this, 'destroy_Generic_DB'));
		}

		// ------------------------

		/**
		 * Generic_DB::db_setQuery()
		 *
		 * Sets a sql query and refreshes the _db_resource.
		 *
		 * @param string $query
		 * @access public
		 */
		function db_setQuery($query) {
			$this->query = $query;
			$this->db_refresh();
		}

		// ------------------------

		/**
		 * Generic_DB::db_execute()
		 *
		 * Executes a sql query and returns the result.
		 *
		 * @param string $query
		 * @return {resource | boolean false}
		 * @access public
		 */
		function db_execute($query = '') {
			if ( empty($this->query) && $query == '' ) {
				return false;
			}
			if ( $query == '' ) {
				$query = $this->query;
			}
			if (! $this->_db_resource ) {
				$this->connect();
			}
			if ($this->debug !== false) {
				echo "{$query}\n";
			}
			return ( ($this->debug === false || $this->debug == 'run')?
						mysql_query($query):
						false );
		}

		// ------------------------

		/**
		 * Generic_DB::db_setDebugMode()
		 *
		 * Set property debug mode to: { false | "debug" | "run" }.
		 * Meaning:
		 *  - boolean false  := No debug mode,
		 *  - string "debug" := Ouput query only - do not execute,
		 *  - string "run"	 := Execute query but output, too.
		 *
		 * @param mixed $debug
		 * @access public
		 */
		function db_setDebugMode($debug) {
			$this->debug = is_string($debug)? strtolower($debug): $debug;
		}

		// ------------------------

		/**
		 * Generic_DB::db_setTable()
		 *
		 * Set property db_table on which operations are executed.
		 *
		 * @param string $name
		 * @return -
		 * @access public
		 */
		function db_setTable($name) {
			$this->db_table = $name;
		}

		// ------------------------

		/**
		 * Generic_DB::db_insert()
		 *
		 * Inserts a row into a table, specified in property $this->db_table.
		 * Therefore it makes use of the table definition in
		 * $this->tbl_container.
		 *
		 * Note: specify in array $values the attribute values EXCEPT
		 * the primary key - if existant like follows:
		 *
		 * array $values := Array Of ( db_values );
		 *
		 * That means, $values expects an array in which the values for each
		 * db attribute is specified (in the order, the attributes are in the db).
		 *
		 * NOTICE: if you specify a db_value as Array, that means, that the
		 * db wrapper would interpret this value as MySQL-function and will
		 * not escape it with a quote.
		 *
		 * @param array $values
		 * @return {resource | boolean false}
		 * @access public
		 */
		function db_insert($values = Array()) {
			if ( empty($this->db_table) ) {
				return false;
			}
			if (! array_key_exists($this->db_table, $this->tbl_container) ) {
				return false;
			}
			if (! $this->_db_resource ) {
				$this->connect();
			}

			// declarations
				$attributes = $db_vals = $db_cols = Array();

			// filter acceptable values
				foreach ($this->tbl_container[$this->db_table]['rows'] as $v)
					if ( $v != $this->tbl_container[$this->db_table]['increment_key'] )
						$attributes[$v] = array_shift($values);

			// merge attribute names and values to an sql string
				foreach ($attributes as $k => $v) {
					$db_cols []= '`' . $k . '`';
					$db_vals []= is_string($v)? ("'" . addslashes($v) . "'"): (is_null($v)? "NULL": (is_array($v)? $v[0]: $v));
				}

			return $this->db_execute("INSERT INTO `{$this->db_table}`(" .
					implode(', ', $db_cols) . ") VALUES (" .
					implode(', ', $db_vals) . ");"
				   );
		}

		// ------------------------

		/**
		 * Generic_DB::db_matchQuery()
		 *
		 * Returns a sql subquery that matches rows that match
		 * at least one of the indexes in $this->db_table]['indexes']
		 * and/or the fulltext index $this->db_table]['fulltext'].
		 *
		 * The returned string looks like
		 *
		 * ", GREATEST( ([`{key}` LIKE '%$query%']+)([[,] MATCH( {fulltext} ) AGAINST ( '$query' )] ) AS `$evalKey`"
		 *
		 * @param string $query
		 * @param string $evalKey
		 * @return string
		 * @access public
		 */
		function db_matchQuery($query = '', $evalKey = 'matchIndex') {
			if ( empty($this->db_table) ) {
				return;
			}
			if (! array_key_exists($this->db_table, $this->tbl_container) ) {
				return;
			}
			if ( count($this->tbl_container[$this->db_table]['indexes']) == 0 &&
				count($this->tbl_container[$this->db_table]['fulltext']) == 0 ) {
				return;
			}

			$arrIndexes  = $this->tbl_container[$this->db_table]['indexes'];
			$arrFulltext = $this->tbl_container[$this->db_table]['fulltext'];
			$useGreatest = (count($arrIndexes) + count($arrFulltext)) > 1;

			array_walk($arrIndexes, create_function('&$s', '$s = "`$s`";'));
			array_walk($arrFulltext, create_function('&$s', '$s = "`$s`";'));

			$sql['match'] = ', ' . ($useGreatest? 'GREATEST( ': '');
			$sql['like']  = Array();

            foreach ( $arrIndexes as $k => $row ) {
                $sql['like'][$k] = $row . ' LIKE ( \'%' . $query . '%\' )';
            }

            $sql['match'] .= implode(', ', $sql['like']);
            $sql['match'] .= count($arrFulltext) > 0? ((count($sql['like']) > 0? ', ': '') . 'MATCH ( '.implode(', ', $arrFulltext).' ) AGAINST ( \'' . addslashes($query) . '\' )'): '';
            $sql['match'] .= ($useGreatest? ' )': '') . ' AS `' . $evalKey . '` ';

            return $sql['match'];
		}

		// ------------------------

		/**
		 * Generic_DB::db_update()
		 *
		 * Updates a row $id in a table, specified in property $this->db_table.
		 * Therefore it makes use of the table definition in
		 * $this->tbl_container.
		 *
		 * Note: specify in array $values the attribute values EXCEPT
		 * the primary key - if existant like follows:
		 *
		 * array $values := Associative Array Of ( 'db_key' => db_value );
		 *
		 * If parameter $where is set, this is the selective string to
		 * specify the row, which is the one to be updated.
		 *
		 * NOTICE: if you specify a db_value as Array, that means, that the
		 * db wrapper would interpret this value as MySQL-function and will
		 * not escape it with a quote.
		 *
		 * @param array $values
		 * @param integer $id
		 * @param string $where
		 * @return {resource | boolean false}
		 * @access public
		 */
		function db_update($values = Array(), $id, $where = '') {
			if ( empty($this->db_table) ) {
				return false;
			}
			if (! array_key_exists($this->db_table, $this->tbl_container) ) {
				return false;
			}
			if (! $this->_db_resource ) {
				$this->connect();
			}

			// declarations
				$attributes = $update = Array();

			// filter acceptable values
				foreach ($this->tbl_container[$this->db_table]['rows'] as $v)
					if ( array_key_exists($v, $values) )
						$attributes[$v] = $values[$v];

			// check if data exists and each value has an attribute (and vice versa)
				if (count($attributes) == 0 || count($values) == 0) {
					return false;
				}

				if (count($attributes) != count($values)) {
					return false;
				}

			// merge attribute names and values to an sql string
				foreach ($attributes as $k => $v)
					$update []= '`' . $k . '` = ' . (is_string($v)? ("'" . addslashes($v) . "'"): (is_null($v)? "NULL": (is_array($v)? $v[0]: $v)));

			// execute
				return $this->db_execute("UPDATE `{$this->db_table}` SET " . implode(', ', $update)
						. " WHERE " . ($where == ''? "`{$this->tbl_container[$this->db_table]['increment_key']}` = {$id}": $where)
					   );
		}

		// ------------------------

		/**
		 * Generic_DB::db_delete()
		 *
		 * Deletes row(s) that have the $id in a table, specified in property
		 * $this->db_table. Therefore it makes use of the table definition in
		 * $this->tbl_container.
		 *
		 * If parameter $where is set, this is the selective string to
		 * specify the row, which is the one to be deleted.
		 *
		 * @param integer $id
		 * @param string $where
		 * @return {resource | boolean false}
		 * @access public
		 */
		function db_delete($id, $where = '') {
			if ( empty($this->db_table) ) {
				return false;
			}
			if (! array_key_exists($this->db_table, $this->tbl_container) ) {
				return false;
			}
			if (! $this->_db_resource ) {
				$this->connect();
			}

			// delete
				return $this->db_execute("DELETE FROM `{$this->db_table}` WHERE " .
						($where == ''? "`{$this->tbl_container[$this->db_table]['increment_key']}` = {$id}": $where)
					   );
		}

		// ------------------------

		/**
		 * Generic_DB::db_refresh()
		 *
		 * Sets the property $this->_db_result to false.
		 *
		 * @access public
		 */
		function db_refresh() {
			$this->_db_result = false;
		}

		// ------------------------

		/**
		 * Generic_DB::db_fetch_row()
		 *
		 * Fetch a single row out of mysql database.
		 * If $new is true, the query is executed from begin again.
		 *
		 * @param boolean $new
		 * @return {array | object}
		 * @access public
		 */
		function db_fetch_row($new = false) {
			if (! $this->_db_resource ) {
				$this->connect();
			}
			if (! $this->_db_result || $new) {
				$this->_db_result = $this->db_execute();
			}
			if ( mysql_num_rows($this->_db_result) == 0 ) {
				return (strtolower($this->fetch_by) == 'object'? null: Array());
			}
			$this->row = call_user_func('mysql_fetch_' . strtolower($this->fetch_by), $this->_db_result);

			if (is_array($this->row)) {
				foreach ($this->row as $k => $v)
					$this->row[$k] = (is_string($v) && !is_null($v))? stripslashes($v): $v;
			}
			return $this->row;
		}

		// ------------------------

		/**
		 * Generic_DB::destroy_Generic_DB()
		 *
		 * Destructur for class Generic_DB.
		 *
		 * @access private
		 */
		function destroy_Generic_DB() {
		// destructor //

			mysql_close($this->_db_resource);

		}

}
}
?>