<?php
	//
	// Pattern definitions for db tables in current project.
	//

	/**
	 * Pattern class definition for interface Generic_DB.
	 *
	 * @package
	 * @author Daniel Schliebner
	 * @copyright Copyright (c) 2007
	 * @access public
	 */
	class DBMyPluginHandle extends Generic_DB {
		// db settings

			var $db_host 		 = MYSQL_SERVER;
			var $db_user 		 = MYSQL_USER;
			var $db_password 	 = MYSQL_PASSWORD;
			var $db_port 		 = '';
			var $db_connect_type = 'tcp';
			var $db_socket 		 = '';
			var $db_name 		 = MYSQL_DATABASE;
			var $fetch_by 		 = 'assoc';
			var $debug 			 = false;

		// internal properties

			// -


		// tbl definitions

			var $tbl_container = Array(
										//
										// dynpg_myPlugin_dbTable :=
										//
										'dynpg_myPlugin_dbTable' => Array(
											'rows' => Array(
												'myAttribute1',
												'myAttribute2'
											),
											'indexes' => Array(),
											'fulltext' => Array(),
											'increment_key' => 'myTable_id',
										)
								 );

		// constructor

			function DBMyPluginHandle() {
				if (! defined('MATCH')) {
					define('MATCH', create_function('$query, $class', 'return $class->db_matchQuery($query, "matchIndex");'));
				}
				register_shutdown_function(array(&$this, 'destroy_DBMyPluginHandle'));
			}

		// destructor

			function destroy_DBMyPluginHandle() {
				@ob_end_flush();
        	}

		// general methods

			// function getMatchQuery: x string -> string
			// Returns the table-specific sql match query.
			function getMatchQuery($query) {
				return call_user_func(MATCH, $query, $this);
			}


			// procedure switchDebug: [x string]
			// Switches between the available debug modes and buffers the output
			// to add a <br />-tag instead of each line feed.
			function switchDebug($mode = 'debug') {
				if ( $this->debug === false ) {
					@ob_start(create_function('$buffer', 'return nl2br($buffer);'));
					$this->db_setDebugMode($mode);
				} else {
					@ob_end_flush();
					$this->db_setDebugMode(false);
				}
			}
	}
?>