<?php
    /**
    *   D Y N P G  -  D Y N A M I C  P A G E S
    *
    *   BACKEND FILE
    *
	*   This is a DynPG - Dynamic Pages backup file, that contains
    *   handling routines for specific parts of the plugin project
    *   in order to manage default data procedures (like insert, change, delete)
    *   and to output the existing data.
    *
    *   @package: plugin "Example"
    */

	// ---------------------------------------------------------------------
	// imports

	require dirname(__FILE__) . "/api/db_api.php";

    require_once "connectdb.php";


    // ---------------------------------------------------------------------
	// process GET param/submit

    foreach ( $_GET as $key => $value ) {
        $_GET[$key] = addslashes(urldecode($value));
    }

    // constant params:  set the default values for GET parameters
		list($show, $selectIDX, $action, $orderby, $sort, $page, $limit, $refID, $search_query) = Array(md5('PLUGINNAME_backend'), '', '', '', 'ASC', 0, 100, '', '');

    // superficial params (parameters, that perform an action directly, without needing more user data,
    // after performing an action, there have to be a redirect, using the header()-function
		list($superficialParam) = Array('');

    // deduce get data
	    if ( get_magic_quotes_gpc() ) {
	        $_GET = array_map(create_function('$a', 'return stripslashes($a);'), $_GET);
	    }

	    extract($_GET, EXTR_OVERWRITE);

	    $search_query = stripslashes($search_query);


    // ---------------------------------------------------------------------
	// declarations

	// functions

		// generates a query that looks like "show=$conformUri['show']&amp;selectIDX=$conformUri['selectIDX']&amp;..."
		function thisQuery() {
	        $conformUri = Array('show', 'selectIDX', 'action' , 'orderby' , 'sort' , 'page' , 'limit', 'refID', 'search_query');

	        $this_function_args = func_get_args();

	        return implode('&amp;', array_map(
						create_function('$a, $b', 'return $a . "=" . urlencode($b);'),
						$conformUri,
						$this_function_args
					)
				   );
	    }

    // variables

    	$THIS_LANGUAGE_PROC = dynpg_get_plugin_language_proc('DPGplugin');

		$C_WEBSITE_MAINBACKGROUND = C_WEBSITE_MAINBACKGROUND;
		$C_WEBSITE_AKTBACKGROUND  = C_WEBSITE_AKTBACKGROUND;

		$ERROR_STRING = $THIS_LANGUAGE_PROC->str['lang_backend_page_1_error_string'];

	    // database handlers
		$dbh = Array(
	    			'tbl_dbTable' => new DB_MyPlugin_DBTable(),
	    			/**
					* @TODO : add your own database wrappers here
					*/
			   );


    // ---------------------------------------------------------------------
	// process post submit

    $Sucessfull   = true;
    $query_posted = false;

    if ( !empty($_POST['search_query']) && empty($_POST['nosearch']) ) {
        $query_posted = true;
		$search_query = stripslashes($_POST['search_query']);
    }

    if ( !empty($_POST['PG_LIMIT']) ) {
        $limit = $_POST['PG_LIMIT'];
    }

    if ( !empty($_POST['PG_SHOW']) ) {
        $page = (integer)$_POST['PG_SHOW'] - 1;
        $page = $page < 0? 0: $page;
    }

	if ( !empty($_POST['delete_queue_x']) ) {
        $action = 'delete';
        $Sucessfull = false;
    }

    if ( !empty($_POST['delete_strict_queue_x']) ) {
        $action = 'strict_delete';
        $Sucessfull = false;
    }


	//
    // create, edit, delete
    //

    if ( !empty($_POST['STATUS']) && !empty($_POST['TYPE']) ) {
        if (! get_magic_quotes_gpc() ) {
            $_POST = array_map(create_function('$a', 'return addslashes($a);'), $_POST);
        }
        switch ( $_POST['TYPE'] ) {
            case 'strict_delete':
			case 'delete':
                    if ( $_POST['Queue'] == 'yes' ) {
                        // delete queue

						foreach ( $_POST as $key => $value ) {
							if ( ereg('^chk', $key) ) {
								$dbh['tbl_dbTable']->delete($value);
							}
						}
                    } else {
                        // delete single row

						$dbh['tbl_dbTable']->delete($_POST['DELID']);
                    }
                break;

            case 'create':
//					  // Some secure checks
//                    if ( empty($_POST['title']) ) {
//                        $Sucessfull = false;
//                        break;
//                    }

                    $insert = Array(
                    	/**
						* @TODO : insert post values here
						*/
					);

					$dbh['tbl_dbTable']->insert($insert);
                break;

            case 'edit':
//					  // Some secure checks
//                    if ( empty($_POST['title']) ) {
//                        $Sucessfull = false;
//                        break;
//                    }


					$update = Array(
						/**
						* @TODO : insert post values here
						*/
					);

					$dbh['tbl_dbTable']->update($_POST['CHGID'], $update);
                break;

            default:
                break;
        }
    }

    // end processing post submit


	// ---------------------------------------------------------------------
	// handle superficial GET params

    // change order_index from a selected item

		if ($superficialParam != '') {
			switch ($superficialParam) {
				case 'someValue':

					/**
					* @TODO : Perform action
					*/

					header('Location: ' . dynpg_get_HTTP_URL() . '?' . str_replace('&amp;', '&', thisQuery($show, $selectIDX, '', $orderby, $sort, $page, $limit, '', $search_query)));
					break;

				default:
	    			break;
			}
	    }


	// ---------------------------------------------------------------------
	// handle constant GET params

	// specific: read in default values for the different form fields
	// to load some data in the "value"-attribute of an form element

	/**
	* @TODO : Maybe add some specific data here (or let it blank, because the
	*		  following loop will set a default value to each form element that's
	*		  named equal to the corresponding database attribute).
	*/

	foreach ( $dbh['tbl_dbTable']->tbl_container[$dbh['tbl_dbTable']->db_table]['rows'] as $row ) {
		$_readData[$row] = '';
	}


	// general

    $_readData['submitType']   = 'create';
    $_readData['buttonValue']  = $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_create'];

    switch ( $action ) {
        case 'strict_delete':
		case 'delete':

            $queryStr = thisQuery($show, $selectIDX, '', $orderby, $sort, $page, $limit);
            $inQueue  = empty($_POST['delete_queue_x'])? 'no': 'yes';
            $queueElm = '';

			if ( $inQueue == 'yes' ) {
                foreach ( $_POST as $key => $value ) {
                   if ( ereg('^chk', $key) ) {
                        $queueElm .= '<input type="hidden" value="' . stripslashes($value) . '" name="' . stripslashes($key) . '">' . "\r\n";
                   }
               }
            }

            echo <<<STRING
                	<table border="0" Cellpadding="8" Cellspacing="0" width="400" class="InnerWebsiteTable">
                	<tr>
                		<td bgcolor="{$C_WEBSITE_MAINBACKGROUND}" valign="top">
                			<img src="pictures/innertext_info.jpg"><BR>
                			<span class="yellow">
                				<i>{$THIS_LANGUAGE_PROC->str['lang_backend_page_1_delete_question']}</i>
                				<p align=right>
                				<table border="0" Cellspadding="0" Cellspacing="0">
                				 <tr>
                				  <form action="{$_SERVER['PHP_SELF']}?{$queryStr}" method="post" name="SUBMIT_DEL_GROUP">
                				  <td>
                					<input type="hidden" value="{$refID}" name="DELID">
                			 		<input type="hidden" value="SUBMITTED" name="STATUS">
                					<input type="hidden" value="{$action}" name="TYPE">
                					<input type="hidden" value="{$inQueue}" name="Queue">
                					{$queueElm}
                					<input type="submit" class="ButtonStyleWhite" value="{$THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_yes']}">
                				  </td>
                				  </form>
                				  <form action="{$_SERVER['PHP_SELF']}?{$queryStr}" method="post" name="SUBMIT_DEL_GROUP">
                				  <td>
                				  	<input type="submit" class="ButtonStyleWhite" value="{$THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_no']}">
                				  </td>
                				  </form>
                				 </tr>
                				</table>
                				</p>
                			</span>
                		</td>
                	</tr>
                	</table><BR>
STRING;
// END HTML OUTPUT
            break;

        case 'edit':
        	/**
			* @TODO : insert your own database query here, that fetches the currently
			* 		  selected item, e.g.
			*
			*		  $dbh['tbl_dbTable']->readRow($refID);
			*/

			$_readData = array_map(create_function('$s', 'return htmlentities($s);'), $dbh['tbl_dbTable']->db_fetch_row());

            $_readData['submitType']   = 'edit';
            $_readData['buttonValue']  = $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_edit'];
            break;

        default:
            break;
    }


    // ---------------------------------------------------------------------
	// result output

    if ( $Sucessfull ) {
    	//
		// SUCCESS
		//
        if ( !empty($_POST['STATUS']) ) {
            // HTML OUTPUT
            echo <<<STRING
            	<table border="0" Cellpadding="8" Cellspacing="0" class="InnerWebsiteTable" width="400">
            	<tr>
            		<td bgcolor="{$C_WEBSITE_MAINBACKGROUND}" valign="top">
            			<img src="pictures/innertext_info.jpg" alt="info"><br>
            			<span class="green">
            			 <em>
            				{$THIS_LANGUAGE_PROC->str['lang_backend_page_1_successful']}<BR>
                            <BR></span>
            			 </em>
            			</span>
            		</td>
            	</tr>
            	</table><BR>
STRING;
// END HTML OUTPUT
        }

	} else {

		//
		// FAIL
		//
        if ( !empty($_POST['STATUS']) ) {
            // HTML OUTPUT
            echo <<<STRING
            	<table border="0" Cellpadding="8" Cellspacing="0" class="InnerWebsiteTable" width="400">
            	<tr>
            		<td bgcolor="{$C_WEBSITE_MAINBACKGROUND}" valign="top">
            			<img src="pictures/innertext_info.jpg" alt="info"><BR>
            			<span class="red">
                             {$THIS_LANGUAGE_PROC->str['lang_backend_page_1_failed']}
                             <br /><br />
                             {$ERROR_STRING}
            			     <br />
            			</span>
            		</td>
            	</tr>
            	</table><BR>
STRING;
// END HTML OUTPUT

            $_readData = array_merge($_readData, $_POST);
            $_readData['submitType']   = $_readData['TYPE'];
            $_readData['buttonValue']  = $_readData['TYPE'] == 'create'? $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_create']: $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_edit'];
            $refID = $_readData['CHGID'];
        }
    }
?>
<h3><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_title']; ?></h3>

<table border="0" Cellpadding="6" Cellspacing="0" width="400" class="WebsiteTable">
    <tr>
    	<td bgcolor="<?php echo ($_readData['submitType'] != 'edit')? C_WEBSITE_AKTBACKGROUND: C_WEBSITE_MAINBACKGROUND; ?>">
    		<img src="pictures/imgbtn_create.gif" alt="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_alt_create']; ?>">
    		<a href="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, '', $orderby, $sort, $page, $limit, '', $search_query); ?>"><strong><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_create_data']; ?><strong></a>
    	</td>
    	<td bgcolor="<?php echo ($_readData['submitType'] == 'edit')? C_WEBSITE_AKTBACKGROUND: C_WEBSITE_MAINBACKGROUND; ?>">
    		<img src="pictures/imgbtn_edit.gif" alt="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_alt_edit']; ?>">
    		<strong><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_change_data']; ?></strong>
    	</td>
    </tr>
</table>

<table border="0" Cellpadding="8" Cellspacing="0" width="100%" class="InnerWebsiteTable">
    <tr>
    	<td bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>" valign="top" colspan="3">
    	    <form action="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, '', $orderby, $sort, $page, $limit, '', $search_query); ?>" method="post" name="SUBMIT" accept-charset="ISO-8859-1">

                <table border="0" Cellpadding="5" Cellspacing="0" width="650" class="InnerWebsiteTableTransparent">

					<colgroup>
                		<col width="110">
                		<col width="540">
                	</colgroup>

                    <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND_ALT ?>">
                        <td valign="top">
                            <strong>Some value:</strong>
                        </td>
                        <td>
                        	<!--
								@TODO:
								Input field, that may have the same name, than the
								corresponding database attribute.
							-->
                    	</td>
                    </tr>

                    <tr bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>">
	                    <td colspan="2" align="right">
	                        <input type="submit" class="ButtonStyleWhite" value="<?php echo $_readData['buttonValue']; ?>">
	                    </td>
                    </tr>

                </table>

                <input type="hidden" value="<?php echo $_readData['submitType']; ?>" name="TYPE">
                <input type="hidden" value="<?php echo !empty($refID)? $refID: ''; ?>" name="CHGID">
                <input type="hidden" value="SUBMITTED" name="STATUS">

            </form>
    	</td>
    </tr>
</table>

<br>

<table border="0" Cellpadding="8" Cellspacing="0" width="100%" class="InnerWebsiteTable">
    <tr>
    	<td bgcolor="<?php echo C_WEBSITE_MAINBACKGROUND ?>" valign="top">

    		<fieldset style="margin: 0 0 10px 0;">
                <legend><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_view']; ?></legend>

                <table border="0" width="100%" cellpadding="0" cellspacing="0">
                    <tr>
                        <td align="left">
                            <form action="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, $action, $orderby, $sort, $page, $limit, $refID); ?>" method="post" name="SUBMIT_SEARCH" style="margin: 0; display: inline;">
                                <input type="text" value="<?php echo htmlentities($search_query); ?>" name="search_query" size="50" style="background-color: <?php echo C_WEBSITE_AKTBACKGROUND ?>;" class="TextFieldStyleWhite">
                                <input type="submit" name="search" value="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_search']; ?>" class="ButtonStyleWhite" />
                                <input type="submit" name="nosearch" value="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_btn_show_all']; ?>" class="ButtonStyleWhite" />
                            </form>
                        </td>
                    </tr>
                </table>

            </fieldset>

            <form action="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, '', $orderby, $sort, $page, $limit, '', $search_query); ?>" method="post" name="SUBMIT_LIST" style="margin: 0;">

            <fieldset style="margin: 0 0 5px 0; background-color: white;">
                <legend><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_marked']; ?></legend>
				<input type="image" name="delete_queue" src="pictures/imgbtn_delete.jpg" title="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_alt_delete']; ?>" alt="<?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_alt_delete']; ?>">
            </fieldset>

            <a name="top"></a>

            <table border="0" Cellpadding="8" Cellspacing="0" width="100%" class="InnerWebsiteTableWhite">
                <tr>
                	<td width="20" class="seperated">&nbsp;</td>

            		<td width="50" valign="middle" align="center" class="seperated">
            			<span class="Normal"><strong><a href="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, $action, '@TODO: DB_field_1', $sort=='DESC'? 'ASC': 'DESC', $page, $limit, $refID, $search_query); ?>#top">ID</a></strong></span>
            		</td>

            		<td width="200" valign="middle" align="center" class="seperated">
            			<span class="Normal"><strong><a href="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, $action, '@TODO: DB_field_2', $sort=='DESC'? 'ASC': 'DESC', $page, $limit, $refID, $search_query); ?>#top">Attribute #1</a></strong></span>
            		</td>

            		<td valign="middle" align="left" class="seperated">
            			<span class="Normal"><strong><a href="<?php echo "{$_SERVER['PHP_SELF']}?" . thisQuery($show, $selectIDX, $action, '@TODO: DB_field_3', $sort=='DESC'? 'ASC': 'DESC', $page, $limit, $refID, $search_query); ?>#top">Attribute #2</a></strong></span>
            		</td>

            		<td valign="middle" colspan="6" align="center" class="seperated_bottom">
            			<span class="Normal"><strong><?php echo $THIS_LANGUAGE_PROC->str['lang_backend_page_1_actions']; ?></strong></span>
            		</td>
            	</tr>

            	<?php
            		$begin = $page * $limit;

					/**
					* @TODO : create your own method in the db wrapper, that realizes the output of all (selected) items.
					*/
					$dbh['tbl_dbTable']->readAll($query_posted? 'matchIndex': $orderby, $query_posted? 'DESC': $sort, $search_query);

					while ( $dbh['tbl_dbTable']->db_fetch_row() ) {
						$dbh['tbl_dbTable']->row = array_map(create_function('$val', 'return htmlentities($val);'), $dbh['tbl_dbTable']->row);

						/**
						* @TODO : iterate throught all data rows, that match the query, and give them out
						*/
					}
            	?>

            	</table>

            </form>

        </td>
    </tr>
</table>