<?php
/**
* global string $dynPG_PLUGINNAME_Class_ID.
*
* Declare the class name of the  e x t e n d e d  plugin class in your
* files, if you want to use your extending class instead of this.
*
* PLUGIN: Example
*
* @access public
*/
global
	$dynPG_PLUGINNAME_Class_ID;
	$dynPG_PLUGINNAME_Class_ID = /* DPGplugin := {*/ 'dynPG_PLUGINNAME' /*}*/;


/**
* This file includes the main class for the plugin.
*
* PLUGIN: Example
*
* @package DynPG PlugIn Engine
* @author Daniel Schliebner
*/

class dynPG_PLUGINNAME {

    // -- dynpg plugin properties --

	// string $property_code
    // String which is generatet by DynPG where Plugin might by inserted in.
    var $property_code;

    // TDynPG_MainClass $dynpg_instance
    // Copy of instance from super global $GLOBALS['DynPG'].
    var $dynpg_instance;

    // string $rootToTool
    // Path to the CMS directory in which DynPG has been installed
    var $rootToTool;

    // string $rootToPlugin
    // Path to the plugin directory in which plugin
    var $rootToPlugin;

    // string $output_Message
    // buffered outputs when succeeded or failed
    var $output_Message;

    // array[0..1] of [ string | TLanguage ] $language
    // instance for current language class (default is "de")
    var $language;

    // TTemplate $template
    // instance for current template processor
    var $template;

    // array $parameters
    // array of parameters for this plugin
    var $parameters;


	function dynPG_PLUGINNAME() {
        // import DynPG //
		global $DynPG;

		// constructor //

        // 1. initiate variables with default values

        $this->output_Message = '';
        $this->property_code  = '';


        // 2. get some foreign data of DynPG CMS

        if ( isset($GLOBALS['DynPG']) && is_object($GLOBALS['DynPG']) ) {
            $this->dynpg_instance = $GLOBALS['DynPG'];
            $this->rootToTool     = $this->dynpg_instance->PathToRoot;
            $this->rootFromPlugin = dynPG_PDF_Creator::realpath($this->rootToTool . 'plugins/DPGplugin/') . '/';
        } else {
            $this->rootToTool     = '';
            $this->rootToPlugin   = '';
            $this->dynpg_instance = null;
        }


        // 3. read current language (selected by includes class)

        $this->setupLanguage($this->dynpg_instance->_PlugIn['dpgplugin']['language']);


        // 4. instanciate current template processor

        // a) create instance

        $this->template = new TTemplate();

        // b) disable autoRender mode

        $this->template->autoRenderOff();

        // c) set some default values

        // see 8.

        // d) add some plugin specific vaiables to the dynpg template processor

        // -

        // 5. connect MySQL

        $this->establish_MySQL_Connection();


        // 6. Include required data

        $this->setupRequirements();


        // 7. read parameters

        // a) instanciate defaults

            $_ = Array(
			);

        // b) read user defined

            $this->parameters = array_merge($_, $this->dynpg_instance->_PlugIn['dpgplugin']['parameters']);


        // 8. add get and post values to template engine

        	foreach ($_GET as $key => $value) {
				$this->template->addVar('PLUGINNAME->get->' . $key, htmlentities($value));
			}
			foreach ($_POST as $key => $value) {
				$this->template->addVar('PLUGINNAME->post->' . $key, htmlentities($value));
			}


		register_shutdown_function(array(&$this, 'destroy_dynPG_PLUGINNAME'));
    }

	function realpath($path) {
		if (! function_exists('realpath')) {
			return $path;
		}
		$_ = realpath($path);
		return (
			($_ != false)?
			$_:
			$path
		);
	}


	// -- dynpg plugin methods --

	function perform() {
        // insert plugin
			if ( preg_match('/<img([^<>]+)alt="PLUGINNAME"([^<>]+)\/>/', $this->property_code ) ) {
	            $pdf = $this->write_PLUGINNAME();
	            $this->property_code = preg_replace('/<img([^<>]+)alt="PLUGINNAME"([^<>]+)\/>/', $pdf, $this->property_code);
	        }

	    // finally render the code because the autoRender mode is disabled
	    	$this->property_code = $this->template->render($this->property_code, false);
    }

    function setupLanguage($lang = 'de') {
        require_once dirname( __FILE__ ) . '/languages/'.strtolower($lang).'.lang.php';

        $this->language[0] = strtolower($lang);
        $this->language[1] = new TLanguage($this->language[0], 'DPGplugin');
    }

    function establish_MySQL_Connection() {
        require_once $this->rootToTool . 'connectdb.php';
    }

    function setupRequirements() {
    	// require 3rd party and misc
			// -

		// require libaries
			$dir = dirname(__FILE__) . '/api/';
			$dh  = opendir($dir);
			while ($obj = readdir($dh)) {
				if (is_file($dir . $obj) && eregi('_api.php$', $obj)) {
					require_once ($dir . $obj);
				}
			}
			closedir($dh);
    }

    function setParam($param = '', $value = '') {
        $this->parameters[strtolower($param)] = $value;
    }


	// -- private --

	function array_change_key_case($arr, $case = CASE_LOWER) {
        if (! is_array($arr) ) {
            return $arr;
        }

        $_ = Array();
        foreach ( $arr as $key => $value ) {
            $_[ $case == CASE_UPPER ? strtoupper($key) : strtolower($key) ] = $value;
        }

        return $_;
    }

    function array_swap_elements($e1, $e2, $array) {
    	if (isset($array[$e1]) && isset($array[$e2])) {
    		$_ = $array[$e1];
    		$array[$e1] = $array[$e2];
			$array[$e2] = $_;
    	}
    	return $array;
    }

	function get_url_string($html = true/*, [...]*/) {
		$conform_Uri   = Array('dataIDX');
		$function_args = func_get_args();
        $query_array   = Array();

        $html = $function_args[0];
        array_shift($function_args);

		foreach ($conform_Uri as $param) {
			$value = count($function_args) > 0? array_shift($function_args): '';
			$query_array []= "{$param}={$value}";
        }

        return implode(($html? '&amp;': '&'), $query_array);
	}

	function get_Global_Var($var, $default = null) {
		$content = $default;

		if (!empty($_GET[$var])) {
			$content = addslashes($_GET[$var]);
		}
		if (!empty($_POST[$var])) {
			$content = $_POST[$var];
		}

		return $content;
	}


	// -- implementation --

	function write_PLUGINNAME() {
		// try to get some GET data (this is exmaple code!)
			$sourceIDX = $this->get_Global_Var('dataIDX', '');

		return '';
	}

    // destructor
	function destroy_dynPG_PLUGINNAME() {
        // destructor //
    }

}
?>