<?php
	// For compatibility to old versions of DynPG
	// declare global variables

	global $DefineRootToTool;
	global $UseThisPageInClass;
    global $DYNPG_VAR_OUTSIDE_IMGURL;


	/**
	 * This class implements methods to use the
	 * data, entered in DynPG backend inside web-projects.
	 * Therefore it makes use of several property-set-functions,
	 * whose names start with "SetParam".
	 *
	 * @author Daniel Schliebner
	 * @copyright 2007
	 * @version 1.0
	 * @access public
	 **/

	class TDynPG_MainClass {

	// begin->class

        // begin properties

        // general
	        var $PathToRoot;
			var $PathToNextPage;
	        var $PathToPriorPage1;
	        var $PathToPriorPage2;
	        var $PathToCurrPage;
	        var $SavedSettings;

	        var $PageSelector;
	        var $IdxSelector;
	        var $CatSelector;
	        var $CurrentPage;
            var $IsGroupContent;

        //	all groups
	        var $_AG_Anytime;
	        var $_AG_ForceAnyTime;
	        var $_AG_Maxview;
	        var $_AG_ForceNav;
	        var $_AG_Order;
	        var $_AG_Sort;

        //	all articles
	        var $_AA_Anytime;
	        var $_AA_Maxview;
	        var $_AA_ForceNav;
	        var $_AA_SingleGroup;
	        var $_AA_SingleArticle;
	        var $_AA_CatNav;
	        var $_AA_FwdText;
	        var $_AA_SingleCss;
	        var $_AA_ForceAnyTime;
	        var $_AA_IncludeGroups;
	        var $_AA_ExcludeGroups;
	        var $_AA_ExcludeArticles;
	        var $_AA_IncludeArticles;
	        var $_AA_Order;
	        var $_AA_Sort;
	        var $_AA_IgnoreSeperator;
	        var $_AA_loadText;
	        var $_AA_home;
	        var $_AA_IgnoreLimitation;
	        var $_AA_HitlistTimeSpan;
	        var $_AA_TextGrouping;

        //	articles
	        var $_A_Anytime;
	        var $_A_SingleArticle;
	        var $_A_CatNav;
	        var $_A_PrintNav;
          	var $_A_LinkNav;
          	var $_A_RecommendNav;
          	var $_A_PdfNav;
	        var $_A_Head;
	        var $_A_SingleArticleCss;
	        var $_A_IgnoreSeperator;
          	var $_A_loadText;
	        var $_A_ShowText;
	        var $_A_IgnoreLimitation;

        //	home
	        var $_H_Anytime;
	        var $_H_Head;
	        var $_H_ShowAll;
	        var $_H_FwdText;
	        var $_H_ShowText;

        // search
        	var $_SRCH_ResultPage;

        // pool
	        var $_POOL_ShowWhat;
	        var $_POOL_Pool;

        // select list
	        var $_SL_Section;
	        var $_SL_Order;
	        var $_SL_Limit;
	        var $_SL_Separator;

        // dynamic menu
	        var $_VM_Template;
	        var $_VM_All_Groups;
	        var $_VM_Groups;
	        var $_VM_All_ArticlesFrom;
	        var $_VM_NotGroups;
	        var $_VM_ArticlesFrom;
	        var $_VM_ArticlesNotFrom;
	        var $_VM_Order;
	        var $_VM_PathToNext;
	        var $_VM_GroupsStructured;
	        var $_VM_BeginLetter;

        // plugins
        	var $_PlugIn;

        // extended usage
	        var $language;
	        var $template;

	    // other
	    	var $__treestruct_Table_Content;

        //cache
            var $_cacheLiteObject;
            var $_cacheLiteOptions;
            var $_cacheLiteId;
            var $cacheLiteDisabled;

		//
		// end properties
		//

		// ---------------------------------------------------------------------------
		/**
			* function TDynPG_MainClass()
			*
			* This is the constructor of the class TDynPG_MainClass.
			* Its use is to preload variables and set default data, used
			* in following processes (e.g. it opens an mysql-connection).
			*
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function TDynPG_MainClass()
		{
			@session_start();

			//cache lite implementation
            @require_once dirname(__FILE__) . '/'."config.php";

            $this->cacheLiteDisabled = false;

            if (!empty($GLOBALS['cfg']["config_Cache_Mode"]) && $GLOBALS['cfg']["config_Cache_Mode"] && (!isset($_POST) || empty($_POST)) && (!isset($_FILES) || empty($_FILES)) && (ob_get_length() === false || ob_get_length() == 0)) {
                // Include the package
                @include_once('Lite.php');
                if(class_exists('Cache_Lite')){
                    // Set a id for this cache
                    $host = $_SERVER['HTTP_HOST'];
                    $self = $_SERVER['PHP_SELF'];
                    $query = !empty($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : null;
                    $url = !empty($query) ? " $host$self?$query" : " $host$self";
                    $this->_cacheLiteId = md5($url);

                    // Set a few options
                    if(!is_dir(dirname(__FILE__) . '/'.'cache/')){
                        @mkdir(dirname(__FILE__) . '/'.'cache/', 0777);
                    }
                    $this->_cacheLiteOptions = array(
                        'cacheDir' => dirname(__FILE__) . '/'.'cache/',
                        'lifeTime' => ((!empty($GLOBALS['cfg']["config_Cache_Lifetime"])) ? $GLOBALS['cfg']["config_Cache_Lifetime"]: 3600)
                    );

                    // Create a Cache_Lite object
                    $this->_cacheLiteObject = new Cache_Lite($this->_cacheLiteOptions);

                    //check editMode
                    @require_once dirname(__FILE__) . '/'."connectdb.php";
                    $editMode = 'FALSE';
                    if(!empty($_SESSION['NAME'])){
                        $sql_res = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_user` WHERE `NAME`='{$_SESSION['NAME']}'"));
                        $editMode = $sql_res["EDIT_MODE"];
                    }

                    // Test if thereis a valide cache for this id
                    if(is_object($this->_cacheLiteObject)){
                        if (($data = $this->_cacheLiteObject->get($this->_cacheLiteId)) && $editMode != 'TRUE') {
                            echo $data;
                            exit();
                        } else {
                          if($editMode == 'TRUE')
                            $this->cacheLiteDisabled = true; //delete cache if editMode is ON
                          ob_start();
                        }
                    }
                }
            }

            if ( empty($_GET["page"]) ) {
                $_GET["page"] = 0;
            }

            $this->CurrentPage = addslashes(is_numeric($_GET["page"])? $_GET["page"]: '0');

			if ( empty($_GET["read_category"]) &&
                 empty($_GET["read_group"])    &&
                 empty($_GET["read_article"])  &&
                 empty($_GET["read_srch"])     ) {

                 $this->PageSelector = "HOME";

            } else if ( !empty($_GET["read_category"]) &&
                         empty($_GET["read_group"])    &&
                         empty($_GET["read_article"])  &&
                         empty($_GET["read_srch"]) ) {

                 $this->PageSelector = "GROUPS";

            } else if ( empty($_GET["read_article"]) ) {

                 $this->PageSelector = "ARTICLES";

            } else {

                 $this->PageSelector = "ARTICLES_EX";

            }

			switch ($this->PageSelector) {
				case "HOME": 		$this->IdxSelector = 'NULL'; break;
				case "GROUPS": 		$this->IdxSelector = is_numeric($_GET["read_category"])? $_GET["read_category"]: 'NULL'; break;
				case "ARTICLES": 	$this->IdxSelector = ( empty($_GET["read_srch"]) ) ? is_numeric($_GET["read_group"])? $_GET["read_group"]: 'NULL' : '0'; break;
				case "ARTICLES_EX": $this->IdxSelector = is_numeric($_GET["read_article"])? $_GET["read_article"]: 'NULL'; break;
				default:            $this->IdxSelector = 'NULL'; break;
			}

			$this->IdxSelector = addslashes($this->IdxSelector);

            $this->SavedSettings = Array();

			// preload variables
            $this->CatSelector = "";
            $this->IsGroupContent = FALSE;

			//	all groups
			$this->_AG_Anytime 	    = FALSE;
			$this->_AG_ForceAnyTime = FALSE;
			$this->_AG_Maxview 	    = 0;
			$this->_AG_ForceNav     = TRUE;
			$this->_AG_Order        = Array('Index', 'Name');
            $this->_AG_Sort         = Array('Desc', 'Asc');

			//	all groups
			$this->_AA_Anytime 	        = FALSE;
			$this->_AA_Maxview 	        = 0;
			$this->_AA_ForceNav         = TRUE;
			$this->_AA_SingleGroup      = "";
            $this->_AA_SingleArticle    = 0;
			$this->_AA_CatNav           = TRUE;
            $this->_AA_PrintNav         = FALSE;
            $this->_AA_FwdText          = "";
            $this->_AA_SingleCss        = 0;
            $this->_AA_ForceAnyTime     = FALSE;
            $this->_AA_IncludeGroups    = Array();
            $this->_AA_ExcludeGroups    = Array();
            $this->_AA_ExcludeArticles  = Array();
            $this->_AA_IncludeArticles  = Array();
            $this->_AA_Order            = Array('Fixpoint', 'Date');
            $this->_AA_Sort             = Array('Asc', 'Desc');
            $this->_AA_loadText         = FALSE;
            $this->_AA_IgnoreSeperator  = TRUE;
            $this->_AA_home             = FALSE;
            $this->_AA_IgnoreLimitation = FALSE;
            $this->_AA_HitlistTimeSpan  = 0;
            $this->_AA_TextGrouping     = FALSE;

			//	articles
			$this->_A_Anytime          = FALSE;
			$this->_A_SingleArticle    = 0;
			$this->_A_SingleArticleCss = 0;
			$this->_A_CatNav           = TRUE;
			$this->_A_PrintNav         = TRUE;
	      	$this->_A_LinkNav          = FALSE;
	      	$this->_A_RecommendNav     = FALSE;
	      	$this->_A_PdfNav   		   = FALSE;
			$this->_A_Head             = TRUE;
            $this->_A_IgnoreSeperator  = TRUE;
            $this->_A_loadText   	   = TRUE;
            $this->_A_ShowText         = TRUE;
            $this->_A_IgnoreLimitation = FALSE;

            //	home
			$this->_H_Anytime  = FALSE;
			$this->_H_Head     = TRUE;
            $this->_H_ShowAll  = FALSE;
            $this->_H_ShowText = TRUE;
            $this->_H_FwdText  = TRUE;

            //  search
            $this->_SRCH_ResultPage = $_SERVER["PHP_SELF"];

            //  pool
            $this->_POOL_ShowWhat = 0;
            $this->_POOL_Pool     = '';

            //  select list
            $this->_SL_Section   = '';
    		$this->_SL_Order     = 'ASC';
            $this->_SL_Limit     = 0;
            $this->_SL_Separator = '---';

            //  dynamic menu
            $this->_VM_Template         = '_phpmenu';
    		$this->_VM_All_Groups       = TRUE;
            $this->_VM_Groups           = Array();
            $this->_VM_All_ArticlesFrom = TRUE;
            $this->_VM_ArticlesFrom     = Array();
    		$this->_VM_Order            = Array('NAME', 'ASC');
            $this->_VM_PathToNext       = Array($_SERVER["PHP_SELF"], $_SERVER["PHP_SELF"]);
            $this->_VM_NotGroups        = Array();
            $this->_VM_ArticlesNotFrom  = Array();
            $this->_VM_GroupsStructured = TRUE;
            $this->_VM_BeginLetter      = '';

            // other
            $this->__treestruct_Table_Content = Array();

            //  plugins
            $this->_PlugIn = Array();

			$this->SetParam_PathToCurrPage($_SERVER["PHP_SELF"]);
            $this->SetParam_PathToNextPage($_SERVER["PHP_SELF"]);
            $this->SetParam_PathToPriorPage($_SERVER["PHP_SELF"], 1);
            $this->SetParam_PathToPriorPage($_SERVER["PHP_SELF"], 2);

            $this->getContent_verify__POST();

            $this->saveCurrentParams();

            $this->PathToRoot = dirname(__FILE__) . '/';
            $GLOBALS['DefineRootToTool'] = $this->PathToRoot;

            $this->language = Array();

            $this->template = Array();

			register_shutdown_function(array(&$this, "Destruct_TDynPG_MainClass"));
		} // end->contructor
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
        /**
			* procedure getContent_verify__POST()
			*
			* This function denies SQL-Injections: makes POST-Data MySQL-Secure
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return boolean
			*/
        function getContent_verify__POST()
        {
            if ( get_magic_quotes_gpc() ) {
                return false;
            }

            // general protection against SQL injections
            foreach ( $_POST as $key => $value ) {
                if ( strpos(strtolower($key), 'mail') ) {
                    $_POST[$key] = preg_replace("/,.*$/", "", $value);
                }

                if (! is_array($value) ) {
                    $_POST[$key] = addslashes($value);
                }
            }

            return true;
        }
        // --------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
        /**
			* procedure sendHTTPHeader()
			*
			* This function sends an http-header information for charset (only call if really neccessary!)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [charset: string, content_type: string, additional: string]
			* @return -
			*/
        function sendHTTPHeader($charset = 'iso-8859-1', $content_type = 'text/html', $additional = null)
        {
            @header("Content-Type: {$content_type}; charset={$charset}");

            if (! is_null($additional) ) {
                @header($additional);
            }
        }
        // ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure LoadIncludes()
			*
			* This function loads all important php-includes
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function LoadIncludes()
		{
			// I. include api and header files
				require_once $this->PathToRoot."defines.php";
				require_once $this->PathToRoot."counter.php";
				require_once $this->PathToRoot."config.php";
				require_once $this->PathToRoot."functions.php";

				require_once $this->PathToRoot."plugins/plugins.php";
				require_once $this->PathToRoot."plugins/templates.php";
				require_once $this->PathToRoot."plugins/languages.php";

				require_once $this->PathToRoot."connectdb.php";

			// II. set error reporting
				if (!empty($GLOBALS['cfg']["config_Debug_Mode"]) && $GLOBALS['cfg']["config_Debug_Mode"]) {
					@error_reporting(E_ALL);
					@ini_set('display_errors', 1);
				} else {
					@error_reporting(0);
					@ini_set('display_errors', 0);
				}

			// III. init some processes

				// III.1 init treestruct table of groups to spare db server traffic
				$this->__init_DynPG_treestruct_Table_Content();

		} // end->LoadIncludes
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_PathToRoot()
			*
			* This function sets the path to the root-folder of DynPG
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string: string]
			* @return -
			*/
		function SetParam_PathToRoot($string = "")
		{
			$this->PathToRoot = $string;

            $GLOBALS["DefineRootToTool"] = $string;

			$this->LoadIncludes();

			$this->LoadPlugIns();

            $defaultLanguage = (empty($GLOBALS['cfg']["config_default_language"])? 'de': $GLOBALS['cfg']["config_default_language"]);
            $this->setupLanguage($defaultLanguage);

            $this->setupTemplate();

		} // end->SetParam_PathToRoot
        // ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
 		/**
			* procedure SetParam_PathToNextPage()
			*
			* This function sets the path to the next page in hierarchy from including page
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string: string]
			* @return -
			*/
		function SetParam_PathToNextPage($string = "")
		{
			$this->PathToNextPage = $string;
		} // end->SetParam_PathToNextPage
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure PathToPriorPage()
			*
			* This function returns the value from a prior page with depth of hierarchy 1 or 2
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [depth: integer]
			* @return integer
			*/
		function PathToPriorPage($depth = 1)
		{
			return ( $depth==1 ? $this->PathToPriorPage1 : $this->PathToPriorPage2 );
		} // end->SetParam_PathToPriorPage
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure SetParam_PathToPriorPage()
			*
			* This function sets the path to the prior page in hierarchy from including page
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string: string, depth: integer]
			* @return -
			*/
		function SetParam_PathToPriorPage($string = "", $depth = 1)
		{
			if ( $depth==1 ) $this->PathToPriorPage1 = $string;
                else $this->PathToPriorPage2 = $string;
		} // end->SetParam_PathToPriorPage
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure SetParam_PathToCurrPage()
			*
			* This function sets the path to the current page from including page
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string: string]
			* @return -
			*/
		function SetParam_PathToCurrPage($string = "")
		{
			$this->PathToCurrPage = $string;
            $GLOBALS["UseThisPageInClass"] = $string;
		} // end->SetParam_PathToCurrPage
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_UseCategory()
			*
			* This function sets the current category to load on home
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string: string, byname: boolean]
			* @return -
			*/
		function SetParam_UseCategory($string = null, $byname = true)
		{
            if ( empty($this->IdxSelector) || $this->IdxSelector == 'NULL' ) {
                if ( is_null($string) ) {
                    $this->IdxSelector = 'NULL';
                    $this->CatSelector = 'Alle';
                } else {
                	if ( $byname ) {
						$GROUP = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_groups` WHERE UCASE(`NAME`)='".strtoupper($string)."'"));
					} else {
						$GROUP = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_groups` WHERE `id`='{$string}'"));
					}
                	$this->IdxSelector = $GROUP->id;
                    $this->CatSelector = $GROUP->NAME;
                }
            }
		} // end->SetParam_UseCategory
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure SetParam_Images_On_Server()
			*
			* This function sets the global var to the external path where the images lie
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [server: string]
			* @return -
			*/
        function SetParam_Images_On_Server($server = "")
        {
            if ( !empty($server) ) $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"] = $server;
                else echo "<b>ERROR #2:</b> No server specified in `SetParam_DB_On_Server()`! Please specify a server.";
        } // end->SetParam_Images_On_Server

		// ---------------------------------------------------------------------------
		/**
			* procedure Private_ReconnectMySQL()
			*
			* This function reconnects to MySQL
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [otherDB: boolean, connData: array]
			* @return -
			*/
		function Private_ReconnectMySQL( $otherDB = false, $connData = Array() )
		{
			global $OPEN_MYSQL_CONNECTION;

			if ( !$otherDB ) {
				if (empty($GLOBALS['OPEN_MYSQL_CONNECTION']) && empty($OPEN_MYSQL_CONNECTION))
                	require	$this->PathToRoot . "connectdb.php";
            } else {
                $GLOBALS['OPEN_MYSQL_CONNECTION'] = @mysql_connect($connData[0], $connData[1], $connData[2])
            			or die(htmlentities("Cannot connect to MySQL Server. Please contact your administrator."));
            	mysql_select_db(MYSQL_DATABASE)
            			or die(htmlentities("No connection to database " . $connData[3] . ". Please contact your administrator."));
            }
		} // end->Private_ReconnectMySQL
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure Private_GetTimeStamp()
			*
			* This function creates the unix timestamp of a date (dd.mm.yyyy)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param time: string
			* @return integer
			*/
		function Private_GetTimeStamp($time)
		{
			$SplittetTime = preg_replace("/(\d+)-(\d+)-(\d+)(.*) (\d+):(\d+):(\d+)/","\\1;\\2;\\3;\\5;\\6;\\7",$time);
			/*
			*  '$SplittetTime' now set as: "Year;Month;Day;Hours;Minutes;Seconds"
			*/
			$SplittetTime = explode(";", $SplittetTime);

			// fix for PHP-Versions >= 5
			// because mktime does not return -1 any more

			$nilDate = true;
			foreach($SplittetTime as $entry){
				if ( (integer)$entry != 0 ) {
					$nilDate = false;
				}
			}
			if ($nilDate) {
				return -1;
			}

			return ( mktime($SplittetTime[3],
						  	$SplittetTime[4],
						  	$SplittetTime[5],
						  	$SplittetTime[1],
						  	$SplittetTime[2],
						  	$SplittetTime[0]) );
		}
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure Private_GetSiteString()
			*
			* This function gets the sites of navigation
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param DestinationPage: string, Entries: integer, MaxEntries: integer[, Show: boolean]
			* @return string
			*/
		function Private_GetSiteString($DestinationPage, $Entries, $MaxEntries, $Show = TRUE)
		{
			if ( ($Entries<=$MaxEntries or !$Show) && !($Entries<=$MaxEntries && $Show) ) return "";

			$sites = "";
			$arith = ceil($Entries/$MaxEntries);

			$_range = ceil( $GLOBALS["cfg"]["config_Navigation_Range_Numbered"] / 2 );
			$_min = 1;

			$listing      = '';
            $template_row = $this->template[1]->getSubTemplate('listing', dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/navigation-pages.tpl');

			for ($i=1; $i<=$arith; $i++ )
			{
                if (($i-1)==$this->CurrentPage) $linkstr="<b>[$i]</b>";
					else $linkstr="<a href=\"$DestinationPage"."page=".($i-1)."\">$i</a>";


                $separation = 0;
                if ($i==$_min) {
					$sites .= "$linkstr | ";
					$separation = 1;
				} else if ( ($i>=($this->CurrentPage+1)-$_range && $i<=($this->CurrentPage+1)+$_range) && $i<$arith ) {
					$sites .= " $linkstr | ";
					$separation = 2;
				} else if ( ( ($i==($this->CurrentPage+1)-$_range-1 && $i>$_min) || ($i==($this->CurrentPage+1)+$_range+1 && $i<$arith)) && $i<$arith ) {
					$sites .= " ... | ";
					$separation = 3;
				} else if ($i==$arith) {
					$sites .= " $linkstr";
					$separation = 4;
				}

				if ( $separation ) {
                    $listing .= $this->template[1]->fillTemplate(

                                    $template_row ,

                                    false ,

                                    Array (

                                      'PG_NAV_ISCURRENT' => (($i-1)==$this->CurrentPage) ? 'True' : 'False',

                                      'PG_NAV_PAGENUMBER' => $i,

                                      'PG_NAV_RELPAGE' => $DestinationPage,

                                      'PG_NAV_SEPARATION' => $separation

                                    ) );
                }
			}

			if ($MaxEntries<$Entries)
			{
				if ( (($this->CurrentPage + 1)*$MaxEntries) >= $Entries && $this->CurrentPage>0 )
				{
					# Last page
					$preview = $this->CurrentPage - 1;
					$next    = -1;
				} else if ( ($this->CurrentPage*$MaxEntries) < $Entries && $this->CurrentPage>0 )
				{
					# Between
					$preview = $this->CurrentPage - 1;
					$next    = $this->CurrentPage + 1;
				} else if ( ($this->CurrentPage*$MaxEntries) < $Entries && $this->CurrentPage==0 )
				{
					# First page
					$preview = -1;
					$next    = $this->CurrentPage + 1;
				}
			} else
			  {
			  	# Only one page
			 	$preview = -1;
				$next    = -1;
			  }

			unset($PointsSet);
			unset($arith);
			unset($i);
			unset($linkstr);
			unset($MaxEntries);

			return $returntext = $this->template[1]->render(
					$this->template[1]->fillTemplate(
                        $this->template[1]->replaceSubTemplate(
                            'listing',

                            $listing,

                            dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/navigation-pages.tpl'
                        ),

                        false,

                        Array(

                            'PG_NAV_RELPAGE' => $DestinationPage,

                            'PG_NAV_NEXTPAGE' => $next,

                            'PG_NAV_LASTPAGE' => $preview,

                            'LANG_PG_NAV_BACK' => $this->language[1]->str['lang_navigation_pages_back'],

                            'LANG_PG_NAV_NEXT' => $this->language[1]->str['lang_navigation_pages_next']

                        ) ), false);
		}
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
        function dynPG_getContent_organizeUrlQueryString($uri = '', $doUrlEncode = TRUE)
        {
            $uri = str_replace('&amp;', '&', $uri);
            $uri = preg_replace('/%(SELECTO|DYNPG)([^%]+)%/', '__PERCENT__\\1\\2__PERCENT__', $uri);

            $tpl_idx   = Array(0=> 't', 1 => 'read_category', 2 => 'read_group', 3 => 'read_article', 4 => 'PHPSESSID', 5 => 'page');

            parse_str($uri, $query_parsed);

            $organizedUri = 'START';

            foreach ( $tpl_idx as $idx => $command ) {
                if ( array_key_exists($command, $query_parsed) ) {
                    if ( !empty($query_parsed[$command]) ) {
                        $query_parsed[$command] = stripslashes($query_parsed[$command]);

                        if ( $doUrlEncode ) {
                            $organizedUri .= '&' . urlencode($command) . '=' . urlencode($query_parsed[$command]);
                        } else {
                            $organizedUri .= '&' . $command . '=' . $query_parsed[$command];
                        }
                    }
                }
            }

            $notSpecified = '';

            foreach ( $query_parsed as $command => $parsed_str ) {
                if ( !in_array($command, $tpl_idx) ) {
                    if ( !empty($parsed_str) ) {
                        $parsed_str = stripslashes($parsed_str);

                        if ( $doUrlEncode ) {
                            $notSpecified .= '&' . urlencode($command) . '=' . urlencode($parsed_str);
                        } else {
                            $notSpecified .= '&' . $command . '=' . $parsed_str;
                        }
                    }
                }
            }

            $organizedUri .= $notSpecified;

            if ( $organizedUri == 'START' ) {
                $organizedUri = preg_replace('/START/', '', $organizedUri);
            } else {
                $organizedUri = str_replace('START&', '', $organizedUri);
            }

            $organizedUri = str_replace('&', '&amp;', $organizedUri);
            $organizedUri = str_replace('__PERCENT__', '%', $organizedUri);

            return $organizedUri;
        }
        // ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure saveCurrentParams()
			*
			* This function 'saves' the settings of current params
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function saveCurrentParams()
        {
            $this->SavedSettings[0] = time();

            // preload variables
            $this->SavedSettings[1] = $this->CatSelector;

			//	all groups
			$this->SavedSettings[2]  = $this->_AG_Anytime;
			$this->SavedSettings[3]  = $this->_AG_Maxview;
			$this->SavedSettings[4]  = $this->_AG_ForceNav;
			$this->SavedSettings[54] = $this->_AG_Order;
			$this->SavedSettings[55] = $this->_AG_Sort;

			//	all groups
			$this->SavedSettings[5] = $this->_AA_Anytime;
			$this->SavedSettings[6] = $this->_AA_Maxview;
			$this->SavedSettings[7] = $this->_AA_ForceNav;
			$this->SavedSettings[8] = $this->_AA_SingleGroup;
            $this->SavedSettings[9] = $this->_AA_SingleArticle;
			$this->SavedSettings[10] = $this->_AA_CatNav;
            $this->SavedSettings[67] = $this->_AA_PrintNav;
            $this->SavedSettings[11] = $this->_AA_FwdText;
            $this->SavedSettings[12] = $this->_AA_SingleCss;
            $this->SavedSettings[13] = $this->_AA_ForceAnyTime;
            $this->SavedSettings[41] = $this->_AA_IncludeGroups;
            $this->SavedSettings[42] = $this->_AA_ExcludeGroups;
            $this->SavedSettings[60] = $this->_AA_ExcludeArticles;
            $this->SavedSettings[61] = $this->_AA_IncludeArticles;
            $this->SavedSettings[56] = $this->_AA_Order;
			$this->SavedSettings[57] = $this->_AA_Sort;
			$this->SavedSettings[58] = $this->_AA_IgnoreSeperator;
			$this->SavedSettings[59] = $this->_AA_home;
			$this->SavedSettings[62] = $this->_AA_loadText;

			//	articles
			$this->SavedSettings[14] = $this->_A_Anytime;
			$this->SavedSettings[15] = $this->_A_SingleArticle;
			$this->SavedSettings[16] = $this->_A_SingleArticleCss;
			$this->SavedSettings[17] = $this->_A_CatNav;
			$this->SavedSettings[18] = $this->_A_PrintNav;
	      	$this->SavedSettings[64] = $this->_A_LinkNav;
	      	$this->SavedSettings[65] = $this->_A_RecommendNav;
	      	$this->SavedSettings[66] = $this->_A_PdfNav;
			$this->SavedSettings[19] = $this->_A_Head;
			$this->SavedSettings[20] = null /*deleted*/;
            $this->SavedSettings[21] = $this->_A_IgnoreSeperator;
            $this->SavedSettings[22] = $this->_A_ShowText;
      		$this->SavedSettings[63] = $this->_A_loadText;

            //	home
			$this->SavedSettings[23] = $this->_H_Anytime;
			$this->SavedSettings[24] = $this->_H_Head;
            $this->SavedSettings[25] = $this->_H_ShowAll;
            $this->SavedSettings[26] = $this->_H_FwdText;
            $this->SavedSettings[27] = $this->_H_ShowText;

            //  search
            $this->SavedSettings[28] = null /*deleted*/;
            $this->SavedSettings[29] = $this->_SRCH_ResultPage;

            //  pool
            $this->SavedSettings[30] = $this->_POOL_ShowWhat;
            $this->SavedSettings[31] = $this->_POOL_Pool;

            //  select list
            $this->SavedSettings[33] = $this->_SL_Section;
    		$this->SavedSettings[34] = $this->_SL_Order;
            $this->SavedSettings[35] = $this->_SL_Limit;
            $this->SavedSettings[36] = $this->_SL_Separator;

            // dynamic menu
            $this->SavedSettings[43] = $this->_VM_Template;
            $this->SavedSettings[44] = $this->_VM_All_Groups;
            $this->SavedSettings[45] = $this->_VM_Groups;
            $this->SavedSettings[46] = $this->_VM_All_ArticlesFrom;
            $this->SavedSettings[47] = $this->_VM_NotGroups;
            $this->SavedSettings[48] = $this->_VM_ArticlesFrom;
            $this->SavedSettings[49] = $this->_VM_ArticlesNotFrom;
            $this->SavedSettings[50] = $this->_VM_Order;
            $this->SavedSettings[51] = $this->_VM_PathToNext;
            $this->SavedSettings[52] = $this->_VM_GroupsStructured;
            $this->SavedSettings[53] = $this->_VM_BeginLetter;

            $this->SavedSettings[37] = $this->PathToCurrPage;
            $this->SavedSettings[38] = $this->PathToNextPage;
            $this->SavedSettings[39] = $this->PathToPriorPage1;
            $this->SavedSettings[40] = $this->PathToPriorPage2;
        }
        // ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure loadSavedParams()
			*
			* This function 'load' the settings of saved params
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function loadSavedParams()
        {
            // preload variables
            $this->CatSelector = $this->SavedSettings[1];

			//	all groups
			$this->_AG_Anytime = $this->SavedSettings[2];
			$this->_AG_Maxview = $this->SavedSettings[3];
			$this->_AG_ForceNav = $this->SavedSettings[4];
			$this->_AG_Order = $this->SavedSettings[54];
			$this->_AG_Sort = $this->SavedSettings[55];

			//	all groups
			$this->_AA_Anytime = $this->SavedSettings[5];
			$this->_AA_Maxview = $this->SavedSettings[6];
			$this->_AA_ForceNav = $this->SavedSettings[7];
			$this->_AA_SingleGroup = $this->SavedSettings[8];
            $this->_AA_SingleArticle = $this->SavedSettings[9];
			$this->_AA_CatNav = $this->SavedSettings[10];
            $this->_AA_PrintNav = $this->SavedSettings[67];
            $this->_AA_FwdText = $this->SavedSettings[11];
            $this->_AA_SingleCss = $this->SavedSettings[12];
            $this->_AA_ForceAnyTime = $this->SavedSettings[13];
            $this->_AA_IncludeGroups = $this->SavedSettings[41];
            $this->_AA_ExcludeGroups = $this->SavedSettings[42];
            $this->_AA_ExcludeArticles = $this->SavedSettings[60];
            $this->_AA_IncludeArticles = $this->SavedSettings[61];
            $this->_AA_Order = $this->SavedSettings[56];
            $this->_AA_Sort = $this->SavedSettings[57];
            $this->_AA_IgnoreSeperator = $this->SavedSettings[58];
            $this->_AA_home = $this->SavedSettings[59];
            $this->_AA_loadText = $this->SavedSettings[62];

			//	articles
			$this->_A_Anytime = $this->SavedSettings[14];
			$this->_A_SingleArticle = $this->SavedSettings[15];
			$this->_A_SingleArticleCss = $this->SavedSettings[16];
			$this->_A_CatNav = $this->SavedSettings[17];
			$this->_A_PrintNav = $this->SavedSettings[18];
      		$this->_A_LinkNav = $this->SavedSettings[64];
      		$this->_A_RecommendNav = $this->SavedSettings[65];
      		$this->_A_PdfNav = $this->SavedSettings[66];
			$this->_A_Head = $this->SavedSettings[19];
            $this->_A_IgnoreSeperator = $this->SavedSettings[21];
            $this->_A_ShowText = $this->SavedSettings[22];
            $this->_A_loadText = $this->SavedSettings[63];

            //	home
			$this->_A_Anytime = $this->SavedSettings[23];
			$this->_H_Head = $this->SavedSettings[24];
            $this->_H_ShowAll = $this->SavedSettings[25];
            $this->_H_FwdText = $this->SavedSettings[26];
            $this->_H_ShowText = $this->SavedSettings[27];

            //  search
            $this->_SRCH_ResultPage = $this->SavedSettings[29];

            //  pool
            $this->_POOL_ShowWhat = $this->SavedSettings[30];
            $this->_POOL_Pool = $this->SavedSettings[31];

            //  select list
            $this->_SL_Section = $this->SavedSettings[33];
    		$this->_SL_Order = $this->SavedSettings[34];
            $this->_SL_Limit = $this->SavedSettings[35];
            $this->_SL_Separator = $this->SavedSettings[36];

            // dynamic menu
            $this->_VM_Template = $this->SavedSettings[43];
            $this->_VM_All_Groups = $this->SavedSettings[44];
            $this->_VM_Groups = $this->SavedSettings[45];
            $this->_VM_All_ArticlesFrom = $this->SavedSettings[46];
            $this->_VM_NotGroups = $this->SavedSettings[47];
            $this->_VM_ArticlesFrom = $this->SavedSettings[48];
            $this->_VM_ArticlesNotFrom = $this->SavedSettings[49];
            $this->_VM_Order = $this->SavedSettings[50];
            $this->_VM_PathToNext = $this->SavedSettings[51];
            $this->_VM_GroupsStructured = $this->SavedSettings[52];
            $this->_VM_BeginLetter = $this->SavedSettings[53];

            $this->PathToCurrPage = $this->SavedSettings[37];
            $this->PathToNextPage = $this->SavedSettings[38];
            $this->PathToPriorPage1 = $this->SavedSettings[39];
            $this->PathToPriorPage2 = $this->SavedSettings[40];
        }
        // ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure setupLanguage()
			*
			* This function sets a specific language
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [lang: string]
			* @return -
			*/
		function setupLanguage($lang = 'de')
		{
            if(preg_match('/[^a-zA-Z]/', $lang) == 1){
            	$lang = 'de';
            }
            require_once $this->PathToRoot . 'localised/'.strtolower($lang).'.lang.php';

            $this->language[0] = strtolower($lang);
            $this->language[1] = new TLanguage($this->language[0], 'General');
		} // end->setupLanguage
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure setupTemplate()
			*
			* This function sets a specific language (for tpl)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [template: string]
			* @return -
			*/
		function setupTemplate($template = 'default')
		{
            if (! is_dir(dirname(__FILE__) . '/tpl/MyCMS/' . $template)) {
            	trigger_error('Could not find template &quot;' . $template . '&quot; in ' . dirname(__FILE__) . '/tpl/MyCMS/' . $template);
				$template = 'default';
            }

			$this->template[0] = strtolower($template);
            $this->template[1] = new TTemplate;

            if (isset($GLOBALS['cfg']["config_AutoRender_Mode"]) && !$GLOBALS['cfg']["config_AutoRender_Mode"])
				$this->template[1]->autoRenderOff();

            $this->template[1]->addVar('Main->rootToTool', $this->PathToRoot );
            $this->template[1]->addVar('Main->QueryString', htmlentities(((!getenv("QUERY_STRING")) ? $_SERVER['QUERY_STRING'] : getenv("QUERY_STRING"))) );
            $this->template[1]->addVar('Main->Self', $_SERVER['PHP_SELF'] );
            $this->template[1]->addVar('Main->time', time() );
            $this->template[1]->addVar('Main->PageSelector', $this->PageSelector );
            $this->template[1]->addVar('Main->IdxSelector', $this->IdxSelector );
            $this->template[1]->addVar('Main->Forms->Error', empty($_SESSION['FORM_DATA']['ERROR_STRING'])? '': $_SESSION['FORM_DATA']['ERROR_STRING'] );

            foreach ( $this->SavedSettings as $key => $value ) {

                if ( is_string($value) ) {
                    $this->template[1]->addVar('Main->Settings->Read[' . $key . ']', $value );
                }

                if ( is_numeric($value) ) {
                    $this->template[1]->addVar('Main->Settings->Read[' . $key . ']', (string)$value );
                }

                if ( is_bool($value) ) {
                    $this->template[1]->addVar('Main->Settings->Read[' . $key . ']', $value ? 'True' : 'False');
                }

                if ( is_array($value) ) {
                    foreach ( $value as $k => $v ) {
                        $this->template[1]->addVar('Main->Settings->Read[' . $key . '][' . $k . ']', (string)$v);
                    }
                }

            }
		} // end->setupTemplate
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
        /**
			* procedure LoadPlugIns()
			*
			* This function loads up plugins to class
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function LoadPlugIns()
		{
            $plugins = dynpg_handle_plugins('handle', true);

            // initiate template sets

            foreach ( $plugins as $key => $value ) {
                $this->_PlugIn[strtolower($value)]['realname']   = $value;
                $this->_PlugIn[strtolower($value)]['template']   = 'default';

                //setup default language
                $defaultLanguage = (empty($GLOBALS['cfg']["config_default_language"])? 'de': $GLOBALS['cfg']["config_default_language"]);
                if(!is_file(dirname(__FILE__).'/plugins/'.$value.'/languages/'.$defaultLanguage.'.lang.php')){
                    $defaultLanguage = 'de';
                }
                $this->_PlugIn[strtolower($value)]['language']   = $defaultLanguage;
                $this->_PlugIn[strtolower($value)]['parameters'] = Array();

                // read multi media data in plugin folder
                $this->_PlugIn[strtolower($value)]['html4styles'] = Array();

                if ( !is_dir(dirname(__FILE__) . '/plugins/' . $value . '/styles/') ) {
                    continue;
                }

                $directory = opendir(dirname(__FILE__) . '/plugins/' . $value . '/styles/');

                while ( $sub = readdir($directory) ) {
                    if ( !in_array($sub, Array('.', '..')) && is_file(dirname(__FILE__) . '/plugins/' . $value . '/styles/' . $sub) ) {
                        $this->_PlugIn[strtolower($value)]['html4styles'][] = $sub;
                    }
                }
            }

            foreach ( $plugins as $key => $value ) {
                if ( function_exists('PlugIn_preInitialize_' . strtolower($value)) ) {
                    call_user_func('PlugIn_preInitialize_' . strtolower($value));
                }
            }
		} // end->LoadPlugIns
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure plugInExists()
			*
			* This function checks if a plugin exists
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param name: string
			* @return boolean
			*/
		function plugInExists($name)
		{
            return ( array_key_exists(strtolower($name), $this->_PlugIn) );
		} // end->plugInExists
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure SetParam_PlugIn_Template()
			*
			* This function sets the template of a plugin
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [plugIn_Name: string]
			* @return string
			*/
        function SetParam_PlugIn_Template($pluginId = '', $template = 'default') { $this->_PlugIn[strtolower($pluginId)]['template'] = strtolower($template); }

		/**
			* procedure SetParam_PlugIn_Language()
			*
			* This function sets the language of a plugin
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.1
			* @access private
			* @copyright Daniel Schliebner, 18.08.2009
			* @param [plugIn_Name: string]
			* @return string
			*/
		function SetParam_PlugIn_Language($pluginId = '', $language = 'de') { $_SESSION['DPG_Plugin_' . strtolower($pluginId)]['language'] = $this->_PlugIn[strtolower($pluginId)]['language'] = strtolower($language); }

		/**
			* procedure SetParam_PlugIn_Param()
			*
			* This function sets the param of a plugin
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.1
			* @access private
			* @copyright Daniel Schliebner, 18.08.2009
			* @param [plugIn_Name: string]
			* @return string
			*/
		function SetParam_PlugIn_Param($pluginId = '', $param = '', $value = '') { $_SESSION['DPG_Plugin_' . strtolower($pluginId)]['parameters'][strtolower($param)] = $this->_PlugIn[strtolower($pluginId)]['parameters'][strtolower($param)] = $value; }

		/**
			* procedure call_PlugIn()
			*
			* This function calls a function, defined in a plugin
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [plugIn_Name: string]
			* @return string
			*/
		function call_PlugIn($plugIn_Name = '')
		{
            if ( function_exists($write_userfunction = ( 'write_DynPG_PlugIn_' . strtolower($plugIn_Name) )) ) {
                return call_user_func($write_userfunction);
			}

			trigger_error('Cannot find write-function to PlugIn ' . $plugIn_Name, E_USER_ERROR);
            return 0;
		} // end->call_PlugIn
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure writePathOfElement()
			*
			* This function writes the path of elements in navigation
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param _pathTo: string, _html_href: string[, test: integer]
			* @return string
			*/
		function writePathOfElement( $_pathTo, $_html_href, $recursion = 0 )
        {
            if ( $_pathTo == 'NULL' || trim($_pathTo) == '' ) {
                return '';
            }

            $subPiece['string'] 		= $this->language[1]->str['lang_navigation_root_separate_str'];
            $subPiece['firstelement'] 	= $this->language[1]->str['lang_navigation_root_firstelement'];
            $subPiece['singleelement']  = $this->language[1]->str['lang_navigation_root_singleelement'];

            $subPiece['regEx']  = dynpg_formPregValid($this->language[1]->str['lang_navigation_root_separate_str']);

            $__template_Str = "$_html_href%FIRSTELEMENT%</a>" . $this->template[1]->fillTemplate($subPiece['string'] , false) . "$_html_href%SUBELEMENTS%</a>";

            $__takeThisNext = Array('element_id_fk' => 'root_id_fk', 'successor_id_fk' => 'element_id_fk');

            $result = '';

            $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = $_pathTo GROUP BY `element_id_fk`");
            $_thisRow = 'element_id_fk';

            if ( mysql_num_rows($mysql_result) == 0 ) {
                $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `successor_id_fk` = $_pathTo");
                $_thisRow = 'successor_id_fk';
            }

            if ( mysql_num_rows($mysql_result) == 0 ) {
            	return '';
            }

            $listindex = $recursion + 1;

            $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC);

			$_complete_groupInfo = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_groups` WHERE `id` = ".$mysql_row[$_thisRow]), MYSQL_ASSOC);

            foreach ( $_complete_groupInfo as $key => $value ) {
                if ( $key != 'id' ) {
                    $__template_Str = str_replace('%'.strtoupper($key).'%', htmlentities($value), $__template_Str);
                }
            }

            if ( is_null($mysql_row['root_id_fk']) ) {
                $old = $_complete_groupInfo;
                $old = array_map(create_function('$value', 'return  htmlentities(stripslashes($value));'), $old);

				$_complete_groupInfo = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_groups` WHERE `id` = ".$mysql_row['element_id_fk']), MYSQL_ASSOC);
				$_complete_groupInfo = array_map(create_function('$value', 'return  htmlentities(stripslashes($value));'), $_complete_groupInfo);

                if (!is_null($mysql_row['successor_id_fk'])) {
					$_arr_Add_Replace = Array( 'SELECTOR' => 'read_category',
	                                           'RELPAGE'  => $this->PathToPriorPage(1),
	                                           'ID' => '%ID2%' );

	                foreach ( $_arr_Add_Replace as $key => $value ) {
	                    $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
	                }
				} else {
					$_arr_Add_Replace = Array( 'SELECTOR' => 'read_group',
	                                           'RELPAGE'  => $this->PathToPriorPage(2),
	                                           'ID' => '%ID2%' );

	                foreach ( $_arr_Add_Replace as $key => $value ) {
	                    $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
	                }
				}

                if ( $recursion == 0 && $old['id'] != $_complete_groupInfo['id'] ) {
                    $_arr_Add_Replace = Array( 'SELECTOR' => 'read_group',
                                               'RELPAGE'  => $this->PathToPriorPage(2) );

                    foreach ( $_arr_Add_Replace as $key => $value ) {
                        $__template_Str = str_replace('%'.$key.'%', $value, $__template_Str);
                    }
                }

                if ( $old['id'] != $_complete_groupInfo['id'] ) {
                    $firstelement   = $this->template[1]->fillTemplate($subPiece['firstelement'], false, array_merge(Array('LIST_INDEX' => $listindex), $_complete_groupInfo));
                    $singleelement  = $this->template[1]->fillTemplate($subPiece['singleelement'], false, array_merge(Array('LIST_INDEX' => $listindex), $old));

					$__template_Str = str_replace('%ID%', $old['id'], $__template_Str);
                    $__template_Str = str_replace('%ID2%', $_complete_groupInfo['id'], $__template_Str);
                    $__template_Str = preg_replace('/\%FIRSTELEMENT\%/', $firstelement, $__template_Str);
                    $listindex++;
                    $__template_Str = str_replace('%SUBELEMENTS%', $singleelement, $__template_Str);
					$listindex++;
                } else {
                    $firstelement  = $this->template[1]->fillTemplate($subPiece['firstelement'], false, array_merge(Array('LIST_INDEX' => $listindex), $_complete_groupInfo));

					$__template_Str = str_replace('%ID2%', $old['id'], $__template_Str);
                    $__template_Str = preg_replace('/\%FIRSTELEMENT\%<\/a>(.*)' . $this->template[1]->fillTemplate($subPiece['regEx'] , false) . '/', $firstelement . '</a>', $__template_Str);
                    $__template_Str = preg_replace('/<a [^>]+>\%SUBELEMENTS\%(.*)<\/a>/', '', $__template_Str);
                    $listindex++;
                }

                $result = $__template_Str . $result;

                return $this->template[1]->render($result, false);
            }

            if ( $recursion == 0 && $_thisRow == 'successor_id_fk' ) {
                $_arr_Add_Replace = Array( 'SELECTOR' => 'read_group',
                                           'RELPAGE'  => $this->PathToPriorPage(2) );
            } else {
                $_arr_Add_Replace = Array( 'SELECTOR' => 'read_category',
                                           'RELPAGE'  => $this->PathToPriorPage(1) );
            }

            foreach ( $_arr_Add_Replace as $key => $value ) {
                $__template_Str = str_replace('%'.$key.'%', $value, $__template_Str);
            }

            $singleelement = $this->template[1]->fillTemplate($subPiece['singleelement'], false, array_merge(Array('LIST_INDEX' => $listindex), $_complete_groupInfo));

            $__template_Str = str_replace('%ID%', $_complete_groupInfo['id'], $__template_Str);
            $__template_Str = str_replace('%SUBELEMENTS%', $singleelement, $__template_Str);
            $listindex++;

			$result = str_replace('%FIRSTELEMENT%', '', $__template_Str) . $result;
            $result = $this->writePathOfElement($mysql_row[$__takeThisNext[$_thisRow]], $_html_href, $recursion + $listindex - 1) . $result;

            return $this->template[1]->render($result, false);
        }
        // ---------------------------------------------------------------------------

		// ===========================================================================
		// ===========================================================================


		// ===========================================================================
		// ===========================================================================

		// ---------------------------------------------------------------------------
        /**
			* procedure getHTML4StyleHeader()
			*
			* This function creates the string for js/css include in the header
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param file: string
			* @return string
			*/
		function getHTML4StyleHeader($file)
        {
            $pathinfo = pathinfo($file);

            switch ( strtolower($pathinfo['extension']) ) {
                case 'js':
                    return '<script src="'.$file.'" type="text/javascript"></script>' . "\n";
                    break;

                case 'css':
                    return '<link rel="stylesheet" type="text/css" href="'.$file.'" />' . "\n";
                    break;

                default:
                    return null;
                    break;
            }
        }
        // ---------------------------------------------------------------------------


		// ---------------------------------------------------------------------------
        /**
			* procedure get_DynPG_Subgroups_Of()
			*
			* This function returns an array of all subgroups of a group.
			* If $max_depth is boolean false, then a l l subgroups will be
			* returned, otherwise only the next $max_depth depths.
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 29.02.2008
			* @param $group_id: integer
			* @param $max_depth: boolean/integer
			* @return array
			*/
		function get_DynPG_Subgroups_Of($group_id = null, $max_depth = false)
        {
            if ($max_depth === 0)
            	return Array();

			if ($group_id == null) {
				$group_id = $this->IdxSelector;
            }

			$groups = Array();
			$result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk`='{$group_id}'");
			while ($row = mysql_fetch_array($result)) {
				array_push($groups, $row["successor_id_fk"]);
				if ($row["successor_id_fk"] != null)
					$groups = array_merge(
						$groups,
						$this->get_DynPG_Subgroups_Of($row["successor_id_fk"], $max_depth === false? false: $max_depth - 1)
					);
			}
			return $groups;
        }
        // ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
        /**
			* procedure get_DynPG_Subgroups_Of()
			*
			* This function returns an array of all parent groups of a group
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 20.05.2008
			* @param $group_id: integer
			* @return array
			*/
			function __init_DynPG_treestruct_Table_Content() {
				// save treestruct inside an array to enhance speed for
	            // method "get_DynPG_allParents_Of"
	            $this->__treestruct_Table_Content = Array();
				$result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE 1");
	        	while($row = mysql_fetch_assoc($result)) {
					$this->__treestruct_Table_Content []= $row;
	        	}
			}

		function get_DynPG_allParents_Of($group_id = null) {
            if (is_null($group_id))
                return Array();

            $__takeThisNext = Array('element_id_fk' => 'root_id_fk', 'successor_id_fk' => 'element_id_fk');
			$_thisRow 		= '';
			$fetchRow 		= Array();

			foreach ($this->__treestruct_Table_Content as $row) {
            	if ($row['element_id_fk'] == $group_id) {
            		$_thisRow = 'element_id_fk';
            		$fetchRow = $row;
            		break;
            	}
            	if ($row['successor_id_fk'] == $group_id) {
            		$_thisRow = 'successor_id_fk';
            		$fetchRow = $row;
            		break;
            	}
            }

            if ($_thisRow == '')
            	return Array();

            $found = Array();

            if (!is_null($_thisRow['root_id_fk'])) {
                $found = $this->get_DynPG_allParents_Of($fetchRow[$__takeThisNext[$_thisRow]]);
            }

            if ( !is_null($fetchRow[$__takeThisNext[$_thisRow]]) ) {
                $found[] = $fetchRow[$__takeThisNext[$_thisRow]];
            }

            return $found;
        }
        // ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
			* procedure Write_CSS_JS_Header()
			*
			* This function writes the js/css include into the header
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [take_external: boolean, _vertical_Menu_Css: boolean]
			* @return -
			*/
		function Write_CSS_JS_Header($take_external = FALSE, $_vertical_Menu_Css = FALSE)
		{
			$_css_root = ( $take_external && !empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) )
                         ? $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]
                         : $this->PathToRoot;

            if ( !$_vertical_Menu_Css ) {
                echo '<script src="'.$_css_root.'js/jquery.js" type="text/javascript"></script>';
                echo '<script src="'.$_css_root.'js/swfobject.js" type="text/javascript"></script>';
                echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$_css_root."css/config_general.css\" />\n";

				if (file_exists(dirname(__FILE__) . '/handlevotes.php'))
					echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$_css_root."css/config_votes.css\" />\n";

				if (file_exists(dirname(__FILE__) . '/handleforum.php'))
					echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$_css_root."css/config_forum.css\" />\n";

                foreach ( $this->_PlugIn as $name => $data ) {
                    @asort($data['html4styles']);
                    foreach ( $data['html4styles'] as $file ) {

        			     echo $this->getHTML4StyleHeader($_css_root . 'plugins/' . $data['realname'] . '/styles/' . $file);

        			}
        		}

        		echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$_css_root."css/config_editor.css\" />\n";

    			echo '<script src="'.$_css_root.'js/forum.js" type="text/javascript"></script>';
            }

            if ( $_vertical_Menu_Css ) {
                echo "\n".'<script src="'.$_css_root.'tpl/'.$this->_VM_Template.'/js/scripts.js'.'" type="text/javascript"></script>';
                echo "\n<link rel=\"stylesheet\" type=\"text/css\" href=\"".$_css_root."tpl/".$this->_VM_Template."/css/style.css\" />\n";
            }
		}
		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		/**
		* function Formulars_Submit_Page_Url()
		*
		*/
		function Formulars_Submit_Page_Url() {
			return 'formulars_check.php';
		}

		/**
		* function Formulars_Posted_Data_Html()
		*
		*/
		function Formulars_Posted_Data_Html() {
			if (empty($_SESSION['FORM_DATA']))
				return '';

			$html = '';

			foreach ($_SESSION['FORM_DATA'] as $name => $value) {
				$name  = htmlentities($name);
				$value = htmlentities($value);
				$html .= "<input type=\"hidden\" name=\"{$name}\" value=\"{$value}\" />\n";
			}

			return $html;
		}

		/**
		* function Formulars_Add_Step_To_Workflow_Html($processpage, $processtype)
		*
		* @param $processpage: page to refer after submit
		* @param $processtype: type of refenciation: no = embedded (include $processpage),
		* yes = output $processpage
		*
		*/
		function Formulars_Add_Step_To_Workflow_Html($processpage, $processtype = 'no') {
			if (! file_exists(dirname(__FILE__) . '/' . $processpage)) {
				trigger_error("Specified process page &gt;{$processpage}&lt; does not exist!", E_USER_ERROR);
				return false;
			}

			$html  = "<input type=\"hidden\" name=\"processpage\" value=\"{$processpage}\" />\n";
			$html .= "<input type=\"hidden\" name=\"processtype\" value=\"{$processtype}\" />\n";

			return $html;
		}

		/**
		* function Formulars_Posted_Data_Cleared()
		*
		*/
		function Formulars_Posted_Data_Cleared() {
			if (empty($_SESSION['FORM_DATA']))
				return Array();

			$data = Array();

			foreach ($_SESSION['FORM_DATA'] as $name => $value) {
				if ( preg_match('/F[0-9]+_(\w+)-[^$]*/', $name) ) {
            		$name = preg_replace('/F[0-9]+_(\w+)-[^$]*/', '\1', $name);
            		$data[$name] = $value;
            		continue;
            	}
				if ( preg_match('/([^\-])-(\w+)([-|\/\w]+)/', $name) ) {
            		$name = preg_replace('/([^\-])-(\w+)([-|\/\w]+)/', '\1', $name);
            		$data[$name] = $value;
            		continue;
            	}
			}

			return $data;
		}

		// ---------------------------------------------------------------------------

		// ---------------------------------------------------------------------------
		//	ALL GROUPS
		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_AG_Anytime()
			*
			* This function sets the param if a group list should be shown in every case
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AG_Anytime($bool = FALSE, $force = FALSE)	 { $this->_AG_Anytime = $bool; $this->_AG_ForceAnyTime = $force; }

		/**
			* procedure SetParam_AG_Maxview()
			*
			* This function sets the param for how many groups are shown per page in the group list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_AG_Maxview($int = 0)	 	 { $this->_AG_Maxview = $int; }

		/**
			* procedure SetParam_AG_ForceNav()
			*
			* This function sets the param if the group list should have a navigation
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AG_ForceNav($bool = FALSE) { $this->_AG_ForceNav = $bool; }

		/**
			* procedure SetParam_AG_Order()
			*
			* This function sets the param for the arrangement of the groups in the group-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AG_Order($array = Array()) { $this->_AG_Order = $array; }

		/**
			* procedure SetParam_AG_Sort()
			*
			* This function sets the param for the kind of arrangement of the groups in the group-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AG_Sort($array = Array()) { $this->_AG_Sort = $array; }

		/**
			* procedure Write_AllGroups()
			*
			* This function writes the view of 'group list'
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return string
			*/
		function Write_AllGroups()
		{
			if ( $this->PageSelector!="GROUPS" && !$this->_AG_Anytime ) {
			 return '';
			}

            if ( $this->PageSelector!="HOME" && $this->PageSelector!="GROUPS" && $this->_AG_Anytime ) {
			 return '';
			}

            // $this->Private_ReconnectMySQL();

            // check if this group has an ref id as article
            $selector_group = mysql_fetch_assoc(mysql_query("SELECT `REFID` FROM `dynpg_cms_groups` WHERE `id` = {$this->IdxSelector}"));

            if (! is_null($selector_group['REFID']) && !$this->_AG_ForceAnyTime ) {
                // call detail view

                // set refid as article
                $this->SetParam_A_Anytime(true);
                $this->SetParam_A_Article($selector_group['REFID']);

                $this->Write_Article();

                return '';
            }

            //
            // modified: 2009/01/08 by Daniel Schliebner
            //
            // In order to lock the current selector,
            // we use the DPGcommunity plugin engine.
            // These holds user data and information
            // about the user stock that is allowed
            // to enter the current IdxSelector.
            //
            // At first we check if the plugin is available.
            // If it is, we call the routines that lock the
            // group. Every content that is shown in this case
            // comes out of templates from the DPGcommunity plugin.
            //
            if ($this->plugInExists('DPGcommunity')) {
            	$dpgcommunity = $this->call_PlugIn('DPGcommunity');
            	$lock = $dpgcommunity->dpglock_verify(
					true,
					array_merge(
						Array($this->IdxSelector),
						$this->get_DynPG_allParents_Of($this->IdxSelector)
					)
				);
            	if ($lock !== C_COMMUNITY_NOLOCK && $lock !== C_COMMUNITY_FREE) {
            		print $lock;
            		return $lock;
            	}
            }
			//
            // Now we continue the default routines to show the
            // frontend views. That means, that the plugin has not
            // been installed or the user is not allowed to view this
            // IdxSelector.

            if ( !empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
                $_general_image_url = $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"];
            } else {
                $_general_image_url = $this->PathToRoot . FORMS_IMAGES_DESTINATIONURL_ROOT;
            }

            $public2private = Array( 'NAME' => '`NAME`',

                                     'TEXT' => '`SHORTTEXT`',

                                     'IMAGE' => '`IMAGE`',

                                     'ALIGN' => '`ALIGN`',

                                     'DATE' => '`CREATEDATE`',

                                     'SHOWVISITS' => '`SHOWVISITS`',

                                     'INDEX' => '`INDEX`',

                                     'ID' => '`ID`'
                                    );

            $order = Array();

            foreach ( $this->_AG_Order as $value ) {
                $order[] = empty($public2private[strtoupper($value)]) ? '`NAME`' : $public2private[strtoupper($value)];
            }

            $sort = $this->_AG_Sort;

            if ( count($sort) < count($order) ) {
                for ( $i = 0; $i < count($order) - count($sort); $i++ ) {
                    $sort[] = 'ASC';
                }
            }

            if ( count($sort) > count($order) ) {
                for ( $i = 0; $i < count($sort) - count($order); $i++ ) {
                    $order[] = '`NAME`';
                }
            }


			// get data for currently selected group

			$CURRENT = Array(
				'GROUP_ID' => '',
				'GROUP_NAME' => '',
				'GROUP_SHORTTEXT' => '',
				'GROUP_IMAGEID' => '',
				'GROUP_IMAGEALIGN' => '',
				'GROUP_REFID' => '',
				'GROUP_IMAGE_URL' => '',
				'GROUP_IMAGE_NAME' => '',
				'GROUP_IMAGE_DESCR' => '',
				'GROUP_IMAGE_ALIGN' => ''
			);

			if ($this->IdxSelector != 'NULL') {
				$CURRENT = mysql_fetch_assoc(
					mysql_query(
						"SELECT DISTINCT
							A.`id` AS `GROUP_ID`,
							A.`NAME` AS `GROUP_NAME`,
							A.`SHORTTEXT` AS `GROUP_SHORTTEXT`,
							A.`IMAGE` AS `GROUP_IMAGEID`,
							A.`ALIGN` AS `GROUP_IMAGEALIGN`,
							A.`ALIGN` AS `GROUP_IMAGE_ALIGN`,
							A.`REFID` AS `GROUP_REFID`,
							B.`NAME` AS `GROUP_IMAGE_NAME`,
							B.`URL` AS `GROUP_IMAGE_URL`,
							B.`DESCR` AS `GROUP_IMAGE_DESCR`
						FROM
							`dynpg_cms_groups` AS A LEFT JOIN `dynpg_cms_images` AS B
							ON A.`IMAGE` = B.`id`
						WHERE
							A.`id` = {$this->IdxSelector}"
					)
				);

                $CURRENT['GROUP_SHORTTEXT_NOHTML'] = strip_tags($CURRENT['GROUP_SHORTTEXT']);

				if ((integer)$CURRENT['GROUP_IMAGEID'] > 0) {
	                $CURRENT['GROUP_IMAGE_URL']   = $_general_image_url . $CURRENT['GROUP_IMAGE_URL'];
	                $CURRENT['GROUP_IMAGE_NAME']  = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_NAME']));
	                $CURRENT['GROUP_IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_DESCR']));
	                $CURRENT['GROUP_IMAGE_ALIGN'] = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_ALIGN']));
	            }
			}


            // read subgroups for current group

			$SQL = "SELECT DISTINCT
                      A.*,
                      B.*
                    FROM
                      `dynpg_cms_group_treestruct` AS A
                      INNER JOIN `dynpg_cms_groups` AS B
                      ON A.`".( $this->IdxSelector == 'NULL' ? 'element_id_fk' : 'successor_id_fk' )."` = B.`id`
                    WHERE
                      A.".( $this->IdxSelector == 'NULL' ? '`root_id_fk` IS' : '`element_id_fk` = ' )." ".$this->IdxSelector."
					  AND B.`PUBLIC` != '2'
                    GROUP BY
                        B.`id`
                    ORDER BY
                      " . implode(', ' , array_map(create_function('$a, $b', 'return "B.$a " . strtoupper($b);') , $order, $sort));

			$RES = mysql_query($SQL);

			if ( !$this->_AG_Maxview ) {
                $this->_AG_Maxview = $GLOBALS["cfg"]["config_AllGroups_Limit"];
            }

            $nav_query = $this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("page=(\w+)"));

            if ( !empty($nav_query) ) {
                $nav_query .= '&';
            }

			$Navigator = $this->Private_GetSiteString($this->PathToCurrPage . "?" . $nav_query
														, mysql_num_rows($RES)
														, $this->_AG_Maxview
														, $this->_AG_ForceNav);

			if( mysql_num_rows($RES) > $this->_AG_Maxview ){
				$this->template[1]->addVar('PAGES_NAVIGATION', $Navigator );
			}
			else {
				$this->template[1]->addVar('PAGES_NAVIGATION', '' );
			}

			$pathOfElement = $this->writePathOfElement($this->IdxSelector, '<a href="'.$_SERVER['PHP_SELF']."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("&page=(\w+)", dynpg_insert_urlheader("read_category=(\w+)")), FALSE).'read_category=%ID%&page=0', FALSE).'">');

            $this->template[1]->addVar('ROOT_NAVIGATION', $pathOfElement );

            $count        = 1;
            $listIndex    = 0;
			$listing      = '';
            $template_row = $this->template[1]->getSubTemplate('listing', dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/groups.tpl');

            while ( $ROW = mysql_fetch_array($RES) ) {

                if (! ( $count > ( $this->CurrentPage * $this->_AG_Maxview ) && $count <= ( ($this->CurrentPage + 1) * $this->_AG_Maxview ) ) ) {
                    $count++;
                    continue;
                }

                $listIndex++;

                // $this->Private_ReconnectMySQL();

                if ( $this->IdxSelector == 'NULL' ) {
                    $__has_Successors = !is_null($ROW['successor_id_fk']);
                } else {
                    $offset = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = '".$ROW['successor_id_fk']."'");
                    $__has_Successors = mysql_num_rows($offset) > 0;
                }

                $this_image_str = Array();

                if ( $ROW['IMAGE'] != -1 ) {
                    $IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id` = '$ROW[IMAGE]'"));

                    $this_image_str['IMAGE_URL']   = $_general_image_url.$IMG['URL'];
                    $this_image_str['IMAGE_NAME']  = dynpg_htmlentities(stripslashes($IMG['NAME']));
                    $this_image_str['IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($IMG['DESCR']));
                }

                $ROW = array_map(create_function('$val', 'return dynpg_htmlentities(stripslashes($val));'), $ROW);

                $ROW['SHORTTEXT'] = PerformTextFormat(stripslashes($ROW['SHORTTEXT']));
                $ROW['SHORTTEXT'] = ReplaceDummyCode($ROW['SHORTTEXT'], FALSE, 0 );
                $ROW['SHORTTEXT'] = dynpg_htmlentities($ROW['SHORTTEXT']);

                $ROW['CREATEDATE'] = date($this->language[1]->str['lang_general_groups_date_format'], $ROW['CREATEDATE']);

                if ( $count > ( $this->CurrentPage * $this->_AG_Maxview ) && $count <= ( ($this->CurrentPage + 1) * $this->_AG_Maxview ) ) {

                    $listing .= $this->template[1]->fillTemplate(

                                $template_row ,

                                false ,

                                array_merge (

                                    $ROW ,

                                    $this_image_str,

                                    Array (

                                      'LIST_IMAGE_ALIGN' => $ROW['ALIGN'],

                                      'LIST_HAS_IMAGE' => ( $ROW['IMAGE'] == -1 ) ? 'False' : 'True',

                                      'LIST_SHOW_VISTS' => ( $ROW['SHOWVISITS'] == 'TRUE' ) ? init_counter("group>".$ROW['id'], true, "RETURNTEXT") : '',

                                      'LIST_INDEX' => $listIndex,

                                      'LIST_REFER_TO' => ($__has_Successors ? $_SERVER['PHP_SELF'] : $this->PathToNextPage)."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_category=(\w+)", dynpg_insert_urlheader("&page=(\w+)"), FALSE).($__has_Successors ? 'read_category=' : 'read_group=').$ROW['id']."&t=".urlencode($ROW['NAME'])."&page=0")

                                    )

                                ) );

                }

				$count++;
			}

			$template_str = $this->template[1]->replaceSubTemplate(
                                'listing',

                                $listing,

                                dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/groups.tpl'
                            );

            $this->template[1]->addVar('LIST_INDEX', $listIndex );

            $returntext = $this->template[1]->fillTemplate(
				$this->template[1]->fillTemplate(
					$template_str,
					false,
					$CURRENT
				),
				false
			);

			@mysql_free_result($RES);

			unset($Navigator);
			unset($count);
			unset($td);

			$returntext = $this->template[1]->render($returntext, false);

			echo $returntext;

			return $returntext;
		}
		// ---------------------------------------------------------------------------
		// END ALL GROUPS
		// ---------------------------------------------------------------------------


		// ---------------------------------------------------------------------------
		//	ALL ARTICLES
		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_AA_Anytime()
			*
			* This function sets the param if a article list should be shown in every case
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean, boolean]
			* @return -
			*/
		function SetParam_AA_Anytime($bool = FALSE, $force = FALSE)	 { $this->_AA_Anytime = $bool; $this->_AA_ForceAnyTime = $force; }

		/**
			* procedure SetParam_AA_Maxview()
			*
			* This function sets the param for how many articles are shown per page in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_AA_Maxview($int = 0)		 { $this->_AA_Maxview = $int; }

		/**
			* procedure SetParam_AA_ForceNav()
			*
			* This function sets the param if the article list should have a navigation
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_ForceNav($bool = FALSE) { $this->_AA_ForceNav = $bool; }

		/**
			* procedure SetParam_AA_Group()
			*
			* This function sets the param of the group, whose article should be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_AA_Group($string = "") 	 { $this->_AA_SingleGroup = $string; }

		/**
			* procedure SetParam_AA_Groups()
			*
			* This function sets the param of the groups, whose article should be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [array, array]
			* @return -
			*/
		function SetParam_AA_Groups($include = Array(), $exclude = Array() ) { $this->_AA_IncludeGroups = $include; $this->_AA_ExcludeGroups = $exclude; }

		/**
			* procedure SetParam_AA_ExcludeArticle()
			*
			* This function sets the param of the articles, which should not be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 27.04.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AA_ExcludeArticles($array = Array()) {  $this->_AA_ExcludeArticles = $array;  }

		/**
			* procedure SetParam_AA_IncludeArticles()
			*
			* This function sets the param of the articles, which should be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 29.01.2008
			* @param [array]
			* @return -
			*/
		function SetParam_AA_IncludeArticles($array = Array()) {  $this->_AA_IncludeArticles = $array;  }

	   	/**
			* procedure SetParam_AA_OneArticle()
			*
			* This function sets the param for a single article which should be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_AA_OneArticle($int = 0) 	 { $this->_AA_SingleArticle = $int; }

		/**
			* procedure SetParam_AA_CategoryNavigation()
			*
			* This function sets the param if a navigation should be shown in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_CategoryNavigation($bool = FALSE) { $this->_AA_CatNav = $bool; }

        /**
            * procedure SetParam_AA_PrintNavigation()
            *
            * This function sets the param if an article-list should have a link to print the text
            *
            * @package DynPG Frontend Engine
            * @author Christoph Wuersch <info@chriswuersch.com>
            * @version 1.0
            * @access private
            * @copyright Christoph Wuersch, 07.10.2009
            * @param [boolean]
            * @return -
            */
        function SetParam_AA_PrintNavigation($bool = FALSE) { $this->_AA_PrintNav = $bool; }

		/**
			* procedure SetParam_AA_ForwardText()
			*
			* This function sets the param for the text of the link to the detail-view of an article
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_AA_ForwardText($string = "") { $this->_AA_FwdText = $string; }

		/**
			* procedure SetParam_AA_SingleCss()
			*
			* This function sets the param for a special css in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_AA_SingleCss($int = 0) { $this->_AA_SingleCss = $int; }

		/**
			* procedure SetParam_AA_Order()
			*
			* This function sets the param for the arrangement of the groups in the article-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AA_Order($array = Array()) { $this->_AA_Order = $array; }

		/**
			* procedure SetParam_AA_Sort()
			*
			* This function sets the param for the kind of arrangement of the articles in the article-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AA_Sort($array = Array()) { $this->_AA_Sort = $array; }

		/**
			* procedure SetParam_AA_IgnoreSeperator()
			*
			* This function sets the param if the seperator should be ignored in the article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_IgnoreSeperator($bool = TRUE) {  $this->_AA_IgnoreSeperator = $bool; }

		/**
			* procedure SetParam_AA_fullLoadText()
			*
			* This function sets the param if the detail-text of an article should be loaded
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_fullLoadText($bool = FALSE) {  $this->_AA_loadText = $bool; }

		/**
			* procedure SetParam_AA_seperateHome()
			*
			* This function sets the param if the articles should be separated for home-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_seperateHome($bool = TRUE) { $this->_AA_home = $bool; }

		/**
			* procedure SetParam_AA_ExcludeArticle()
			*
			* This function implements a set of associations to a set of specified association names.
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 27.04.2007
			* @param [array]
			* @return -
			*/
		function SetParam_AA_Associations($names = array()) {
			// includes all id's, that correspond to the current
			// association
			$assocIds = Array();

			// show list every time
			$this->SetParam_AA_Anytime(true, true);

			// set explicit addition of articles
			$this->SetParam_AA_Groups(Array(null));
			$this->SetParam_AA_IncludeArticles(Array());

			// check if association mode can be enabled
			if (!count($names)) {
				$this->SetParam_AA_IncludeArticles(Array(-1));
				return;
			}

			if (empty($this->IdxSelector) || $this->IdxSelector == 'NULL') {
				$this->SetParam_AA_IncludeArticles(Array(-1));
				return;
			}

			// current view: group selected?
			$cV_groups = !($this->PageSelector == 'ARTICLES_EX');

			// indicates, if any articles was found
			$emptyList = true;

			// new names array, that contains all associations, which not
			// matched
			$notMatched = Array();

			//
			// match all associations to the currently selected group/article
			//
			foreach ($names as $assoc) {
				$matched = false;

				// try to get all associations to the current group or article
				// and add all matched associated articles to the $assocIds array
				$res = mysql_query(
					"SELECT DISTINCT " .
					"	* " .
					"FROM " .
					"	`" . ($cV_groups? "dynpg_cms_groups_assoc": "dynpg_cms_articles_assoc") . "` " .
					"WHERE " .
					"	`" . ($cV_groups? "group_id_fk": "article_id_fk") . "` = {$this->IdxSelector} " .
					"	AND UCASE(`title`) = '" . strtoupper($assoc) . "' "
				);
				if (mysql_num_rows($res)) {
					// we found associations to the current article or group
					$emptyList = false;
					$matched   = true;
					while ($row = mysql_fetch_assoc($res)) {
						$assocIds[] = $row[($cV_groups? '': 'assoc_') . 'article_id_fk'];
					}
				} elseif (!$cV_groups) {
					// when no associations with the current name are associated
					// to the current article, then load the associations to
					// his parent group, if existing.
					$article = mysql_fetch_assoc(
						mysql_query(
							"SELECT `GROUP` FROM `dynpg_cms_article` WHERE `id` = {$this->IdxSelector}"
						)
					);
					$res = mysql_query(
						"SELECT DISTINCT " .
						"	* " .
						"FROM " .
						"	`dynpg_cms_groups_assoc` " .
						"WHERE " .
						"	`group_id_fk` = {$article['GROUP']} " .
						"	AND UCASE(`title`) = '" . strtoupper($assoc) . "' "
					);
					if (mysql_num_rows($res)) {
						$emptyList = false;
						$matched   = true;
						while ($row = mysql_fetch_assoc($res)) {
							$assocIds[] = $row['article_id_fk'];
						}
					}
				}

				if (!$matched)
					$notMatched []= $assoc;
			}


			//
			// match all associations for subgroups of the current selected group
			//
			foreach ($notMatched as $assoc) {
				// try to get all associations to the current group or article
				// and add all matched associated articles to the $assocIds array
				$idx = $this->IdxSelector;
				if (!$cV_groups) {
					// when no associations with the current name are associated
					// to the current article, then load the associations to
					// his parent group, if existing.
					$article = mysql_fetch_assoc(
						mysql_query(
							"SELECT `GROUP` FROM `dynpg_cms_article` WHERE `id` = {$this->IdxSelector}"
						)
					);
					$idx = $article['GROUP'];
				}
				// get all subgroups of the current group
				$subgroups = $this->get_DynPG_allParents_Of($idx);
				$sub_assocIds = Array();
				foreach ($subgroups as $subgroup) {
					$res = mysql_query(
						"SELECT DISTINCT " .
						"	* " .
						"FROM " .
						"	`dynpg_cms_groups_assoc` " .
						"WHERE " .
						"	`subgroups` = 'TRUE' " .
						"	AND `group_id_fk` = {$subgroup} " .
						"	AND UCASE(`title`) = '" . strtoupper($assoc) . "' "
					);
					if (mysql_num_rows($res)) {
						$emptyList = false;
						$sub_assocIds = Array();
						while ($row = mysql_fetch_assoc($res)) {
							if (!in_array($row['article_id_fk'], $assocIds))
								$sub_assocIds []= $row['article_id_fk'];
						}
					}
				}
				if (count($sub_assocIds))
					$assocIds = array_merge($assocIds, $sub_assocIds);
			}


			// return list of articles
			if (!$emptyList) {
				// set current list entries
				$this->SetParam_AA_IncludeArticles($assocIds);
			} else {
				// set list of included articles to Array(-1)
				// in order to show an empty list of articles
				// (otherwise the SQL query in Write_AllArticles
				// will show all articles)
				$this->SetParam_AA_IncludeArticles(Array(-1));
			}
		}

		/**
			* procedure SetParam_AA_IgnoreLimitation()
			*
			* This function sets specifies, wheather an article is shown, even
			* if his limitations forbid that.
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 26.09.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_AA_IgnoreLimitation($bool = TRUE) {  $this->_AA_IgnoreLimitation = $bool;  }

		/**
			* procedure SetParam_AA_HitlistTimeSpan()
			*
			* This function sets the timespan (in days), in which a hitlist will
			* be produced. This is only relevant, if you order by "VISITS", using
			* "SetParam_AA_Order".
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 16.05.2008
			* @param [integer]
			* @return -
			*/
		function SetParam_AA_HitlistTimeSpan($timeSpan = 0) {  $this->_AA_HitlistTimeSpan = $timeSpan * 24 * 60 * 60;  }

		/**
			* procedure SetParam_AA_HitlistTimeSpan()
			*
			* This function sets the timespan (in days), in which a hitlist will
			* be produced. This is only relevant, if you order by "VISITS", using
			* "SetParam_AA_Order".
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 16.05.2008
			* @param [integer]
			* @return -
			*/
		function SetParam_AA_TextGrouping($bool = false) {  $this->_AA_TextGrouping = $bool;  }

		/**
			* procedure Write_AllArticles()
			*
			* This function writes the view of 'article list'
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return string
			*/
		function Write_AllArticles()
		{
			if ( ( $this->PageSelector != "ARTICLES" && !$this->_AA_Anytime || $this->PageSelector=="ARTICLES_EX" ) &&

                 !isset($_POST['DynPG_General_Search_Query'])                                                       &&

                 !$this->_AA_ForceAnyTime ) {

                  // this view is not active or (in connection to it's parameters) not allowed

                  return '';

            }

            // save selector value
			$tmpIdxSelector = $this->IdxSelector;

            if ( $this->_AA_Anytime && !empty($this->_AA_SingleGroup) ) {
                $_ = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_groups` WHERE UCASE(`NAME`)='".strtoupper($this->_AA_SingleGroup)."'"));
                $this->IdxSelector = $_['id'];
            }

            // check if this group has an ref id as article
            $selector_group = mysql_fetch_assoc(mysql_query("SELECT `REFID` FROM `dynpg_cms_groups` WHERE `id` = {$this->IdxSelector}"));

            if ( !is_null($selector_group['REFID']) && !$this->_AA_ForceAnyTime ) {
                // call detail view

                // set refid as article
                $_ = $this->_A_Anytime;
				$this->SetParam_A_Anytime(true);
                $this->SetParam_A_Article($selector_group['REFID']);
                $this->IsGroupContent = TRUE;

                $this->Write_Article();

                $this->SetParam_A_Anytime($_);
                $this->IsGroupContent = FALSE;

                return '';
            }


            //
            // modified: 2009/01/08 by Daniel Schliebner
            //
            // In order to lock the current selector,
            // we use the DPGcommunity plugin engine.
            // These holds user data and information
            // about the user stock that is allowed
            // to enter the current IdxSelector.
            //
            // At first we check if the plugin is available.
            // If it is, we call the routines that lock the
            // group. Every content that is shown in this case
            // comes out of templates from the DPGcommunity plugin.
            //
            if ($this->plugInExists('DPGcommunity')) {
            	$dpgcommunity = $this->call_PlugIn('DPGcommunity');

            	if ($dpgcommunity->parameters['enable_locking_feature']) {
					// the following code will inherit the lock for all
	            	// subgroups as well
					if ($this->_AA_Anytime || !empty($this->_AA_IncludeGroups) || !empty($this->_AA_ExcludeGroups))
						$array = $this->_AA_IncludeGroups;
					else
						$array = Array($this->IdxSelector);

					$groups = Array();
					foreach ($array as $group)
						$groups = array_merge($groups, Array($group), $this->get_DynPG_allParents_Of($group));

	            	// we can check the lock now
					$lock = $dpgcommunity->dpglock_verify(
						true,
						$groups
					);
	            	if ($lock !== C_COMMUNITY_NOLOCK && $lock !== C_COMMUNITY_FREE) {
	            		print $lock;
	            		return $lock;
	            	}
	            	$lock = $dpgcommunity->dpglock_verify(
						false,
						$this->_AA_IncludeArticles
					);
	            	if ($lock !== C_COMMUNITY_NOLOCK && $lock !== C_COMMUNITY_FREE) {
	            		print $lock;
	            		return $lock;
	            	}
	            }
            }
			//
            // Now we continue the default routines to show the
            // frontend views. That means, that the plugin has not
            // been installed or the user is not allowed to view this
            // IdxSelector.


			// initialisze counter
            @init_counter("group>".$this->IdxSelector, FALSE, "RETURNTEXT");


            // reconnect to MySQL because function init_counter terminates it
            // $this->Private_ReconnectMySQL();

			if ( $this->_AA_Maxview > 0 ) {
                $_private_AA_Maxview = $this->_AA_Maxview;
            } else {
                $_private_AA_Maxview = $GLOBALS["cfg"]["config_AllArticles_Limit"];
            }

            if ( !empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
                $_general_image_url = $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"];
            } else {
                $_general_image_url = $this->PathToRoot . FORMS_IMAGES_DESTINATIONURL_ROOT;
            }

            $this->template[1]->addVar('FWD_TEXT', $this->_AA_FwdText );

            $include_groups = '';
            foreach ( $this->_AA_IncludeGroups as $grp_id ) {
                if (!empty($grp_id))
					$include_groups .= 'A.`id` = '.$grp_id.' OR ';
            }

            if ( !empty($include_groups) ) {
                $include_groups = substr($include_groups, 0, -4);
                $include_groups = 'AND (' . $include_groups . ')';
            }

            $exclude_groups = '';
            foreach ( $this->_AA_ExcludeGroups as $grp_id ) {
                if (!empty($grp_id))
					$exclude_groups .= 'A.`id` = '.$grp_id.' OR ';
            }

            if ( !empty($exclude_groups) ) {
                $exclude_groups = substr($exclude_groups, 0, -4);
                $exclude_groups = 'AND NOT (' . $exclude_groups . ')';
            }

            $exclude_articles = '';
            foreach ( $this->_AA_ExcludeArticles as $art_id ) {
                if (!empty($art_id))
					$exclude_articles .= 'B.`id` = '.$art_id.' OR ';
            }
            if ( !empty($exclude_articles) ) {
                $exclude_articles = substr($exclude_articles, 0, -4);
                $exclude_articles = 'AND NOT (' . $exclude_articles . ')';
            }

            $include_articles = '';
            foreach ( $this->_AA_IncludeArticles as $art_id ) {
                if (!empty($art_id))
					$include_articles .= 'B.`id` = '.$art_id.' OR ';
            }
            if ( !empty($include_articles) ) {
                $include_articles = substr($include_articles, 0, -4);
                $include_articles = 'AND (' . $include_articles . ')';
            }

            $public2private = Array(
				'TITLE' => '`TITLE`',
				'LEAD' => '`LEAD`',
				'DATE_TO' => '`DATE_TO`',
				'DATE_FROM' => '`DATE_UP`',
				'TIME_TO' => '`TIME_TO`',
				'TIME_FROM' => '`TIME_UP`',
				'DATE' => '`CREATEDATE`',
				'FIXPOINT' => '`DATEFIX`',
				'SHOWVISITS' => '`SHOWVISITS`',
				'SHOWDATE' => '`SHOWDATE`',
				'SEARCHKEYS' => '`SEARCHKEYS`',
				'INDEX' => '`INDEX`',
				'ID' => '`id`',
				'VISITS' => '`visits`',
				'OWNER' => '`OWNER_NAME`',
				'MODIFIER' => '`MODIFIER_NAME`',
                'CHANGED' => '`CHANGED`'
            );

            $order = Array();

            foreach ( $this->_AA_Order as $value ) {
                $order[] = empty($public2private[strtoupper($value)]) ? '`TITLE`' : $public2private[strtoupper($value)];
            }

            $sort = $this->_AA_Sort;

            if ( count($sort) < count($order) ) {
                for ( $i = 0; $i < count($order) - count($sort); $i++ ) {
                    $sort[] = 'ASC';
                }
            }

            if ( count($sort) > count($order) ) {
                for ( $i = 0; $i < count($sort) - count($order); $i++ ) {
                    $order[] = '`TITLE`';
                }
            }

            if (in_array('VISITS', $this->_AA_Order)) {
				$select  = ", C.`visits` ";
				$from 	 = "(`dynpg_cms_groups` AS A INNER JOIN `dynpg_cms_article` AS B ON ".
						   "B.`GROUP` = A.`id`) INNER JOIN `dynpg_cms_counter` AS C " .
						   "ON C.`section` = CONCAT( 'article>', B.`id`)";
				$hitlist = " AND " . ($this->_AA_HitlistTimeSpan > 0? "B.`CREATEDATE` >= " . (time() - $this->_AA_HitlistTimeSpan): '');
            } else {
            	$select  = "";
            	$from 	 = "`dynpg_cms_groups` AS A INNER JOIN `dynpg_cms_article` AS B ON ".
						   "B.`GROUP` = A.`id`";
				$hitlist = "";
            }

            $from = "(({$from}) LEFT JOIN `dynpg_cms_user` AS Z ON Z.`id` = B.`OWNER`) LEFT JOIN `dynpg_cms_user` AS Y ON Y.`id` = B.`MODIFIER`";

            $order_by = implode(', ' , array_map(create_function('$a, $b', 'return (!strpos($a, "visits")? "B.$a ": "$a") . strtoupper($b);') , $order, $sort));

            $group_by = $this->_AA_TextGrouping? "GROUP BY B.`CONTENT` ASC": "";

            $is_at_home = $this->_AA_home? " AND B.`ISATHOME` = 'TRUE' ": "";

            if ( !$this->_AA_Anytime ) {
                $SQL = "SELECT DISTINCT
							B.*,
							A.`id` as GROUP_ID,
							A.`NAME` as GROUP_NAME,
							A.`SHORTTEXT` AS GROUP_SHORTTEXT,
							A.`IMAGE` AS GROUP_IMAGEID,
        					A.`ALIGN` AS GROUP_IMAGEALIGN,
        					A.`REFID` AS GROUP_REFID,
        					Z.`NAME` AS OWNER_NAME,
        					Y.`NAME` AS MODIFIER_NAME
        					{$select}
						 FROM
							{$from}
						 WHERE
							".(empty($include_groups) && empty($exclude_groups) ? "B.`GROUP`='".$this->IdxSelector."' AND" : "" )."
							1
							{$is_at_home}
							{$include_groups}
                            {$exclude_groups}
							{$exclude_articles}
							{$include_articles}
							{$hitlist}
						 {$group_by}
						 ORDER BY
							{$order_by}";
			} else {
				$SQL = "SELECT DISTINCT
							B.*,
							A.`id` as GROUP_ID,
							A.`NAME` as GROUP_NAME,
							A.`SHORTTEXT` AS GROUP_SHORTTEXT,
							A.`IMAGE` AS GROUP_IMAGEID,
        					A.`ALIGN` AS GROUP_IMAGEALIGN,
        					A.`REFID` AS GROUP_REFID,
        					Z.`NAME` AS OWNER_NAME,
        					Y.`NAME` AS MODIFIER_NAME
        					{$select}
						FROM
							{$from}
						WHERE
							".( empty($include_groups) && empty($exclude_groups) && !empty($this->_AA_SingleGroup) ? "A.`NAME`='".$this->_AA_SingleGroup."' AND" : "" )."
							1
							{$is_at_home}
							{$include_groups}
                            {$exclude_groups}
							{$exclude_articles}
							{$include_articles}
							{$hitlist}
						{$group_by}
						ORDER BY
							{$order_by}";
            }

            if ( !empty($this->_AA_SingleArticle) ) {
                $SQL = "SELECT DISTINCT
            					B.*,
            					A.`id` as GROUP_ID,
            					A.`NAME` as GROUP_NAME,
            					A.`SHORTTEXT` AS GROUP_SHORTTEXT,
            					A.`IMAGE` AS GROUP_IMAGEID,
            					A.`ALIGN` AS GROUP_IMAGEALIGN,
            					A.`REFID` AS GROUP_REFID,
	        					Z.`NAME` AS OWNER_NAME,
	        					Y.`NAME` AS MODIFIER_NAME
            					{$select}
            			FROM
            					((`dynpg_cms_groups` AS A INNER JOIN `dynpg_cms_article` AS B
								ON B.`GROUP` = A.`id`) LEFT JOIN `dynpg_cms_user` AS Z
								ON Z.`id` = B.`OWNER`) LEFT JOIN `dynpg_cms_user` AS Y
								ON Y.`id` = B.`MODIFIER`
            			WHERE
            					B.`id`='".$this->_AA_SingleArticle."'
            			ORDER BY
								{$order_by}";
            }

            if ( !empty($_GET["read_srch"]) ) {
                $_POST['DynPG_General_Search_Query'] = addslashes(urldecode($_GET["read_srch"]));
            }

            if ( !empty($_POST['DynPG_General_Search_Query']) ) {
                $_keyWords = explode(' ', $_POST['DynPG_General_Search_Query']);

                $like    = '';
                $mtch3   = '';
                $NOTlike = '';
                $mtch4   = '';

                foreach ( $_keyWords as $key => $value ) {
                    if ( substr($value, 0, 1) == '-' ) {
                        $NOTlike .= 'ROUND(B.`SEARCHKEYS` LIKE \'%'.substr($value, 1).'%\') + ';
                    } else {
                        $like .= 'ROUND(B.`SEARCHKEYS` LIKE \'%'.$value.'%\') + ';
                    }
                }

                $_POST['DynPG_General_Search_Query'] = preg_replace('/-([^\s]+)/', '', $_POST['DynPG_General_Search_Query']);

                if ( !empty($like) ) {
                    $like  = substr($like, 0, -3);
                    $like  = ', (' . $like . ' )';
                    $like .= ' AS mtch3';
                    $mtch3 = 'OR mtch3 > 0.001';
                }

                if ( !empty($NOTlike) ) {
                    $NOTlike  = substr($NOTlike, 0, -3);
                    $NOTlike  = ', (' . $NOTlike . ' )';
                    $NOTlike .= ' AS mtch4';
                    $mtch4 = 'AND mtch4 = 0.001';
                }

                // prepare query string to be inserted in the mysql-query
				$query = explode(' ', htmlentities($_POST['DynPG_General_Search_Query']));
                $query_string = '';
                $boolean_mode = false;
                foreach ($query as $word) {
                	if (preg_match('/&(\w+);/', $word)) {
						$query_string .= " \"{$word}\"";
						$boolean_mode  = true;
                	} else {
                		$query_string .= " {$word}";
                	}
                }
                $query_string = trim($query_string);

                $SQL = "SELECT DISTINCT
            					B.*,
            					A.`id` as GROUP_ID,
            					A.`NAME` as GROUP_NAME,
            					A.`SHORTTEXT` AS GROUP_SHORTTEXT,
            					A.`IMAGE` AS GROUP_IMAGEID,
            					A.`ALIGN` AS GROUP_IMAGEALIGN,
            					A.`REFID` AS GROUP_REFID,
                                MATCH (`dynpg_cms_articletexts`.`TEXT`) AGAINST ( '" . $query_string . "' " . ($boolean_mode? "IN BOOLEAN MODE": "") . ") AS mtch1,
                                MATCH (B.`LEAD`, B.`SEARCHKEYS`, B.`TITLE`) AGAINST ( '{$_POST['DynPG_General_Search_Query']}' ) AS mtch2,
                                MATCH (B.`LEAD`, B.`SEARCHKEYS`, B.`TITLE`) AGAINST ( '" . $query_string . "' " . ($boolean_mode? "IN BOOLEAN MODE": "") . ") AS mtch4
                                $like
                                $NOTlike
            			 FROM
            					(`dynpg_cms_groups` AS A INNER JOIN `dynpg_cms_article` AS B
								ON B.`GROUP`=A.`id` OR B.`id` = A.`REFID`)
            					LEFT JOIN `dynpg_cms_articletexts`
                                ON B.`CONTENT` = `dynpg_cms_articletexts`.`id`
            			 WHERE
						 		1
						 		{$is_at_home}
                                {$include_groups}
	                            {$exclude_groups}
								{$exclude_articles}
								{$include_articles}
						 {$group_by}
                         HAVING
						 	    mtch1 > 0.001
                                OR mtch2 > 0.001
                                OR mtch4 > 0.001
                                $mtch3
                                $mtch4
            			 ORDER BY
            					".(!empty($mtch3) ? 'mtch3 DESC,' : '')."
                                mtch2 DESC,
                                mtch1 DESC,
                                $order_by";
            }

			// edit mode:
			// is edit_mode enabled for the user?
			if(! empty($_SESSION['NAME']) ) {
				$sql_res = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_user` WHERE `NAME`='{$_SESSION['NAME']}'"));
				$this->template[1]->addVar('EDIT_MODE' , $sql_res["EDIT_MODE"]);
			} else {
				$this->template[1]->addVar('EDIT_MODE' , 'false');
			}

			// check if empty search query has been entered
			// if is, then skip query execution
			$skip_query_exec = isset($_POST['DynPG_General_Search_Query']) && empty($_POST['DynPG_General_Search_Query']);

			if (!$skip_query_exec)
				$RES = mysql_query($SQL);

			$count        = 1;
			$listIndex    = 0;
			$td_all       = "";
            $listing      = '';
            $_css_switch  = '';
            $template_row = $this->template[1]->getSubTemplate('listing', dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/articles.tpl');

			while ( !$skip_query_exec && $ROW = mysql_fetch_assoc($RES) ) {

                if ( $ROW['ISPUBLIC'] == "TRUE"                                                       &&
			 		 ( $this->Private_GetTimeStamp($ROW['DATE_UP'] . ' ' . $ROW['TIME_UP'])<=time() ) &&
					 ( $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO'])>=time() || $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO']) == -1 ) ||
					 ($this->_AA_IgnoreLimitation && $ROW['ISPUBLIC'] == "TRUE")
				   ) {

                        // Current article is ready to show (in time and selected as public)

						if ( !( $count > ( $this->CurrentPage * $_private_AA_Maxview ) &&
                             $count <= ( ( $this->CurrentPage + 1 ) * $_private_AA_Maxview ) ) ) {

							$count++;

							continue;

						}

						unset($LEADIMAGES);

						$listIndex++;

						$_private_articletext = '';

						// edit mode

							$articletext_id    = null;
							$articletext_group = null;

							if ( mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'")) > 0 ) {
								$_ = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'"));

								// read status of edit-mode
								$articletext_id    = $_['id'];
								$articletext_group = $_['GROUP'];
							}

						//

            			if ( $this->_AA_loadText ) {
                            $content = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'"));

                            $_private_articletext = !empty($content)? stripslashes($content->TEXT): '';

                            if ( !$this->_AA_IgnoreSeperator  ) {
                                $_private_articletext = PerformTextFormat($_private_articletext);
                                $_private_articletext = ReplaceDummyCode($_private_articletext, FALSE, !empty($content)? $content->id: '' );
                                $_private_articletext = dynpg_htmlentities($_private_articletext);

                                $_private_articletext = stripslashes($_private_articletext);
                                $_private_articletext = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "[/SEPERATOR/]", $_private_articletext);

                                if ( strpos($_private_articletext, "[/SEPERATOR/]") ) {
                                    $_private_articletext = substr($_private_articletext, 0, strpos($_private_articletext, "[/SEPERATOR/]"));
                                }

                            } else {

                                $_private_articletext = stripslashes(!empty($content)? $content->TEXT: '');

                                $_private_articletext = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "", $_private_articletext);

                                $_private_articletext = str_replace("[/SEPERATOR/]", "", $_private_articletext);

                                $_private_articletext = PerformTextFormat($_private_articletext);
                                $_private_articletext = ReplaceDummyCode($_private_articletext, FALSE, !empty($content)? $content->id: '' );
                                $_private_articletext = dynpg_htmlentities($_private_articletext);
                            }
                        }

                        $_css_switch = ( $this->_AA_SingleCss > 0 ) ? ( str_repeat("0", 2 - strlen((string)$this->_AA_SingleCss)) ) . $this->_AA_SingleCss : '';

                        $this->template[1]->addVar('LIST_USER_DEFINED_CSS', $_css_switch);

						// $this->Private_ReconnectMySQL();

                        $LEADIMAGES = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_leadimages` WHERE `AID`='" . $ROW['id'] . "'"));

						$this_image_str = Array();
						$this_image_str['IMAGE_URL']  = $this_image_str['IMAGE_NAME']  =
						$this_image_str['MAGE_DESCR'] = $this_image_str['IMAGE_ALIGN'] = '';

                        if ( !empty($LEADIMAGES['id']) ) {
                            $IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='" . $LEADIMAGES['IID'] . "'"));

                            $this_image_str['IMAGE_URL']   = $_general_image_url . $IMG['URL'];
                            $this_image_str['IMAGE_NAME']  = dynpg_htmlentities(stripslashes($IMG['NAME']));
                            $this_image_str['IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($IMG['DESCR']));
                            $this_image_str['IMAGE_ALIGN'] = dynpg_htmlentities(stripslashes($LEADIMAGES['ALIGN']));
                        }

                        $grp_image_str = Array();
                        $grp_image_str['GROUP_IMAGE_URL']   = $grp_image_str['GROUP_IMAGE_NAME']  =
						$grp_image_str['GROUP_IMAGE_DESCR'] = $grp_image_str['GROUP_IMAGE_ALIGN'] = '';

						if ((integer)$ROW['GROUP_IMAGEID'] > 0) {
                            $IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='" . $ROW['GROUP_IMAGEID'] . "'"));

                            $grp_image_str['GROUP_IMAGE_URL']   = $_general_image_url . $IMG['URL'];
                            $grp_image_str['GROUP_IMAGE_NAME']  = dynpg_htmlentities(stripslashes($IMG['NAME']));
                            $grp_image_str['GROUP_IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($IMG['DESCR']));
                            $grp_image_str['GROUP_IMAGE_ALIGN'] = dynpg_htmlentities(stripslashes($ROW['GROUP_IMAGEALIGN']));
	                    }

                        $ROW_TITLE_FOR_URL = $ROW['TITLE'];
                        $ROW_GROUP_NAME_FOR_URL = $ROW['GROUP_NAME'];
                        $ROW = array_map(create_function('$val', 'return dynpg_htmlentities(stripslashes($val));'), $ROW);

                        if ( (integer)$ROW['DATEFIX'] > 2147483647 ) {
                            $ROW['DATEFIX'] = 2147483647;
                        }

                        $ROW['TITLEL']     = count($ROW['TITLE']);
						$ROW['TEXT']       = $_private_articletext;
                        $ROW['TEXTL']      = count($ROW['TEXT']);
                        $ROW['LEAD'] = PerformTextFormat(stripslashes($ROW['LEAD']));
                        $ROW['LEAD'] = ReplaceDummyCode($ROW['LEAD'], FALSE, 0);
                        $ROW['LEAD'] = dynpg_htmlentities($ROW['LEAD']);
                        $ROW['LEADL']      = count($ROW['LEAD']);
                        $ROW['LEADNOHTML'] = strip_tags($ROW['LEAD']);
                        $ROW['GROUP_SHORTTEXT_NOHTML'] = strip_tags($ROW['GROUP_SHORTTEXT']);
                        $ROW['SHOWDATE']   = $ROW['SHOWDATE'] == 'TRUE' ? 'True' : 'False';
                        $ROW['CREATEDATE'] = date($this->language[1]->str['lang_general_articles_create_date_format'], $ROW['CREATEDATE']);
                        $ROW['DATEFIX']    = date($this->language[1]->str['lang_general_articles_fix_date_format'], $ROW['DATEFIX']);
                        $date['DATE_UP']   = date($this->language[1]->str['lang_general_articles_from_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_UP'] . ' ' . $ROW['TIME_UP'])) > 0 ? $_ : time() );
                        $date['DATE_TO']   = date($this->language[1]->str['lang_general_articles_till_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO'])) > 0 ? $_ : time() );
                        $date['CHANGED']   = date($this->language[1]->str['lang_general_articles_change_date_format'], $ROW['CHANGED'] );

                        if ( $count > ( $this->CurrentPage * $_private_AA_Maxview ) && $count <= ( ( $this->CurrentPage + 1 ) * $_private_AA_Maxview ) ) {

                            $listing .= $this->template[1]->fillTemplate(

                                        $template_row ,

                                        false ,

                                        array_merge (

                                            $ROW,

                                            $this_image_str,

                                            $grp_image_str,

                                            $date,

                                            Array (

                                              'ROW_TITLE_PLAIN' => stripslashes($ROW_TITLE_FOR_URL),

                                              'LIST_IMAGE_ALIGN' => ( !empty($LEADIMAGES['id']) ) ? $this_image_str['IMAGE_ALIGN'] : 'NULL',

                                              'LIST_HAS_IMAGE' => ( empty($LEADIMAGES['id']) ) ? 'False' : 'True',

                                              'LIST_FWD_TEXT' => ( $ROW['CONTENT'] > 0 ) ? 'True' : 'False',

                                              'LIST_SHOW_VISTS' => ( $ROW['SHOWVISITS'] == 'TRUE' ) ? init_counter("article>" . $ROW['id'], TRUE, "RETURNTEXT") : '',

                                              'LIST_INDEX' => $listIndex,

                                              'LIST_REFER_TO' => $this->PathToNextPage . "?" . $this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_category=(\w+)")), FALSE).((isset($_POST['DynPG_General_Search_Query']) && $ROW['id'] == $ROW['GROUP_REFID']) ? "&read_group=".$ROW['GROUP_ID']."&t=".urlencode(stripslashes($ROW_TITLE_FOR_URL)) : "&read_article=".$ROW['id']."&t=".urlencode(stripslashes($ROW_TITLE_FOR_URL)))),

                                              'LIST_USER_DEFINED_CSS' => $_css_switch,

                                              'EDIT_MODE_ADDRESS' => $this->PathToRoot . 'index.php?show=3&take=' . $ROW['GROUP_ID'] . '&acttype=chg&aid=' . $ROW['id'],

					                          'LANG_AA_LANGUAGE' => $this->language[1]->str['lang_general_articles_language'],

					                          'LANG_AA_READ_MORE' => $this->language[1]->str['lang_general_articles_read_more'],

					                          'LANG_AA_MORE' => $this->language[1]->str['lang_general_articles_more'],

					                          'LANG_AA_EDIT' => $this->language[1]->str['lang_general_articles_edit'],

					                          'LANG_AA_EDITING' => $this->language[1]->str['lang_general_articles_editing'],

					                          'LANG_AA_EDITING_WITHIN_DYNPG' => $this->language[1]->str['lang_general_articles_edit_within_dynpg']

                                            )

                                        ) );


                            // $this->Private_ReconnectMySQL();

                        }

						$count++;

						// finished showing articles

					} // end if->article is ready to show

			} // end while

            if ( !empty($_POST['DynPG_General_Search_Query']) ) {
                $__query_url = 'read_srch='.urlencode($_POST['DynPG_General_Search_Query']);

                if ( !mysql_num_rows($RES) ) {
                    $this->template[1]->addVar('NO_RESULTS', 'True');
                    $this->template[1]->addVar('SEARCH_QUERY', htmlentities($_POST['DynPG_General_Search_Query']));
                    $this->template[1]->addVar('LANG_AA_NO_MATCHING_RESULTS', str_replace('%SEARCH_QUERY%', htmlentities($_POST['DynPG_General_Search_Query']), $this->language[1]->str['lang_general_articles_no_matching_results']));
                } else {
                    $this->template[1]->addVar('NO_RESULTS', 'False');
                    $this->template[1]->addVar('SEARCH_QUERY', '');
                    $this->template[1]->addVar('LANG_AA_NO_MATCHING_RESULTS', str_replace('%SEARCH_QUERY%', '', $this->language[1]->str['lang_general_articles_no_matching_results']));
                }
            } else {
                $__query_url = 'read_group=' . $this->IdxSelector;

                if ( isset($_POST['DynPG_General_Search_Query']) ) {
                    $this->template[1]->addVar('NO_RESULTS', 'True');
                    $this->template[1]->addVar('SEARCH_QUERY', $this->language[1]->str['lang_general_articles_no_search_query']);
                    $this->template[1]->addVar('LANG_AA_NO_MATCHING_RESULTS', str_replace('%SEARCH_QUERY%', $this->language[1]->str['lang_general_articles_no_search_query'], $this->language[1]->str['lang_general_articles_no_matching_results']));
                } else {
                    $this->template[1]->addVar('NO_RESULTS', 'False');
                    $this->template[1]->addVar('SEARCH_QUERY', '');
                    $this->template[1]->addVar('LANG_AA_NO_MATCHING_RESULTS', str_replace('%SEARCH_QUERY%', '', $this->language[1]->str['lang_general_articles_no_matching_results']));
                }
            }

            $this->template[1]->addVar('LANG_AA_NO_MATCHING_RESULTS_FOR_TIMESPAN', $this->language[1]->str['lang_general_articles_no_matching_results_for_timespan']);

            $nav_query = $this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_srch=(\w+)")), FALSE).$__query_url);

            if ( !empty($nav_query) ) {
                $nav_query .= '&';
            }

            $Navigator = $this->Private_GetSiteString($this->PathToCurrPage . "?" . $nav_query
														, ($count - 1)
														, $_private_AA_Maxview
														, $this->_AA_ForceNav);

			if( ($count-1) > $_private_AA_Maxview ){
				$this->template[1]->addVar('PAGES_NAVIGATION', $Navigator );
			}
			else {
				$this->template[1]->addVar('PAGES_NAVIGATION', '' );
			}

			$pathOfElement = ($this->_AA_ForceAnyTime)? '': $this->writePathOfElement($this->IdxSelector, '<a href="%RELPAGE%'."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("&page=(\w+)", dynpg_insert_urlheader("read_category=(\w+)")), FALSE).'%SELECTOR%=%ID%&page=0', FALSE).'">');

            $this->template[1]->addVar('COND_SEGM_CATNAV', $this->_AA_CatNav ? 'True' : 'False' );
            $this->template[1]->addVar('COND_SEGM_PRINTNAV', $this->_AA_PrintNav ? 'True' : 'False' );
            $this->template[1]->addVar('PRINT_HREF', $this->PathToRoot . "print_list.php?lang=".$this->language[0]."&amp;" . $__query_url );
            $this->template[1]->addVar('LANG_AA_PRINT', $this->language[1]->str['lang_general_detail_print'] );
            $this->template[1]->addVar('LANG_AA_PRINT_PAGE', $this->language[1]->str['lang_general_detail_print'] );

			$this->template[1]->addVar('ROOT_NAVIGATION', $pathOfElement );

			$template_str = $this->template[1]->replaceSubTemplate(
                                'listing',

                                $listing,

                                dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/articles.tpl'
                            );

            $this->template[1]->addVar('LIST_INDEX', $listIndex );

            $returntext = $this->template[1]->fillTemplate( $template_str, false );

            // restore selector value
			$this->IdxSelector = $tmpIdxSelector;

			unset($count);
			unset($Navigator);
			unset($td);
			unset($td_all);
			unset($CurrentCategory);
			unset($CurrentCategoryName);
			unset($CurrentGroup);
			unset($CurrentGroupName);

			$returntext = $this->template[1]->render($returntext, false);

			echo $returntext;

			return ($returntext);
		}
		// ---------------------------------------------------------------------------
		// END ALL ARTICLES
		// ---------------------------------------------------------------------------


		// ---------------------------------------------------------------------------
		//	ARTICLE
		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_A_Anytime()
			*
			* This function sets the param if an article-text should be shown in every case
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_Anytime($bool = FALSE)	 { $this->_A_Anytime = $bool; }

		/**
			* procedure SetParam_A_Article()
			*
			* This function sets the param of the article-text that should be shown
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_A_Article($int = 0) 	 { $this->_A_SingleArticle = $int;}

		/**
			* procedure SetParam_A_CategoryNavigation()
			*
			* This function sets the param if a navigation should be shown in the detail-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_CategoryNavigation($bool = FALSE) { $this->_A_CatNav = $bool; }

		/**
			* procedure SetParam_A_PrintNavigation()
			*
			* This function sets the param if an article-text should have a link to print the text
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_PrintNavigation($bool = FALSE) { $this->_A_PrintNav = $bool; }

	    /**
	      * procedure SetParam_A_LinkNavigation()
	      *
	      * This function sets the param if an article-text should have a link to the page itself
	      *
	      * @package DynPG Frontend Engine
	      * @author Chris Wuersch
	      * @version 1.0
	      * @access private
	      * @copyright Chris Wuersch, 06.04.2009
	      * @param [boolean]
	      * @return -
	      */
	    function SetParam_A_LinkNavigation($bool = TRUE) { $this->_A_LinkNav = $bool; }

	    /**
	      * procedure SetParam_A_RecommendNavigation()
	      *
	      * This function sets the param if an article-text should have a link to recommend the page
	      *
	      * @package DynPG Frontend Engine
	      * @author Chris Wuersch
	      * @version 1.0
	      * @access private
	      * @copyright Chris Wuersch, 06.04.2009
	      * @param [boolean]
	      * @return -
	      */
	    function SetParam_A_RecommendNavigation($bool = TRUE) { $this->_A_RecommendNav = $bool; }

	    /**
	      * procedure SetParam_A_PdfNavigation()
	      *
	      * This function sets the param if an article-text should have a link to show the text as pdf
	      *
	      * @package DynPG Frontend Engine
	      * @author Chris Wuersch
	      * @version 1.0
	      * @access private
	      * @copyright Chris Wuersch, 01.09.2009
	      * @param [boolean]
	      * @return -
	      */
	    function SetParam_A_PdfNavigation($bool = TRUE) { $this->_A_PdfNav = $bool; }

		/**
			* procedure SetParam_A_ArticleHeader()
			*
			* This function sets the param if the title of the article should be shown
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_ArticleHeader($bool = FALSE) { $this->_A_Head = $bool; }

		/**
			* procedure SetParam_A_SingleCss()
			*
			* This function sets the param for a special css in the detail-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [integer]
			* @return -
			*/
		function SetParam_A_ArticleCss($int = 0) {  $this->_A_SingleArticleCss = $int;  }

		/**
			* procedure SetParam_A_IgnoreSeperator()
			*
			* This function sets the param if the seperator should be ignored in the detail-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_IgnoreSeperator($bool = TRUE) {  $this->_A_IgnoreSeperator = $bool;  }

    /**
      * procedure SetParam_A_fullLoadText()
      *
      * This function sets the param if the detail-text of an article should be loaded
      *
      * @package DynPG Frontend Engine
      * @author Chris Wuersch <info@chriswuersch.com>
      * @version 1.0
      * @access private
      * @copyright Chris Wuersch, 24.03.2009
      * @param [boolean]
      * @return -
      */
    function SetParam_A_fullLoadText($bool = TRUE) {  $this->_A_loadText = $bool; }

		/**
			* procedure SetParam_A_IgnoreLimitation()
			*
			* This function sets specifies, wheather an article is shown, even
			* if his limitations forbid that.
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 26.09.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_IgnoreLimitation($bool = TRUE) {  $this->_A_IgnoreLimitation = $bool;  }

		/**
			* procedure SetParam_A_ShowText()
			*
			* This function sets the param if the article-text should be shown
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_A_ShowText($bool = TRUE) {  $this->_A_ShowText = $bool;  }

		/**
			* procedure Write_Article()
			*
			* This function writes the view of 'single article'
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return string
			*/
		function Write_Article()
		{
            if ( $this->PageSelector!="ARTICLES_EX" && !$this->_A_Anytime ) {
                return '';
            }

			if ( $this->_A_Anytime ) {
                $ShowArticle = $this->_A_SingleArticle;
            } else {
                $ShowArticle = $this->IdxSelector;
            }

            //
            // modified: 2009/01/08 by Daniel Schliebner
            //
            // In order to lock the current selector,
            // we use the DPGcommunity plugin engine.
            // These holds user data and information
            // about the user stock that is allowed
            // to enter the current IdxSelector.
            //
            // At first we check if the plugin is available.
            // If it is, we call the routines that lock the
            // group. Every content that is shown in this case
            // comes out of templates from the DPGcommunity plugin.
            //
            if ($this->plugInExists('DPGcommunity')) {
            	$dpgcommunity = $this->call_PlugIn('DPGcommunity');
            	if ($dpgcommunity->parameters['enable_locking_feature']) {
	            	$article = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `id` = '{$ShowArticle}'"));
	            	$lock = $dpgcommunity->dpglock_verify(
						true,
						Array($article['GROUP'])
					);
	            	if ($lock !== C_COMMUNITY_NOLOCK && $lock !== C_COMMUNITY_FREE) {
	            		print $lock;
	            		return $lock;
	            	}
	            	$lock = $dpgcommunity->dpglock_verify(
						false,
						Array($ShowArticle)
					);
	            	if ($lock !== C_COMMUNITY_NOLOCK && $lock !== C_COMMUNITY_FREE) {
	            		print $lock;
	            		return $lock;
	            	}
	            }
            }
			//
            // Now we continue the default routines to show the
            // frontend views. That means, that the plugin has not
            // been installed or the user is not allowed to view this
            // IdxSelector.

			$_css_switch = ( $this->_A_SingleArticleCss )
                            ? ( str_repeat("0", 2-strlen((string)$this->_A_SingleArticleCss)) ) . $this->_A_SingleArticleCss
                            : '';

            $this->template[1]->addVar('LIST_USER_DEFINED_CSS', $_css_switch);

			@init_counter("article>$ShowArticle", FALSE, "RETURNTEXT");

			// $this->Private_ReconnectMySQL();

			if ( mysql_num_rows(mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `id` = '{$ShowArticle}'")) == 0 ) {
				return '';
			}

			$ROW = mysql_fetch_assoc(
				mysql_query(
					"SELECT DISTINCT
						A.*,
						Z.`NAME` AS OWNER_NAME,
	        			Y.`NAME` AS MODIFIER_NAME
					 FROM
					 	(`dynpg_cms_article` AS A LEFT JOIN `dynpg_cms_user` AS Z
						ON Z.`id` = A.`OWNER`) LEFT JOIN `dynpg_cms_user` AS Y
						ON Y.`id` = A.`MODIFIER`
					 WHERE A.`id` = '{$ShowArticle}'"
				)
			);

			if (! ( $ROW['ISPUBLIC'] == "TRUE"                                                    &&
    	 		 ( $this->Private_GetTimeStamp($ROW['DATE_UP'] . ' ' . $ROW['TIME_UP'])<=time() ) &&
    			 ( $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO'])>=time() || $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO']) == -1 )
		       ) ) {

                  if (!$this->_A_IgnoreLimitation || $ROW['ISPUBLIC'] == "FALSE")
				  	return '';

		    }

			// edit mode

				$articletext_id    = null;
				$articletext_group = null;
				$enable_edit_mode  = 'false';

				if ( mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'")) > 0 ) {
					$ROW = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'"));

					// read status of edit-mode
					$articletext_id    = $ROW['id'];
					$articletext_group = $ROW['GROUP'];
				}

				// is edit_mode enabled for the user?
				if(! empty($_SESSION['NAME']) ){
					$sql_res = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_user` WHERE `NAME` = '{$_SESSION['NAME']}'"));
					$enable_edit_mode = $sql_res["EDIT_MODE"];
				}

			//

			if (! isset($ROW['TEXT']) ) {
				$ROW['TEXT'] = '';
			}

      $_private_articletext = '';

      if ( $this->_A_loadText ) {

            $_private_articletext = stripslashes($ROW['TEXT']);

            if ( !$this->_A_IgnoreSeperator  ) {

                $_private_articletext = PerformTextFormat($_private_articletext);
                $_private_articletext = ReplaceDummyCode($_private_articletext, FALSE, $ROW['id'] );
                $_private_articletext = dynpg_htmlentities($_private_articletext);

                $_private_articletext = stripslashes($_private_articletext);
                $_private_articletext = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "[/SEPERATOR/]", $_private_articletext);

                if ( strpos($_private_articletext, "[/SEPERATOR/]") ) {
                    $_private_articletext = substr($_private_articletext, 0, strpos($_private_articletext, "[/SEPERATOR/]"));
                }

            } else {

                $_private_articletext = stripslashes($ROW['TEXT']);

                $_private_articletext = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "", $_private_articletext);

                $_private_articletext = str_replace("[/SEPERATOR/]", "", $_private_articletext);

                $_private_articletext = PerformTextFormat($_private_articletext);
                $_private_articletext = ReplaceDummyCode($_private_articletext, FALSE, $ShowArticle );
                $_private_articletext = dynpg_htmlentities($_private_articletext);
            }

      }

      if(strpos($_private_articletext, '<input type="hidden" id="dpg_field_dynpgform" name="dynpgform"') !== false)
            $this->cacheLiteDisabled = true;

			@mysql_free_result($RES);

			if ( !empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
                $_general_image_url = $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"];
            } else {
                $_general_image_url = $this->PathToRoot . FORMS_IMAGES_DESTINATIONURL_ROOT;
            }

			// $this->Private_ReconnectMySQL();

			$ROW = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `id` = '$ShowArticle'"));


			// get data for currently selected group

			$CURRENT = Array(
				'GROUP_ID' => '',
				'GROUP_NAME' => '',
				'GROUP_SHORTTEXT' => '',
				'GROUP_IMAGEID' => '',
				'GROUP_IMAGEALIGN' => '',
				'GROUP_REFID' => '',
				'GROUP_IMAGE_URL' => '',
				'GROUP_IMAGE_NAME' => '',
				'GROUP_IMAGE_DESCR' => '',
				'GROUP_IMAGE_ALIGN' => ''
			);

			$CURRENT = mysql_fetch_assoc(
				mysql_query(
					"SELECT DISTINCT
						A.`id` AS `GROUP_ID`,
						A.`NAME` AS `GROUP_NAME`,
						A.`SHORTTEXT` AS `GROUP_SHORTTEXT`,
						A.`IMAGE` AS `GROUP_IMAGEID`,
						A.`ALIGN` AS `GROUP_IMAGEALIGN`,
						A.`ALIGN` AS `GROUP_IMAGE_ALIGN`,
						A.`REFID` AS `GROUP_REFID`,
						B.`NAME` AS `GROUP_IMAGE_NAME`,
						B.`URL` AS `GROUP_IMAGE_URL`,
						B.`DESCR` AS `GROUP_IMAGE_DESCR`
					FROM
						`dynpg_cms_groups` AS A LEFT JOIN `dynpg_cms_images` AS B
						ON A.`IMAGE` = B.`id`
					WHERE
						".((($this->IsGroupContent) && isset($this->IdxSelector) && $this->IdxSelector != 'NULL' && !empty($this->IdxSelector)) ? "A.`id` = {$this->IdxSelector}" : "A.`id` = {$ROW['GROUP']}")
				)
			);

			if ((integer)$CURRENT['GROUP_IMAGEID'] > 0) {
                $CURRENT['GROUP_IMAGE_URL']   = $_general_image_url . $CURRENT['GROUP_IMAGE_URL'];
                $CURRENT['GROUP_IMAGE_NAME']  = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_NAME']));
                $CURRENT['GROUP_IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_DESCR']));
                $CURRENT['GROUP_IMAGE_ALIGN'] = dynpg_htmlentities(stripslashes($CURRENT['GROUP_IMAGE_ALIGN']));
            }


			$this->template[1]->addVar('PAGES_NAVIGATION', '' );

			$ROW = array_map(create_function('$val', 'return dynpg_htmlentities(stripslashes($val));'), $ROW);

			$itembreadcrumb = $this->template[1]->fillTemplate(
				$this->language[1]->str['lang_navigation_root_itemelement'],
				false,
				array_merge(
					Array(
						'LIST_INDEX' => 0,
						'SEPERATE' => $this->language[1]->str['lang_navigation_root_separate_str']
					),
					$ROW
				)
			);

			$pathOfElement = $this->writePathOfElement($CURRENT['GROUP_ID'], '<a href="%RELPAGE%'."?".
				$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_article=(\w+)", dynpg_insert_urlheader("&page=(\w+)"), FALSE).'%SELECTOR%=%ID%&page=0', FALSE).'">').
				$itembreadcrumb;

            $this->template[1]->addVar('ROOT_NAVIGATION', $pathOfElement );

            $LEADIMAGES = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_leadimages` WHERE `AID`='" . $ROW['id'] . "'"));

			$this_image_str = Array();
			$this_image_str['IMAGE_URL']  = $this_image_str['IMAGE_NAME']  =
			$this_image_str['MAGE_DESCR'] = $this_image_str['IMAGE_ALIGN'] = '';

            if ( !empty($LEADIMAGES['id']) ) {
                $IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='" . $LEADIMAGES['IID'] . "'"));

                $this_image_str['IMAGE_URL']   = $_general_image_url . $IMG['URL'];
                $this_image_str['IMAGE_NAME']  = dynpg_htmlentities(stripslashes($IMG['NAME']));
                $this_image_str['IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($IMG['DESCR']));
                $this_image_str['IMAGE_ALIGN'] = 'LEFT';
            }
            $ROW['LEAD'] = PerformTextFormat(stripslashes($ROW['LEAD']));
            $ROW['LEAD'] = ReplaceDummyCode($ROW['LEAD'], FALSE, $ShowArticle );
            $ROW['LEAD'] = dynpg_htmlentities($ROW['LEAD']);
            $ROW['LEAD_NOHTML'] = strip_tags($ROW['LEAD']);
            $ROW['SHOWDATE']   = $ROW['SHOWDATE'] == 'TRUE' ? 'True' : 'False';
            $ROW['CREATEDATE'] = date($this->language[1]->str['lang_general_detail_create_date_format'], $ROW['CREATEDATE']);
            $ROW['DATEFIX']    = date($this->language[1]->str['lang_general_detail_fix_date_format'], $ROW['DATEFIX']);
            $date['DATE_UP']   = date($this->language[1]->str['lang_general_detail_from_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_UP'] . ' ' . $ROW['TIME_UP'])) > 0 ? $_ : time() );
            $date['DATE_TO']   = date($this->language[1]->str['lang_general_detail_till_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO'])) > 0 ? $_ : time() );
            $date['CHANGED']   = date($this->language[1]->str['lang_general_detail_change_date_format'], $ROW['CHANGED'] );

            $_private_url_ShowHeader = ( $this->_A_Head ) ? 'Y' : 'N';

			$template_str = $this->template[1]->fillTemplate(
                                dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/detail.tpl',

                                true,

                                array_merge(

                                    $ROW,

                                    $this_image_str,

                                    $CURRENT,

                                    Array ( 'CONTENT' => $_private_articletext ),

                                    $date,

                                    Array (

                                        'COND_SEGM_CATNAV' => $this->_A_CatNav ? 'True' : 'False',

                                        'COND_SEGM_HEAD' => $this->_A_Head ? 'True' : 'False',

                                        'COND_SEGM_TEXT' => $this->_A_ShowText ? 'True' : 'False',

                                        'COND_SEGM_PRINTNAV' => $this->_A_PrintNav ? 'True' : 'False',

                                        'COND_SEGM_LINKNAV' => $this->_A_LinkNav ? 'True' : 'False',

                                        'COND_SEGM_RECOMMENDNAV' => $this->_A_RecommendNav ? 'True' : 'False',

                                        'COND_SEGM_PDFNAV' => $this->_A_PdfNav ? 'True' : 'False',

                                        'COND_SEGM_SEPARATOR' => $this->_A_IgnoreSeperator ? 'True' : 'False',

                                        'LIST_USER_DEFINED_CSS' => $_css_switch,

                                        'HAS_IMAGE' => !empty($LEADIMAGES['id']) ? 'True' : 'False',

                                        'PRINT_HREF' => $this->PathToRoot . "print_text.php?lang=".$this->language[0]."&amp;aid=" . $ROW['id'] . "&amp;showheader=".$_private_url_ShowHeader.((isset($_GET['board_id'])) ? '&amp;board_id='.$_GET['board_id']: '').((isset($_GET['thread_id'])) ? '&amp;thread_id='.$_GET['thread_id']: ''),

                                        'LINK_HREF' => $_SERVER['PHP_SELF'] . "?" . $this->dynPG_getContent_organizeUrlQueryString("read_article=" . $ROW['id']).((isset($_GET['board_id'])) ? '&amp;board_id='.$_GET['board_id']: '').((isset($_GET['thread_id'])) ? '&amp;thread_id='.$_GET['thread_id']: ''),

                                        'RECOMMEND_HREF' => "mailto:?subject=".$ROW['TITLE']."&amp;body=".urlencode("http://".$_SERVER['SERVER_NAME'].$_SERVER['SCRIPT_NAME'] . "?" . $this->dynPG_getContent_organizeUrlQueryString("read_article=" . $ROW['id']).((isset($_GET['board_id'])) ? '&amp;board_id='.$_GET['board_id']: '').((isset($_GET['thread_id'])) ? '&amp;thread_id='.$_GET['thread_id']: '')),

                                        'PDF_HREF' => $this->PathToRoot . "pdf.php?lang=".$this->language[0]."&amp;aid=" . $ROW['id'] . "&amp;showheader=".$_private_url_ShowHeader.((isset($_GET['board_id'])) ? '&amp;board_id='.$_GET['board_id']: '').((isset($_GET['thread_id'])) ? '&amp;thread_id='.$_GET['thread_id']: ''),

                                        'MORE_HREF' => $this->PathToNextPage . "?" . $this->dynPG_getContent_organizeUrlQueryString("read_article=" . $ROW['id']),

                                        'EDIT_MODE_ADDRESS' => $this->PathToRoot . 'index.php?show=3&take=' . $ROW['GROUP'] . '&acttype=chg&aid=' . $ROW['id'],

										'TEXT_ID' => $articletext_id,

										'EDIT_MODE' => $enable_edit_mode,

					                    'LANG_A_PDF' => $this->language[1]->str['lang_general_detail_pdf'],

					                    'LANG_A_PDF_PAGE' => $this->language[1]->str['lang_general_detail_pdf_page'],

					                    'LANG_A_RECOMMEND' => $this->language[1]->str['lang_general_detail_recommend'],

					                    'LANG_A_RECOMMEND_PAGE' => $this->language[1]->str['lang_general_detail_recommend_page'],

					                    'LANG_A_LINK' => $this->language[1]->str['lang_general_detail_link'],

					                    'LANG_A_LINK_PAGE' => $this->language[1]->str['lang_general_detail_link_page'],

					                    'LANG_A_PRINT' => $this->language[1]->str['lang_general_detail_print'],

					                    'LANG_A_PRINT_PAGE' => $this->language[1]->str['lang_general_detail_print_page'],

					                    'LANG_A_READ_MORE' => $this->language[1]->str['lang_general_detail_read_more'],

					                    'LANG_A_MORE' => $this->language[1]->str['lang_general_detail_more'],

					                    'LANG_A_EDIT' => $this->language[1]->str['lang_general_detail_edit'],

					                    'LANG_A_EDITING' => $this->language[1]->str['lang_general_detail_editing'],

					                    'LANG_A_EDIT_WITHIN_DYNPG' => $this->language[1]->str['lang_general_detail_edit_within_dynpg']
                                    )
                                )
                            );

            $returntext = $this->template[1]->fillTemplate( $template_str, false );

			unset($_private_url_ShowHeader);
			unset($_private_articletext);
			unset($ShowArticle);
			unset($CurrentCategory);
			unset($CURRENT);

			$returntext = $this->template[1]->render($returntext, false);

			echo $returntext;
			return ($returntext);
		}
		// ---------------------------------------------------------------------------
		// END ARTICLE
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		//	HOME
		// ---------------------------------------------------------------------------
		/**
			* procedure SetParam_H_Anytime()
			*
			* This function sets the param if an article-text should be shown in every case at home-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_H_Anytime($bool = FALSE)	 { $this->_H_Anytime = $bool; }

		/**
			* procedure SetParam_H_ArticleHeader()
			*
			* This function sets the param if the title of the article should be shown at home-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_H_ArticleHeader($bool = FALSE) { $this->_H_Head = $bool; }

		/**
			* procedure SetParam_H_ShowAll()
			*
			* This function sets the param if all articles for home should be shown
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_H_ShowAll($bool = FALSE) { $this->_H_ShowAll = $bool; }

		/**
			* procedure SetParam_H_ForwardText()
			*
			* This function sets the param for the text of the link to the full detail-view of an article
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_H_ForwardText($bool = TRUE) { $this->_H_FwdText = $bool; }

		/**
			* procedure SetParam_H_ShowText()
			*
			* This function sets the param if the article-text should be shown in home-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [boolean]
			* @return -
			*/
		function SetParam_H_ShowText($bool = TRUE) { $this->_H_ShowText = $bool; }

		/**
			* procedure SetParam_H_Group()
			*
			* This function sets the param of the group, whose home-article should be shown in the home-view
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_H_Group($string = "") { $this->CatSelector = $string; }

		/**
			* procedure Write_Home()
			*
			* This function writes the view of 'home'
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return string
			*/
		function Write_Home()
		{
			if ( $this->PageSelector != "HOME" && !$this->_H_Anytime ) {
                return '';
            }

            // $this->Private_ReconnectMySQL();

            if ( !empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
                $_general_image_url = $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"];
            } else {
                $_general_image_url = $this->PathToRoot . FORMS_IMAGES_DESTINATIONURL_ROOT;
            }

			if ( $this->_H_Anytime && !$this->_H_ShowAll ) {

                $SQL = "SELECT DISTINCT
                            `dynpg_cms_article`.*
                        FROM
                            `dynpg_cms_article`,
                            `dynpg_cms_groups`
                        WHERE
                            `dynpg_cms_article`.`GROUP`=`dynpg_cms_groups`.`id`
                            AND `dynpg_cms_groups`.`NAME`='".$this->CatSelector."'
                        ORDER BY `dynpg_cms_article`.`DATEFIX` ASC,
                                 `dynpg_cms_article`.`CREATEDATE` DESC";

			} else if ( !$this->_H_ShowAll ) {

                $SQL = "SELECT DISTINCT
                            `dynpg_cms_article`.*
                        FROM
                            `dynpg_cms_article`
                        WHERE
                            `dynpg_cms_article`.`GROUP`='".$this->IdxSelector."'
                        ORDER BY `dynpg_cms_article`.`DATEFIX` ASC,
                                 `dynpg_cms_article`.`CREATEDATE` DESC";

			} else {

                $SQL = "SELECT
                            *
                        FROM
                            `dynpg_cms_article`
                        ORDER BY
                            `dynpg_cms_article`.`DATEFIX` ASC,
                            `dynpg_cms_article`.`CREATEDATE` DESC";

            }

            $RES = mysql_query($SQL);

			$returntext   = '';
			$listing      = '';
            $count        = 1;
            $listIndex    = 0;
            $template_row = $this->template[1]->getSubTemplate('listing', dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/home.tpl');

			while ( $ROW = mysql_fetch_assoc($RES) ) {

                if ( $count > $GLOBALS["cfg"]["config_Home_Limit"] ) {
                    break;
                }

                if ( $ROW['CONTENT'] != -1
                     && (   $ROW['ISPUBLIC']=="TRUE"
                     &&     $ROW['ISATHOME']=="TRUE"
			 		 && (   $this->Private_GetTimeStamp($ROW['DATE_UP']." ".$ROW['TIME_UP'])<=time() )
					 && (   $this->Private_GetTimeStamp($ROW['DATE_TO']." ".$ROW['TIME_TO'])>=time()
                     ||     $this->Private_GetTimeStamp($ROW['DATE_TO']." ".$ROW['TIME_TO'])==-1 )   ) ) {

                    $listIndex++;

                    $_private_articletext = '';

                    if ( $this->_H_ShowText && mysql_num_rows(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'")) > 0 ) {

                        $ARTICLE = mysql_fetch_object(mysql_query("SELECT * FROM `dynpg_cms_articletexts` WHERE `id`='" . $ROW['CONTENT'] . "'"));

    					$_private_articletext = $ARTICLE->TEXT;

			            $_private_articletext = PerformTextFormat($_private_articletext);
			            $_private_articletext = ReplaceDummyCode($_private_articletext, FALSE, $ROW['id'] );
			            $_private_articletext = dynpg_htmlentities($_private_articletext);

    					$_private_articletext = stripslashes($_private_articletext);
                        $_private_articletext = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "[/SEPERATOR/]", $_private_articletext);

                        if ( strpos($_private_articletext, "[/SEPERATOR/]") ) {
                            $_private_articletext = substr($_private_articletext, 0, strpos($_private_articletext, "[/SEPERATOR/]"));
                        }

                        // $this->Private_ReconnectMySQL();

                    }

                    $GROUP = mysql_fetch_assoc(
                                mysql_query(
                                    "SELECT DISTINCT
                                        `dynpg_cms_groups`.`NAME` AS GRP_NAME,
                                        `dynpg_cms_groups`.`SHORTTEXT` AS GRP_SHORTTEXT,
                                        `dynpg_cms_groups`.`CREATEDATE` AS GRP_CREATEDATE
                                     FROM
                                        `dynpg_cms_article`,
                                        `dynpg_cms_groups`
                                     WHERE
                                        `dynpg_cms_article`.`id`='" . $ROW['id'] . "'
                                        AND `dynpg_cms_article`.`GROUP`=`dynpg_cms_groups`.`id`"
                                     )
                                 );

                    if (! is_array($GROUP) ) {
                    	$GROUP = Array();
                    }

                    unset($LEADIMAGES);
                    unset($this_image_str);

                    $LEADIMAGES = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_leadimages` WHERE `AID`='" . $ROW['id'] . "'"));

					$this_image_str = Array();

                    if ( !empty($LEADIMAGES['id']) ) {
                        $IMG = mysql_fetch_assoc(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id`='" . $LEADIMAGES['IID'] . "'"));

                        $this_image_str['IMAGE_URL']   = $_general_image_url . $IMG['URL'];
                        $this_image_str['IMAGE_NAME']  = dynpg_htmlentities(stripslashes($IMG['NAME']));
                        $this_image_str['IMAGE_DESCR'] = dynpg_htmlentities(stripslashes($IMG['DESCR']));
                        $this_image_str['IMAGE_ALIGN'] = dynpg_htmlentities(stripslashes($LEADIMAGES['ALIGN']));
                    }

                    if ( (integer)$ROW['DATEFIX'] > 2147483647 ) {
                        $ROW['DATEFIX'] = 2147483647;
                    }

                    $ROW['LEAD'] = PerformTextFormat(stripslashes($ROW['LEAD']));
                    $ROW['LEAD'] = ReplaceDummyCode($ROW['LEAD'], FALSE, $ROW['id'] );
                    $ROW['LEAD'] = dynpg_htmlentities($ROW['LEAD']);
                    $ROW['SHOWDATE']   = $ROW['SHOWDATE'] == 'TRUE' ? 'True' : 'False';
                    $ROW['CREATEDATE'] = date($this->language[1]->str['lang_general_home_create_date_format'], $ROW['CREATEDATE']);
                    $ROW['DATEFIX']    = date($this->language[1]->str['lang_general_home_fix_date_format'], $ROW['DATEFIX']);
                    $date['DATE_UP']   = date($this->language[1]->str['lang_general_home_from_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_UP'] . ' ' . $ROW['TIME_UP'])) > 0 ? $_ : time() );
                    $date['DATE_TO']   = date($this->language[1]->str['lang_general_home_till_date_format'], ($_ = $this->Private_GetTimeStamp($ROW['DATE_TO'] . ' ' . $ROW['TIME_TO'])) > 0 ? $_ : time() );

                    $ROW   = array_map(create_function('$val', 'return dynpg_htmlentities(stripslashes($val));'), $ROW);
                    $GROUP = array_map(create_function('$val', 'return dynpg_htmlentities(stripslashes($val));'), $GROUP);

                    $listing .= $this->template[1]->fillTemplate(

                                    $template_row ,

                                    false ,

                                    array_merge (

                                        $ROW,

                                        $this_image_str,

                                        $GROUP,

                                        Array('CONTENT' => $_private_articletext),

                                        $date,

                                        Array (

                                          'LIST_IMAGE_ALIGN' => ( !empty($LEADIMAGES['id']) ) ? $this_image_str['IMAGE_ALIGN'] : 'NULL',

                                          'LIST_HAS_IMAGE' => ( empty($LEADIMAGES['id']) ) ? 'False' : 'True',

                                          'LIST_HEADER_EACH' => ( $this->_H_Head ) ? 'True' : 'False',

                                          'LIST_SHOWTEXT_EACH' => ( $this->_H_ShowText && $ROW['CONTENT'] > 0 ) ? 'True' : 'False',

                                          'LIST_FWD_TEXT' => ( $this->_H_FwdText && $ROW['CONTENT'] > 0 ) ? 'True' : 'False',

                                          'LIST_INDEX' => $listIndex,

                                          'LIST_REFER_TO' => $this->PathToNextPage . "?" . $this->dynPG_getContent_organizeUrlQueryString("read_article=".$ROW['id']),

					                   	  'LANG_HOME_READ_MORE' => $this->language[1]->str['lang_general_home_read_more'],

					                      'LANG_HOME_MORE' => $this->language[1]->str['lang_general_home_more']

                                        )

                                    ) );

					$count++;
                }
			}

			unset($_private_articletext);

			$template_str = $this->template[1]->replaceSubTemplate(
                                'listing',

                                $listing,

                                dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/home.tpl'
                            );

            $this->template[1]->addVar('LIST_INDEX', $listIndex );

            $returntext = $this->template[1]->render( $template_str, false );

			echo $returntext;

			return ($returntext);
		}
		// ---------------------------------------------------------------------------
		// END HOME
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		// SEARCH IN ARTICLES
		// ---------------------------------------------------------------------------
        /**
			* procedure SetParam_AA_Group()
			*
			* This function sets the param of the page for showing search results
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_SRCH_ResultPage($str = '') {  $this->_SRCH_ResultPage = $str;  }

		/**
			* procedure Write_ArticleSearch()
			*
			* This function writes the the searchresult page
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return string
			*/
        function Write_ArticleSearch()
		{
            $this->template[1]->addVar('SEARCH_RESULTPAGE', htmlentities($this->_SRCH_ResultPage) );
            $this->template[1]->addVar('LANG_SEARCH_BUTTON', $this->language[1]->str['lang_general_search_button']);

            $returntext = $this->template[1]->render( dirname( __FILE__) . '/tpl/MyCMS/' . $this->template[0] . '/search-form.tpl' );

            echo $returntext;

            return $returntext;
        }
        // ---------------------------------------------------------------------------
		// END SEARCH IN ARTICLES
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// WRITE RANDOM ARTICLE POOL
		// ---------------------------------------------------------------------------
        /**
			* procedure SetParam_POOL_Show()
			*
			* This function sets if the pool is for article (0) or home view (1)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_POOL_Show($int = 0) { $this->_POOL_ShowWhat = $int; /* 0 = article, 1 = home */ }

		/**
			* procedure _POOL_Clear()
			*
			* This function clears the pool for random articles
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function _POOL_Clear() { $this->_POOL_Pool = ''; }

		/**
			* procedure SetParam_POOL_Add()
			*
			* This function adds groups to the article pool
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param arrayOfint: array
			* @return -
			*/
		function SetParam_POOL_Add($arrayOfint = array())
        {
            // Hash 53fdc5d324033d34 means `SeCuReHashRef26112005`
            if ( empty($this->_POOL_Pool) ) {
                $this->_POOL_Pool = implode(',', $arrayOfint);
            } else {
                $_arr_offset      = explode(',', $this->_POOL_Pool);
                $this->_POOL_Pool = implode(',', $_arr_offset);

                foreach ( $arrayOfint as $key=>$value )
                {
                    if ( !in_array($value, $_arr_offset) ) {
                        $this->_POOL_Pool .= ',' . $value;
                    }
                }
            }
        }

		/**
			* procedure Write_RandomArticlePool()
			*
			* This function writes a random article/article list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
        function Write_RandomArticlePool()
		{
            srand( (double)microtime()*1000000 );
            $pool = explode(',', $this->_POOL_Pool);

            switch ( $this->_POOL_ShowWhat )
            {
                case 0:
                    // article
                    $rnd = rand(0, count($pool)-1);

                    $this->SetParam_A_Anytime(true);
                    $this->SetParam_A_IgnoreSeperator(true);
                    $this->SetParam_A_Article($pool[$rnd]);
                    $this->Write_Article();
                break;

                case 1:
                    // home
                    $rnd = rand(0, count($pool)-1);

                    $this->SetParam_A_Anytime(true);
                    $this->SetParam_A_IgnoreSeperator(false);
                    $this->SetParam_A_Article($pool[$rnd]);
                    $this->Write_Article();
                break;

                case 2:
                    // article list
                    $rnd = rand(0, count($pool)-1);

                    $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `GROUP` = '$pool[$rnd]'");

                    $tmpIdxSelector = $this->IdxSelector;
                    $this->IdxSelector = $pool[$rnd];

                    $arr_Shown    = Array();
                    $arr_notShown = Array();

                    for ( $i = 0; $i < mysql_num_rows($mysql_result); $i++ ) {
                        $arr_Shown[$i] = '';
                    }

                    while ($mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC)) {
                        $rnd = rand(0, mysql_num_rows($mysql_result)-1);
                        if ( empty($arr_Shown[$rnd]) ) {
                            $arr_Shown[$rnd] = $mysql_row['id'];
                        } else {
                            $arr_notShown[count($arr_notShown)] = $mysql_row['id'];
                        }
                    }

                    $i = 0;
                    $j = 0;

                    foreach ( $arr_Shown as $key => $value ) {
                        $j++;

                        if ( $this->_AA_Maxview < $j ) {
                            break;
                        }

                        if ( empty($value) ) {
                            if ( !empty($arr_notShown[$i]) ) {
                                $value = $arr_notShown[$i];
                                $i++;
                            }
                        }

                        if ( !empty($value) ) {
                            $this->SetParam_AA_Anytime(TRUE, TRUE);

                            // optional: user can define this berfore calling pool
                            // $this->SetParam_AA_ForceNav(FALSE);
                            // $this->SetParam_AA_CategoryNavigation(FALSE);

                            $this->SetParam_AA_OneArticle($value);
                            $this->Write_AllArticles();
                        }
                    }

                    //print_r($arr_Shown);
                    //echo "<br />";
                    //print_r($arr_notShown);

                    $this->IdxSelector = $tmpIdxSelector;
                break;

                default:
                break;
            }

            return 0;
        }
        // ---------------------------------------------------------------------------
		// END WRITE RANDOM ARTICLE POOL
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// GUESTBOOK
		// ---------------------------------------------------------------------------
        /**
			* procedure Write_Guestbook()
			*
			* This function writes the guestbook
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [echo: boolean]
			* @return string
			*/

		function Write_Guestbook($echo = true)
		{
			if (! $this->plugInExists('DPGguestbook')) {
				return '';
			}

            @define("DYNPG_GUESTBOOK_INTERNAL_STARTED", 1);

            $_gb_obj = write_DynPG_PlugIn_dpgguestbook();

			$_gb_text = $_gb_obj->WriteGuestbook('', false);

			if ( $echo ) {
                echo '<a name="GuestbookStartPosition"></a>' . $_gb_text;
            }

            return ( '<a name="GuestbookStartPosition"></a>' . $_gb_text );
		}
        // ---------------------------------------------------------------------------
		// END GUESTBOOK
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// VOTES
		// ---------------------------------------------------------------------------
		/**
			* procedure Write_Vote()
			*
			* This function writes the voting
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [int: integer]
			* @return -
			*/
		function Write_Vote($int = 0)
		{
			if ( $int != 0 ) {

    			if ( file_exists(dirname(__FILE__)."/handlevotes.php") ) {

    				@include_once dirname(__FILE__)."/handlevotes.php";

    				WriteVote($int, TRUE, $this->PathToCurrPage."?".$this->dynPG_getContent_organizeUrlQueryString(((!getenv("QUERY_STRING")) ? $_SERVER['QUERY_STRING'] : getenv("QUERY_STRING"))), $this->PathToRoot);

    			}

             } else {
                echo "<b>ERROR #3:</b> No vote specified in \"Write_Vote([id])\"! Please specify a vote-id.";
            }
		}
        // ---------------------------------------------------------------------------
		// END VOTES
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// SELECTLIST
		// ---------------------------------------------------------------------------
        /**
			* procedure SetParam_SL_Section()
			*
			* This function sets the section for the select-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_SL_Section($string = '')	 { $this->_SL_Section = $string; }

		/**
			* procedure SetParam_SL_Order()
			*
			* This function sets the kind of arrangement in the selection-list
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_SL_Order($string = 'ASC')	 { $this->_SL_Order = $string; }

		/**
			* procedure SetParam_H_Group()
			*
			* This function sets a limit for shown groups in the treestruct (selection-list)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_SL_Limit($int = 0)	 { $this->_SL_Limit = $int; }

		/**
			* procedure SetParam_SL_Seperator()
			*
			* This function sets the seperator for subgroups
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [string]
			* @return -
			*/
		function SetParam_SL_Separator($string = '---')	 { $this->_SL_Separator = $string; }

        /**
			* procedure TDynPG_MainClass_SelectList_private_List_Successors()
			*
			* This function writes a list of grouptreestruct (subgroups)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param _group_id: integer[, _depth: integer, _output_row: string, _order_by: string, _sort: string, _as_html_list: boolean, _selection: integer, _check_rights: boolean]
			* @return -
			*/
		function TDynPG_MainClass_SelectList_private_List_Successors($_group_id, $_depth = 0, $_output_row = null, $_order_by = null, $_sort = null, $_as_html_list = TRUE, $_selection = null, $_check_rights = TRUE)
        {
            $__result = mysql_query("SELECT DISTINCT
                                            A.*,
                                            B.*,
                                            REPLACE(REPLACE(REPLACE(UPPER(B.`NAME`), '', ''), '', ''), '', '') as NAME
                                         FROM
                                            `dynpg_cms_group_treestruct` AS A
                                            INNER JOIN `dynpg_cms_groups` AS B
                                            ON A.`successor_id_fk` = B.`id`
                                         WHERE
                                            A.`element_id_fk` = '$_group_id'
                                         ORDER BY
                                            B.`$_order_by` $_sort");

            while ( $__row = mysql_fetch_array($__result, MYSQL_ASSOC) ) {
                $_ouput = '<option value="'.htmlentities($this->_SL_Separator).'">'.htmlentities($this->_SL_Separator).'</option>';

                $_ouput .= $_output_row;

                if ( !is_null($__row['successor_id_fk']) ) {
                    $offset = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = '".$__row['successor_id_fk']."'");
                    $__grp_has_Successors = mysql_num_rows($offset) > 0;
                } else {
                    $__grp_has_Successors = FALSE;
                }


                if ( $__grp_has_Successors ) {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth).'', $_ouput);
                } else {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth) . '', $_ouput);
                }

                foreach ( $__row as $key => $value ) {
                    $value = htmlentities(stripslashes($value));

                    if ( $key == 'SHORTTEXT' && !empty($value) ) {
                        $value = '(' . $value . ')';
                    }

                    $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
                }

                if ( $_selection != $__row['id'] ) {
                    $_ouput = str_replace(' selected="selected"', '', $_ouput);
                }

                if ( !$__grp_has_Successors ) {
                    $__off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `GROUP` = $__row[successor_id_fk]");

                    if ( mysql_num_rows($__off_mysql_result) > 0 ) {
                        $_ouput .= '<option value="'.htmlentities($this->_SL_Separator).'">'.htmlentities($this->_SL_Separator).'</option>';
                    }

                    while ( $__off_mysql_row = mysql_fetch_array($__off_mysql_result, MYSQL_ASSOC) ) {
                          $_ouput .= $_output_row;

                          $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth).'', $_ouput);

                          foreach ( $__off_mysql_row as $key => $value ) {
                              $value = htmlentities(stripslashes($value));

                              $_arr_switch_Article = Array('NAME' => 'TITLE');

                              if ( $key == 'TITLE' ) {
                                $key   = 'NAME';
                                $value = ' &gt; ' . $value;
                              }

                              $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
                          }
                      }
                }

                echo $_ouput;

                if ( !is_null($__row['successor_id_fk']) ) {
                    $this->TDynPG_MainClass_SelectList_private_List_Successors($__row['successor_id_fk'], $_depth + 1, $_output_row, $_order_by, $_sort, $_as_html_list, $_selection);
                }

            }
        }

        /**
			* procedure Write_SelectList()
			*
			* This function writes a list of grouptreestruct (maingroups)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param _group_id: integer[, _depth: integer, _output_row: string, _order_by: string, _sort: string, _as_html_list: boolean, _selection: integer, _check_rights: boolean]
			* @return -
			*/
		function Write_SelectList()
		{
            if ( !empty($this->_SL_Section) ) {

                if ( $this->_SL_Limit ) {
                    $__limit = "LIMIT 0, ".$this->_SL_Limit;
                } else {
                    $__limit = "";
                }

                $mysql_result = mysql_query("SELECT DISTINCT
                                                  A.*,
                                                  B.*,
                                                  REPLACE(REPLACE(REPLACE(UPPER(B.`NAME`), '', ''), '', ''), '', '') as NAME
                                               FROM
                                                  `dynpg_cms_group_treestruct` AS A
                                                  INNER JOIN `dynpg_cms_groups` AS B
                                                  ON A.`element_id_fk` = B.`id`
                                               WHERE
                                                  B.`NAME` = '".$this->_SL_Section."'
                                               GROUP BY
                                                  A.`element_id_fk`
                                               ORDER BY
                                                  B.`NAME` ".$this->_SL_Order."
                                               $__limit");

                  $GLOBALS['__HTML_OUT_ROW'] = '<option value="%NAME%">%SYMB% %NAME%</option>';

                  while ( $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC) ) {
                      $_ouput = '<option value="'.htmlentities($this->_SL_Separator).'">'.htmlentities($this->_SL_Separator).'</option>';

                      $_ouput .= $GLOBALS['__HTML_OUT_ROW'];

                      if ( !is_null($mysql_row['successor_id_fk']) ) {
                          $__grp_has_Successors = TRUE;
                      } else {
                          $__grp_has_Successors = FALSE;
                      }

                      if ( $__grp_has_Successors ) {
                          $_ouput = str_replace('%SYMB%', '', $_ouput);
                      } else {
                          $_ouput = str_replace('%SYMB%', '', $_ouput);
                      }

                      foreach ( $mysql_row as $key => $value ) {
                          $value = htmlentities(stripslashes($value));

                          $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
                      }

                      if ( !$__grp_has_Successors ) {
                        $__off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `GROUP` = $mysql_row[element_id_fk]");

                        if ( mysql_num_rows($__off_mysql_result) > 0 ) {
                            $_ouput .= '<option value="'.htmlentities($this->_SL_Separator).'">'.htmlentities($this->_SL_Separator).'</option>';
                        }

                        while ( $__off_mysql_row = mysql_fetch_array($__off_mysql_result, MYSQL_ASSOC) ) {
                            $_ouput .= $GLOBALS['__HTML_OUT_ROW'];

                            foreach ( $__off_mysql_row as $key => $value ) {
                                $value = htmlentities(stripslashes($value));

                                $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
                            }
                        }
                      }

                      echo $_ouput;

                      if ( !is_null($mysql_row['element_id_fk']) ) {
                          $this->TDynPG_MainClass_SelectList_private_List_Successors($mysql_row['element_id_fk'], 1, $GLOBALS['__HTML_OUT_ROW'], 'NAME', 'ASC', FALSE, null, FALSE);
                      }
                  }
            }
		}
        // ---------------------------------------------------------------------------
		// END SELECTLIST
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// GET DATA
		// ---------------------------------------------------------------------------
        /**
			* procedure Write_DBData()
			*
			* This function writes an element of database-table article
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param ShowWhat: string[, Show: boolean]
			* @return string
			*/
		function Write_DBData($ShowWhat, $Show = 0)
		{
            $Puffer = array ("gruppe"		=> "`GROUP`",
							 "titel"		=> "`TITLE`",
							 "lead"			=> "`LEAD`"	,
							 "von"			=> "`DATE_UP`, `TIME_UP`",
							 "bis"			=> "`DATE_TO`, `TIME_TO`",
							 "inhalt"		=> "`CONTENT`",
							 "oeffentlich" 	=> "`ISPUBLIC`",
							 "home"			=> "`ISATHOME`",
							 "erstellt"		=> "`CREATEDATE`",
							 "fixpunkt" 	=> "`DATEFIX`",
							 "besuche"		=> "`SHOWVISITS`",
							 "datum" 		=> "`SHOWDATE`"
							 );

			$ShowWhat = strtolower($ShowWhat);

			if ( !empty($_GET["getformular_id"]) ) {
                $Show = addslashes($_GET["getformular_id"]);
            }

            if ( !$Show ) {
                return "<b>ERROR #5:</b> Could not read article cause: SHOW is zero in `Write_DBData()`! Please set an article-id anyway.";
            }

			$result = "";

			if ( !isset($Puffer[$ShowWhat]) ) return "<b>ERROR #4:</b> `$ShowWhat` could not be associated in `Write_DBData()`! Please enter correct params.";

			$ROW = mysql_fetch_array(mysql_query("SELECT ".$Puffer[$ShowWhat]." FROM `dynpg_cms_article` WHERE `id`='$Show'"), MYSQL_ASSOC);

			switch ($ShowWhat)
			{
    			case "inhalt":
    				$ROW = mysql_fetch_array(mysql_query("SELECT `TEXT` FROM `dynpg_cms_articletexts` WHERE `id`='$ROW[CONTENT]'"), MYSQL_ASSOC);
    				$Puffer[$ShowWhat] = "`TEXT`";
    				break;
    			case "fixpunkt":
    				$ROW["DATEFIX"] = date("d.m.Y",$ROW["DATEFIX"]);
    				break;
			}

			foreach ($ROW as $element) {
                $result .= "$element ";
            }

			echo $result;

            return $result;
		}
        // ---------------------------------------------------------------------------
		// END GET DATA
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// DYNAMIC MENU
		// ---------------------------------------------------------------------------
        function SetParam_VM_Template($string = '_phpmenu') { $this->_VM_Template = $string; }
        function SetParam_VM_Groups($all = TRUE, $array = Array(), $array2 = Array()) { $this->_VM_All_Groups = $all; $this->_VM_Groups = $array; $this->_VM_NotGroups = $array2; }
        function SetParam_VM_ShowArticles($all = TRUE, $array = Array(), $array2 = Array()) { $this->_VM_All_ArticlesFrom = $all; $this->_VM_ArticlesFrom = $array; $this->_VM_ArticlesNotFrom = $array2; }
        function SetParam_VM_Order($array = Array('NAME', 'ASC'))	 { $this->_VM_Order = $array; }
        function SetParam_VM_SetPathToNext($string = '', $int = 0)	 { /* path from root This->PathToRoot */ $this->_VM_PathToNext[$int] = $string; }
        function SetParam_VM_GroupsStructured($bool = TRUE)	 { $this->_VM_GroupsStructured = $bool; }
        function SetParam_VM_BeginLetter($string = '')	 { $this->_VM_BeginLetter = $string; }

        function TDynPG_MainClass_VM_private_replace_general_TPLstrings($string = '') {
            $_arr = Array( 'PATHTOROOT' => $this->PathToRoot );

            foreach ( $_arr as $key => $value ) {
                $string = str_replace('%DYNPG_MENU_CONST_'.$key.'%', $value, $string);
            }

            return $string;
        }

        function TDynPG_MainClass_VM_private_arraySameElements($_array_1, $_array_2)
        {
            $return = Array();
            foreach ( $_array_1 as $key => $value ) {
                if ( in_array($value, $_array_2) ) {
                    $return[count($return) + 1] = $value;
                }
            }

            return $return;
        }

        function TDynPG_MainClass_VM_private_allParents($_Child = null)
        {
            $__takeThisNext = Array('element_id_fk' => 'root_id_fk', 'successor_id_fk' => 'element_id_fk');

            $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = $_Child GROUP BY `element_id_fk`");
            $_thisRow = 'element_id_fk';

            if ( mysql_num_rows($mysql_result) == 0 ) {
                $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `successor_id_fk` = $_Child");
                $_thisRow = 'successor_id_fk';
            }

            $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC);

            $found = Array();

            if ( !is_null($mysql_row['root_id_fk']) ) {
                $found = $this->TDynPG_MainClass_VM_private_allParents($mysql_row[$__takeThisNext[$_thisRow]]);
            }

            if ( !is_null($mysql_row[$__takeThisNext[$_thisRow]]) ) {
                $found[count($found) + 1] = $mysql_row[$__takeThisNext[$_thisRow]];
            }

            return $found;
        }

        function TDynPG_MainClass_VM_private_isParentFrom($_supposed_Child = null, $_supposed_Parent = null)
        {
            $__takeThisNext = Array('element_id_fk' => 'root_id_fk', 'successor_id_fk' => 'element_id_fk');

            $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = $_supposed_Child GROUP BY `element_id_fk`");
            $_thisRow = 'element_id_fk';

            if ( mysql_num_rows($mysql_result) == 0 ) {
                $mysql_result = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `successor_id_fk` = $_supposed_Child");
                $_thisRow = 'successor_id_fk';
            }

            $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC);

            if ( $mysql_row[$__takeThisNext[$_thisRow]] == $_supposed_Parent ) {
                return TRUE;
            }

            if ( is_null($mysql_row['root_id_fk']) ) {
                return FALSE;
            }

            $found = $this->TDynPG_MainClass_VM_private_isParentFrom($mysql_row[$__takeThisNext[$_thisRow]], $_supposed_Parent);

            if ( $found ) {
                return TRUE;
            }
        }

		/**
			* procedure TDynPG_MainClass_VM_private_List_Successors()
			*
			* This function writes the dynamic menu (subgroups)
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param _group_id: integer[, _depth: integer, _order_by: string, _sort: string, _as_html_list: boolean, _selection: integer]
			* @return -
			*/
        function TDynPG_MainClass_VM_private_List_Successors($_group_id, $_depth = 0, $_order_by = null, $_sort = null, $_as_html_list = TRUE, $_selection = null)
        {
            $__result = mysql_query("SELECT DISTINCT
                                            A.*,
                                            B.*
                                         FROM
                                            `dynpg_cms_group_treestruct` AS A
                                            INNER JOIN `dynpg_cms_groups` AS B
                                            ON A.`successor_id_fk` = B.`id`
                                         WHERE
                                            A.`element_id_fk` = '$_group_id'
                                         ORDER BY
                                            B.`$_order_by` $_sort");

            $this->SetParam_RT_Path($this->_VM_Template);
            $_template_Content = $this->read_Template();

            if ( empty($_template_Content['DYNPG_MENU_IF_DEF']) ) {
                $_template_Content['DYNPG_MENU_IF_DEF'] = '';
            }

            $new_depth = TRUE;

            while ( $__row = mysql_fetch_array($__result, MYSQL_ASSOC) ) {
                if ( in_array($__row['id'], $this->_VM_NotGroups) ) {
                    #continue;
                }

                if ( !is_null($__row['successor_id_fk']) ) {
                    $offset = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = '".$__row['successor_id_fk']."'");
                    $__grp_has_Successors = mysql_num_rows($offset) > 0;
                } else {
                    $__grp_has_Successors = FALSE;
                }

                $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => (string)$_depth));
                $_ouput = $_template_Content['DYNPG_MENU_LEVEL'][$_contentId]['CONTENT'];

                if ( $__grp_has_Successors ) {
                    $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => (string)$_depth, 'SUBELEMENTS' => 'TRUE'));

                    if ( $_contentId ) {
                        // this template was specified
                        $_ouput = $_template_Content['DYNPG_MENU_LEVEL'][$_contentId]['CONTENT'];
                    }

                    $_arr_Add_Replace = Array( 'SELECTOR' => 'read_category',
                                               'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[0] );
                } else {
                    $_arr_Add_Replace = Array( 'SELECTOR' => 'read_group',
                                               'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[1] );
                }

                $__template_Str = '%RELPAGE%'."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_category=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("read_article=(\w+)"))), FALSE).'&%SELECTOR%=%DYNPG_MENU_INPUT_ID%&page=0', TRUE);

                foreach ( $_arr_Add_Replace as $key => $value ) {
                    $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
                }

                $_ouput = str_replace('%HREF%', $__template_Str, $_ouput);
                $_ouput = str_replace('%UNIQUE_ID%', md5($_arr_Add_Replace['SELECTOR'] . $__row['id']), $_ouput);

                foreach ( $__row as $key => $value ) {
                    $value = htmlentities(stripslashes($value));

                    $_ouput = str_replace('%DYNPG_MENU_INPUT_'.strtoupper($key).'%', $value, $_ouput);
                }

                if ( $new_depth ) {
                    $new_depth = FALSE;
                    $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'ACTUAL' => 'TRUE'));

                    if ( $_contentId ) {
                        $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['CONTENT'], $_ouput);
                    }
                }

                if ( $this->PageSelector == 'GROUPS' || $this->PageSelector == 'ARTICLES' ) {
                    $_refer = $this->IdxSelector;
                } else {
                    $__off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `id` = ".$this->IdxSelector);
                    $__off_mysql_row = mysql_fetch_array($__off_mysql_result, MYSQL_ASSOC);

                    $_refer = $__off_mysql_row['GROUP'];
                }

                if ( $this->IdxSelector != 'NULL' && $this->PageSelector != 'HOME' ) {
                    if ( $this->TDynPG_MainClass_VM_private_isParentFrom($__row['id'], $_refer) && $_depth - $GLOBALS['_CURRENTLY_SELECTED_ELEMENT']['atDepth'] < 2 ) {
                        $_content[3] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'PARENTSELECTED' => 'TRUE'));
                        $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['CONTENT'], $_ouput);
                    }

                    if ( $this->TDynPG_MainClass_VM_private_isParentFrom($_refer, $__row['id']) ) {
                        $_content[3] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth + 1), 'PARENTSELECTED' => 'TRUE'));
                        $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['CONTENT'], $_ouput);
                    }

                    if ( $_refer == $__row['id'] ) {
                        $_content[3] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth), 'PARENTSELECTED' => 'TRUE'));
                        $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['CONTENT'], $_ouput);
                    }

                    $_all_Parents[1] = $this->TDynPG_MainClass_VM_private_allParents($_refer);
                    $_all_Parents[2] = $this->TDynPG_MainClass_VM_private_allParents($__row['id']);

                    if ( count($this->TDynPG_MainClass_VM_private_arraySameElements($_all_Parents[1], $_all_Parents[2])) > 0 && (count($_all_Parents[2])-count($_all_Parents[1])) < 1 ) {
                        $_content[3] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth), 'PARENTSELECTED' => 'TRUE'));
                        $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['CONTENT'], $_ouput);
                    }
                }

                if ( ( $this->PageSelector == 'GROUPS' || $this->PageSelector == 'ARTICLES' ) && $this->IdxSelector == $__row['id'] ) {
                    $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'SELECTED' => 'TRUE'));

                    $GLOBALS['_CURRENTLY_SELECTED_ELEMENT']['atDepth'] = $_depth;

                    if ( $_contentId ) {
                        // this template was specified
                        $_content[1] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'SELECTED' => 'TRUE', 'ROW' => '1'));
                        $_content[2] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'SELECTED' => 'TRUE', 'ROW' => '2'));

                        if ( $_content[1] > 0 ) {
                            $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="1" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[1]]['CONTENT'], $_ouput);
                        }

                        if ( $_content[2] > 0 ) {
                            $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="2" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[2]]['CONTENT'], $_ouput);
                        }
                    }
                }

                if ( in_array($__row['id'], $this->_VM_NotGroups) ) {
                    $_ouput = '';
                }

                if ( !$__grp_has_Successors ) {
                    $__off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `GROUP` = $__row[successor_id_fk] AND `ISPUBLIC` = 'TRUE'");

                    if ( mysql_num_rows($__off_mysql_result) > 0 ) {
                        $new_depth = TRUE;
                    }

                    while ( $__off_mysql_row = mysql_fetch_array($__off_mysql_result, MYSQL_ASSOC) ) {
                          if ( !$this->_VM_All_ArticlesFrom ) {
                            if ( !in_array($__off_mysql_row['id'], $this->_VM_ArticlesFrom) ) {
                                continue;
                            }
                          }

                          if ( in_array($__off_mysql_row['id'], $this->_VM_ArticlesNotFrom) ) {
                              continue;
                          }

                          $_new_line = $_template_Content['DYNPG_MENU_LEVEL'][$this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => (string)($_depth + 1)), Array('SELECTED' => 'NOMATTER'))]['CONTENT'];

                          if ( $new_depth ) {
                            $new_depth = FALSE;
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)$_depth, 'ACTUAL' => 'TRUE'));

                            if ( $_contentId ) {
                                $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)$_depth.'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['CONTENT'], $_new_line);
                            }
                          }

                          if ( $_refer == $__off_mysql_row['GROUP'] ) {
                            $_content[3] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth + 1), 'PARENTSELECTED' => 'TRUE'));
                            $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)($_depth + 1).'" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[3]]['CONTENT'], $_new_line);
                          }

                          if ( $this->PageSelector == 'ARTICLES_EX' && $this->IdxSelector == $__off_mysql_row['id'] ) {
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth + 1), 'SELECTED' => 'TRUE'));

                            if ( $_contentId ) {
                                // this template was specified
                                $_content[1] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth + 1), 'SELECTED' => 'TRUE', 'ROW' => '1'));
                                $_content[2] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => (string)($_depth + 1), 'SELECTED' => 'TRUE', 'ROW' => '2'));

                                if ( $_content[1] > 0 ) {
                                    $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)($_depth + 1).'" ROW="1" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[1]]['CONTENT'], $_new_line);
                                }

                                if ( $_content[2] > 0 ) {
                                    $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="'.(string)($_depth + 1).'" ROW="2" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[2]]['CONTENT'], $_new_line);
                                }
                            }
                          }

                          $_ouput .= $_new_line;

                          $_arr_Add_Replace = Array( 'SELECTOR' => 'read_article',
                                                     'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[2] );


                          $__template_Str = '%RELPAGE%'."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_category=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("read_article=(\w+)"))), FALSE).'&%SELECTOR%=%DYNPG_MENU_INPUT_ID%&page=0', TRUE);

                          foreach ( $_arr_Add_Replace as $key => $value ) {
                              $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
                          }

                          $_ouput = str_replace('%HREF%', $__template_Str, $_ouput);
                          $_ouput = str_replace('%UNIQUE_ID%', md5($_arr_Add_Replace['SELECTOR'] . $__off_mysql_row['id']), $_ouput);

                          foreach ( $__off_mysql_row as $key => $value ) {
                              $value = htmlentities(stripslashes($value));

                              $_arr_switch_Article = Array('NAME' => 'TITLE');

                              if ( $key == 'TITLE' ) {
                                $key   = 'NAME';
                              }

                              $_ouput = str_replace('%DYNPG_MENU_INPUT_'.strtoupper($key).'%', $value, $_ouput);
                          }
                      }
                }

                echo $this->TDynPG_MainClass_VM_private_replace_general_TPLstrings($this->strip_TemplateTags($_ouput));

                if ( !is_null($__row['successor_id_fk']) ) {
                    $this->TDynPG_MainClass_VM_private_List_Successors($__row['successor_id_fk'], $_depth + 1, $_order_by, $_sort, $_as_html_list, $_selection);
                }

            }
        }

		/**
			* procedure Write_VerticalMenu()
			*
			* This function writes the dynamic menu
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
        function Write_VerticalMenu()
        {
            if ( $this->_VM_All_Groups || count($this->_VM_Groups) > 0 ) {

                if ( count($this->_VM_Groups) > 0 ) {
                    $_select_This = '';
                    foreach ( $this->_VM_Groups as $key => $value ) {
                        $_select_This .= 'B.`id` = \''.$value.'\' OR ';
                    }
                    $_select_This = substr($_select_This, 0, -3);
                } else {
                    $_select_This = 'A.`root_id_fk` IS NULL';
                }

                if ( $this->_VM_GroupsStructured ) {
                    if ( !empty($this->_VM_BeginLetter) ) {
                        $_select_This .= ' AND UPPER(LEFT(B.`NAME`, 1)) = \''.$this->_VM_BeginLetter.'\'';
                    }

                    $mysql_result = mysql_query("SELECT DISTINCT
                                                  A.*,
                                                  B.*
                                               FROM
                                                  `dynpg_cms_group_treestruct` AS A
                                                  INNER JOIN `dynpg_cms_groups` AS B
                                                  ON A.`element_id_fk` = B.`id`
                                               WHERE
                                                  $_select_This
                                               GROUP BY
                                                  A.`element_id_fk`
                                               ORDER BY
                                                  B.`".$this->_VM_Order[0]."` ".$this->_VM_Order[1]);
                } else {
                    if ( !empty($this->_VM_BeginLetter) ) {
                        $_select_This = 'UPPER(LEFT(A.`NAME`, 1)) = \''.$this->_VM_BeginLetter.'\'';
                    } else {
                        $_select_This = '1';
                    }

                    $mysql_result = mysql_query("SELECT DISTINCT
                                            A.*
                                         FROM
                                            `dynpg_cms_groups` AS A
                                         WHERE
                                            $_select_This
                                         ORDER BY
                                            A.`NAME` ASC");
                }

                  $this->SetParam_RT_Path($this->_VM_Template);
                  $_template_Content = $this->read_Template();

                  if ( empty($_template_Content['DYNPG_MENU_IF_DEF']) ) {
                      $_template_Content['DYNPG_MENU_IF_DEF'] = '';
                  }

                  global $_CURRENTLY_SELECTED_ELEMENT;

                  $GLOBALS['_CURRENTLY_SELECTED_ELEMENT']['atDepth'] = null;

                  $new_depth = TRUE;

                  while ( $mysql_row = mysql_fetch_array($mysql_result, MYSQL_ASSOC) ) {
                      if ( in_array($mysql_row['id'], $this->_VM_NotGroups) ) {
                        continue;
                      }

                      if ( !$this->_VM_GroupsStructured ) {
                        $mysql_row['element_id_fk'] = $mysql_row['id'];
                        $mysql_row['successor_id_fk'] = NULL;
                      }

                      if ( !is_null($mysql_row['successor_id_fk']) ) {
                          $__grp_has_Successors = TRUE;
                      } else {
                          $__grp_has_Successors = FALSE;
                      }

                        $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => 'ROOT'));
                        $_ouput = $_template_Content['DYNPG_MENU_LEVEL'][$_contentId]['CONTENT'];

                        if ( $__grp_has_Successors ) {
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => 'ROOT', 'SUBELEMENTS' => 'TRUE'));

                            if ( $_contentId ) {
                                // this template was specified
                                $_ouput = $_template_Content['DYNPG_MENU_LEVEL'][$_contentId]['CONTENT'];
                            }

                            $_arr_Add_Replace = Array( 'SELECTOR' => 'read_category',
                                                       'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[0] );
                        } else {
                            $_arr_Add_Replace = Array( 'SELECTOR' => 'read_group',
                                                       'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[1] );
                        }

                        $__template_Str = '%RELPAGE%'."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_category=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("read_article=(\w+)"))), FALSE).'&%SELECTOR%=%DYNPG_MENU_INPUT_ID%&page=0', TRUE);

                        foreach ( $_arr_Add_Replace as $key => $value ) {
                            $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
                        }

                        $_ouput = str_replace('%HREF%', $__template_Str, $_ouput);
                        $_ouput = str_replace('%UNIQUE_ID%', md5($_arr_Add_Replace['SELECTOR'] . $mysql_row['id']), $_ouput);

                        foreach ( $mysql_row as $key => $value ) {
                            $value = htmlentities(stripslashes($value));

                            $_ouput = str_replace('%DYNPG_MENU_INPUT_'.strtoupper($key).'%', $value, $_ouput);
                        }

                        if ( $new_depth ) {
                            $new_depth = FALSE;
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => 'ROOT', 'ACTUAL' => 'TRUE'));

                            if ( $_contentId ) {
                                $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="ROOT" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['CONTENT'], $_ouput);
                            }
                        }

                        if ( ( $this->PageSelector == 'GROUPS' || $this->PageSelector == 'ARTICLES' ) && $this->IdxSelector == $mysql_row['id'] ) {
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => 'ROOT', 'SELECTED' => 'TRUE'));

                            $GLOBALS['_CURRENTLY_SELECTED_ELEMENT']['atDepth'] = 0;

                            if ( $_contentId ) {
                                // this template was specified
                                $_content[1] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => 'ROOT', 'SELECTED' => 'TRUE', 'ROW' => '1'));
                                $_content[2] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => 'ROOT', 'SELECTED' => 'TRUE', 'ROW' => '2'));

                                if ( $_content[1] > 0 ) {
                                    $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="ROOT" ROW="1" /$>', trim($_template_Content['DYNPG_MENU_IF_DEF'][$_content[1]]['CONTENT']), $_ouput);
                                }

                                if ( $_content[2] > 0 ) {
                                    $_ouput = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="ROOT" ROW="2" /$>', trim($_template_Content['DYNPG_MENU_IF_DEF'][$_content[2]]['CONTENT']), $_ouput);
                                }
                            }
                        } else {
                            $GLOBALS['_CURRENTLY_SELECTED_ELEMENT']['atDepth'] = null;
                        }

                      if ( !$__grp_has_Successors ) {
                        $__off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `GROUP` = $mysql_row[element_id_fk] AND `ISPUBLIC` = 'TRUE'");

                        if ( mysql_num_rows($__off_mysql_result) > 0 ) {
                            $new_depth = TRUE;
                        }

                        while ( $__off_mysql_row = mysql_fetch_array($__off_mysql_result, MYSQL_ASSOC) ) {
                          if ( !$this->_VM_All_ArticlesFrom ) {
                            if ( !in_array($__off_mysql_row['id'], $this->_VM_ArticlesFrom) ) {
                                continue;
                            }
                          }

                          if ( in_array($__off_mysql_row['id'], $this->_VM_ArticlesNotFrom) ) {
                              continue;
                          }

                          $_new_line = $_template_Content['DYNPG_MENU_LEVEL'][$this->private_Array_Match($_template_Content['DYNPG_MENU_LEVEL'], Array('LEVEL_DEF' => '1'), Array('SELECTED' => 'NOMATTER'))]['CONTENT'];

                          if ( $new_depth ) {
                            $new_depth = FALSE;
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => '1', 'ACTUAL' => 'TRUE'));

                            if ( $_contentId ) {
                                $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="1" ROW="'.$_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['ROW'].'" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_contentId]['CONTENT'], $_new_line);
                            }
                          }

                          if ( $this->PageSelector == 'GROUPS' || $this->PageSelector == 'ARTICLES' ) {
                              $_refer = $this->IdxSelector;
                          } else {
                              $___off_mysql_result = mysql_query("SELECT * FROM `dynpg_cms_article` WHERE `id` = ".$this->IdxSelector);
                              $___off_mysql_row = mysql_fetch_array($___off_mysql_result, MYSQL_ASSOC);

                              $_refer = $___off_mysql_row['GROUP'];
                          }

                          if ( $_refer == $__off_mysql_row['GROUP'] ) {
                              $_content[1] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => '1', 'PARENTSELECTED' => 'TRUE', 'ROW' => '2'));
                              $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="1" ROW="2" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[1]]['CONTENT'], $_new_line);
                          }

                          if ( $this->PageSelector == 'ARTICLES_EX' && $this->IdxSelector == $__off_mysql_row['id'] ) {
                            $_contentId = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => '1', 'SELECTED' => 'TRUE'));

                            if ( $_contentId ) {
                                // this template was specified
                                $_content[1] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => '1', 'SELECTED' => 'TRUE', 'ROW' => '1'));
                                $_content[2] = $this->private_Array_Match($_template_Content['DYNPG_MENU_IF_DEF'], Array('LEVEL_DEF' => '1', 'SELECTED' => 'TRUE', 'ROW' => '2'));

                                if ( $_content[1] > 0 ) {
                                    $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="1" ROW="1" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[1]]['CONTENT'], $_new_line);
                                }

                                if ( $_content[2] > 0 ) {
                                    $_new_line = str_replace('<$DYNPG_MENU_INPUT_IF LEVEL_DEF="1" ROW="2" /$>', $_template_Content['DYNPG_MENU_IF_DEF'][$_content[2]]['CONTENT'], $_new_line);
                                }
                            }
                          }

                            $_ouput .= $_new_line;

                            $_arr_Add_Replace = Array( 'SELECTOR' => 'read_article',
                                                       'RELPAGE'  => $this->PathToRoot.$this->_VM_PathToNext[2] );


                            $__template_Str = '%RELPAGE%'."?".$this->dynPG_getContent_organizeUrlQueryString(dynpg_insert_urlheader("read_category=(\w+)", dynpg_insert_urlheader("page=(\w+)", dynpg_insert_urlheader("read_group=(\w+)", dynpg_insert_urlheader("read_article=(\w+)"))), FALSE).'&%SELECTOR%=%DYNPG_MENU_INPUT_ID%&page=0', TRUE);

                            foreach ( $_arr_Add_Replace as $key => $value ) {
                                $__template_Str = preg_replace('/%'.$key.'%/', $value, $__template_Str, 1);
                            }

                            $_ouput = str_replace('%HREF%', $__template_Str, $_ouput);
                            $_ouput = str_replace('%UNIQUE_ID%', md5($_arr_Add_Replace['SELECTOR'] . $__off_mysql_row['id']), $_ouput);

                            foreach ( $__off_mysql_row as $key => $value ) {
                                $value = htmlentities(stripslashes($value));

                                if ( $key == 'TITLE' ) {
                                    $key = 'NAME';
                                }

                                $_ouput = str_replace('%DYNPG_MENU_INPUT_'.strtoupper($key).'%', $value, $_ouput);
                            }

                        }
                      }

                      echo $this->TDynPG_MainClass_VM_private_replace_general_TPLstrings($this->strip_TemplateTags($_ouput));

                      if ( !is_null($mysql_row['element_id_fk']) && $this->_VM_GroupsStructured ) {
                          $this->TDynPG_MainClass_VM_private_List_Successors($mysql_row['element_id_fk'], 1, $this->_VM_Order[0], $this->_VM_Order[1], FALSE, null);
                      }
                  }
            }
        }

        // ---------------------------------------------------------------------------
		// END DYNAMIC MENU
		// ---------------------------------------------------------------------------


        // ---------------------------------------------------------------------------
		// READ TEMPLATE
		// ---------------------------------------------------------------------------
        function SetParam_RT_Path($string = '') { $this->_RT_Path = $string; }

        function strip_TemplateTags($string = '')
        {

            return preg_replace('/<\$(.*?)\$>/', '', $string);
        }

		/**
			* procedure read_Template()
			*
			* This function reads the template
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return array
			*/
		function read_Template()
        {
            $xml_folder = $this->_RT_Path;
        	$xml_filename = 'template.tpl.php';
        	$xml_file_content = file($this->PathToRoot."tpl/$xml_folder/$xml_filename");

            $return = Array();

            $currently_atTag = Array();

            foreach ( $xml_file_content as $pointer => $line ) {
                if ( preg_match('/<\$([^\/]+)\$>/', $line) ) {
                    $_tpl_Tag = preg_replace('/(.*)<\$(.*)\$>(.*)/', '\\2', $line);
                    $offset1  = explode(' ', $_tpl_Tag);

                    $_tpl_Attributes = Array();
                    foreach ( $offset1 as $attribute ) {
                        if ( preg_match('/(.*)="(.*)"/', $attribute) ) {
                            $offset2 = explode('|', preg_replace('/(.*)="(.*)"/', '\\1|\\2', $attribute));
                            $_tpl_Attributes[$offset2[0]] = trim($offset2[1]);
                        } else {
                            $_tpl_Tag = trim($attribute);
                        }
                    }

                    if ( !empty($return[$_tpl_Tag]) ) {
                        $return[$_tpl_Tag][count($return[$_tpl_Tag]) + 1] = $_tpl_Attributes;
                    } else {
                        $return[$_tpl_Tag][1] = $_tpl_Attributes;
                    }

                    $currently_atTag[count($currently_atTag) + 1] = $_tpl_Tag;

                    continue;
                }

                if ( preg_match('/<\$\/(.*)\$>/', $line) ) {
                    unset($currently_atTag[count($currently_atTag)]);
                    continue;
                }

                if ( count($currently_atTag) > 0 ) {
                    if ( empty($return[$currently_atTag[count($currently_atTag)]][count($return[$currently_atTag[count($currently_atTag)]])]['CONTENT']) ) {
                        $return[$currently_atTag[count($currently_atTag)]][count($return[$currently_atTag[count($currently_atTag)]])]['CONTENT'] = $line;
                    } else {
                        $return[$currently_atTag[count($currently_atTag)]][count($return[$currently_atTag[count($currently_atTag)]])]['CONTENT'] .= $line;
                    }
                }
            }

            #echo '<pre>';
            #print_r($return);
            #echo '</pre>';

            return $return;
        }
        // ---------------------------------------------------------------------------
		// END READ TEMPLATE
		// ---------------------------------------------------------------------------

        // ---------------------------------------------------------------------------
		/**
			* procedure private_Array_Match()
			*
			* This function searches for an array inside an array
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param [haystack: array, needle: array, except: array]
			* @return string
			*/		//
        function private_Array_Match($haystack = Array(), $needle = Array(), $except = Array()) {
           if ( !is_array($haystack) || !is_array($needle) ) {
            return 0;
           }

           foreach ( $haystack as $key => $value ) {
            $match = TRUE;
            foreach ( $needle as $__key => $__value  ) {
                $match = ( !empty($value[$__key]) && (string)$value[$__key] == (string)$__value );
                if ( !$match ) {
                    break;
                }
            }

            if ( $match ) {
                foreach ( $except as $__key => $__value  ) {
                    $match = ( empty($value[$__key]) );
                    if ( !$match ) {
                        break;
                    }
                }

                if ( $match ) {
                    return $key;
                }
            }
           }

           return 0;
        } // end->private_Array_Match
        // ---------------------------------------------------------------------------


		// ===========================================================================
		// ===========================================================================


		// ---------------------------------------------------------------------------
		/**
			* procedure Destruct_TDynPG_MainClass()
			*
			* destruct TDynPG_MainClass
			*
			* @package DynPG Frontend Engine
			* @author Daniel Schliebner <mail@ds-develop.de>
			* @version 1.0
			* @access private
			* @copyright Daniel Schliebner, 08.01.2007
			* @param -
			* @return -
			*/
		function Destruct_TDynPG_MainClass()
		{
            if(is_object($this->_cacheLiteObject)){
                $contents = ob_get_contents();
                ob_end_clean();
                echo $contents;
                if(!$this->_cacheLiteObject->get($this->_cacheLiteId) && !$this->cacheLiteDisabled){
                    $this->_cacheLiteObject->save($contents, $this->_cacheLiteId);
                }
                if($this->cacheLiteDisabled){
                    $this->_cacheLiteObject->remove($this->_cacheLiteId);
                }
            }
			@mysql_close($GLOBALS['OPEN_MYSQL_CONNECTION']);
		} // end->destructor
		// ---------------------------------------------------------------------------

	} // end->class

	global $DynPG;
	$GLOBALS["DynPG"] = new TDynPG_MainClass();
?>