/**
 * $Id: editor_plugin_src.js 201 2007-02-12 15:56:56Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	// Load plugin specific language pack
	tinymce.PluginManager.requireLangPack('dynpg_statistics');

	tinymce.create('tinymce.plugins.DynPGStatisticsPlugin', {
		/**
		 * Initializes the plugin, this will be executed after the plugin has been created.
		 * This call is done before the editor instance has finished it's initialization so use the onInit event
		 * of the editor instance to intercept that event.
		 *
		 * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.
		 * @param {string} url Absolute URL to where the plugin is located.
		 */
		init : function(ed, url) {
			// Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');
			ed.addCommand('mcedynpg_statistics', function() {
				ed.execCommand('mceInsertContent', false, '<img src="js/tiny_mce/plugins/dynpg_statistics/img/placeholder.gif" alt="STATISTICS" />');
			});

			// Register example button
			ed.addButton('dynpg_statistics', {
				title : 'dynpg_statistics.desc',
				cmd : 'mcedynpg_statistics',
				image : url + '/img/dynpg_statistics.gif'
			});
		},

		/**
		 * Creates control instances based in the incomming name. This method is normally not
		 * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons
		 * but you sometimes need to create more complex controls like listboxes, split buttons etc then this
		 * method can be used to create those.
		 *
		 * @param {String} n Name of the control to create.
		 * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.
		 * @return {tinymce.ui.Control} New control instance or null if no control was created.
		 */
		createControl : function(n, cm) {
			return null;
		},

		/**
		 * Returns information about the plugin as a name/value array.
		 * The current keys are longname, author, authorurl, infourl and version.
		 *
		 * @return {Object} Name/value array containing information about the plugin.
		 */
		getInfo : function() {
			return {
				longname : 'DynPG Statistic Plugin',
				author : 'DS Develop',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://tinymce.moxiecode.com/tinymce/docs/plugin_emotions.html',
				version : "1.0"
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('dynpg_statistics', tinymce.plugins.DynPGStatisticsPlugin);
})();