<?php
    /**
    * This file is the basic core engine for plugins
    * in DynPG.
    *
    *
    * @package DynPG PlugIn Engine
    * @author Daniel Schliebner
    *
    * (c) 2006 Daniel Schliebner
    */


    // constants for the menu-type in DynPG backend

    define ('C_DYNPG_PLUGIN_SUBMENU'  , 0);
    define ('C_DYNPG_PLUGIN_SINGMENU' , 1);
    define ('C_DYNPG_PLUGIN_ROOTMENU' , 2);


    // public class for new plugins

    class dynpgPlugIn {

        // $PI_selection -> string
        // Property plugin selector, contains the identifier name of
        // the plugin
        var $PI_selection;

        // $HTML_Vmenu -> array
        // Contains menu elements for vertical menu in DynPG backend
        var $HTML_Vmenu;

        // $subFiles -> array
        // Contains the files in backend for the current mode
        var $subFiles;

        function dynpgPlugIn($id_selector = null)
        {
            $this->PI_selection = $id_selector;

            $this->HTML_Vmenu = Array();
            $this->subFiles   = Array();

            register_shutdown_function(array(&$this, 'destroy_dynpgPlugIn'));
        }

        function menuAdd($type = 0, $_title = '', $id_selector = null)
        {
            if ( is_null($id_selector) ) {
                $id_selector = $this->PI_selection;
            }

            $add_str = ( addslashes($_GET["show"]) == $id_selector ) ? '_act' : '';

            if ( $type ) {
                $this->HTML_Vmenu[] =
                    '<tr>' .

                    '	<td align=left valign=center height=40 background="pictures/menu_btn' . $add_str . '.gif" style="background-repeat:no-repeat;background-position:left;" id="bg_change' . $id_selector . '">' .

                    '		<img src="pictures/space.gif" height="0" width="40">' .

                    '		<span class="TinyWhite"><b>' .

                    ( $type == C_DYNPG_PLUGIN_SINGMENU ? '<a href="index.php?show=' . $id_selector . '" class="menu" onMouseOver="switchBackground(\'bg_change' . $id_selector . '\',\'pictures/menu_btn_act.gif\')" onMouseOut="switchBackground(\'bg_change' . $id_selector . '\',\'pictures/menu_btn' . $add_str . '.gif\')">' . htmlentities($_title) . '</a>' : '<span style="font-size: 11px; color: rgb(0, 73, 140);">' . htmlentities($_title) . '</span>' ) .

                    '           </b></span>' .

                    '	</td>' .

                    '</tr>';
            } else {
                $this->HTML_Vmenu[] =
                    '<tr>' .

                    '	<td align=left valign=center height=30 background="pictures/menu_subbtn' . $add_str . '.gif" style="background-repeat:no-repeat;background-position:left;" id="bg_change' . $id_selector . '">' .

                    '		<img src="pictures/space.gif" height="0" width="60">' .

                    '		<span class="TinyWhite"><a href="index.php?show=' . $id_selector . '" class="menu" onMouseOver="switchBackground(\'bg_change' . $id_selector . '\',\'pictures/menu_subbtn_act.gif\')" onMouseOut="switchBackground(\'bg_change' . $id_selector . '\',\'pictures/menu_subbtn' . $add_str . '.gif\')">' . htmlentities($_title) . '</a></span>' .

                    '	</td>' .

                    '</tr>';
            }
        }

        function writeMenu($raw = true)
        {
            $m_str = implode('', $this->HTML_Vmenu);

            if ( $raw ) {
                echo $m_str;
            }

            return $m_str;
        }

        function relate_Selector_Menu($id_selector = null, $page = '')
        {
            $this->subFiles[] = Array($id_selector => $page);
        }

        function checkIf_relation($plugin_destination = '.')
        {
            foreach ( $this->subFiles as $i => $arr_val ) {

                if ( !empty($arr_val[$_GET["show"]]) ) {
                    require $plugin_destination . '/' . $arr_val[$_GET["show"]];
                }

            }
        }

        function plugin_Exists($plugin = '')
        {
            return ( is_dir( dirname( __FILE__ ) . '/' . $plugin ) );
        }

        function destroy_dynpgPlugIn()
        {

        }
    }
?>