<?php
    /**
    * This file is the basic core engine for language support
    * in DynPG.
    *
    *
    * @package DynPG PlugIn Engine
    * @author Daniel Schliebner
    *
    * (c) 2006 Daniel Schliebner
    */

    class TLanguage {

        var $str;


        function TLanguage($language = 'de', $plugin = '') {
            // constructor //

            $this->str = Array();

            if ( !function_exists('callback_Language_' . $language . '_' . strtolower($plugin)) ) {

                trigger_error('Unable to find user callback for language definition "'.$language.'" in Plugin ' . $plugin . '!');

                $language = 'de';

            }

            $_ = call_user_func('callback_Language_' . $language . '_' . strtolower($plugin));

            foreach ( $_ as $k => $v ) {
                $this->str['lang_' . $k] = $v;
            }

            register_shutdown_function(array(&$this, 'destroy_TLanguage'));
        }

        function destroy_TLanguage() {
            // destructor //
        }
    }
?>