<?php
    /**
    * This file performs sets a specific language to the DPGshop
    * Plugin, by default "de".
    *
    * This file includes language data for language "english" alias "en"
    *
    * PLUGIN: eShop
    *
    * @package DynPG PlugIn Engine (Languages)
    * @author Daniel Schliebner
    * @return language data as assocciative array
    */

    // callback_Language_de_dpgshop: -> array
    // Sets language data for language "english"
    function callback_Language_en_general() {

        // instanciate language array
        $_LANG_ = Array();

        // define "new line" placeholder variable
        $N = "\r\n";


        // This definition is more a template but to small for an extra template
        // file so we define it here. In addition to that, this element is parsed
        // with the template processor too.
        $_LANG_['navigation_root_separate_str']          = '&nbsp;<strong>>></strong>&nbsp;';
        $_LANG_['navigation_root_firstelement']          = '<div style="display: inline;" class="breadcrumb_at_{$LIST_INDEX}">{$NAME}</div>';
        $_LANG_['navigation_root_singleelement']         = '<div style="display: inline;" class="breadcrumb_at_{$LIST_INDEX}">{$NAME}</div>';
        $_LANG_['navigation_root_itemelement']           = '<div class="breadcrumb_at_{$LIST_INDEX}">{$SEPERATE}{$TITLE}</div>';


        // date format for dates in the group list
        $_LANG_['general_groups_date_format']            = 'F d, Y';


        // date format for dates in the article list
        $_LANG_['general_articles_create_date_format']   = 'F d, Y';
        $_LANG_['general_articles_fix_date_format']      = 'F d, Y';
        $_LANG_['general_articles_from_date_format']     = 'F d, Y';
        $_LANG_['general_articles_till_date_format']     = 'F d, Y';

        // string for empty search query in article list
        $_LANG_['general_articles_no_search_query']      = '-';


        // date format for dates at detail page
        $_LANG_['general_detail_create_date_format']     = 'F d, Y';
        $_LANG_['general_detail_fix_date_format']        = 'F d, Y';
        $_LANG_['general_detail_from_date_format']       = 'F d, Y';
        $_LANG_['general_detail_till_date_format']       = 'F d, Y';


        // date format for dates at home site
        $_LANG_['general_home_create_date_format']       = 'D, d M Y h:i:s';
        $_LANG_['general_home_fix_date_format']          = 'D, d M Y h:i:s';
        $_LANG_['general_home_from_date_format']         = 'D, d M Y h:i:s';
        $_LANG_['general_home_till_date_format']         = 'D, d M Y h:i:s';


        // form processing
        $_LANG_['forms_errors_number_00']                = '';
        $_LANG_['forms_errors_number_01']                = 'Fehler: You can submit the form only once!';
        $_LANG_['forms_errors_number_02']                = 'Fehler: Internal error #2!';
        $_LANG_['forms_errors_number_03']                = 'Fehler: Wrong referer!';
        $_LANG_['forms_errors_number_04']                = 'Fehler: The valid timespan for this form is over!';
        $_LANG_['forms_errors_number_05']                = 'Fehler: Please fill each required field!';
        $_LANG_['forms_errors_number_06']                = 'Fehler: Please insert a valid e-mail address!';
        $_LANG_['forms_errors_number_07']                = 'Fehler: Please insert a valud url!';
        $_LANG_['forms_errors_number_08']                = 'Fehler: The validation code was incorrect!';
        $_LANG_['forms_errors_number_09']                = 'Fehler: No header information is accepted!';

        return $_LANG_;
    }
?>