<?php
    /**
    * This file performs sets a specific language for DynPG frontend,
    * by default "de".
    *
    * This file includes language data for language "german" alias "de"
    *
    *
    *
    * @package DynPG PlugIn Engine (Languages)
    * @author Daniel Schliebner
    * @return language data as assocciative array
    */

    // callback_Language_de_general: -> array
    // Sets language data for language "german"
    function callback_Language_de_dynpg_backend() {

        // instanciate language array
        $_LANG_ = Array();

		/*
		----------
		Navigation
		----------
		*/

		$_LANG_['menu_left_1']			= 'Dateiverwaltung';
		$_LANG_['menu_left_2']			= 'Gruppen';
		$_LANG_['menu_left_3a']			= 'Artikelbezogene';
		$_LANG_['menu_left_3b']			= 'Texte';

		$_LANG_['menu_top_logout']		= 'Abmelden';
		$_LANG_['menu_top_help']		= 'Update, Hilfe &amp; Support';
		$_LANG_['menu_top_rights']		= 'RechtevergabeCenter';
		$_LANG_['menu_top_settings']	= 'Einstellungen';

		/*--------------------------*/

		$_LANG_['message_success']		= 'Vorgang erfolgreich!';


		/*
		---------------
		Dateiverwaltung
		---------------
		*/

		$_LANG_['file_management_title']	= 'Dateiverwaltung';
		$_LANG_['fileman_yes']				= 'ja';
		$_LANG_['fileman_no']				= 'nein';


		// _filegroups.php (show=100)

		$_LANG_['filegroups_create']		= 'Datei-Gruppe erstellen';
		$_LANG_['filegroups_change']		= 'Datei-Gruppe &auml;ndern';
		$_LANG_['filegroups_name']			= 'Gruppen Name:';
		$_LANG_['filegroups_structure']		= 'Hierarchie:';
		$_LANG_['filegroups_no_maingroup']	= '[ Keine &Uuml;bergruppe... ]';
		$_LANG_['filegroups_shortText']		= 'Kurztext:';
		$_LANG_['filegroups_create_button']	= 'Erstellen';
		$_LANG_['filegroups_change_button']	= '&Auml;ndern';

		$_LANG_['filegroups_openAll']		= 'alle aufklappen';
		$_LANG_['filegroups_closeAll']		= 'alle zuklappen';
		$_LANG_['filegroups_showAll']		= 'alle Dateien anzeigen';
		$_LANG_['filegroups_close_grp']		= 'zuklappen';
		$_LANG_['filegroups_open_grp']		= 'aufklappen';
		$_LANG_['filegroups_tbl_ID']		= 'ID';
		$_LANG_['filegroups_tbl_name']		= 'Datei-Gruppen';
		$_LANG_['filegroups_tbl_files']		= 'Dateien';
		$_LANG_['filegroups_tbl_action']	= 'Aktionen';
		$_LANG_['filegroups_doDelete']		= 'Datei-Gruppe l&ouml;schen...';
		$_LANG_['filegroups_doChange']		= 'Datei-Gruppe &auml;ndern...';

		$_LANG_['filegroups_ask_delete']	= 'M&ouml;chten Sie die ausgew&auml;hlte Datei-Gruppe wirklich l&ouml;schen?';
		$_LANG_['filegroups_error_1']		= '<U>Bitte beachten Sie:</U> Sie d&uuml;rfen keine Gruppe als &Uuml;bergruppe von sich selbst w&auml;hlen!';
		$_LANG_['filegroups_error_2']		= 'Die gew&auml;hlte &Uuml;bergruppe enth&auml;lt bereits Dateien. Verschieben Sie diese erst in eine andere Gruppe';


		// _fileupload.php (show=2)

		$_LANG_['fileupload_fileUpload']	= 'Datei hochladen';
		$_LANG_['fileupload_zipUpload']		= 'Archiv hochladen';
		$_LANG_['fileupload_fileChange']	= 'Datei &amp; Daten &auml;ndern';
		$_LANG_['fileupload_uploadField']	= 'Upload:';
		$_LANG_['fileupload_zipField']		= 'Archiv:';
		$_LANG_['fileupload_titleField']	= 'Titel:';
		$_LANG_['fileupload_descField']		= 'Beschreibung:';
		$_LANG_['fileupload_origName']		= 'Originalnamen beibehalten (i.a. nicht empfohlen)';
		$_LANG_['fileupload_groupField']	= 'Gruppe:';
		$_LANG_['fileupload_available_1']	= '[Datei Nr. ';
		$_LANG_['fileupload_available_2']	= ' ist auf dem Server vorhanden]';
		$_LANG_['fileupload_checkLength']	= 'Textl&auml;nge &uuml;berpr&uuml;fen';
		$_LANG_['fileupload_upload_button']	= 'Hochladen';
		$_LANG_['fileupload_unzip_button']	= 'Entpacken';
		$_LANG_['fileupload_change_button']	= '&Auml;ndern';
		$_LANG_['fileupload_ok_button']		= ' OK ';

		$_LANG_['fileupload_ask_selection']	= 'Wonach m&ouml;chten Sie die Dateien selektieren?';
		$_LANG_['fileupload_sel_1']			= 'Keine Selektion - alle anzeigen';
		$_LANG_['fileupload_sel_2']			= '[ nach Text suchen ]';
		$_LANG_['fileupload_page']			= 'Auf der Seite ';
		$_LANG_['fileupload_entry']			= ' Eintr&auml;ge';
		$_LANG_['fileupload_show_button']	= 'anzeigen';
		$_LANG_['fileupload_allFiles']		= 'Alle Dateien';
		$_LANG_['fileupload_back']			= 'Zur&uuml;ck';
		$_LANG_['fileupload_next']			= 'Weiter';

		$_LANG_['fileupload_tbl_ID']		= 'Nr';
		$_LANG_['fileupload_tbl_name']		= 'Name';
		$_LANG_['fileupload_tbl_desc']		= 'Beschreibung';
		$_LANG_['fileupload_tbl_action']	= 'Aktionen';
		$_LANG_['fileupload_tbl_type']		= 'Typ';
		$_LANG_['fileupload_doChange']		= 'Datei & Daten &auml;ndern...';
		$_LANG_['fileupload_doDelete']		= 'Datei l&ouml;schen...';
		$_LANG_['fileupload_doShow']		= 'Datei betrachten...';
		$_LANG_['fileupload_doEdit']		= 'Datei bearbeiten...';

		$_LANG_['fileupload_chosenFiles']	= 'Ausgew&auml;hlte Dateien:';
		$_LANG_['fileupload_otherGrp']		= 'In andere Gruppe verschieben';
		$_LANG_['fileupload_deleteFast']	= 'Ohne erneute Nachfrage l&ouml;schen';
		$_LANG_['fileupload_doit']			= 'Ausf&uuml;hren';
		$_LANG_['fileupload_ask_delete']	= 'M&ouml;chten Sie die ausgew&auml;hlte Datei wirklich l&ouml;schen?';
		$_LANG_['fileupload_ask_grp']		= 'In welche Gruppe sollen die Dateien verschoben werden?';

		$_LANG_['fileupload_error_1']		= 'Fehler<BR><BR>Sie k&ouml;nnen keine Dateien in eine Gruppe verschieben, welche Untergruppen enth&auml;lt';
		$_LANG_['fileupload_message_1a']	= 'Vorgang teils erfolgreich!<BR>Die hochgeladenen Dateien haben die <b>Nummern ';
		$_LANG_['fileupload_message_1b']	= '</b> erhalten!';
		$_LANG_['fileupload_message_2']		= 'Vorgang <B>nicht</B> erfolgreich!';
		$_LANG_['fileupload_message_2b']	= 'Vorgang <B>teils/nicht</B> erfolgreich!';
		$_LANG_['fileupload_message_3a']	= 'Folgende Dateien konnten nicht hochgeladen werden:';
		$_LANG_['fileupload_message_3b']	= 'Beachten Sie Dateigr&ouml;&szlig;e, Dateityp und Ihre Rechte.</I>';
		$_LANG_['fileupload_message_4a']	= 'Die hochgeladenen Dateien haben die <b>Nummer ';
		$_LANG_['fileupload_message_5a']	= 'Vorgang leider <b>nicht</b> erfolgreich! Bitte &uuml;berpr&uuml;fen Sie folgende Bedingungen:<BR> &bull; Dateigr&ouml;&szlig;e unter ';
		$_LANG_['fileupload_message_5b']	= ' KB <BR> &bull; Dateityp entweder ';
		$_LANG_['fileupload_message_5c']	= '<BR><BR> Folgende Meldung wurde aufgezeichnet:';
		$_LANG_['fileupload_message_5d']	= 'Beachten Sie auch die Ihnen zugeteilten Rechte!';
		$_LANG_['fileupload_message_6a']	= 'Bitte stellen Sie sicher, dass die angegebene Datei eine Zip-Datei ist und dass Sie die Berechtigung haben, Dateien mit der Endung .zip hochzuladen.';
		$_LANG_['fileupload_message_6b']	= 'Das Zip-File hat die maximale Uploadgr&ouml;sse der PHP-Konfiguration &uuml;berschritten. <BR/><BR/>Die Datei hat eine Gr&ouml;sse von';
		$_LANG_['fileupload_message_6c']	= 'Folgende Dateien konnten aufgrund ihrer Endung nicht entpackt werden:';
		$_LANG_['fileupload_message_6d']	= 'Unbekannter Fehler beim Hochladen der Zip-Datei.';
		$_LANG_['fileupload_zipInfo']		= '<i>- Es k&ouml;nnen nur Archive im Dateiformat .zip hochgeladen werden <BR/></i>';
		$_LANG_['fileupload_reason_1']		= 'Gr&ouml;&szlig;e';
		$_LANG_['fileupload_reason_2']		= 'Typ';
		$_LANG_['fileupload_reason_3']		= 'Titel/Url/Beschreibung';


		/*
		-------
		Gruppen
		-------
		*/

		$_LANG_['group_dir_l']				= 'Links';
		$_LANG_['group_dir_r']				= 'Rechts';
		$_LANG_['group_dir_u']				= 'Dr&uuml;ber';
		$_LANG_['group_dir_d']				= 'Drunter';
		$_LANG_['group_yes']				= 'Ja';
		$_LANG_['group_no']					= 'Nein';
		$_LANG_['group_yesAll']				= 'Ja, mit Inhalt und Leadbild';
		$_LANG_['group_public']				= 'Ver&ouml;ffentlichen:';
		$_LANG_['group_public_notfornavi']	= 'Ja, ohne Navigation';
		$_LANG_['group_public_notforsubnavi']	= 'Ja, ohne Sub-Navigation';
		$_LANG_['group_yesVisits']			= 'Ja, Besucher im &ouml;ffentlichen Bereich anzeigen.';
		$_LANG_['group_valueText1']			= ' bitte w&auml;hlen...';
		$_LANG_['group_valueText2']			= ' bitte w&auml;hlen...';
		$_LANG_['group_choseContent']		= 'Inhalt ausw&auml;hlen';
		$_LANG_['group_choseFile']			= 'Datei ausw&auml;hlen';


		// _groups.php (show=1)

		$_LANG_['group_title']				= 'Gruppen verwalten';
		$_LANG_['group_create_button']		= 'Erstellen';
		$_LANG_['group_change_button']		= '&Auml;ndern';
		$_LANG_['group_create']				= 'Gruppe erstellen';
		$_LANG_['group_change']				= 'Gruppe &auml;ndern';
		$_LANG_['group_nameField']			= 'Gruppenname:';
		$_LANG_['group_structure']			= 'Hierarchie:';
		$_LANG_['group_no_maingroup']		= '[ Keine &Uuml;bergruppe... ]';
		$_LANG_['group_shortText']			= '<B>Kurztext:<BR/></B><I>(HTML konform)</I>';
		$_LANG_['group_content']			= 'Gruppeninhalt:';
		$_LANG_['group_preImg']				= 'Vorschaubild:';
		$_LANG_['group_imgAlign']			= 'Bildausrichtung:';
		$_LANG_['group_showVisits']			= 'Besucher anzeigen:';
		$_LANG_['group_index']				= 'Sortierindex:';

		$_LANG_['group_openAll']			= 'alle aufklappen';
		$_LANG_['group_closeAll']			= 'alle zuklappen';
		$_LANG_['group_close_Grp']			= 'zuklappen';
		$_LANG_['group_open_Grp']			= 'aufklappen';
		$_LANG_['group_Tree']				= 'Baum';
		$_LANG_['group_tbl_ID']				= 'ID';
		$_LANG_['group_tbl_index']			= 'Index';
		$_LANG_['group_tbl_name']			= 'Gruppen';
		$_LANG_['group_tbl_action']			= 'Aktionen';
		$_LANG_['group_doDelete']			= 'Gruppe l&ouml;schen...';
		$_LANG_['group_doChange']			= 'Gruppenattribute &auml;ndern...';
		$_LANG_['group_newArticles']		= 'Neue Artikel erfassen in:';
		$_LANG_['group_tothisGrp']			= 'Zur Gruppe von Artikel';
		$_LANG_['group_star1']				= 'Artikel-Nr. die dieser Gruppe zugewiesen ist';
		$_LANG_['group_star2']				= 'Anzahl Artikel in dieser Gruppe';
		$_LANG_['group_tothisGroup']		= 'Artikel-Nr., die dieser Gruppe zugewiesen ist: ';

		$_LANG_['group_message_nosuccess']	= '<i>Vorgang leider <b>nicht</b> erfolgreich!</i>';
		$_LANG_['group_message_1']			= '<br /> <br /><i>Bitte &uuml;berpr&uuml;fen Sie, ob Sie alle n&ouml;tigen Felder ausgef&uuml;llt haben!</i><BR><BR><B>Beachten Sie auch die Ihnen zugeteilten Rechte!</B>';
		$_LANG_['group_message_2']			= 'IHRE GRUPPE WURDE DENNOCH ERSTELLT!<br /><br /><u>Bitte beachten Sie:</u> Sie d&uuml;rfen keine Gruppe, welche Artikel enth&auml;lt, als &uuml;bergeordnete Gruppe ausw&auml;hlen!';
		$_LANG_['group_message_3']			= '<u>Bitte beachten Sie:</u> Sie d&uuml;rfen keine Gruppe, welche Artikel enth&auml;lt, als &uuml;bergeordnete Gruppe ausw&auml;hlen!';
		$_LANG_['group_message_4']			= '<u>Bitte beachten Sie:</u> Sie d&uuml;rfen keine Gruppe, als &Uuml;bergruppe von sich selbst w&auml;hlen!';
		$_LANG_['group_message_5a']			= 'M&ouml;chten Sie die ausgew&auml;hlte Gruppe mit samt ihrem Inhalt (';
		$_LANG_['group_message_5b']			= ' Untergruppen) wirklich l&ouml;schen?';


		// _articles.php (show=3)

		$_LANG_['articles_title']			= 'Artikel bearbeiten';
		$_LANG_['articles_create_button']	= 'Erstellen';
		$_LANG_['articles_change_button']	= '&Auml;ndern';
		$_LANG_['articles_show_button']		= 'anzeigen';
		$_LANG_['articles_do_button']		= 'Ausf&uuml;hren';
		$_LANG_['articles_ok_button']		= 'OK';

		$_LANG_['articles_create']			= 'Artikel erstellen';
		$_LANG_['articles_change']			= 'Artikel &auml;ndern';
		$_LANG_['articles_group']			= 'Gruppe:';
		$_LANG_['articles_group_desc']		= '(es sind nur Gruppen ohne Nachfolgegruppe zul&auml;ssig)';
		$_LANG_['articles_choose']			= ' [ Bitte w&auml;hlen Sie... ]';
		$_LANG_['articles_A_title']			= 'Titel:';
		$_LANG_['articles_lead']			= 'Lead:';
		$_LANG_['articles_content']			= 'Inhalt des Artikels:';
		$_LANG_['articles_limit']			= 'Limitieren:';
		$_LANG_['articles_limit_from']		= 'vom:';
		$_LANG_['articles_limit_to']		= 'bis:';
		$_LANG_['articles_limit_desc']		= 'Lassen Sie die Felder unver&auml;ndert, wenn Sie die Limitierung deaktivieren m&ouml;chten.';
		$_LANG_['articles_time']			= 'Uhr';
		$_LANG_['articles_fixpoint']		= 'Zeitpunkt fixieren:';
		$_LANG_['articles_date']			= 'Datum:';
		$_LANG_['articles_fixpoint_desc']	= 'Lassen Sie dieses Feld frei oder unver&auml;ndert, um keinen Zeitpunkt zu fixieren.';
		$_LANG_['articles_leadImg']			= 'Leadbild:';
		$_LANG_['articles_align']			= 'Ausrichtung:';
		$_LANG_['articles_public']			= 'Ver&ouml;ffentlichen:';
		$_LANG_['articles_public_yes']		= 'Ja, Artikel ver&ouml;ffentlichen.';
		$_LANG_['articles_home']			= 'Artikel auf Home:';
		$_LANG_['articles_home_yes']		= 'Ja, Artikel auf die Startseite (Home).';
		$_LANG_['articles_visits']			= 'Besucher anzeigen:';
		$_LANG_['articles_showDate']		= 'Datum anzeigen:';
		$_LANG_['articles_showDate_yes']	= 'Ja, Datum in der Detail- und Listenansicht anzeigen.';
		$_LANG_['articles_search']			= 'Suchindizes:';
		$_LANG_['articles_search_desc']		= 'Trennen Sie Ihre Suchw&ouml;rter nur mit einem Leerzeichen.';
		$_LANG_['articles_index']			= 'Sortierindex:';

		$_LANG_['articles_expand']			= 'Tabelle expandieren &lt; || &gt;';
		$_LANG_['articles_tighten']			= 'Tabelle zusammenziehen &gt;||&lt;';
		$_LANG_['articles_pages']			= 'Auf der Seite';
		$_LANG_['articles_entry']			= 'Eintr&auml;ge';

		$_LANG_['articles_tbl_ID']			= 'Nr.';
		$_LANG_['articles_tbl_title']		= 'Titel';
		$_LANG_['articles_tbl_lead']		= 'Lead';
		$_LANG_['articles_tbl_limit']		= 'Limitierung';
		$_LANG_['articles_tbl_content']		= 'Inhaltsnr.';
		$_LANG_['articles_tbl_public']		= '&Ouml;ffentlich';
		$_LANG_['articles_tbl_home']		= '@Home';
		$_LANG_['articles_tbl_actions']		= 'Aktionen';
		$_LANG_['articles_tbl_create']		= 'Erstellt';
		$_LANG_['articles_tbl_fixpoint']	= 'Fixiert';
		$_LANG_['articles_tbl_visits']		= 'Besucher <BR> zeigen';
		$_LANG_['articles_tbl_date']		= 'Datum <BR> zeigen';
		$_LANG_['articles_tbl_search']		= 'Suchindizes';
		$_LANG_['articles_tbl_leadImg']		= 'Leadbild';
		$_LANG_['articles_tbl_order']		= 'Sortierung';

		$_LANG_['articles_none']			= 'Keines';
		$_LANG_['articles_changeText']		= 'Artikeltext &auml;ndern...';
		$_LANG_['articles_doWatch']			= 'Artikelinhalt ansehen...';
		$_LANG_['articles_doDuplicate']		= 'Artikel duplizieren...';
		$_LANG_['articles_doChange']		= 'Artikel editieren...';
		$_LANG_['articles_doDelete']		= 'Artikel l&ouml;schen...';
		$_LANG_['articles_doNull']			= 'Besucherz&auml;hler des Artikels auf null setzen...';

		$_LANG_['articles_selectAllArticles']	= 'alle markieren';
		$_LANG_['articles_unselectAllArticles']	= 'nichts markieren';
		$_LANG_['articles_selArticles']		= 'Markierte Artikel:';
		$_LANG_['articles_selMove']			= 'In andere Gruppe verschieben';
		$_LANG_['articles_selDelete']		= 'L&ouml;schen';
		$_LANG_['articles_selNull']			= 'Besucherz&auml;hler auf Null setzen';
		$_LANG_['articles_outOfHome']		= 'Aus Home-Anzeige nehmen';

		$_LANG_['articles_message_1']		= 'In welche Gruppe sollen die Artikel verschoben werden?';
		$_LANG_['articles_message_2']		= 'Fehler<BR><BR>Sie k&ouml;nnen keine Artikel in eine Gruppe verschieben, welche Untergruppen enth&auml;lt';
		$_LANG_['articles_message_3']		= 'Der gew&auml;hlte Artikel wurde dubliziert. Das Dublikat hat die ID';
		$_LANG_['articles_message_4a']		= 'Vorgang leider <b>nicht</b> erfolgreich!<BR><BR>Bitte &uuml;berpr&uuml;fen Sie, ob Sie alle erforderlichen Felder ausgef&uuml;llt haben!';
		$_LANG_['articles_message_4b']		= 'Beachten Sie auch die Ihnen zugeteilten Rechte!';
		$_LANG_['articles_message_5']		= 'M&ouml;chten Sie die (den) ausgew&auml;hlten Artikel wirklich l&ouml;schen?';


		/*
		-----
		Texts
		-----
		*/

		//_texts.php (show=4)

		$_LANG_['texts_title']				= 'Artikelbezogene Texte';
		$_LANG_['texts_preview_button']		= 'Vorschau';
		$_LANG_['texts_create_button']		= 'Erstellen';
		$_LANG_['texts_create2_button']		= 'Text &amp; zugeh&ouml;rigen Artikel erstellen';
		$_LANG_['texts_change_button']		= '&Auml;ndern';
		$_LANG_['texts_change2_button']		= 'Text &amp; zugeh&ouml;rigen Artikel &auml;ndern';
		$_LANG_['texts_move_button']		= 'verschieben';
		$_LANG_['texts_yes']				= ' Ja ';
		$_LANG_['texts_no']					= 'Nein';

		$_LANG_['texts_create']				= 'Text verfassen';
		$_LANG_['texts_change']				= 'Texte &auml;ndern';
		$_LANG_['texts_noJS']				= 'Sollte kein Editor verf&uuml;gbar sein, aktivieren Sie bitte JavaScript oder informieren Sie sich ggf. bei Ihrem Administrator, wie Sie den WYSIWYG Editor auch f&uuml;r Sie verf&uuml;gbar machen.';
		$_LANG_['texts_textgroup']			= 'Textgruppe zuweisen:';
		$_LANG_['texts_noTextgroup']		= ' [ ohne Text-Gruppe ] ';
		$_LANG_['texts_group']				= 'Diesen Artikeltext mit der folgenden Gruppe assoziieren:';
		$_LANG_['texts_noGroup']			= ' [ Keine Gruppe ] ';

		$_LANG_['texts_newGroup']			= 'Neue Text-Gruppe erstellen';
		$_LANG_['texts_groupName']			= 'Gruppen-Name:';

		$_LANG_['texts_texts']				= 'Texte / Text-Gruppen';
		$_LANG_['texts_tbl_ID']				= 'ID';
		$_LANG_['texts_tbl_content']		= 'Inhalt des artikelbezogenen Textes';
		$_LANG_['texts_tbl_actions']		= 'Aktionen';
		$_LANG_['texts_noTexts']			= 'keine Texte in dieser Gruppe';
		$_LANG_['texts_whitoutGroup']		= 'ohne Gruppe';
		$_LANG_['texts_formated']			= '--- Inhalt absolut formatiert ---';
		$_LANG_['texts_doChange']			= 'Artikelbezogenen Text &auml;ndern...';
		$_LANG_['texts_doDuplicate']		= 'Artikelbezogenen Text duplizieren...';
		$_LANG_['texts_doDelete']			= 'Artikelbezogenen Text l&ouml;schen...';

		$_LANG_['texts_preLink1']			= 'Bitte folgen Sie folgendem Link:';
		$_LANG_['texts_preLink2']			= 'Zur Vorschau';

		$_LANG_['texts_moveGroup']			= 'Verschiebe ausgew&auml;hlte Texte in diese Gruppe: ';

		$_LANG_['texts_message_1']			= 'Der Text wurde erstellt, allerdings konnte nicht zur Artikelebene gewechselt werden, weil Sie keine Gruppe ausgew&auml;hlt haben!';
		$_LANG_['texts_message_2']			= 'Der gew&auml;hlte Artikelbezogene Text wurde dupliziert. Das Duplikat hat die ID';
		$_LANG_['texts_message_3a']			= 'Vorgang leider <b>nicht</b> erfolgreich! Bitte &uuml;berpr&uuml;fen Sie ob Sie alle n&ouml;tigen Eingaben get&auml;tigt haben!';
		$_LANG_['texts_message_3b']			= 'Beachten Sie auch die Ihnen zugeteilten Rechte';
		$_LANG_['texts_message_4']			= 'M&ouml;chten Sie den gew&auml;hlten Text wirklich l&ouml;schen?';
		$_LANG_['texts_message_5a']			= 'M&ouml;chten Sie die gew&auml;hlte Gruppe wirklich l&ouml;schen? (Texte werden nach "';
		$_LANG_['texts_message_5b']			= '" verschoben)';


		/*
		-----------------
		Hilfe und Support
		-----------------
		*/

		// _help.php (show=5)

		$_LANG_['help_title']				= 'Hilfe &amp; Support';

		$_LANG_['help_subtitle_1']			= 'Mein Produkt';
		$_LANG_['help_version']				= 'Version:';
		$_LANG_['help_key']					= 'Schl&uuml;ssel:';
		$_LANG_['help_domain']				= 'Domain:';

		$_LANG_['help_subtitle_2']			= 'Ihr Support';
		$_LANG_['help_docu']				= 'Dokumentation';
		$_LANG_['help_state']				= 'Stand';
		$_LANG_['help_dateformat']			= 'd.m.Y';
		$_LANG_['help_support']				= 'Kostenloser Support im offiziellen Supportforum';

		$_LANG_['help_subtitle_3']			= 'Impressum';
		$_LANG_['help_subtitle_3a']			= 'PROGRAMMIERUNG UND UMSETZUNG';
		$_LANG_['help_subtitle_3b']			= 'INITIATOR, KONZEPT &amp; TESTING';
		$_LANG_['help_subtitle_3c']			= 'VERTRIEB';
		$_LANG_['help_germany']				= 'Deutschland:';
		$_LANG_['help_switzerland']			= 'Schweiz:';
		$_LANG_['help_subtitle_3d']			= 'INTERNET';


		/*
		-------------
		Einstellungen
		-------------
		*/

		// _settings.php (show=0)

		$_LANG_['settings_title']			= 'Einstellungen';
		$_LANG_['settings_change_button']	= '&Auml;ndern';
		$_LANG_['settings_delete_button']	= 'L&ouml;schen';
		$_LANG_['settings_create_button']	= 'Anlegen';
		$_LANG_['settings_message_error']	= 'Vorgang leider <b>nicht</b> erfolgreich! Bitte &uuml;berpr&uuml;fen Sie, ob Sie keine der Sonderzeichen (\',\\,") eingegeben haben bzw. ob Sie alle Felder ausgef&uuml;llt haben!';

		$_LANG_['settings_navi_1']			= '1. Passwort/Sprache';
		$_LANG_['settings_subtitle_1a']		= '1.1 Mein Passwort &auml;ndern';
		$_LANG_['settings_subtitle_1b']		= '1.2 Sprache &auml;ndern';
		$_LANG_['settings_name']			= 'Name:';
		$_LANG_['settings_oldPW']			= 'Altes Passwort:';
		$_LANG_['settings_newPW']			= 'Neues Passwort:';
		$_LANG_['settings_repeatPW']		= 'Neues Passwort wiederholen:';
		$_LANG_['settings_message_1a']		= '<b>ACHTUNG:</b> Das Passwort des neuen Benutzers lautet:';
		$_LANG_['settings_message_1b']		= '<b>Bitte legen Sie nun die Rechte des neuen Nutzers fest!</b>';

		$_LANG_['settings_navi_2']			= '2. Meine Rechte';
		$_LANG_['settings_subtitle_2']		= '2. Meine Rechte';
		$_LANG_['settings_create']			= 'Erstellen:';
		$_LANG_['settings_delete']			= 'L&ouml;schen';
		$_LANG_['settings_change']			= '&Auml;ndern:';
		$_LANG_['settings_man_rights']		= 'Rechte vergeben:';
		$_LANG_['settings_man_votes']		= 'Umfragen verwalten:';
		$_LANG_['settings_man_gb']			= 'G&auml;stebuch verwalten:';
		$_LANG_['settings_man_basket']		= 'Warenkorb verwalten:';
		$_LANG_['settings_man_forum']		= 'Forum verwalten:';
		$_LANG_['settings_man_statistics']	= 'Statistiken verwalten:';
		$_LANG_['settings_true']			= 'JA';
		$_LANG_['settings_false']			= 'NEIN';

		$_LANG_['settings_navi_3']			= '3. Benutzerverwaltung';
		$_LANG_['settings_subtitle_3a']		= '3.1 Benutzer l&ouml;schen';
		$_LANG_['settings_subtitle_3b']		= '3.2 Benutzer anlegen';
		$_LANG_['settings_subtitle_3c']		= '3.3 Passwort von anderem Benutzer &auml;ndern';
		$_LANG_['settings_noUser']			= ' [ Kein Benutzer gew&auml;hlt ] ';
		$_LANG_['settings_newPW2']			= 'Neues Passwort:';
		$_LANG_['settings_pwDesc']			= '(Frei lassen, wenn automatisch generiert werden soll.)';
		$_LANG_['settings_mail']			= 'E-Mail:';
		$_LANG_['settings_mailDesc']		= '(Dem Nutzer werden seine Login-Daten an diese Adresse geschickt)';
		$_LANG_['settings_save']			= 'Save:';
		$_LANG_['settings_saveDesc']		= '(E-Mailadresse, in der die neuen Daten archiviert und gesichert werden)';
		$_LANG_['settings_noRights']		= 'Sie haben keine Berechtigung!';
		$_LANG_['settings_user']			= 'Benutzer:';

		$_LANG_['settings_navi_4']			= '4. Auto-Mailtexte';
		$_LANG_['settings_subtitle_4a']		= '4.1 Auto-Mailadressen';
		$_LANG_['settings_subtitle_4b']		= '4.2 Auto-Mailtexte';
		$_LANG_['settings_noMail']			= ' [ Keine Auto-Mailadresse gew&auml;hlt ] ';
		$_LANG_['settings_mailaddress']		= 'E-Mail-Adresse:';
		$_LANG_['settings_noMailtext']		= ' [ Kein Auto-Mailtext gew&auml;hlt ] ';
		$_LANG_['settings_contentType']		= 'Content-Type:';
		$_LANG_['settings_contentText']		= 'Text';
		$_LANG_['settings_contentHtml']		= 'HTML';
		$_LANG_['settings_mailListTitle']	= 'Titel f&uuml;r Auto-Mailliste:';
		$_LANG_['settings_from']			= 'Von:';
		$_LANG_['settings_to']				= 'An:';
		$_LANG_['settings_reply']			= 'Re:';
		$_LANG_['settings_subject']			= 'Betreff:';
		$_LANG_['settings_text']			= 'Text:';

		$_LANG_['settings_navi_5']			= '5. Einstellungen';
		$_LANG_['settings_subtitle_5']		= '5. Einstellungen';
		$_LANG_['settings_max']				= 'Maximale Uploadgr&ouml;sse:';
		$_LANG_['settings_maxKb']			= 'maximal';
		$_LANG_['settings_types']			= 'Erlaube Dateitypen in der Dateiverwaltung:';
		$_LANG_['settings_font']			= 'Schriftartauswahl im Editor zulassen:';
		$_LANG_['settings_editmode']		= 'Frontend-Editiermodus:';
		$_LANG_['settings_yes']				= 'Ja';
		$_LANG_['settings_no']				= 'Nein';
		$_LANG_['settings_language']		= 'Sprache:';

		$_LANG_['settings_navi_6']			= '6. CSS-Vorgabenmanager';
		$_LANG_['settings_subtitle_6']		= '6. CSS-Vorgabenmanager';
		$_LANG_['settings_noClass']			= ' [ Keine Klasse gew&auml;hlt ] ';
		$_LANG_['settings_classname']		= 'Klassenname:';
		$_LANG_['settings_description']		= 'Klartext Beschreibung:';


		/*
		-------------
		Rechtevergabe
		-------------
		*/

		// _rights.php

		$_LANG_['rights_title']				= 'RechtevergabeCenter';
		$_LANG_['rights_noRights']			= 'Sie haben keine Berechtigung zur Rechtevergabe!';
		$_LANG_['rights_none']				= 'keine';

		$_LANG_['rights_ask_1']				= '1. F&uuml;r welchen Benutzer m&ouml;chten Sie die Rechte festlegen?';
		$_LANG_['rights_showUser']			= 'Benutzer anzeigen';
		$_LANG_['rights_user']				= 'Benutzer:';

		$_LANG_['rights_ask_2']				= '2. Auf welche Gruppe m&ouml;chten Sie Rechte verteilen?';
		$_LANG_['rights_showGroups']		= 'Gruppen anzeigen';
		$_LANG_['rights_group']				= 'Gruppe:';
		$_LANG_['rights_noGroup']			= ' [ keine Gruppe... ] ';

		$_LANG_['rights_ask_3']				= '3. M&ouml;chten Sie weitere Rechte festlegen?';
		$_LANG_['rights_showRights3']		= 'weitere Rechte anzeigen';
		$_LANG_['rights_right1']			= 'Benutzer authorisieren, anderen Nutzern Rechte zu erteilen.';
		$_LANG_['rights_right2']			= 'Benutzer authorisieren, Gruppen zu erstellen / administrative Aufgaben zu &uuml;bernehmen.';
		$_LANG_['rights_right3']			= 'Artikel des Benutzers autark belassen (Artikel nur fr Superadmins noch sichtbar)';
		$_LANG_['rights_right4']			= 'Benutzer authorisieren, Umfragen zu erstellen.';
		$_LANG_['rights_right5']			= 'Benutzer authorisieren, das G&auml;stebuch zu verwalten.';
		$_LANG_['rights_right6']			= 'Benutzer authorisieren, den Warenkorb zu verwalten.';
		$_LANG_['rights_right7']			= 'Benutzer authorisieren, das Forum zu verwalten.';
		$_LANG_['rights_right8']			= 'Benutzer authorisieren, die Statistiken zu verwalten.';
		$_LANG_['rights_rightAdmin']		= 'Administrationsrechte &uuml;ber alle Gruppen und Artikel (Superadmin)';
		$_LANG_['rights_Img_a_create']		= 'Darf Artikel erstellen';
		$_LANG_['rights_Img_a_delete']		= 'Darf Artikel l&ouml;schen';
		$_LANG_['rights_Img_a_change']		= 'Darf Artikel &auml;ndern';

		$_LANG_['rights_ask_4']				= 'Rechtevergabe der Gruppe';
		$_LANG_['rights_showRights4']		= 'weitere Rechte anzeigen';
		$_LANG_['rights_grp_right']			= 'Vorgaberechte der Gruppe';
		$_LANG_['rights_art_right']			= 'Artikel der Gruppe';
		$_LANG_['rights_Img_g_create']		= 'Darf Artikel in Gruppe erstellen';
		$_LANG_['rights_Img_g_delete']		= 'Darf Gruppe l&ouml;schen';
		$_LANG_['rights_Img_g_change']		= 'Darf Gruppe &auml;ndern';

		$_LANG_['rights_select']			= '(nicht) markieren:';
		$_LANG_['rights_all']				= 'alle';
		$_LANG_['rights_just_del']			= 'nur l&ouml;schen';
		$_LANG_['rights_just_chg']			= 'nur &auml;ndern';
		$_LANG_['rights_save']				= 'Rechte speichern';


		/*
		---------------
		Bildbearbeitung
		---------------
		*/

		// _file_edit.php

		$_LANG_['fileedit_title']			= 'Bildbearbeitung';
		$_LANG_['fileedit_preview_button']	= 'Vorschau';
		$_LANG_['fileedit_saveNew_button']	= 'Neu Speichern';
		$_LANG_['fileedit_change_button']	= '&Auml;ndern';
		$_LANG_['fileedit_ok_button']		= 'OK';
		$_LANG_['fileedit_no_button']		= 'Nein';
		$_LANG_['fileedit_abort_button']	= 'Abbrechen';
		$_LANG_['fileedit_close']			= 'Fenster schliessen';

		$_LANG_['fileedit_edit']			= 'Bearbeitung';
		$_LANG_['fileedit_resize']			= 'Skalieren';
		$_LANG_['fileedit_size']			= 'Gr&ouml;sse:';
		$_LANG_['fileedit_proportional']	= 'Proportional';
		$_LANG_['fileedit_reflect']			= 'Spiegeln';
		$_LANG_['fileedit_axis']			= 'Achse:';
		$_LANG_['fileedit_axis_v']			= 'vertikal';
		$_LANG_['fileedit_axis_h']			= 'horizontal';
		$_LANG_['fileedit_axis_no']			= 'keine Spiegelung';
		$_LANG_['fileedit_rotation']		= 'Rotieren';
		$_LANG_['fileedit_angle']			= 'Winkel (in ):';
		$_LANG_['fileedit_quality']			= 'Qualit&auml;t';
		$_LANG_['fileedit_value']			= 'Wert (1-100):';
		$_LANG_['fileedit_version']			= 'keine gefunden';

		$_LANG_['fileedit_cut']				= 'Zuschneiden';
		$_LANG_['fileedit_cords']			= 'Koordinaten ab (px):';
		$_LANG_['fileedit_cutsize']			= 'Ausschnitt Gr&ouml;sse (px):';

		$_LANG_['fileedit_oldSize']			= 'Originale Bildgr&ouml;sse:';
		$_LANG_['fileedit_newSize']			= 'Neue Bildgr&ouml;sse:';

		$_LANG_['fileedit_name']			= 'Name:';
		$_LANG_['fileedit_desc']			= 'Beschreibung';
		$_LANG_['fileedit_group']			= 'Gruppe:';

		$_LANG_['fileedit_message_1a']		= 'Wollen Sie das Bild';
		$_LANG_['fileedit_message_1b']		= 'durch das aktuelle Bild ersetzen?';
		$_LANG_['fileedit_message_2']		= 'Zum neuen Bild wechseln';
		$_LANG_['fileedit_message_3']		= 'Fehler beim laden der Bildbearbeitung.<BR>M&ouml;gliche Ursachen:';
		$_LANG_['fileedit_message_4a']		= '- Die gew&auml;hlte Datei existiert nicht.';
		$_LANG_['fileedit_message_4b']		= 'Verzeichnis:';
		$_LANG_['fileedit_message_5a']		= '- Das Dateiformat wird nicht unterst&uuml;tzt.';
		$_LANG_['fileedit_message_5b']		= 'Ihr Format:';
		$_LANG_['fileedit_message_5c']		= 'Unterst&uuml;tzte Formate:';
		$_LANG_['fileedit_message_6a']		= '- Nicht die aktuellste GD-Version vorhanden.';
		$_LANG_['fileedit_message_6b']		= 'Ben&ouml;tigte Version: 2.0.1 oder h&ouml;her';
		$_LANG_['fileedit_message_7a']		= 'GD Version nicht aktuell! (Installierte Version:';
		$_LANG_['fileedit_message_7b']		= 'Ben&ouml;tigte Version: 2.0.1 oder h&ouml;her';
		$_LANG_['fileedit_message_8']		= 'GD-Bibliothek nicht installiert/aktiviert!';
		$_LANG_['fileedit_message_8']		= 'Beim Dateiformat .png wird zurzeit keine Transparenz unterst&uuml;tzt.';


		/*
		-------
		Pop-Ups
		-------
		*/

		// backendpopup/popup.php

		$_LANG_['popup_howtoSelect']		= 'Bitte klicken Sie auf einen Eintrag, um ihn auszuw&auml;hlen.';
		$_LANG_['popup_showOptions']		= 'Anzeigeoptionen';
		$_LANG_['popup_gotoPage']			= 'gehe zu Seite';
		$_LANG_['popup_show']				= 'zeige';
		$_LANG_['popup_entries']			= 'Eintr&auml;ge';
		$_LANG_['popup_searchgroup']		= 'Gruppe:';
		$_LANG_['popup_all_groups']			= '- Alle Gruppen -';
		$_LANG_['popup_searchkey']			= 'Suchwort:';
		$_LANG_['popup_back']				= 'Zur&uuml;ck';
		$_LANG_['popup_next']				= 'Weiter';
		$_LANG_['popup_reload']				= 'Liste neu laden';
		$_LANG_['popup_search']				= 'Suchen';
		$_LANG_['popup_hits']				= 'Treffer';
		$_LANG_['popup_noEntry']			= 'Kein Eintrag w&auml;hlen';

		$_LANG_['popup_bad']				= 'schlecht';
		$_LANG_['popup_soso']				= 'm&auml;ssig';
		$_LANG_['popup_good']				= 'gut';
		$_LANG_['popup_verygood']			= 'sehr gut';

		$_LANG_['popup_message_1']			= 'Keine passenden Eintr&auml;ge gefunden!';
		$_LANG_['popup_message_2']			= 'M&ouml;glicherweise existieren keine Ergebnisse mehr f&uuml;r die Seite';
		$_LANG_['popup_close']				= 'PopUp schliessen';
		$_LANG_['popup_closeW']				= 'Fenster schliessen';

		// for articles (index.res.php)

		$_LANG_['popup_a_title']			= 'Artikel ausw&auml;hlen';
		$_LANG_['popup_a_as1']				= 'ID';
		$_LANG_['popup_a_as2']				= 'Titel';
		$_LANG_['popup_a_as3']				= 'Lead';
		$_LANG_['popup_a_as4']				= 'Suchindizes';

		// for files (index.res.php)

		$_LANG_['popup_f_title']			= 'Bild ausw&auml;hlen';
		$_LANG_['popup_f_as1']				= 'ID';
		$_LANG_['popup_f_as2']				= 'Vorschau';
		$_LANG_['popup_f_as3']				= 'Name';
		$_LANG_['popup_f_as4']				= 'Beschreibung';

		// for texts (index.res.php)

		$_LANG_['popup_t_title']			= 'Artikelbezogenen Text ausw&auml;hlen';
		$_LANG_['popup_t_as1']				= 'ID';
		$_LANG_['popup_t_as2']				= 'Text';


		return $_LANG_;
    }
?>