/**
 * $RCSfile: editor_plugin_src.js,v $
 * $Revision: 1.22 $
 * $Date: 2006/02/10 16:29:39 $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2006, Moxiecode Systems AB, All rights reserved.
 */

/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('formular', 'en,tr,cs,el,fr_ca,it,ko,sv,zh_cn,fa,fr,de,pl,pt_br,nl,da,he,nb,ru,ru_KOI8-R,ru_UTF-8,nn,fi,es,cy,is,pl');

var TinyMCE_FormularPlugin = {
	getInfo : function() {
		return {
			longname : 'Insert formular elements',
			author : 'Daniel Schliebner',
			authorurl : 'http://www.ds-develop.de',
			infourl : 'http://tinymce.moxiecode.com/tinymce/docs/plugin_formular.html',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},

	/**
	 * Returns the HTML contents of the insertdate, inserttime controls.
	 */
	getControlHTML : function(cn) {
		switch (cn) {
			case "formular":
				return tinyMCE.getButtonHTML(cn, 'lang_formular_desc', '{$pluginurl}/images/formular.gif', 'mceformular');
		}

		return "";
	},

	/**
	 * Executes the mceInsertDate command.
	 */
	execCommand : function(editor_id, element, command, user_interface, value) {
		// Handle commands
		switch (command) {
			case "mceformular":
				var template = new Array();

				template['file'] = '../../plugins/formular/popup.php'; // Relative to theme
				template['width'] = 350;
				template['height'] = 250;

				// Language specific width and height addons
				template['width'] += tinyMCE.getLang('lang_formular_delta_width', 0);
				template['height'] += tinyMCE.getLang('lang_formular_delta_height', 0);

				tinyMCE.openWindow(template, {editor_id : editor_id, inline : "yes"});

				return true;
		}

		// Pass to next handler in chain
		return false;
	}
};

tinyMCE.addPlugin("formular", TinyMCE_FormularPlugin);
