/**
 * $RCSfile: editor_plugin_src.js,v $
 * $Revision: 1.23 $
 * $Date: 2006/02/10 16:29:38 $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2006, Moxiecode Systems AB, All rights reserved.
 */

/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('dynpg_separator', 'en,tr,sv,zh_cn,cs,fa,fr_ca,fr,de,pl,pt_br,nl,da,he,nb,hu,ru,ru_KOI8-R,ru_UTF-8,nn,es,cy,is,zh_tw,zh_tw_utf8,sk');

// Plucin static class
var TinyMCE_DynPGSeparatorPlugin = {
	getInfo : function() {
		return {
			longname : 'DynPG Separator Plugin',
			author : 'DS Develop',
			authorurl : 'http://tinymce.moxiecode.com',
			infourl : 'http://tinymce.moxiecode.com/tinymce/docs/plugin_emotions.html',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},

	/**
	 * Returns the HTML contents of the dynpg separator control.
	 */
	getControlHTML : function(cn) {
		switch (cn) {
			case "dynpg_separator":
				return tinyMCE.getButtonHTML(cn, 'lang_dynpg_separator_desc', '{$pluginurl}/images/dynpg_separator.gif', 'mcedynpg_separator');
		}

		return "";
	},

	/**
	 * Executes the mceEmotion command.
	 */
	execCommand : function(editor_id, element, command, user_interface, value) {
		// Handle commands
		switch (command) {
			case "mcedynpg_separator":
				tinyMCE.execInstanceCommand(editor_id, 'mceInsertContent', false, tinyMCE.getParam("plugin_dynpg_separator_bla", '<img src="js/tiny_mce/plugins/dynpg_separator/images/placeholder.gif" alt="SEPARATOR" />'));
				return true;
		}

		// Pass to next handler in chain
		return false;
	}
};

// Register plugin
tinyMCE.addPlugin('dynpg_separator', TinyMCE_DynPGSeparatorPlugin);