<?php
    /**
    * This file is the basic core engine for templates
    * in DynPG.
    *
	* The class TTemplate implements the basic template logic and
    * enables the user to parse a string/file.
    *
    *
    * @version 2.0
	* @package DynPG PlugIn Engine
    * @author Daniel Schliebner
    *
    * (c) 2007 Daniel Schliebner
    */
    class TTemplate {
		// array $rows
    	// Array that contains placeholders and their data to be replaced
		// inside the templates.
		var $rows;

        // boolean $autoRender
    	// If autoRender is boolean true, pseudo if- and php-statements
		// will be rendered directly, otherwise they are kept inside
		// to be replaces later.
		var $autoRender;

		/**
		 * TTemplate::TTemplate()
		 *
		 * Constructor of this class.
		 */
		function TTemplate() {
            // constructor //

            $this->rows = Array();
            $this->autoRender = true;

            register_shutdown_function(array(&$this, 'destroy_TTemplate'));
        }

        /**
         * TTemplate::refresh()
         *
		 * Sets the placeholder-variable to an empty array.
         *
         * @return
         */
        function refresh() {
            $this->rows = Array();
        }

        /**
         * TTemplate::autoRenderOn()
         *
         * Enables automatic rendering (see description of variable $autoRender)
         *
         * @return
         */
        function autoRenderOn() {
        	$this->autoRender = true;
        }

        /**
         * TTemplate::autoRenderOn()
         *
         * Disables automatic rendering (see description of variable $autoRender)
         *
         * @return
         */
		function autoRenderOff() {
        	$this->autoRender = false;
        }

        /**
         * TTemplate::addVar()
         *
         * Add a global placeholder variable.
         *
         * @param string $id
         * @param string $var
         * @param boolean $overwrite
         * @param boolean $scriptVarCallback
         * @return
         */
        function addVar($id = '', $var = '', $overwrite = true, $scriptVarCallback = null) {

            if ( is_callable($scriptVarCallback) ) {
                $var = $scriptVarCallback($var);
            }

            if ( !$overwrite && array_key_exists($id, $this->rows) ) {
                return 0;
            }

            $this->rows[$id] = $var;
        }

        /**
         * TTemplate::getSubTemplate()
         *
         * Read a subTemplate inside a string/file with the name $name.
         * Set $file to false if you want to parse a string instead.
         *
         * @param string $name
         * @param mixed $template
         * @param boolean $file
         * @return string
         */
        function getSubTemplate($name = '', $template = null, $file = true) {

            $_ = $template;

            if ( $file ) {

                if ( file_exists($template) ) {

                    $_ = implode('', file($template));

                    clearstatcache();
                }

            }

            // match the subtemplate area

            if ( preg_match('/<!--[[:space:]]*RepeatedListBegin[[:space:]]*name[[:space:]]*=[[:space:]]*\"{0,1}' . (($name != '')? $name: '[^\"[:space:]]+') . '\"{0,1}[[:space:]]*-->/', $_, $regExBegin) ) {
                $_after_ = $after = substr($_, $_C1 = (strpos($_, $regExBegin[0]) + strlen($regExBegin[0])), strlen($_) - $_C1);

                $_d_ = 0;

                while ( !(isset($end)) || ( isset($end) && !$end ) ) {

                    $_d_++;

                    preg_match('/<!--[[:space:]]*RepeatedListFinish[^-]*-->/', $_after_, $regExEnd);

                    $__ = substr($_after_, 0, strpos($_after_, $regExEnd[0]));

                    $end = !preg_match('/<!--[[:space:]]*RepeatedListBegin[[:space:]]*name[[:space:]]*=[[:space:]]*\"{0,1}[^\"[:space:]]+\"{0,1}[[:space:]]*-->/', $__, $regExOff);

                    if ( !$end ) {
                        $_after_ = str_replace($regExOff[0], str_repeat(' ', strlen($regExOff[0])), $_after_);
                        $_after_ = str_replace($regExEnd[0], str_repeat(' ', strlen($regExEnd[0])), substr($_after_, 0, $_Cx = (strpos($_after_, $regExEnd[0]) + strlen($regExEnd[0])) )) . substr($_after_, $_Cx, strlen($_after_) - $_Cx);
                    }

                    if ( $end ) {
                        $_ = substr($after, 0, strpos($_after_, $regExEnd[0]));
                    }

                    if ( $_d_ > 999 ) { echo '<b>DOS::getSubTemplate</b>'; break; }
                }
            }

            return $_;
        }

        /**
         * TTemplate::replaceSubTemplate()
         *
         * Replaces a subTemplate inside a string/file with the name $name.
         * Set $file to false if you want to parse a string instead.
         *
         * @param string $name
         * @param string $replace
         * @param mixed $template
         * @param boolean $file
         * @return string
         */
		function replaceSubTemplate($name = '', $replace = '', $template = null, $file = true) {

            $_ = $template;

            if ( $file ) {

                if ( file_exists($template) ) {

                    $_ = implode('', file($template));

                    clearstatcache();
                }

            }

			// match the subtemplate area and replace it with $replace

            if ( preg_match('/<!--[[:space:]]*RepeatedListBegin[[:space:]]*name[[:space:]]*=[[:space:]]*\"{0,1}' . (($name != '')? $name: '[^\"[:space:]]+') . '\"{0,1}[[:space:]]*-->/', $_, $regExBegin) ) {
                $_after_ = $after = substr($_, $_C1 = (strpos($_, $regExBegin[0]) + strlen($regExBegin[0])), strlen($_) - $_C1);

                $_d_ = 0;

                while ( !(isset($end)) || ( isset($end) && !$end ) ) {

                    $_d_++;

                    preg_match('/<!--[[:space:]]*RepeatedListFinish[^-]*-->/', $_after_, $regExEnd);

                    $__ = substr($_after_, 0, strpos($_after_, $regExEnd[0]));

                    $end = !preg_match('/<!--[[:space:]]*RepeatedListBegin[[:space:]]*name[[:space:]]*=[[:space:]]*\"{0,1}[^\"[:space:]]+\"{0,1}[[:space:]]*-->/', $__, $regExOff);

                    if ( !$end ) {
                        $_after_ = str_replace($regExOff[0], str_repeat(' ', strlen($regExOff[0])), $_after_);
                        $_after_ = str_replace($regExEnd[0], str_repeat(' ', strlen($regExEnd[0])), substr($_after_, 0, $_Cx = (strpos($_after_, $regExEnd[0]) + strlen($regExEnd[0])) )) . substr($_after_, $_Cx, strlen($_after_) - $_Cx);
                    }

                    if ( $end ) {
                        $_ = str_replace( $regExBegin[0] . substr($after, 0, strpos($_after_, $regExEnd[0])) . $regExEnd[0], $replace, $_ );
                    }

                    if ( $_d_ > 999 ) { echo '<b>DOS::replaceSubTemplate</b>'; break; }
                }
            }

            return $_;
        }

        /**
         * TTemplate::fillTemplate()
         *
         * This is the heart of the template engine. This method parses a
         * complete file or a string and replaces all placeholder variables
         * (global or out of $subRows) and also interprets the pseudo if-
         * and php-statements {$# [...] #} and {$#PHP [...] #}.
         *
         * @param mixed $template
         * @param boolean $file
         * @param array $subRows
         * @return string
         */
        function fillTemplate($template = null, $file = true, $subRows = null) {

            // deduce source
				$_ = $template;

	            if ( $file ) {

	                if ( file_exists($template) ) {

	                    $_ = implode('', file($template));

	                    clearstatcache();
	                }

	            }


			// placeholder replacements

	            if ( is_null($subRows) ) {
	                foreach ( $this->rows as $key => $value ) {

	                    $_ = str_replace('{$' . $key . '}', $value, $_);

	                }
	            }

	            if ( !is_null($subRows) ) {
	                foreach ( $subRows as $key => $value ) {

	                    $_ = str_replace('{$' . $key . '}', $value, $_);

	                }
	            }


            // conditional replacements

	            $CC    = Array('start' => 0, 'end' => 0, 'valid' => false, 'error' => false);
	            $CACHE = Array();

	            while ( preg_match('/\{\$#[[:space:]]([^#]+)#\}/', $_, $matches) ) {

					$_ = substr($_, 0, $_C1 = strpos($_, $matches[0])) .
	                     substr($_, $_C2 = ( $_C1 + strlen($matches[0]) ), strlen($_) - $_C2);

	                // Debug
	                // echo htmlentities($_);
	                // echo "<b>$matches[1]</b>" . htmlentities($_);
	            	// echo '<hr color="red">';

	                if ( strtolower(trim($matches[1])) == 'end' && !$CC['error'] ) {
	                    $CC['end'] = $_C1;

	                    if ( !$CC['valid'] ) {

	                        $_ = substr($_, 0, $CC['start']) .
	                             substr($_, $CC['end'], strlen($_) - $CC['end']);

	                    }

	                    if ( count($CACHE) ) {
	                        $CC = $CACHE[count($CACHE) - 1];
	                        $CACHE = array_slice($CACHE, 0, count($CACHE) - 1);
	                    } else {
	                        $CC = Array('start' => 0, 'end' => 0, 'valid' => false, 'error' => false);
	                    }

	                    // Debug
						// echo '<pre>';
						// print_r($CACHE);
						// echo '</pre>';

	                    continue;
	                }

	                if ( $CC['start'] > 0 ) {
	                    $CACHE[] = $CC;
	                }

	                // Debug
					// echo '<pre>';
					// print_r($CACHE);
					// echo '</pre>';

	                $bool = @call_user_func( @create_function('', 'return (' . trim($matches[1]) . ');') );

	                $CC['valid'] = is_bool($bool) ? $bool : false;
	                $CC['error'] = false;

	                if (!is_bool($bool)) {
	                    $bool = @call_user_func( @create_function('', 'return (' . trim($this->fillTemplate($matches[1], false)) . ');') );

	                    $CC['valid'] = is_bool($bool) ? $bool : false;
	                    $CC['error'] = is_bool($bool) ? false : true;

	                    if ($CC['error'] && $this->autoRender) {
	                        trigger_error('The template conditional statement "<em>'.$matches[0].'</em>" at char #' . $_C1 . ' is incorrect (not boolean or syntax error)'
								. ($file? '; file: ' . $template: '') );

							if ( preg_match('/\{\$([^#\}]+)\}/', $matches[0], $matches_) ) {
	                        	$matches_ = array_splice($matches_, 1);
								$matches_ = implode(' and ', $matches_);
	                        	trigger_error('Reason: unable to parse the template placeholder <em>'.$matches_.'</em>');
	                        }
	                    }

	                    if ($CC['error'] && !$this->autoRender) {
	                    	$_ = substr($_, 0, $_C1) .
								 substr($matches[0], 0, 1) . strtoupper(uniqid('@CACHED', true)) . substr($matches[0], 1, strlen($matches[0])) .
	                     		 substr($_, $_C1, strlen($_) - $_C1);
	                    }
	                }

	                $CC['start'] = $_C1;
	            }

	            $_ = preg_replace('/\{@CACHED[^\$]+\$/', '{$', $_);


            // php code replacements

	            while ( preg_match('/\{\$#PHP[[:space:]]([^#]+)#\}/', $_, $matches) ) {
	                $return = @call_user_func( @create_function('', 'return (' . trim($this->fillTemplate($matches[1], false)) . ');') );

	                $_ = preg_replace('/\{\$\#PHP[[:space:]]([^#]+)\#\}/', $return, $_, 1);

	                // for Debugging
	                if (!isset($x)) $x = 1; else $x++; if ($x>999) break;
	            }


			// for Debugging

				if (isset($x) && $x>999) die('<b>DOS::fillTemplate</b>');

            return $_;
        }

        /**
         * TTemplate::render()
         *
         * This method does the same line TTemplate::fillTemplate() but
         * enables autoRender before parsing.
         *
         * @param mixed $template
         * @param boolean $file
         * @param array $subRows
         * @return string
         */
        function render($template = null, $file = true, $subRows = null) {
			$_ = $this->autoRender;
			$this->autoRenderOn();
			$string = $this->fillTemplate($template, $file, $subRows);
			$this->autoRender = $_;
			return $string;
        }

        /**
         * TTemplate::destroy_TTemplate()
         *
         * The destructor.
         *
         * @return
         */
        function destroy_TTemplate() {
            // destructor //
        }
    }
?>