<?php
class dynPG_guestbook {
    // $property_code -> string
    // String which is generatet by DynPG where Plugin might by inserted in.
    var $property_code;

    // $dynpg_instance -> instance of class TDynPG_MainClass
    // Copy of instance from super global $GLOBALS['DynPG'].
    var $dynpg_instance;

    // $rootToTool -> string
    // Path to the CMS directory in which DynPG has been installed
    var $rootToTool;

    // $rootToPlugin -> string
    // Path to the plugin directory of this plugin
    var $rootToPlugin;

    // $output_Message -> string
    // buffered outputs when succeeded or failed
    var $output_Message;

    // $language -> array[0..1] of [ string | TLanguage ]
    // instaance for current language class (default is "de")
    var $language;

    // $template -> TTemplate
    // instaance for current template processor
    var $template;

    // get some foreign data of DynPG CMS
	function dynPG_guestbook()
    {
        $this->property_code = '';

        if ( isset( $GLOBALS['DynPG'] ) && is_object( $GLOBALS['DynPG'] ) ) {
            $this->dynpg_instance = $GLOBALS['DynPG'];
            $this->rootToTool = $this->dynpg_instance->PathToRoot;
        } else {
            $this->rootToTool = '';
            $this->rootToPlugin = '';
            $this->dynpg_instance = null;
        }

        $this->dynPG_guestbook_setupLanguage($this->dynpg_instance->_PlugIn['dpgguestbook']['language']);

		$this->template = new TTemplate();
	}

    function perform()
    {
        $this->property_code = $this->dynPG_guestbook_HandleguestbookInText();
    }

    function dynPG_guestbook_setupLanguage( $lang = 'de' )
    {
        require_once dirname( __FILE__ ) . '/languages/' . strtolower( $lang ) . '.lang.php';

        $this->language[0] = strtolower( $lang );
        $this->language[1] = new TLanguage( $this->language[0], 'DPGguestbook' );
    }

	function GetGuestbookValue()
	{
        $_SESSION['DYNPG_GB_REFER'] = md5(getenv('HTTP_REFERRER') . getenv('PHP_SELF'));

        if ( empty($_SESSION['DYNPG_GB_RETURN_VALUE']) ) {
            $_SESSION['DYNPG_GB_RETURN_VALUE'] = 0;
        }

        if ( empty($_SESSION['DYNPG_GB_RETURN_DONE']) ) {
            $_SESSION['DYNPG_GB_RETURN_DONE'] = FALSE;
        }

        if ( empty($_SESSION['DYNPG_GB_RETURN_VALID']) ) {
            $_SESSION['DYNPG_GB_RETURN_VALID'] = FALSE;
        }

		if ( $_SESSION['DYNPG_GB_RETURN_VALUE'] > 0 ) {
			$this->template->addVar('ACTION', $_SESSION['DYNPG_GB_RETURN_VALUE'] );
			$this->template->addVar('THIS_PAGE', basename($_SERVER['PHP_SELF']) . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString(preg_replace('/action=(\w+)/', '', getenv('QUERY_STRING')), true) );

			$_gb_return_value = $this->template->fillTemplate(dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgguestbook']['template'] . '/messages.tpl');
		}
		else {
			$_gb_return_value = "";
		}

    	if ( $_SESSION['DYNPG_GB_RETURN_DONE'] ) {
            unset($_SESSION['DYNPG_GB_RETURN_VALUE']);
            unset($_SESSION['DYNPG_GB_RETURN_VALID']);
            unset($_SESSION['DYNPG_GB_RETURN_DONE']);

            return $_gb_return_value;
        } else {
            if ( !empty($_SESSION['DYNPG_GB_ERR']) ) {
				$this->template->addVar('ACTION', 5 );
				$this->template->addVar('ERROR', (($_SESSION['DYNPG_GB_ERR'] * 1878 + 47) * 17) );
				$this->template->addVar('THIS_PAGE',  basename($_SERVER['PHP_SELF']) . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString(preg_replace('/action=(\w+)/', '', getenv('QUERY_STRING')), true) );

				$_gb_return_error = $this->template->fillTemplate(dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgguestbook']['template'] . '/messages.tpl');

			   return $_gb_return_error;
            }
    	}

    	$now = time();

        $_gb_return_value .=
       	'<form action="' . basename($_SERVER['PHP_SELF']) . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString(preg_replace('/action=(\w+)/', '', getenv('QUERY_STRING')) . '&action=new', true) .'" method="post" name="guestbook_submit">';

		$_gb_return_value .= $this->template->fillTemplate(dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgguestbook']['template'] . '/create-form.tpl');

		$_gb_return_value .=
        '
		<input type="hidden" value="'.dynpg_public_create_uniqueID($now).'" name="gb_unique_id" />
        <input type="hidden" value="'.$now.'" name="gb_ts" />
    	</form>
        ';

   		if ( !isset($_GET["site"]) ) $showsite=0;
   			else  $showsite=$_GET["site"];

   		$sql = "SELECT * FROM `dynpg_cms_guestbook` WHERE `code` = 'open'";
   		$res = mysql_query($sql);
   		$gb_entries = mysql_num_rows($res);

   		$sql = "SELECT * FROM `dynpg_cms_guestbook`  WHERE `code` = 'open' ORDER BY `id` DESC LIMIT ".($showsite*$GLOBALS["cfg"]["config_Guestbook_Limit"]).",".$GLOBALS["cfg"]["config_Guestbook_Limit"];
   		$res = mysql_query($sql);

      	$all_sites = ($gb_entries-($gb_entries%$GLOBALS["cfg"]["config_Guestbook_Limit"]))/$GLOBALS["cfg"]["config_Guestbook_Limit"];

   		if ($gb_entries%$GLOBALS["cfg"]["config_Guestbook_Limit"]==0) $all_sites--;

		$page_navi = "";

   		for ($i=0; $i<=$all_sites; $i++)
   		{
 			$page_navi .= "[<a href=\"".$GLOBALS["UseThisPageInClass"]."?site=$i\" class=\"DynPG_General_a_DYNEL_Guestbook\">".($i+1)."</a>]";

   			if ($i!=$all_sites)
   			{
   				$page_navi .= " | ";
   			}
   		}

   		$this->template->addVar('PAGES', $page_navi );
   		$this->template->addVar('TOTALPAGES', $all_sites+1 );
   		$this->template->addVar('MAXPAGES', $GLOBALS["cfg"]["config_Guestbook_Limit"] );

		$_gb_return_value .= $this->template->fillTemplate(dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgguestbook']['template'] . '/page-navigation.tpl');

   		while ($row = mysql_fetch_object($res))
   		{
   			$this->template->addVar('TOOL_DIR', $this->rootToTool );
   			$this->template->addVar('AUTHOR', htmlentities(stripslashes($row->author)) );
			$this->template->addVar('ENTRYDATE', $row->datecreated );
			$this->template->addVar('SUBTEXT', dynpg_htmlentities(stripslashes($row->subtext)) );

			if (!empty($row->hp) && stripslashes($row->hp)!="http://") {
				$this->template->addVar('NOT_EMPTY_HP', 'TRUE' );
				$this->template->addVar('HP', stripslashes($row->hp) );
			}
			else {
				$this->template->addVar('NOT_EMPTY_HP', 'FALSE' );
				$this->template->addVar('HP', '' );
			}

			if( !empty($row->isfrom) ) {
				$this->template->addVar('NOT_EMPTY_FROM', 'TRUE' );
				$this->template->addVar('ISFROM', htmlentities(stripslashes($row->isfrom)) );
			}
			else {
				$this->template->addVar('NOT_EMPTY_FROM', 'FALSE' );
				$this->template->addVar('ISFROM', '' );
			}

			$_gb_return_value .= $this->template->fillTemplate(dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgguestbook']['template'] . '/gb-entries.tpl');
   		}

        unset($_SESSION['DYNPG_GB_RETURN_VALUE']);
        unset($_SESSION['DYNPG_GB_RETURN_VALID']);
        unset($_SESSION['DYNPG_GB_RETURN_DONE']);

        return $_gb_return_value;
	}


	function WriteGuestbook($result = "", $FromClass = false)
    {
		@include_once dirname( __FILE__ )."/guestbookaction.php";

        $result .= $this->GetGuestbookValue();

		if ( $FromClass ) {
			echo '<a name="GuestbookStartPosition"></a>' . $result;
		}

        return ( '<a name="GuestbookStartPosition"></a>' . $result );
    }


	function dynpg_guestbook_HandleguestbookInText()
    {
		@define("DYNPG_GUESTBOOK_INTERNAL_STARTED", 1);

		$result = " ".$this->property_code;

		if (! preg_match('/<img([^<>]+)alt="GUESTBOOK"([^<>]+)\/>/', $result) ) {
            return $result;
        }

        $result = preg_replace( '/<img([^<>]+)alt="GUESTBOOK"([^<>]+)\/>/', "[GUESTBOOK]", $result );

        $i = 0;
        $tpos = 0;
        $pos = true;

        while ( $pos && $tpos < strlen( $result ) ) {
            $i++;
			$pos = strpos( $result, "[GUESTBOOK", $tpos );
            if ( $pos != false ) {
                $votestr = substr( $result, $pos, strpos( $result, "]", $pos ) - $pos + 1 );
                $save_votestr = $votestr;

                $votestr = preg_replace( "'\[GUESTBOOK([^\]]+)*?\]'si", "\\1", $votestr );

                $replacestring = $this->WriteGuestbook( $votestr );

                $result = str_replace( $save_votestr, $replacestring, $result );
            }

            $tpos = $pos + 1;
            $i++;
            if ( $i > 1000 ) {
                break;
            }
        }
        return $result;
    }
}
?>
