<?php
    /**
    * This file performs a user defined workflow (as plugin) over a
    * current code in the DynPG Engine.
    *
    * PLUGIN: Guestbook
    *
    * @package DynPG PlugIn Engine
    * @author Patrick Rufer
    * @return modified source code as string
    */

    // require user-defined plugin class from source

    require_once dirname(__FILE__) . '/handleguestbook.php';


    // USERFUNCTION
    // replaces plugin-specific Code in text
    // callback_DynPG_PlugIn_dpgguestbook: string -> string

    function callback_DynPG_PlugIn_dpgguestbook( $source = '' ) {

        // create new instance of plugin-class

        $my_guestbook_plugin = new dynPG_guestbook();

        $my_guestbook_plugin->property_code = $source;

        $my_guestbook_plugin->perform();

        return $my_guestbook_plugin->property_code;
    }


    // USERFUNCTION
    // returns a string, which contains the plugin
    // write_DynPG_PlugIn_dpgguestbook: [] -> class plugin_dpgguestbook

    function write_DynPG_PlugIn_dpgguestbook() {

        // create new instance of plugin-class

        $my_guestbook_plugin = new dynPG_guestbook();


        // return changed code to DynPG Engine

        return $my_guestbook_plugin;
    }
?>