<?php
    /**
    * This file performs a user defined workflow (as plugin) over a
    * current code in the DynPG Engine.
    *
    * PLUGIN: Dynamic Menu
    *
    * @package DynPG PlugIn Engine
    * @author Daniel Schliebner
    * @return modified source code as string
    */

    // require user-defined plugin class from source

    require_once dirname(__FILE__) . '/dynmenu.class.php';

    // USERFUNCTION
    // manage some things which need to send header information
    // PlugIn_preInitialize_dpgdynmenu: return null

    function PlugIn_preInitialize_dpgdynmenu() {
        return null;
    }


    // USERFUNCTION
    // replaces plugin-specific Code in text
    // callback_DynPG_PlugIn_dpgdynmenu: string -> string

    function callback_DynPG_PlugIn_dpgdynmenu( $source = '' ) {

        // create new instance of plugin-class

        $my_dpgmenu_plugin = new dynPG_Dynamic_Menu();

        $my_dpgmenu_plugin->property_code = $source;

        $my_dpgmenu_plugin->perform();

        return $my_dpgmenu_plugin->property_code;
    }


    // USERFUNCTION
    // returns a string, which contains the plugin
    // write_DynPG_PlugIn_dpgdynmenu: [] -> class plugin_dpgshop

    function write_DynPG_PlugIn_dpgdynmenu() {

        // create new instance of plugin-class

        $my_dpgmenu_plugin = new dynPG_Dynamic_Menu();


        // return changed code to DynPG Engine

        return $my_dpgmenu_plugin;
    }
?>