<?php

/**
* This file includes the main class fpor the dynamic
* menu plugin.
*
* PLUGIN: Dynamic Menu
*
* @package DynPG PlugIn Engine
* @author Daniel Schliebner*
*/

if ( !defined('CASE_LOWER') ) {
    define ( 'CASE_LOWER' , 0 );
}

if ( !defined('CASE_UPPER') ) {
    define ( 'CASE_UPPER' , 1 );
}

class dynPG_Dynamic_Menu {

    // $property_code -> string
    // String which is generatet by DynPG where Plugin might by inserted in.
    var $property_code;

    // $dynpg_instance -> instance of class TDynPG_MainClass
    // Copy of instance from super global $GLOBALS['DynPG'].
    var $dynpg_instance;

    // $rootToTool -> string
    // Path to the CMS directory in which DynPG has been installed
    var $rootToTool;

    // $rootToPlugin -> string
    // Path to the plugin directory in which plugin
    var $rootToPlugin;

    // $output_Message -> string
    // buffered outputs when succeeded or failed
    var $output_Message;

    // $language -> array[0..1] of [ string | TLanguage ]
    // instaance for current language class (default is "de")
    var $language;

    // $template -> TTemplate
    // instance for current template processor
    var $template;

    // $parameters -> array
    // array of parameters for this plugin
    var $parameters;

    function dynPG_Dynamic_Menu() {
        // constructor //

        // 1. initiate variables with default values

        $this->output_Message = '';
        $this->property_code  = '';


        // 2. get some foreign data of DynPG CMS

        if ( isset($GLOBALS['DynPG']) && is_object($GLOBALS['DynPG']) ) {
            $this->dynpg_instance = $GLOBALS['DynPG'];
            $this->rootToTool     = $this->dynpg_instance->PathToRoot;
            $this->rootFromPlugin = dynPG_Dynamic_Menu::realpath($this->rootToTool . '../../') . '/';
        } else {
            $this->rootToTool     = '';
            $this->rootToPlugin   = '';
            $this->dynpg_instance = null;
        }


        // 3. read current language (selected by includes class)

        $this->setupLanguage($this->dynpg_instance->_PlugIn['dpgdynmenu']['language']);


        // 4. instanciate current template processor

        // a) create instance

        $this->template = new TTemplate();

        // b) set some default values

        $this->template->addVar('Main->rootToTool', $this->rootToTool );
        $this->template->addVar('Main->QueryString', htmlentities(getenv('QUERY_STRING')) );
        $this->template->addVar('Main->Host', htmlentities(getenv('HTTP_HOST')) );
        $this->template->addVar('Main->pathToPlugin', 'plugins/DPGdynmenu/' );
        $this->template->addVar('Main->time', time() );

        register_shutdown_function(array(&$this, 'destroy_dynPG_Dynamic_Menu'));


        // 5. connect MySQL

        $this->establish_MySQL_Connection();


        // 6. Include required data

        $this->setupRequirements();


        // 7. read parameters

        // a) instanciate defaults

            $_ = Array(

                        'order' => Array('INDEX'),

                        'sort' => Array('ASC'),

						'order_articles' => Array('INDEX'),

                        'sort_articles' => Array('ASC'),

                        'href_page_groups' => null,

                        'href_page_articles' => null,

                        'href_page_detail' => null,

                        'href_subpages' => Array(),

                        'full_load' => false,

                        'expand_subtree' => Array(),

                        'implode_subtree' => Array()

                      );

        // b) read user defined

            $this->parameters = array_merge($_, $this->dynpg_instance->_PlugIn['dpgdynmenu']['parameters']);
    }

    function array_change_key_case($arr, $case = CASE_LOWER) {
        if (! is_array($arr) ) {
            return $arr;
        }

        $_ = $arr;
        foreach ( $arr as $key => $value ) {
            $_[ $case == CASE_UPPER ? strtoupper($key) : strtolower($key) ] = $value;
        }

        return $_;
    }

    function htmlrealpath($path) {
        $_ = realpath($path);

        return (
			($_ != false)?
			str_replace($_SERVER['DOCUMENT_ROOT'], '', $_):
			$path
		);
    }

    function realpath($path) {
        $_ = realpath($path);

        return (
			($_ != false)?
			$_:
			$path
		);
	}

    function perform() {
        if ( preg_match('/<img([^<>]+)alt="DYNMENU"([^<>]+)\/>/', $this->property_code) ) {
            $dynamic_Menu_HTML4   = $this->writeMenu();
            $this->property_code  = preg_replace('/<img([^<>]+)alt="DYNMENU"([^<>]+)\/>/', $dynamic_Menu_HTML4, $this->property_code);
        }
    }

    function setupLanguage($lang = 'de') {
        require_once dirname( __FILE__ ) . '/languages/'.strtolower($lang).'.lang.php';

        $this->language[0] = strtolower($lang);
        $this->language[1] = new TLanguage($this->language[0], 'DPGdynmenu');
    }

    function establish_MySQL_Connection() {
        require $this->rootToTool . 'connectdb.php';
    }

    function setupRequirements() {
        require_once( dirname( __FILE__ ) . '/__menu_engine.class.php' );
    }

    function setParam($param = '', $value = '') {
        $this->parameters[strtolower($param)] = $value;
    }

    function writeMenu() {
        $this->dynpg_instance->Private_ReconnectMySQL();

        $menuProc = new Tmenu();

        $menu = Array();

        $this->parameters['order'] = array_map(create_function('$val', 'return strtoupper($val);'), $this->parameters['order']);

        $menuProc->list_Successors($menu, null, 0, $this->parameters['order'], $this->parameters['sort']);

        $menuStr = '';

        if ( in_array(strtolower($this->dynpg_instance->PageSelector), Array('groups', 'articles')) ) {
            $self = $this->dynpg_instance->IdxSelector;
            $subE = false;
        } else {
            $self = $menuProc->getParent2Article($this->dynpg_instance->IdxSelector, 'GROUP');
            $subE = true;
        }

        $currentDepth = 0;

        foreach ( $menu as $key => $sub ) {
            if ( $sub[0]['id'] == $self ) {
                $currentDepth = $sub[1];
                break;
            }
        }

        $root_parents = $menuProc->allParents($self);
        $next_parents = $root_parents;
        array_push($next_parents, $self);

        $listOfGroups    = '';
        $leaveDepth      = 0;
        $lastDepth_added = 0;
        $template_row[0] = $this->template->getSubTemplate('listOfGroups', dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgdynmenu']['template'] . '/menu.tpl');

        foreach ( $menu as $key => $sub ) {

            $this_parents = $menuProc->allParents($sub[0]['id']);

            // check if current element is last one of one level so we could realize
            // a folded/unfolded management with CSS
            $leaveDepth = $key > 0? ( $menu[ $key - 1 ][1] - $sub[1] ): 'null';

            // level selection
            $sheetState  = ( // each root elements
                             !count($this_parents)

                             // each element in levels before
                             || ((count($menuProc->arraySameElements($root_parents, $this_parents))==$sub[1]) && $currentDepth > $sub[1])

                             // each elements in same level and same group
                             || ( ($root_parents == $this_parents) && $currentDepth == $sub[1] )

                             // each elements in next level
                             || $this_parents == $next_parents )

                             ? 'expand' : 'collapse';

            if (count($menuProc->arraySameElements($this->parameters['implode_subtree'], $this_parents)) > 0) {
				$sheetState = 'collapse';
            }

			if ( in_array($sub[0]['id'], $this->parameters['expand_subtree']) || $menuProc->isDirectParentFrom($this->parameters['expand_subtree'], $sub[0]['id']) ) {
				$sheetState = 'expand';
            }

			if ( $this->parameters['full_load'] === false ) {
                if ( $sheetState == 'collapse' ) {
                    $menu[ $key ][1] = $key > 0? ( $menu[ $key - 1 ][1] ): 0;
                    continue;
                }
            }

            $lastDepth_added = $sub[1];

            $listitem_id = strtoupper( md5( uniqid('', true) ) );
            $linkQuery   = dynpg_insert_urlheader("read_article=(\w+)",
                                dynpg_insert_urlheader("read_group=(\w+)",
                                    dynpg_insert_urlheader("read_category=(\w+)",
										dynpg_insert_urlheader(
												"t=(\w+)"
										)
									)
                                )
                           );

            if ( !empty($sub[0]['REFID']) ) {
				$t_string = $menuProc->getParent2Article($sub[0]['REFID'], 'TITLE');
				$t_query = "t=".urlencode($t_string);
			} else {
				$t_query = "";
			}

			if ( $sub[2] ) {
                $real = is_null($this->parameters['href_page_groups'])? basename($_SERVER['PHP_SELF']) : $this->dynpg_instance->PathToRoot . $this->parameters['href_page_groups'];
                $link = $real . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString("$linkQuery&$t_query&read_category=-emptyValue-");
            } else {
                $real = is_null($this->parameters['href_page_articles'])? basename($_SERVER['PHP_SELF']) : $this->dynpg_instance->PathToRoot . $this->parameters['href_page_articles'];
                $link = $real . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString("$linkQuery&$t_query&read_group=-emptyValue-");
            }

            if ( array_key_exists($sub[0]['id'], $this->parameters['href_subpages']) ) {
            	$link = $this->dynpg_instance->PathToRoot . (is_array($this->parameters['href_subpages'][$sub[0]['id']])?

						( !empty($this->parameters['href_subpages'][$sub[0]['id']]['page'])?

							$this->parameters['href_subpages'][$sub[0]['id']]['page']:

							call_user_func(create_function('', 'trigger_error("Unconform usage of parameter &gt;href_subpages&lt;: Array-parameter '.
								'<strong>must</strong> have keys \"page\" and \"successors\"!", E_USER_NOTICE); return basename($_SERVER["PHP_SELF"]);'))):

						 $this->parameters['href_subpages'][$sub[0]['id']]);

				if ( strpos($link, '{query}') ) {
            		$link = str_replace('{query}', '', $link) . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString("$linkQuery&$t_query&" . ( $sub[2]? "read_category": "read_group" ) . "=-emptyValue-");
            	}
            } else {
                if ( count( $_ = $menuProc->arraySameElements(array_keys($this->parameters['href_subpages']), $this_parents) ) ) {
                    $selID = call_user_func( create_function('$mP, $aR, $curObj', '$g = Array(-1, -1); foreach($aR as $k_ => $v_) { $g = (($__ = count($mP->allParents($v_))) > $g[0] && in_array($v_, array_keys($curObj->parameters["href_subpages"])))? Array($__, $v_): $g; } return $g[1];'), $menuProc, $this_parents, $this );

					unset($lambda_page);
                    unset($lambda_successors);

					if ( is_array($this->parameters['href_subpages'][$selID]) ) {
						extract($this->parameters['href_subpages'][$selID], EXTR_PREFIX_ALL, 'lambda');

                    	if ( empty($lambda_page) || !isset($lambda_successors) ) {
                    		$lambda_page = basename($_SERVER['PHP_SELF']);
                    		$lambda_successors = false;
                    		trigger_error('Unconform usage of parameter &gt;href_subpages&lt;: Array-parameter <strong>must</strong> have keys "page" and "successors"!', E_USER_NOTICE);
                    	}
                    } else {
                    	$lambda_page = $this->parameters['href_subpages'][$selID];
                    	$lambda_successors = true;
                    }

					if ($lambda_successors) {
						$link = $this->dynpg_instance->PathToRoot . $lambda_page . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString("$linkQuery&$t_query&" . ( $sub[2]? "read_category": "read_group" ) . "=-emptyValue-");
					}

					if ( strpos($link, '{query}') ) {
	            		$link = str_replace('{query}', '', $link);
	            	}
                }
            }

            $real = is_null($this->parameters['href_page_detail'])? basename($_SERVER['PHP_SELF']) : $this->dynpg_instance->PathToRoot . $this->parameters['href_page_detail'];

            $link = dynPG_Dynamic_Menu::htmlrealpath($link);

            $listOfArticles  = '';
            $template_row[1] = $this->template->getSubTemplate('listOfArticles', $template_row[0], false);

            $this_articles = $menuProc->getArticles2Parent($sub[0]['id'], $this->parameters['order_articles'], $this->parameters['sort_articles']);

            foreach ( $this_articles as $article ) {
                if (in_array($sub[0]['id'], $this->parameters['implode_subtree'])) {
					break;
	            }

				if ( $this->parameters['full_load'] === false && !in_array($sub[0]['id'], $this_parents) && !in_array($sub[0]['id'], $this->parameters['expand_subtree']) ) {
                    if ( $self != $sub[0]['id'] ) {
                        continue;
                    }
                }

                $article = dynPG_Dynamic_Menu::array_change_key_case($article, CASE_UPPER);

                $listOfArticles .= $this->template->fillTemplate(

                                        $template_row[1] ,

                                        false ,

                                        array_merge(

                                            $article,

                                            Array (

                                              'M_HAS_SUCCESSORS' => 'False',

                                              'M_DEPTH' => $sub[1] + 1,

                                              'M_ACTIVE' => $subE && $article['id'] == $this->dynpg_instance->IdxSelector  ? 'True' : 'False',

                                              'M_STATE' => ($self == $sub[0]['id'] || in_array($sub[0]['id'], $this->parameters['expand_subtree'])) ? 'expand' : 'collapse',

                                              'M_UNIQUE_ID' => strtoupper( md5( uniqid('', true) ) ),

                                              'M_LINK' => dynPG_Dynamic_Menu::htmlrealpath($real . '?' . $this->dynpg_instance->dynPG_getContent_organizeUrlQueryString("$linkQuery&t=".urldecode($article['TITLE'])."&read_article=" . $article['ID'])),

                                              'M_ISGROUP' => 'False'

                                            )

                                        )

                                    );
            }

            $template_row[2] = $this->template->replaceSubTemplate('listOfArticles', $listOfArticles, $template_row[0], false);

            $thisRow = dynPG_Dynamic_Menu::array_change_key_case($sub[0], CASE_UPPER);
            $thisRow = array_map(create_function('$val', 'return htmlentities(stripslashes($val));'), $thisRow);

			$listOfGroups .= $this->template->fillTemplate(

                            $template_row[2] ,

                            false ,

                            array_merge(

                                $thisRow,

                                Array (

                                  'M_HAS_SUCCESSORS' => $sub[2] ? 'True' : 'False',

                                  'M_DEPTH' => $sub[1],

                                  'M_LEAVE_DEPTH' => $leaveDepth,

                                  'M_ACTIVE' => !$subE && $self == $sub[0]['id'] ? 'True' : 'False',

                                  'M_STATE' => $sheetState,

                                  'M_UNIQUE_ID' => $listitem_id,

                                  'M_LINK' => str_replace('-emptyValue-', $thisRow['ID'], $link),

                                  'M_ISGROUP' => 'True'

                                )
                            ) );
        }

        return $this->template->fillTemplate(
					$this->template->fillTemplate(
						$this->template->replaceSubTemplate('listOfGroups', $listOfGroups, dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgdynmenu']['template'] . '/menu.tpl'),
						false,
                        Array(
                        	// last shown element, add leave depth html elements
							'M_LEAVE_DEPTH' => ($lastDepth_added - 1)
                        )
				    ),
				    false
			   );
    }

    function destroy_dynPG_Dynamic_Menu() {
        // destructor //
    }

}

?>