<?php
    /**
    * This file performs sets a specific language for DynPG frontend,
    * by default "de".
    *
    * This file includes language data for language "english" alias "en"
    *
    *
    *
    * @package DynPG PlugIn Engine (Languages)
    * @author Daniel Schliebner
    * @return language data as assocciative array
    */

    // callback_Language_de_general: -> array
    // Sets language data for language "english"
    function callback_Language_en_dynpg_backend() {

        // instanciate language array
        $_LANG_ = Array();

		/*
		----------
		Navigation
		----------
		*/

		$_LANG_['menu_left_1']			= 'File management';
		$_LANG_['menu_left_2']			= 'Groups';
		$_LANG_['menu_left_3a']			= 'Texts';
		$_LANG_['menu_left_3b']			= '';

		$_LANG_['menu_top_logout']		= 'Logout';
		$_LANG_['menu_top_help']		= 'Update, help &amp; support';
		$_LANG_['menu_top_rights']		= 'Assignment of user rights';
		$_LANG_['menu_top_settings']	= 'Settings';

		/*--------------------------*/

		$_LANG_['message_success']			= 'Procedure successful!';


		/*
		---------------
		File management
		---------------
		*/

		$_LANG_['file_management_title']	= 'File management';
		$_LANG_['fileman_yes']				= 'yes';
		$_LANG_['fileman_no']				= 'no';


		// _filegroups.php (show=100)

		$_LANG_['filegroups_create']		= 'Create file-group';
		$_LANG_['filegroups_change']		= 'Edit file-group';
		$_LANG_['filegroups_name']			= 'Groupname:';
		$_LANG_['filegroups_structure']		= 'Hierarchy:';
		$_LANG_['filegroups_no_maingroup']	= '[ No supergroup... ]';
		$_LANG_['filegroups_shortText']		= 'Short text:';
		$_LANG_['filegroups_create_button']	= 'Create';
		$_LANG_['filegroups_change_button']	= 'Edit';

		$_LANG_['filegroups_openAll']		= 'open all';
		$_LANG_['filegroups_closeAll']		= 'close all';
		$_LANG_['filegroups_showAll']		= 'show all files';
		$_LANG_['filegroups_close_grp']		= 'close';
		$_LANG_['filegroups_open_grp']		= 'open';
		$_LANG_['filegroups_tbl_ID']		= 'ID';
		$_LANG_['filegroups_tbl_name']		= 'File-group';
		$_LANG_['filegroups_tbl_files']		= 'Files';
		$_LANG_['filegroups_tbl_action']	= 'Actions';
		$_LANG_['filegroups_doDelete']		= 'delete file-group...';
		$_LANG_['filegroups_doChange']		= 'edit file-group...';

		$_LANG_['filegroups_ask_delete']	= 'Do you really want delete this group?';
		$_LANG_['filegroups_error_1']		= '<U>Please attend:</U> You are not allowed to select a group as supergroup of itself!';
		$_LANG_['filegroups_error_2']		= 'The selected supergroup contains files. Please move them first into another group.';


		// _fileupload.php (show=100)

		$_LANG_['fileupload_fileUpload']	= 'Upload file';
		$_LANG_['fileupload_zipUpload']		= 'Upload Zip-File';
		$_LANG_['fileupload_fileChange']	= 'Edit file';
		$_LANG_['fileupload_uploadField']	= 'Upload:';
		$_LANG_['fileupload_zipField']		= 'Zip-file:';
		$_LANG_['fileupload_titleField']	= 'Title:';
		$_LANG_['fileupload_descField']		= 'Description:';
		$_LANG_['fileupload_origName']		= 'Keep original name of file (in general not recommended)';
		$_LANG_['fileupload_groupField']	= 'Group:';
		$_LANG_['fileupload_available_1']	= '[File Nr. ';
		$_LANG_['fileupload_available_2']	= ' is available on the server]';
		$_LANG_['fileupload_checkLength']	= 'check text-length';
		$_LANG_['fileupload_upload_button']	= 'Upload';
		$_LANG_['fileupload_unzip_button']	= 'Unzip';
		$_LANG_['fileupload_change_button']	= 'Edit';
		$_LANG_['fileupload_ok_button']		= ' OK ';

		$_LANG_['fileupload_ask_selection']	= 'Which files should be shown?';
		$_LANG_['fileupload_sel_1']			= 'No selection - show all';
		$_LANG_['fileupload_sel_2']			= '[ search for this text ]';
		$_LANG_['fileupload_page']			= 'On page ';
		$_LANG_['fileupload_entry']			= ' entries';
		$_LANG_['fileupload_show_button']	= ' go ';
		$_LANG_['fileupload_allFiles']		= 'All files';
		$_LANG_['fileupload_back']			= 'back';
		$_LANG_['fileupload_next']			= 'next';

		$_LANG_['fileupload_tbl_ID']		= 'Nr';
		$_LANG_['fileupload_tbl_name']		= 'Name';
		$_LANG_['fileupload_tbl_desc']		= 'Description';
		$_LANG_['fileupload_tbl_action']	= 'Actions';
		$_LANG_['fileupload_tbl_type']		= 'Type';
		$_LANG_['fileupload_doChange']		= 'Edit file...';
		$_LANG_['fileupload_doDelete']		= 'Delete file...';
		$_LANG_['fileupload_doShow']		= 'View file...';
		$_LANG_['fileupload_doEdit']		= 'Edit file...';

		$_LANG_['fileupload_chosenFiles']	= 'Selected files:';
		$_LANG_['fileupload_otherGrp']		= 'Move into another group';
		$_LANG_['fileupload_deleteFast']	= 'Delete without request';
		$_LANG_['fileupload_doit']			= ' go ';
		$_LANG_['fileupload_ask_delete']	= 'Would you really like to delete the selected file?';
		$_LANG_['fileupload_ask_grp']		= 'Into which group do you want to move the files?';

		$_LANG_['fileupload_error_1']		= 'Error<BR><BR>You are not allowed to move files into a group, which contains subgroups';
		$_LANG_['fileupload_message_1a']	= 'Procedure partly successful!<BR>The uploaded files received the <b>numbers ';
		$_LANG_['fileupload_message_1b']	= '</b>!';
		$_LANG_['fileupload_message_2']		= 'Procedure <B>not</B> successful!';
		$_LANG_['fileupload_message_2b']	= 'Procedure <B>not/partly</B> successful!';
		$_LANG_['fileupload_message_3a']	= 'The following files could not be uploaded:';
		$_LANG_['fileupload_message_3b']	= 'Check the filesize, file type and your rights.</I>';
		$_LANG_['fileupload_message_4a']	= 'The uploaded files received the <b>numbers ';
		$_LANG_['fileupload_message_5a']	= 'Procedure <b>not</b> successful! Please check the following conditions:<BR> &bull; filesize smaller than ';
		$_LANG_['fileupload_message_5b']	= ' KB <BR> &bull; file type must be ';
		$_LANG_['fileupload_message_5c']	= '<BR><BR> The following message was noted:';
		$_LANG_['fileupload_message_5d']	= 'Also consider your assigned rights!';
		$_LANG_['fileupload_message_6a']	= 'Please make sure that the selected file is a Zip-file and check your rights for uploading .zip files.';
		$_LANG_['fileupload_message_6b']	= 'The Zip-file exceed the upload-limit of the PHP-configuration. <BR/><BR/>The file has a size of';
		$_LANG_['fileupload_message_6c']	= 'This files could not be unzipped because of their extensions (settings):<BR/>';
		$_LANG_['fileupload_message_6d']	= 'Unknown error at uploading Zip-file.';
		$_LANG_['fileupload_zipInfo']		= '<i>- You are just allowed to upload compressed files with the extension .zip <BR/></i>';
		$_LANG_['fileupload_reason_1']		= 'filesize';
		$_LANG_['fileupload_reason_2']		= 'filetype';
		$_LANG_['fileupload_reason_3']		= 'title/url/description';


		/*
		-------
		Gruppen
		-------
		*/

		$_LANG_['group_dir_l']				= 'Left';
		$_LANG_['group_dir_r']				= 'Right';
		$_LANG_['group_dir_u']				= 'Top';
		$_LANG_['group_dir_d']				= 'Bottom';
		$_LANG_['group_yes']				= 'yes';
		$_LANG_['group_no']					= 'no';
		$_LANG_['group_yesAll']				= 'Yes, with content and leadimage';
		$_LANG_['group_public']				= 'Publicise:';
		$_LANG_['group_public_notfornavi']	= 'Yes / not navigation.';
		$_LANG_['group_public_notforsubnavi']	= 'Yes / not sub-navigation.';
		$_LANG_['group_yesVisits']			= 'Yes, show visitors in the public area.';
		$_LANG_['group_valueText1']			= ' select please...';
		$_LANG_['group_valueText2']			= ' select please...';
		$_LANG_['group_choseContent']		= 'Select content';
		$_LANG_['group_choseFile']			= 'Select File';


		// _groups.php (show=1)

		$_LANG_['group_title']				= 'Manage groups';
		$_LANG_['group_create_button']		= 'Create';
		$_LANG_['group_change_button']		= 'Edit';
		$_LANG_['group_create']				= 'Create group';
		$_LANG_['group_change']				= 'Edit group';
		$_LANG_['group_nameField']			= 'Groupname:';
		$_LANG_['group_structure']			= 'Hierarchy:';
		$_LANG_['group_no_maingroup']		= '[ No supergroup... ]';
		$_LANG_['group_shortText']			= '<B>Shorttext:<BR/></B><I>(HTML conform)</I>';
		$_LANG_['group_content']			= 'Groupcontent:';
		$_LANG_['group_preImg']				= 'Preview (image):';
		$_LANG_['group_imgAlign']			= 'Image-align:';
		$_LANG_['group_showVisits']			= 'Show visitors:';
		$_LANG_['group_index']				= 'Index:';

		$_LANG_['group_openAll']			= 'expand tree';
		$_LANG_['group_closeAll']			= 'fold tree';
		$_LANG_['group_close_Grp']			= 'close';
		$_LANG_['group_open_Grp']			= 'open';
		$_LANG_['group_Tree']				= 'Tree';
		$_LANG_['group_tbl_ID']				= 'ID';
		$_LANG_['group_tbl_index']			= 'Index';
		$_LANG_['group_tbl_name']			= 'Group';
		$_LANG_['group_tbl_action']			= 'Actions';
		$_LANG_['group_doDelete']			= 'Delete group...';
		$_LANG_['group_doChange']			= 'Edit group...';
		$_LANG_['group_newArticles']		= 'Create new article in:';
		$_LANG_['group_tothisGrp']			= 'Change to the group of article:';
		$_LANG_['group_star1']				= 'ID of the article which is assigned this group';
		$_LANG_['group_star2']				= 'Number of articles in this group';
		$_LANG_['group_tothisGroup']		= 'Article-Nmb., connected to this group: ';

		$_LANG_['group_message_nosuccess']	= '<i>Procedure <b>not</b> successful!</i>';
		$_LANG_['group_message_1']			= '<br /> <br /><i>Please check if all the required fields are filled in</i><BR><BR><B>Consider your assigned rights!</B>';
		$_LANG_['group_message_2']			= 'THE GROUP WAS CREATED ANYWAY!<br /><br /><u>Attention:</u> You are not allowed to select a group that contains articles as soupergroup!';
		$_LANG_['group_message_3']			= '<u>Attention:</u> You are not allowed to select a group that contains articles as soupergroup!';
		$_LANG_['group_message_4']			= '<u>Attention:</u> You are not allowed to move files into a group, which contains subgroups!';
		$_LANG_['group_message_5a']			= 'Would you really delete the selected group (and ';
		$_LANG_['group_message_5b']			= ' subgroups)?';


		// _articles.php (show=3)

		$_LANG_['articles_title']			= 'Edit articles';
		$_LANG_['articles_create_button']	= 'Create';
		$_LANG_['articles_change_button']	= 'Edit';
		$_LANG_['articles_show_button']		= 'show';
		$_LANG_['articles_do_button']		= 'Go';
		$_LANG_['articles_ok_button']		= 'OK';

		$_LANG_['articles_create']			= 'Create article';
		$_LANG_['articles_change']			= 'Edit article';
		$_LANG_['articles_group']			= 'Group:';
		$_LANG_['articles_group_desc']		= '(there are just groups whitout subgroups allowed)';
		$_LANG_['articles_choose']			= ' [ select please... ]';
		$_LANG_['articles_A_title']			= 'Title:';
		$_LANG_['articles_lead']			= 'Lead:';
		$_LANG_['articles_content']			= 'Content of article:';
		$_LANG_['articles_limit']			= 'Time-limit:';
		$_LANG_['articles_limit_from']		= 'from:';
		$_LANG_['articles_limit_to']		= 'till:';
		$_LANG_['articles_limit_desc']		= 'If you wish no time-limit let this fields unmodified.';
		$_LANG_['articles_time']			= '';
		$_LANG_['articles_fixpoint']		= 'Fixpoint:';
		$_LANG_['articles_date']			= 'Date:';
		$_LANG_['articles_fixpoint_desc']	= 'If you wish no fixpoint let this fields unmodified.';
		$_LANG_['articles_leadImg']			= 'Leadimage:';
		$_LANG_['articles_align']			= 'Align:';
		$_LANG_['articles_public']			= 'Publicise:';
		$_LANG_['articles_public_yes']		= 'Yes, publicise this article.';
		$_LANG_['articles_home']			= 'Article at Home:';
		$_LANG_['articles_home_yes']		= 'Yes, article at home-site.';
		$_LANG_['articles_visits']			= 'Show visitors:';
		$_LANG_['articles_showDate']		= 'Show create-date:';
		$_LANG_['articles_showDate_yes']	= 'Yes, show date at detail- and listview.';
		$_LANG_['articles_search']			= 'Searchkeys:';
		$_LANG_['articles_search_desc']		= 'Separate your searchkeys with a space character.';
		$_LANG_['articles_index']			= 'Sortindex:';

		$_LANG_['articles_expand']			= 'Expand table &lt; || &gt;';
		$_LANG_['articles_tighten']			= 'Short table &gt;||&lt;';
		$_LANG_['articles_pages']			= 'On page';
		$_LANG_['articles_entry']			= 'entries';

		$_LANG_['articles_tbl_ID']			= 'Nr.';
		$_LANG_['articles_tbl_title']		= 'Title';
		$_LANG_['articles_tbl_lead']		= 'Lead';
		$_LANG_['articles_tbl_limit']		= 'Limit';
		$_LANG_['articles_tbl_content']		= 'Content-nr.';
		$_LANG_['articles_tbl_public']		= 'Public';
		$_LANG_['articles_tbl_home']		= '@Home';
		$_LANG_['articles_tbl_actions']		= 'Actions';
		$_LANG_['articles_tbl_create']		= 'Created';
		$_LANG_['articles_tbl_fixpoint']	= 'Fixpoint';
		$_LANG_['articles_tbl_visits']		= 'Show <BR> visitors';
		$_LANG_['articles_tbl_date']		= 'Show <BR> date';
		$_LANG_['articles_tbl_search']		= 'Searchkeys';
		$_LANG_['articles_tbl_leadImg']		= 'Leadimage';
		$_LANG_['articles_tbl_order']		= 'Sortindex';

		$_LANG_['articles_none']			= 'None';
		$_LANG_['articles_changeText']		= 'Edit content...';
		$_LANG_['articles_doWatch']			= 'View content...';
		$_LANG_['articles_doDuplicate']		= 'Duplicate article...';
		$_LANG_['articles_doChange']		= 'Edit article...';
		$_LANG_['articles_doDelete']		= 'Delete article...';
		$_LANG_['articles_doNull']			= 'Reset counter...';

		$_LANG_['articles_selectAllArticles']	= 'select all';
		$_LANG_['articles_unselectAllArticles']	= 'unselect all';
		$_LANG_['articles_selArticles']		= 'Selected articles:';
		$_LANG_['articles_selMove']			= 'Move into another group';
		$_LANG_['articles_selDelete']		= 'Delete';
		$_LANG_['articles_selNull']			= 'Reset counter';
		$_LANG_['articles_outOfHome']		= 'Remove from Home';

		$_LANG_['articles_message_1']		= 'Into which group do you want to move the articles?';
		$_LANG_['articles_message_2']		= 'Error<BR><BR>You can not move articles into a group which contains subgroups';
		$_LANG_['articles_message_3']		= 'The selected article has been duplicated. The duplicate has the ID';
		$_LANG_['articles_message_4a']		= 'Procedure <b>not</b> successful!<BR><BR>Please check if all the required fields are filled in!';
		$_LANG_['articles_message_4b']		= 'Also observe your rights!';
		$_LANG_['articles_message_5']		= 'Do you really want to delete the selected article';


		/*
		-----
		Texts
		-----
		*/

		//_texts.php (show=4)

		$_LANG_['texts_title']				= 'Articlebased texts';
		$_LANG_['texts_preview_button']		= 'Preview';
		$_LANG_['texts_create_button']		= 'Create';
		$_LANG_['texts_create2_button']		= 'Create text &amp; associated article';
		$_LANG_['texts_change_button']		= 'Edit';
		$_LANG_['texts_change2_button']		= 'Edit text &amp; associated article';
		$_LANG_['texts_move_button']		= ' move ';
		$_LANG_['texts_yes']				= ' Yes ';
		$_LANG_['texts_no']					= 'No';

		$_LANG_['texts_create']				= 'Write text';
		$_LANG_['texts_change']				= 'Edit text';
		$_LANG_['texts_noJS']				= 'If there is no editor available, please activate JavaScript or inform you at your administrator, how to make available the WYSIWYG editor.';
		$_LANG_['texts_textgroup']			= 'Assign textgroup:';
		$_LANG_['texts_noTextgroup']		= ' [ No text-group ] ';
		$_LANG_['texts_group']				= 'Associate this article-text with the following group:';
		$_LANG_['texts_noGroup']			= ' [ No group ] ';

		$_LANG_['texts_newGroup']			= 'Create new textgroup';
		$_LANG_['texts_groupName']			= 'Groupname:';

		$_LANG_['texts_texts']				= 'Texts / Textgroups';
		$_LANG_['texts_tbl_ID']				= 'ID';
		$_LANG_['texts_tbl_content']		= 'Content of text';
		$_LANG_['texts_tbl_actions']		= 'Actions';
		$_LANG_['texts_noTexts']			= 'no texts in this group';
		$_LANG_['texts_whitoutGroup']		= 'whitout group';
		$_LANG_['texts_formated']			= '--- Content absolute formatted ---';
		$_LANG_['texts_doChange']			= 'Change text...';
		$_LANG_['texts_doDuplicate']		= 'Duplicate text...';
		$_LANG_['texts_doDelete']			= 'Delete text...';

		$_LANG_['texts_preLink1']			= 'Please follow this link:';
		$_LANG_['texts_preLink2']			= 'To the preview';

		$_LANG_['texts_moveGroup']			= 'Verschiebe ausgew&auml;hlte Texte in diese Gruppe: ';

		$_LANG_['texts_message_1']			= ' Text created. But it was not able to change to the article-section because you did not choose a group!';
		$_LANG_['texts_message_2']			= 'The selected text is duplicated. The duplicate got the ID';
		$_LANG_['texts_message_3a']			= 'Procedure <b>not</b> successful! Please check if you filled in all the required datas!';
		$_LANG_['texts_message_3b']			= 'Also observe your rights!';
		$_LANG_['texts_message_4']			= 'Would you really like to delete the selected text?';
		$_LANG_['texts_message_5a']			= 'Would you really like to delete the selected textgroup? (Texts will be moved to "';
		$_LANG_['texts_message_5b']			= '")';


		/*
		--------------
		Help & support
		--------------
		*/

		// _help.php (show=5)

		$_LANG_['help_title']				= 'Help &amp; support';

		$_LANG_['help_subtitle_1']			= 'My product';
		$_LANG_['help_version']				= 'Version:';
		$_LANG_['help_key']					= 'Key:';
		$_LANG_['help_domain']				= 'Domain:';

		$_LANG_['help_subtitle_2']			= 'Your support';
		$_LANG_['help_docu']				= 'Documentation';
		$_LANG_['help_state']				= 'updated';
		$_LANG_['help_dateformat']			= 'Y-m-d';
		$_LANG_['help_support']				= 'Free support at the offical forum';

		$_LANG_['help_subtitle_3']			= 'Publishing details';
		$_LANG_['help_subtitle_3a']			= 'PROGRAMMING AND REALISATION';
		$_LANG_['help_subtitle_3b']			= 'INITIATOR, CONCEPTION &amp; TESTING';
		$_LANG_['help_subtitle_3c']			= 'DISTRIBUTION';
		$_LANG_['help_germany']				= 'Germany:';
		$_LANG_['help_switzerland']			= 'Switzerland:';
		$_LANG_['help_subtitle_3d']			= 'INTERNET';


		/*
		-------------
		Einstellungen
		-------------
		*/

		// _settings.php (show=0)

		$_LANG_['settings_title']			= 'Settings';
		$_LANG_['settings_change_button']	= 'Change';
		$_LANG_['settings_delete_button']	= 'Delete';
		$_LANG_['settings_create_button']	= 'Create';
		$_LANG_['settings_message_error']	= 'Procedure <B>not</B> successful! Please check that you did not use special chars (\',\\,") and that all fields are filled in!';

		$_LANG_['settings_navi_1']			= '1. Password/Language';
		$_LANG_['settings_subtitle_1a']		= '1.1 Change my password';
		$_LANG_['settings_subtitle_1b']		= '1.2 Change language';
		$_LANG_['settings_name']			= 'Name:';
		$_LANG_['settings_oldPW']			= 'Old password:';
		$_LANG_['settings_newPW']			= 'New password:';
		$_LANG_['settings_repeatPW']		= 'Repeat new password:';
		$_LANG_['settings_message_1a']		= '<b>ATTENTION:</b> The password of the new user is:';
		$_LANG_['settings_message_1b']		= '<b>Please set the rights for the new user</b>';

		$_LANG_['settings_navi_2']			= '2. My rights';
		$_LANG_['settings_subtitle_2']		= '2. My rights';
		$_LANG_['settings_create']			= 'Create:';
		$_LANG_['settings_delete']			= 'Delete';
		$_LANG_['settings_change']			= 'Edit:';
		$_LANG_['settings_man_rights']		= 'Give rights:';
		$_LANG_['settings_man_votes']		= 'Administrate votes:';
		$_LANG_['settings_man_gb']			= 'Administrate guestbook:';
		$_LANG_['settings_man_basket']		= 'Administrate goods:';
		$_LANG_['settings_man_forum']		= 'Administrate forum:';
		$_LANG_['settings_man_statistics']	= 'Administrate statistics:';
		$_LANG_['settings_true']			= 'YES';
		$_LANG_['settings_false']			= 'NO';

		$_LANG_['settings_navi_3']			= '3. Users';
		$_LANG_['settings_subtitle_3a']		= '3.1 Delete User';
		$_LANG_['settings_subtitle_3b']		= '3.2 Create new user';
		$_LANG_['settings_subtitle_3c']		= '3.3 Change password of other user';
		$_LANG_['settings_noUser']			= ' [ No user selected ] ';
		$_LANG_['settings_newPW2']			= 'New password:';
		$_LANG_['settings_pwDesc']			= '(Let empty for generating password automatic.)';
		$_LANG_['settings_mail']			= 'E-mail:';
		$_LANG_['settings_mailDesc']		= '(Send login-data of the user to this address)';
		$_LANG_['settings_save']			= 'Save:';
		$_LANG_['settings_saveDesc']		= '(Save and file new data in this e-mailaddress)';
		$_LANG_['settings_noRights']		= 'You have no rights!';
		$_LANG_['settings_user']			= 'User:';

		$_LANG_['settings_navi_4']			= '4. Auto-mailtexts';
		$_LANG_['settings_subtitle_4a']		= '4.1 Auto-mailaddress';
		$_LANG_['settings_subtitle_4b']		= '4.2 Auto-mailtexts';
		$_LANG_['settings_noMail']			= ' [ No auto-mailaddress selected ] ';
		$_LANG_['settings_mailaddress']		= 'E-mail-address:';
		$_LANG_['settings_noMailtext']		= ' [ no auto-mailtext selected ] ';
		$_LANG_['settings_contentType']		= 'Content-Type:';
		$_LANG_['settings_contentText']		= 'Text';
		$_LANG_['settings_contentHtml']		= 'HTML';
		$_LANG_['settings_mailListTitle']	= 'Title for auto-maillist:';
		$_LANG_['settings_from']			= 'From:';
		$_LANG_['settings_to']				= 'To:';
		$_LANG_['settings_reply']			= 'Re:';
		$_LANG_['settings_subject']			= 'Subject:';
		$_LANG_['settings_text']			= 'Text:';

		$_LANG_['settings_navi_5']			= '5. Settings';
		$_LANG_['settings_subtitle_5']		= '5. Settings';
		$_LANG_['settings_max']				= 'Maximum uploadsize:';
		$_LANG_['settings_maxKb']			= 'maximal';
		$_LANG_['settings_types']			= 'Allowed file-types in file management:';
		$_LANG_['settings_font']			= 'Allow font-options in the editor:';
		$_LANG_['settings_editmode']		= 'Frontend Edit Mode:';
		$_LANG_['settings_yes']				= 'Yes';
		$_LANG_['settings_no']				= 'No';
		$_LANG_['settings_language']		= 'Language:';

		$_LANG_['settings_navi_6']			= '6. CSS-manager';
		$_LANG_['settings_subtitle_6']		= '6. CSS-manager';
		$_LANG_['settings_noClass']			= ' [ No class selected ] ';
		$_LANG_['settings_classname']		= 'Classname:';
		$_LANG_['settings_description']		= 'Class-description:';


		/*
		-------------
		Rechtevergabe
		-------------
		*/

		// _rights.php

		$_LANG_['rights_title']				= 'Center: Distribution of rights';
		$_LANG_['rights_noRights']			= 'You have no rights for the distribution of rights!';
		$_LANG_['rights_none']				= 'none';

		$_LANG_['rights_ask_1']				= '1. For which user do you wish to distribute rights?';
		$_LANG_['rights_showUser']			= 'Show user';
		$_LANG_['rights_user']				= 'User:';

		$_LANG_['rights_ask_2']				= '2. On which group do you wish to distribute rights?';
		$_LANG_['rights_showGroups']		= 'Show groups';
		$_LANG_['rights_group']				= 'Group:';
		$_LANG_['rights_noGroup']			= ' [ no group... ] ';

		$_LANG_['rights_ask_3']				= '3. Do you wish to distribute other rights?';
		$_LANG_['rights_showRights3']		= 'Show other rights';
		$_LANG_['rights_right1']			= 'Authorise user to distribute rights to other users.';
		$_LANG_['rights_right2']			= 'Authorise user to create groups / doing administrative works.';
		$_LANG_['rights_right3']			= 'Artikel des Benutzers autark belassen (Artikel nur fr Superadmins noch sichtbar)';
		$_LANG_['rights_right4']			= 'Authorise user to create votes.';
		$_LANG_['rights_right5']			= 'Authorise user to administrate the guestbook.';
		$_LANG_['rights_right6']			= 'Authorise user to administrate the basket of goods.';
		$_LANG_['rights_right7']			= 'Authorise user to administrate the forum.';
		$_LANG_['rights_right8']			= 'Authorise user to administrate the statistics.';
		$_LANG_['rights_rightAdmin']		= 'Admin rights for all groups and articles (superadmin)';
		$_LANG_['rights_Img_a_create']		= 'Authorised to create articles';
		$_LANG_['rights_Img_a_delete']		= 'Authorised to delete articles';
		$_LANG_['rights_Img_a_change']		= 'Authorised to edit articles';

		$_LANG_['rights_ask_4']				= 'Distribution of rights of group';
		$_LANG_['rights_showRights4']		= 'Show other rights';
		$_LANG_['rights_grp_right']			= 'Rights of group';
		$_LANG_['rights_art_right']			= 'Articles of group';
		$_LANG_['rights_Img_g_create']		= 'Authorised to create articles';
		$_LANG_['rights_Img_g_delete']		= 'Authorised to delete';
		$_LANG_['rights_Img_g_change']		= 'Authorised to edit';

		$_LANG_['rights_select']			= '(un-)select:';
		$_LANG_['rights_all']				= 'alle';
		$_LANG_['rights_just_del']			= 'delete only';
		$_LANG_['rights_just_chg']			= 'edit only';
		$_LANG_['rights_save']				= 'Save rights';


		/*
		---------------
		Bildbearbeitung
		---------------
		*/

		// _file_edit.php

		$_LANG_['fileedit_title']			= 'Image editing';
		$_LANG_['fileedit_preview_button']	= 'Preview';
		$_LANG_['fileedit_saveNew_button']	= 'Save as...';
		$_LANG_['fileedit_change_button']	= 'Save';
		$_LANG_['fileedit_ok_button']		= 'OK';
		$_LANG_['fileedit_no_button']		= 'No';
		$_LANG_['fileedit_abort_button']	= 'Cancel';
		$_LANG_['fileedit_close']			= 'Close window';

		$_LANG_['fileedit_edit']			= 'Editing';
		$_LANG_['fileedit_resize']			= 'Scaling';
		$_LANG_['fileedit_size']			= 'Size:';
		$_LANG_['fileedit_proportional']	= 'Proportional';
		$_LANG_['fileedit_reflect']			= 'Reflect';
		$_LANG_['fileedit_axis']			= 'Achse:';
		$_LANG_['fileedit_axis_v']			= 'vertical';
		$_LANG_['fileedit_axis_h']			= 'horizontal';
		$_LANG_['fileedit_axis_no']			= 'no reflection';
		$_LANG_['fileedit_rotation']		= 'Rotation';
		$_LANG_['fileedit_angle']			= 'Angle ():';
		$_LANG_['fileedit_quality']			= 'Quality';
		$_LANG_['fileedit_value']			= 'Value (1-100):';
		$_LANG_['fileedit_version']			= 'not found';

		$_LANG_['fileedit_cut']				= 'Cut';
		$_LANG_['fileedit_cords']			= 'Coordinates from (px):';
		$_LANG_['fileedit_cutsize']			= 'Size (px):';

		$_LANG_['fileedit_oldSize']			= 'Original filesize:';
		$_LANG_['fileedit_newSize']			= 'New filesize:';

		$_LANG_['fileedit_name']			= 'Name:';
		$_LANG_['fileedit_desc']			= 'Description:';
		$_LANG_['fileedit_group']			= 'Group:';

		$_LANG_['fileedit_message_1a']		= 'Replace image';
		$_LANG_['fileedit_message_1b']		= 'with this image?';
		$_LANG_['fileedit_message_2']		= 'Change to the new image';
		$_LANG_['fileedit_message_3']		= 'Could not load image editing.<BR>Potential causes:';
		$_LANG_['fileedit_message_4a']		= '- The selected file does not exist.';
		$_LANG_['fileedit_message_4b']		= 'Directory:';
		$_LANG_['fileedit_message_5a']		= '- The file format is not supported.';
		$_LANG_['fileedit_message_5b']		= 'Your format:';
		$_LANG_['fileedit_message_5c']		= 'Supported formats:';
		$_LANG_['fileedit_message_6a']		= '- No required GD-version available.';
		$_LANG_['fileedit_message_6b']		= 'Required version: 2.0.1 or higher';
		$_LANG_['fileedit_message_7a']		= 'GD-version not up to date! (Installed version:';
		$_LANG_['fileedit_message_7b']		= 'Required version: 2.0.1 or higher';
		$_LANG_['fileedit_message_8']		= 'GD-libary not installed/activated!';
		$_LANG_['fileedit_message_8']		= 'No transparency supported for .png-format.';


		/*
		-------
		Pop-Ups
		-------
		*/

		// backendpopup/popup.php

		$_LANG_['popup_howtoSelect']		= 'To select a entry you have to klick on it.';
		$_LANG_['popup_showOptions']		= 'Options';
		$_LANG_['popup_gotoPage']			= 'go to page';
		$_LANG_['popup_show']				= 'show';
		$_LANG_['popup_entries']			= 'entries';
		$_LANG_['popup_searchgroup']		= 'Group:';
		$_LANG_['popup_all_groups']			= '- all groups -';
		$_LANG_['popup_searchkey']			= 'Searchkey:';
		$_LANG_['popup_back']				= 'back';
		$_LANG_['popup_next']				= 'next';
		$_LANG_['popup_reload']				= 'Refresh list';
		$_LANG_['popup_search']				= 'Search';
		$_LANG_['popup_hits']				= 'Hits';
		$_LANG_['popup_noEntry']			= 'select no entry';

		$_LANG_['popup_bad']				= 'bad';
		$_LANG_['popup_soso']				= 'ok';
		$_LANG_['popup_good']				= 'good';
		$_LANG_['popup_verygood']			= 'very good';

		$_LANG_['popup_message_1']			= 'No results were found!';
		$_LANG_['popup_message_2']			= 'Probably there are no results for this site';
		$_LANG_['popup_close']				= 'Close PopUp';
		$_LANG_['popup_closeW']				= 'Close window';

		// for articles (index.res.php)

		$_LANG_['popup_a_title']			= 'Select article';
		$_LANG_['popup_a_as1']				= 'ID';
		$_LANG_['popup_a_as2']				= 'Title';
		$_LANG_['popup_a_as3']				= 'Lead';
		$_LANG_['popup_a_as4']				= 'Keywords';

		// for files (index.res.php)

		$_LANG_['popup_f_title']			= 'Select image';
		$_LANG_['popup_f_as1']				= 'ID';
		$_LANG_['popup_f_as2']				= 'Preview';
		$_LANG_['popup_f_as3']				= 'Name';
		$_LANG_['popup_f_as4']				= 'Description';

		// for texts (index.res.php)

		$_LANG_['popup_t_title']			= 'Select text';
		$_LANG_['popup_t_as1']				= 'ID';
		$_LANG_['popup_t_as2']				= 'Text';


        return $_LANG_;
    }
?>