<?php
    /**
    * This file performs sets a specific language for DynPG frontend,
    * by default "de".
    *
    * This file includes language data for language "german" alias "de"
    *
    *
    *
    * @package DynPG PlugIn Engine (Languages)
    * @author Daniel Schliebner
    * @return language data as assocciative array
    */

    // callback_Language_de_general: -> array
    // Sets language data for language "german"
    function callback_Language_de_general() {

        // instanciate language array
        $_LANG_ = Array();

        // define "new line" placeholder variable
        $N = "\r\n";


        // This definition is more a template but to small for an extra template
        // file so we define it here. In addition to that, this element is parsed
        // with the template processor too.
        $_LANG_['navigation_root_separate_str']          = '&nbsp;<strong>>></strong>&nbsp;';
        $_LANG_['navigation_root_firstelement']          = '<div style="display: inline;" class="breadcrumb_at_{$LIST_INDEX}">{$NAME}</div>';
        $_LANG_['navigation_root_singleelement']         = '<div style="display: inline;" class="breadcrumb_at_{$LIST_INDEX}">{$NAME}</div>';
        $_LANG_['navigation_root_itemelement']           = '<div class="breadcrumb_at_{$LIST_INDEX}">{$SEPERATE}{$TITLE}</div>';


        // date format for dates in the group list
        $_LANG_['general_groups_date_format']            = 'd.m.Y';


        // date format for dates in the article list
        $_LANG_['general_articles_create_date_format']   = 'd.m.Y';
        $_LANG_['general_articles_fix_date_format']      = 'd.m.Y';
        $_LANG_['general_articles_from_date_format']     = 'd.m.Y';
        $_LANG_['general_articles_till_date_format']     = 'd.m.Y';

        // string for empty search query in article list
        $_LANG_['general_articles_no_search_query']      = '-';


        // date format for dates at detail page
        $_LANG_['general_detail_create_date_format']     = 'd.m.Y';
        $_LANG_['general_detail_fix_date_format']        = 'd.m.Y';
        $_LANG_['general_detail_from_date_format']       = 'd.m.Y';
        $_LANG_['general_detail_till_date_format']       = 'd.m.Y';


        // date format for dates at home site
        $_LANG_['general_home_create_date_format']       = 'd.m.Y';
        $_LANG_['general_home_fix_date_format']          = 'd.m.Y';
        $_LANG_['general_home_from_date_format']         = 'd.m.Y';
        $_LANG_['general_home_till_date_format']         = 'd.m.Y';


        // form processing
        $_LANG_['forms_errors_number_00']                = '';
        $_LANG_['forms_errors_number_01']                = 'Fehler: Sie k&ouml;nnen das Formular nur einmalig absenden!';
        $_LANG_['forms_errors_number_02']                = 'Fehler: Interner Fehler #2!';
        $_LANG_['forms_errors_number_03']                = 'Fehler: Falscher Referer!';
        $_LANG_['forms_errors_number_04']                = 'Fehler: Die g&uuml;ltige Zeitspanne f&uuml;r das Formular ist abgelaufen!';
        $_LANG_['forms_errors_number_05']                = 'Fehler: Bitte f&uuml;llen Sie alle erforderlichen Felder aus!';
        $_LANG_['forms_errors_number_06']                = 'Fehler: Bitte geben Sie eine g&uuml;ltige E-Mail an!';
        $_LANG_['forms_errors_number_07']                = 'Fehler: Bitte geben Sie eine g&uuml;ltige URL an!';
        $_LANG_['forms_errors_number_08']                = 'Fehler: Der Validierungscode war inkorrekt!';
        $_LANG_['forms_errors_number_09']                = 'Fehler: Es sind keine Header-Angaben zul&auml;ssig!';

        return $_LANG_;
    }
?>