/**
 * $RCSfile: editor_plugin_src.js,v $
 * $Revision: 1.23 $
 * $Date: 2006/02/10 16:29:38 $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2006, Moxiecode Systems AB, All rights reserved.
 */

/* Import plugin specific language pack */
tinyMCE.importPluginLanguagePack('dynpg_forum', 'en,tr,sv,zh_cn,cs,fa,fr_ca,fr,de,pl,pt_br,nl,da,he,nb,hu,ru,ru_KOI8-R,ru_UTF-8,nn,es,cy,is,zh_tw,zh_tw_utf8,sk');

// Plucin static class
var TinyMCE_DynPGForumPlugin = {
	getInfo : function() {
		return {
			longname : 'DynPG Forum Plugin',
			author : 'DS Develop',
			authorurl : 'http://tinymce.moxiecode.com',
			infourl : 'http://tinymce.moxiecode.com/tinymce/docs/plugin_emotions.html',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	},

	/**
	 * Returns the HTML contents of the dynpg forum control.
	 */
	getControlHTML : function(cn) {
		switch (cn) {
			case "dynpg_forum":
				return tinyMCE.getButtonHTML(cn, 'lang_dynpg_forum_desc', '{$pluginurl}/images/dynpg_forum.gif', 'mcedynpg_forum');
		}

		return "";
	},

	/**
	 * Executes the mceEmotion command.
	 */
	execCommand : function(editor_id, element, command, user_interface, value) {
		// Handle commands
		switch (command) {
			case "mcedynpg_forum":
				tinyMCE.execInstanceCommand(editor_id, 'mceInsertContent', false, tinyMCE.getParam("plugin_dynpg_forum_bla", '<img src="js/tiny_mce/plugins/dynpg_forum/images/placeholder.gif" alt="DYNPGFORUM" />'));
				return true;
		}

		// Pass to next handler in chain
		return false;
	}
};

// Register plugin
tinyMCE.addPlugin('dynpg_forum', TinyMCE_DynPGForumPlugin);