<?php
    /*
    *   PERFORM INSTALLATION OF DYNPG PACKAGE
    */

    @session_start();

    if ( empty($_POST['dynpg_install_step1_license']) || empty($_SESSION['DYNPG_INSTALLATION']) ) {
        header("Location: step1.php");
        exit();
    }

    require 'bin.php';

    define('__FAIL_STEP', 0);
    define('__OK_STEP', 1);
    define('__WARN_STEP', 2);

    $install_process['message'] = '';
    $install_process['abort']   = FALSE;

    function dynpg_install_run_SuccessStep($_type = 0, $_value = '')
    {
        switch ( $_type ) {
            case 0: return '<div id="dynpg_install_run_stepFAIL"><img src="install_error.gif" alt="error" /> ' . $_value . '</div>'; break;
            case 1: return '<div id="dynpg_install_run_stepOKAY"><img src="install_okay.gif" alt="okay" /> ' . $_value . '</div>'; break;
            case 2: return '<div id="dynpg_install_run_stepWARN"><img src="install_warn.gif" alt="warning" /> ' . $_value . '</div>'; break;
            default: return '<div id="dynpg_install_run_stepFAIL"><img src="install_error.gif" alt="error" /> ' . $_value . '</div>'; break;
        }
    }

    function dynpg_install_run_GetSingleSQLQueries($_sql_query)
    {
    	$_sql_query = trim($_sql_query);
    	$_sql_query = ereg_replace("\n#[^\n]*\n", "\n", $_sql_query);
    	$_sql_query = ereg_replace("\n--[^\n]*\n", "\n", $_sql_query);

    	$buffer    = Array();
    	$return    = Array();
    	$in_string = FALSE;

    	for ( $i = 0; $i < strlen($_sql_query) - 1; $i++ ) {
    		if ( $_sql_query[$i] == ";" && !$in_string ) {
    			$return[]   = substr($_sql_query, 0, $i);
    			$_sql_query = substr($_sql_query, $i + 1);
    			$i = 0;
    		}

    		if($in_string && ($_sql_query[$i] == $in_string) && $buffer[1] != "\\") {
    			$in_string = FALSE;
    		} elseif ( !$in_string && ($_sql_query[$i] == '"' || $_sql_query[$i] == "'") && (!isset($buffer[0]) || $buffer[0] != "\\") ) {
    			$in_string = $_sql_query[$i];
    		}

    		if( isset($buffer[1]) ) {
    			$buffer[0] = $buffer[1];
    		}

    		$buffer[1] = $_sql_query[$i];
    	}

    	if( !empty($_sql_query) ) {
    		$return[] = $_sql_query;
    	}

    	return $return;
    }

    // FIRST STEP: copy required data in correct foldertree

    // standard

    // create install dir
    if ( !empty($_POST['dynpg_options_installdir']) ) {
        if ( is_dir($_POST['dynpg_options_installdir']) ) {
            if ( @is_readable($_POST['dynpg_options_installdir']) ) {
                $install_process['directory'] = $_POST['dynpg_options_installdir'];
                $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, 'Installationsverzeichnis korrekt!');
            } else {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__WARN_STEP, 'Installationsverzeichnis nicht lesbar!');
            }
        } else {
            if ( @mkdir($_POST['dynpg_options_installdir'], 0755) ) {
                $install_process['directory'] = $_POST['dynpg_options_installdir'];
                $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, 'Installationsverzeichnis angelegt!');
            } else {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Installationspfad inkorrekt!');
                $install_process['abort'] = TRUE;
            }
        }
    } else {
        if ( @is_writable(dirname(dirname(__FILE__))) ) {
            $install_process['directory'] = dirname(dirname(__FILE__));
        } else {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Installationsverzeichnis nicht lesbar!');
            $install_process['abort'] = TRUE;
        }
    }

    if ( substr($install_process['directory'], -1) == '/' ) {
        $install_process['directory'] = substr($install_process['directory'], 0, -1);
    }

    if ( !$install_process['abort'] ) {
        if (! eregi('^DPG', $_POST['dynpg_options_licensekey']) ) {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Falscher Identifikationsschl&uuml;ssel!');
            $install_process['abort'] = TRUE;
        }
    }

    // create config.php
    if ( !$install_process['abort'] ) {
        $nl  = chr(13) . chr(10);
        $tab = '    ';

        $configdist = implode('', file('../configuration.php-dist'));

        $install_process['configcontent'] = '<?php' . $nl;
        $install_process['configcontent'] .= $tab . 'global $cfg;' . $nl . $nl;
        $install_process['configcontent'] .= $tab . '//' . $nl;
        $install_process['configcontent'] .= $tab . '// PUBLIC CONSTANTS' . $nl;
        $install_process['configcontent'] .= $tab . '//' . $nl . $nl;
        $install_process['configcontent'] .= $tab . 'define("MYSQL_SERVER", "'.$_POST['dynpg_mysql_server'].'");' . $nl;
        $install_process['configcontent'] .= $tab . 'define("MYSQL_USER", "'.$_POST['dynpg_mysql_user'].'");' . $nl;
        $install_process['configcontent'] .= $tab . 'define("MYSQL_PASSWORD", "'.$_SESSION['DYNPG_INSTALLATION_MYSQLPW'].'");' . $nl;
        $install_process['configcontent'] .= $tab . 'define("MYSQL_DATABASE", "'.$_POST['dynpg_mysql_dbname'].'");' . $nl . $nl;
        $install_process['configcontent'] .= $configdist;
        $install_process['configcontent'] .= $nl . '?>';

        $file = fopen( '../configuration.php', 'w+' );

        if ( $file ) {
            fwrite($file, $install_process['configcontent']);
            fclose($file);
        } else {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Konfiguration konnte nicht ge&ouml;ffnet werden! Bitte &auml;ndern Sie den CHMOD-Wert der configuration.php-dist auf 777.');
            $install_process['abort'] = TRUE;
        }

        if ( copy('../configuration.php', $install_process['directory'] . '/config.php') ) {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, 'Konfiguratuion erstellt!');
            chmod($install_process['directory'] . '/config.php', 0755);
            @unlink('../configuration.php');
            @unlink('../configuration.php-dist');
        } else {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Konfiguration konnte nicht verschoben werden!');
            $install_process['abort'] = TRUE;
        }
    }

    // copy files
    if ( !$install_process['abort'] ) {
        mkdir( $install_process['directory'] . '/upload/', 0777 );

        if ( dynpg_install_IsModuleInstalled('stock') ) {
            mkdir( $install_process['directory'] . '/bogxmltmp/', 0777 );
        }

        if ( dynpg_install_IsModuleInstalled('forum') ) {
            if ( @is_readable($install_process['directory'] . '/forum/include/configuration/configurations.mysql.inc.php-dist') ) {
                $configdist = implode('', file($install_process['directory'] . '/forum/include/configuration/configurations.mysql.inc.php-dist'));

                $install_process['configcontent'] = '<?php' . $nl;
                $install_process['configcontent'] .= $configdist . $nl . $nl;
                $install_process['configcontent'] .= $tab . '$c["MySQL_Server"] = "'.$_POST['dynpg_mysql_server'].'"; # Your MySQL-Server (recommended: `localhost`).' . $nl;
                $install_process['configcontent'] .= $tab . '$c["MySQL_User"]   = "'.$_POST['dynpg_mysql_user'].'"; # Your MySQL-Server-Authentification-Name.' . $nl;
                $install_process['configcontent'] .= $tab . '$c["MySQL_PW"]     = "'.$_SESSION['DYNPG_INSTALLATION_MYSQLPW'].'"; # Your MySQL-Server-Password.' . $nl;
                $install_process['configcontent'] .= $tab . '$c["MySQL_DB"]     = "'.$_POST['dynpg_mysql_dbname'].'"; # Database in which the data is saved.';
                $install_process['configcontent'] .= $nl . '?>';

                $file = @fopen( $install_process['directory'] . '/forum/include/configuration/configurations.mysql.inc.php', 'w+' );

                if ( $file ) {
                    fwrite($file, $install_process['configcontent']);
                    fclose($file);
                    unlink($install_process['directory'] . '/forum/include/configuration/configurations.mysql.inc.php-dist');
                }
            } else {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Konfiguration des Forums konnte nicht ge&ouml;ffnet werden! Bitte &auml;ndern Sie den CHMOD-Wert der configurations.mysql.inc.php auf 644.');
                $install_process['abort'] = TRUE;
            }
        }
    }

    // install database and insert
    if ( !$install_process['abort'] ) {
        $mysql_connection = @mysql_connect($_POST['dynpg_mysql_server'], $_POST['dynpg_mysql_user'], $_SESSION['DYNPG_INSTALLATION_MYSQLPW']);

        if ( !$mysql_connection ) {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Keine Verbindung zu MySQL m&ouml;glich. Bitte pr&uuml;fen Sie Server, Host und Passwort auf G&uuml;ltigkeit!');
            $install_process['abort'] = TRUE;
        }

        $succeed = @mysql_select_db($_POST['dynpg_mysql_dbname']);

        if ( !$succeed ) {
            if ( empty($_POST['dynpg_module_standalone']) ) {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Keine Verbindung zur Datenbank \''.htmlentities($_POST['dynpg_mysql_dbname']).'\'!');
                $install_process['abort'] = TRUE;
            } else {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__WARN_STEP, 'Keine Verbindung zur Datenbank \''.htmlentities($_POST['dynpg_mysql_dbname']).'\'!');
            }
        }

        if ( empty($_POST['dynpg_module_standalone']) && !$install_process['abort'] ) {
            // install sql
            $sqlfiles = Array('cleardb.sql', 'dynpg.sql', 'requireddata.sql', 'plugins.sql');

            $this_dynpgversion = trim(implode('', file('../VERSION')));

            foreach ( $sqlfiles as $sqlfile ) {
                $sql_Content = implode('', file('sqlbin/' . $sqlfile));
                $sql_Content = dynpg_install_run_GetSingleSQLQueries($sql_Content);

                $succeed = TRUE;

                foreach ( $sql_Content as $query ) {
                    $query = str_replace('{$SUPERADMIN_NAME}', $_POST['dynpg_options_superadmin_name'], $query);
                    $query = str_replace('{$SUPERADMIN_PW}', $_POST['dynpg_options_superadmin_password'], $query);
                    $query = str_replace('{$DYNPG_HASH}', str_replace('-', '', $_POST['dynpg_options_licensekey']), $query);
                    $query = str_replace('{$DYNPG_VERSION}', $this_dynpgversion, $query);
                    $query = str_replace('{$DYNPG_DOMAIN}', $_POST['dynpg_options_domain'], $query);

                    if ( !mysql_query($query) ) {
                        $succeed = FALSE;
                    }
                }

                if ( !$succeed ) {
                    $install_process['message'] .= dynpg_install_run_SuccessStep(__FAIL_STEP, 'Bei der Installation der Datenbank ist ein Fehler aufgetreten (\''.$sqlfile.' meldet: '.htmlentities(mysql_error()).'\')');
                    $install_process['abort'] = TRUE;
                    break;
                }
            }

            if ( $succeed ) {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, 'DynPG Datenbankstruktur wurde erfolgreich erstellt!');
            }

        }

        if ( empty($_POST['dynpg_module_standalone']) && !empty($_POST['dynpg_module_exampledata']) && !$install_process['abort'] ) {
            // install sql
            $sql_Content = implode('', file('sqlbin/installexamples.sql'));
            $sql_Content = dynpg_install_run_GetSingleSQLQueries($sql_Content);

            $succeed = TRUE;

            foreach ( $sql_Content as $query ) {
                if ( !mysql_query($query) ) {
                    $succeed = FALSE;
                }
            }

            if ( !$succeed ) {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__WARN_STEP, 'Bei der Installation der Beispieldaten ist ein Fehler aufgetreten (\'installexamples.sql meldet: '.htmlentities(mysql_error()).'\')');
            } else {
                $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, 'Beispieldaten wurden installiert.');
            }
        }

        $succeed = @mysql_close($mysql_connection);

        if ( !$succeed ) {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__WARN_STEP, 'Die MySQL-Verbindung konnte nicht geschlossen werden.');
        }

        if ( !$install_process['abort'] ) {
            $install_process['message'] .= dynpg_install_run_SuccessStep(__OK_STEP, '<strong>Installation von DynPG abgeschlossen!</strong>');
        }
    }

    if ( !$install_process['abort'] ) {
        unset($_SESSION['DYNPG_INSTALLATION_MYSQLPW']);

        @session_unset();
        @session_destroy();
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">

		<title>
			DynPG - Web Installation Manager - Schritt 4
		</title>

		<link rel="stylesheet" type="text/css" href="install.css">

		<script src="java.js" type="text/javascript"></script>
	</head>

	<body>

	<a name="__self"></a>
	<table border="0" Cellpadding="0" Cellspacing="0" width="100%">
		<tr>
			<td valign="top" align="left" width="100%">
				<table border="0" Cellpadding="0" Cellspacing="0" width="100%">
				 <tr>
				  <td valign="top" align="left" width="705" style="background-image: url('logo.gif'); background-repeat: no-repeat;">
				  <div id="dynpg_installation_steps">
						<img src="step-on.gif" alt="Step 1 - Active" class="dynpg_installation_steps_img" />
						<img src="step-on.gif" alt="Step 2 - Inactive" class="dynpg_installation_steps_img" />
						<img src="step-on.gif" alt="Step 3 - Inactive" class="dynpg_installation_steps_img" />
						<img src="step-on.gif" alt="Step 4 - Inactive" class="dynpg_installation_steps_img" />
					</div>
                  </td>
				  <td valign="center" align="right" style="background-image: url('head-bg.gif');"><img src="head-right.gif" alt="Head-Right" /></td>
				 </tr>
				</table>
			</td>
		</tr>
	</table>

	<table border="0" cellspacing="0" align="center" class="dynpg_installation_step">
		<tr>
			<td height="50" style="background-image:url('stephead.gif');"><div id="dynpg_installation_step_headline">DynPG - Webinstallation (Schritt 4)</div></td>
		</tr>
		<tr>
			<td><div id="dynpg_installation_step4_text">

			<h4>DynPG Installationsvorgang</h4>

			<?php echo $install_process['message']; ?>

			<?php if ( !$install_process['abort'] ) { ?>
            <div align="center" id="dynpg_install_run_stepINFO"><strong>Achtung:</strong> Es wird dringend empfohlen, alle Installationsdateien zu l&ouml;schen!</div>

            <div align="center" id="dynpg_install_run_stepINFO"><div align="left">Sie haben nun folgende Optionen:<ol><li><a href="../index.php"><strong>Hier gelangen Sie zur DynPG Administration!</strong></a></li><li><a href="../pdf/DynPG-doc-begin.pdf" target="_blank"><strong>Hier k&ouml;nnen Sie sich die Dokumentation anschauen!</strong></a></li><?php if ( !empty($_POST['dynpg_module_exampledata']) ) { ?><li><a href="../example/index.php" target="_blank"><strong>Hier k&ouml;nnen Sie sich eine Beispielseite betrachten!</strong></a></li><?php } ?></ol></div></div>
            <?php } ?>

			<p style="margin: 20px;"></p>

			<form action="step2.php" method="post" name="installation_step4_back">
    			<?php foreach ( $_POST as $key => $value ) { ?>
				<?php if ( !strpos($key, 'password') ) { ?>
    			<input type="hidden" name="<?php echo $key ?>" id="<?php echo $key ?>" value="<?php echo $value ?>" />
                <?php } } ?>

				<?php if ( $install_process['abort'] ) { ?>
                <input type="image" src="button_back.gif" alt="zur&uuml;ck" title="vorheriger Schritt" align="left" border="0" />
                <?php } ?>

                <?php if ( !$install_process['abort'] ) { ?>
                <!-- Maybe a close button here. -->
                <?php } ?>
			</form>

			</div></td>
		</tr>
		<tr>
			<td height="30" style="background-color: white; background-image:url('stepfood.gif');"></td>
		</tr>
	</table>

	</body>
</html>