<?php
	/**
	* dynpg_cms_index_hasUpdate(): ->boolean
	*
	* determines whether there is an available update in the update directory
	*
	* @package DynPG Index.php
	* @author Sebastian Bauersfeld
	* @return boolean
	*/
    function dynpg_cms_index_hasUpdate() {
	 	$dir = opendir('update/');
	 	while ($file = readdir($dir)) {
	 		if(substr($file, 0, 7) == 'plugin_' ){
	 			closedir($dir);
				return true;
			}
			if(substr($file, 0, 7) == 'update_' ){
	 			closedir($dir);
				return true;
			}
		}
	 	closedir($dir);
		return false;
	}


	// workflow for older update routines

    if ( is_dir('install/') && file_exists('configuration.php-dist') ) {
        header('Location: install/step1.php');
    }

    if ( is_dir('update/') && dynpg_cms_index_hasUpdate() ) {
        header('Location: update/bin/start.php');
    }

    if ( is_dir('install/')  && !file_exists('configuration.php-dist') ||
         !is_dir('install/') && file_exists('configuration.php-dist') ) {
        header('Location: incomplete.php');
    }

    // require header file for session-handling and backend-header output

    ob_start();

	require "header.php";


	// implement login-logic

	if ( !VerifyAccess() ) {
		require 'loginpage.php';

		require "fooder.php";

		exit;
	}
?>

<table border="0" cellpadding="10" cellspacing="0" width="100%" height="100%">
	<tr>
		<td width="100%" height="100%" valign="top" align="left" style="padding-left: 30px;">

			<?php
				if ( !isset( $_GET["show"] ) ) {
                    $_GET["show"] = 4;
                }

				switch ( (string)$_GET["show"] ) {

					case '0':   	require "_settings.php"; 	break;
					case '1':   	require "_groups.php";	  	break;
					case '2':   	require "_fileupload.php";  break;
					case '100':   require "_filegroups.php";  break;
					case '3':   	require "_articles.php";    break;
					case '4':   	require "_texts.php";       break;
					case '5':   	require "_help.php";        break;
					case '6':   	require "_votes.php";       break;
					case '7':   	require "_impressum.php";   break;

					//  8: as plugin
                    //  9: as plugin

					case '10':  	require "_forum.php";       break;

					// 11: as plugin

					default:
						dynpg_handle_plugins('extensionfiles');
						break;

				}
			?>

		</td>
	</tr>
</table>

<?php
	ob_end_flush();

	require "fooder.php";
?>