<?php
    if ( !function_exists('array_key_exists') ) {
        function array_key_exists($key, $array) {
            if ( function_exists('key_exists') ) {
                return key_exists($key, $array);
            } else {
                trigger_error('Function array_key_exists (PHP >= 4.1.0) and function key_exists (PHP <= 4.0.6) not found!');
                return false;
            }
        }
    }

	/**
		* procedure unhtmlentities()
		*
		* Convert all HTML entities to their applicable characters
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param text: string[, quote_style: string]
		* @return string
		*/
    function unhtmlentities($text, $quote_style = ENT_COMPAT) {

       if (function_exists('html_entity_decode')) {
           $text = html_entity_decode($text, $quote_style, 'ISO-8859-1'); // NOTE: UTF-8 does not work!
       }
       else {
           $trans_tbl = get_html_translation_table(HTML_ENTITIES, $quote_style);
           $trans_tbl = array_flip($trans_tbl);
           $text = strtr($text, $trans_tbl);
       }

       $text = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $text);
       $text = preg_replace('~&#([0-9]+);~e', 'chr("\\1")', $text);

       return $text;
    }

	/**
		* procedure escapeXMLspecialchars()
		*
		* Replace special chars to HTML standard
		*
		* @package DynPG Frontend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access private
		* @copyright Daniel Schliebner, 08.01.2007
		* @param text: string
		* @return string
		*/
    function escapeXMLspecialchars($text) {
        $text = str_replace('<', '&lt;', $text);
        $text = str_replace('>', '&gt;', $text);
        $text = str_replace('&', '&amp;', $text);
        $text = str_replace('\'', '&apos;', $text);
        $text = str_replace('"', '&quot;', $text);

        return $text;
    }

	/**
		* procedure dynpg_is_valid_EMail()
		*
		* Check if a string is a valid email adress
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param s: string[, new: boolean]
		* @return integer
		*/
    function dynpg_is_valid_EMail($s, $new = true) {
        $ccTLD	= array('ac', 'ad', 'ae', 'af', 'ag', 'ai', 'al', 'am', 'an', 'ao', 'aq', 'ar', 'as', 'at', 'au', 'aw', 'az', 'ba', 'bb', 'bd', 'be', 'bf', 'bg', 'bh', 'bi', 'bj', 'bm', 'bn', 'bo', 'br', 'bs', 'bt', 'bv', 'bw', 'by', 'bz', 'ca', 'cc', 'cd', 'cf', 'cg', 'ch', 'ci', 'ck', 'cl', 'cm', 'cn', 'co', 'cr', 'cu', 'cv', 'cx', 'cy', 'cz', 'de', 'dj', 'dk', 'dm', 'do', 'dz', 'ec', 'ee', 'eg', 'eh', 'er', 'es', 'et', 'fi', 'fj', 'fk', 'fm', 'fo', 'fr', 'ga', 'gd', 'ge', 'gf', 'gg', 'gh', 'gi', 'gl', 'gm', 'gn', 'gp', 'gq', 'gr', 'gs', 'gt', 'gu', 'gw', 'gy', 'hk', 'hm', 'hn', 'hr', 'ht', 'hu', 'id', 'ie', 'il', 'im', 'in', 'io', 'iq', 'ir', 'is', 'it', 'je', 'jm', 'jo', 'jp', 'ke', 'kg', 'kh', 'ki', 'km', 'kn', 'kp', 'kr', 'kw', 'ky', 'kz', 'la', 'lb', 'lc', 'li', 'lk', 'lr', 'ls', 'lt', 'lu', 'lv', 'ly', 'ma', 'mc', 'md', 'mg', 'mh', 'mk', 'ml', 'mm', 'mn', 'mo', 'mp', 'mq', 'mr', 'ms', 'mt', 'mu', 'mv', 'mw', 'mx', 'my', 'mz', 'na', 'nc', 'ne', 'nf', 'ng', 'ni', 'nl', 'no', 'np', 'nr', 'nu', 'nz', 'om', 'pa', 'pe', 'pf', 'pg', 'ph', 'pk', 'pl', 'pm', 'pn', 'pr', 'ps', 'pt', 'pw', 'py', 'qa', 're', 'ro', 'ru', 'rw', 'sa', 'sb', 'sc', 'sd', 'se', 'sg', 'sh', 'si', 'sj', 'sk', 'sl', 'sm', 'sn', 'so', 'sr', 'st', 'sv', 'sy', 'sz', 'tc', 'td', 'tf', 'tg', 'th', 'tj', 'tk', 'tm', 'tn', 'to', 'tp', 'tr', 'tt', 'tv', 'tw', 'tz', 'ua', 'ug', 'uk', 'um', 'us', 'uy', 'uz', 'va', 'vc', 've', 'vg', 'vi', 'vn', 'vu', 'wf', 'ws', 'ye', 'yt', 'yu', 'za', 'zm', 'zw');
        $gTLD	= array('arpa', 'com', 'edu' , 'gov', 'int', 'mil', 'net', 'org');
    	$newTLD = array('aero', 'biz', 'coop', 'info', 'museum', 'name', 'pro');
    	$TLD	= array_merge($ccTLD, $gTLD);
    	$allTLD = array_merge($TLD, $newTLD);
    	list($empty_mail, $at_missing, $invalid_username, $invalid_hostname, $invalid_tld, $unknown_domain, $unknown_user) = array(1, 2, 4, 8, 16, 32, 64);
    	if ($s == '')
    		return ($empty_mail);
    	else if (substr_count($s, '@') != 1)
    		return ($at_missing);
    	else {
    		$res = 0;
    		list($userName, $hostName) = explode("@", $s);
    		if (! preg_match("/^(((([^]<>()[\.,;:@\" ]|(\\\[\\x00-\\x7F]))\\.?)+)|(\"((\\\[\\x00-\\x7F])|[^\\x0D\\x0A\"\\\])+\"))$/", $userName))
    			$res |= $invalid_username;
    		if (! preg_match("/^((([[:alnum:]]([[:alnum:]]|-)*[[:alnum:]]))(\\.([[:alnum:]]([[:alnum:]]|-)*[[:alnum:]]))*|(#[[:digit:]]+)|(\\[([[:digit:]]{1,3}(\\.[[:digit:]]{1,3}){3})]))$/", $hostName))
    			$res |= $invalid_hostname;
    		$subdomains = explode('.', $hostName);
    		$tld = $subdomains[count($subdomains) - 1];
    		if (! ($new? in_array($tld, $allTLD): in_array($tld, $TLD)))
    			$res |= $invalid_tld;

    		return ($res);
    	}
    }

	/**
		* procedure VerifyAccess()
		*
		* Check if user is logged in
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param -
		* @return boolean
		*/
	function VerifyAccess()
	{
		if ( (isset($_SESSION["NAME"])) && (isset($_SESSION["PASSWORD"])) && (isset($_SESSION["ID"])) )
			return TRUE; else return FALSE;
	};

	/**
		* procedure FromEngToGer()
		*
		* Return the german word for TRUE or FALSE
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param word: boolean
		* @return string
		*/
	function FromEngToGer($word)
	{
		$English = array(
							"TRUE" 		=> 		"JA",
							"FALSE" 	=> 		"NEIN"
						);

		$xword = strtoupper($word);

		if ( isset($English[$xword]) ) return ( $English[$xword] );
			else return "";
	}

	/**
		* procedure CheckSlashes()
		*
		* Check if a string contains a slash, an apostrophe or a quotation mark
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param CheckString: string
		* @return boolean
		*/
	function CheckSlashes($CheckString)
	{
		if ( empty($CheckString) ) return (FALSE);
		if ( !strpos($CheckString, "'") && !strpos($CheckString, "\"")
				 	&& !strpos($CheckString, "\\") && !strpos($CheckString, "`") ) return (TRUE);
						else return (FALSE);
	}

	/**
		* procedure GetRandomString()
		*
		* Create a random string
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param length: integer
		* @return string
		*/
	function GetRandomString($length)
	{
		srand( (double)microtime()*1000000 );

		if ($length<0) return "1234567890";

		$i=0; while ($i<$length)
		{
			$offset = rand(48,122); // 48 to 90 , 97 to 122

			if ( !($offset>90 && $offset<97) && ($offset>47 && $offset<123) && $offset!=60 && $offset!=62)
			{
				$result[$i] = chr($offset);

				$i++;
			}
		}
		return ( implode("", $result) );
	}

	/**
		* procedure replace_urlstr()
		*
		* Create a HTLM-link of a url
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param str: string
		* @return string
		*/
	function replace_urlstr($str)
	{
		$pattern = '#(^|[^\"=]{1})(http://|ftp://|mailto:|news:)([^\s<>]+)([\s\n<>]|$)#sm';

		return preg_replace($pattern,"\\1<a href=\"\\2\\3\" target=\"_blank\"><u>\\2\\3</u></a>\\4",$str);
	}

	/**
		* procedure ConvertMysqlDate()
		*
		* Convert a mysql date to a date or a date to a mysql date
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param datestring: string, direction: string
		* @return string
		*/
	function ConvertMysqlDate($datestring, $direction)
	{
		switch ($direction)
		{
			case "MySqlToDate":
				$pattern = "/(\d+)-(\d+)-(\d+)/";
				return (preg_replace($pattern, "\\3.\\2.\\1", $datestring));
			break;

			case "DateToMySql":
				$pattern = "/(\d+).(\d+).(\d+)/";
				return (preg_replace($pattern, "\\3-\\2-\\1", $datestring));
			break;

			default: return($datestring); break;
		}
	}

	/**
		* procedure GetTimeStamp()
		*
		* Create the unix timestamp of a date
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param time: string
		* @return integer
		*/
	function GetTimeStamp($time)
	{
		$SplittetTime = preg_replace("/(\d+).(\d+).(\d+)(.*) (\d+):(\d+):(\d+)/","\\1;\\2;\\3;\\5;\\6;\\7",$time);
		/*
		*  '$SplittetTime' now set as: "Year;Month;Day;Hours;Minutes;Seconds"
		*/
		$SplittetTime = explode(";", $SplittetTime);

		// fix for PHP-Versions >= 5
		// because mktime does not return -1 any more

		$nilDate = true;
		foreach($SplittetTime as $entry){
			if ( (integer)$entry != 0 ) {
				$nilDate = false;
			}
		}
		if ($nilDate) {
			return -1;
		}

		return ( mktime($SplittetTime[3],
					  	$SplittetTime[4],
					  	$SplittetTime[5],
					  	$SplittetTime[1],
					  	$SplittetTime[0],
					  	$SplittetTime[2]) );
	}

	/**
		* procedure dynpg_formPregValid()
		*
		* Set backslashes in front of special chars
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param string: string
		* @return string
		*/
    function dynpg_formPregValid($string)
    {
        $_regEx_specialChars = Array('[', '\\', '^', '$', '.', '|', '?', '*', '+', '(', ')', '/');

        $offset = $string;

        foreach ( $_regEx_specialChars as $regExChar ) {
            $offset = str_replace($regExChar, '\\' . $regExChar, $offset);
        }

        return $offset;
    }

	/**
		* procedure dynpg_public_replaceImageWildcarts_PubToPriv()
		*
		* Replace files with wildcards
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __text: string
		* @return string
		*/
    function dynpg_public_replaceImageWildcarts_PubToPriv($__text)
    {
        return preg_replace("/\/imgfile(\w+).(\w+)/", "/FILEID(\\1)", $__text);
    }

	/**
		* procedure dynpg_public_replaceImageWildcarts_PrivToPub()
		*
		* Replace wildcards with files
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __text: string
		* @return string
		*/
    function dynpg_public_replaceImageWildcarts_PrivToPub($__text)
    {
        $offset      = $__text;
        $result      = '';
        $_needle_pos = TRUE;
        $_image_id   = 0;
        $_image_data = Array();

        while ( $_needle_pos && preg_match("/\FILEID\((\w+)\)/", $offset) )
        {
            $_needle_pos = strpos($offset, "/FILEID(");

            if ( $_needle_pos ) {
                $_needle_pos += 8;
                $_image_id   = substr($offset, $_needle_pos, strpos($offset, ")", $_needle_pos) - $_needle_pos);
                $_image_data = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_images` WHERE `id` = '$_image_id'"), MYSQL_ASSOC);
            }

            $result .= substr($offset, 0, $_needle_pos-8).$_image_data['URL'];
            $offset  = substr($offset, strpos($offset, ")", $_needle_pos)+1);
        }

        $result .= $offset;
        return $result;
    }

	/**
		* procedure dynpgReplacePseudoCode()
		*
		* Replace pseudo code
		* (replace dummy-code for images, replace dummy-code for separator, replace dummy-code for links and images with html-code),
		* check that the seperator does not destroy the site-structure
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param string: string[, IsPreview: boolean]
		* @return string
		*/
    function dynpgReplacePseudoCode($string, $IsPreview = FALSE)
    {
        $result = $string;

        if ( empty($GLOBALS["DefineRootToTool"]) )
			$GLOBALS["DefineRootToTool"] = "";

		@include_once $GLOBALS["DefineRootToTool"] . "config.php";
        @include_once $GLOBALS["DefineRootToTool"] . "connectdb.php";

        $included_files = get_included_files();
		$whole          = '';

		foreach ($included_files as $once) {
			$whole .= $once;
        }

		if ( !strstr($whole, "counter") ) {
            @include $GLOBALS["DefineRootToTool"]."counter.php";
        }

        if ( empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
            if ( $IsPreview )
				$ImageUrlAddition = FORMS_IMAGES_DESTINATIONURL_ROOT;
    		else
				$ImageUrlAddition = $GLOBALS["DefineRootToTool"] . FORMS_IMAGES_DESTINATIONURL_ROOT;
        } else {
            $ImageUrlAddition = $GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"];
        }

        $result = preg_replace('/([^A-Za-z][^inc\=])upload\//', "\\1" . $ImageUrlAddition . '/', $result);

        // -----------------------------------------------------------
        // replace dummy-code for images: FILEID(XXX)

        $result = dynpg_public_replaceFormsWildcarts_PrivToPub($result);
        $result = dynpg_public_replaceImageWildcarts_PrivToPub($result);

        // -----------------------------------------------------------

        // -----------------------------------------------------------
        // replace dummy-code for separator

        $result = preg_replace('/<img([^<>]+)alt="SEPARATOR"([^<>]+)\/>/', "[/SEPERATOR/]", $result);

        // -----------------------------------------------------------


        // -----------------------------------------------------------
        // replace dummy-code for links and images with html-code
        // - css-classes are set in config_general.css

        // THIS IS FOR OLD VERSION OF COUNTED LINKS!

        $p0          = 1;
        $p1          = 0;
        $_avoid_dos  = 0;
        $_linked_res = $result;

        $_linked_res = preg_replace('/<\/a>/'
            						, '[/a]'
                                    , $_linked_res);

		while ( $p0 )
		{
			$p0 = strpos($result, "dynpg->cLink(", $p1);

			if ( $p0 )
			{
				$linkstr = substr($result, $p0, strpos($result, ")", $p0) - ($p0-1) );

				$linkUrl = preg_replace("/dynpg->cLink\(([^\)]+)*?\)/si", "\\1", $linkstr, 1);

                $_linked_res = preg_replace('/<a([^<>]+)dynpg->cLink\('.dynpg_formPregValid($linkUrl).'\)([^<>]+)>/'
                                            , "<a\\1".$GLOBALS['DefineRootToTool']."counter.php?inc=".urlencode($linkUrl)."\\2 class=\"DynPG_General_a_DYNEL_Font_linkc\">"
                                            , $_linked_res
                                            , 1);

            	$_linked_res =  substr($_linked_res, 0, $p0) .
                                preg_replace('/\[\/a\]/'
                    						, ( '</a> ['.( init_counter('link>'.strtolower(addslashes($linkUrl)), TRUE, 'RETURNTEXT') ).']' )
                                            , substr($_linked_res, $p0)
                                            , 1);
			}

			$p1 = $p0 + 1;

		    $_avoid_dos++;

            // To avoid a DoS this shold terminate the loop.
            if ( $_avoid_dos > 999 ) {
                echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                break;
            }
		}

        $result = preg_replace('/\[\/a\]/'
        						, '</a>'
                                , $_linked_res);

        // -----------------------------------------------------------

        // -----------------------------------------------------------
        // replace dummy-code for links and images with html-code
        // - css-classes are set in config_general.css

        $p0          = 1;
        $p1          = 0;
        $_avoid_dos  = 0;
        $_linked_res = $result;

        $_linked_res = preg_replace('/<\/a>/'
            						, '[/a]'
                                    , $_linked_res);

		while ( $p0 )
		{
			$p0 = strpos($_linked_res, "{DynPG::cLink(", $p1);

			if ( $p0 )
			{
				$linkstr = substr($_linked_res, $p0, strpos($_linked_res, ")}", $p0) - ($p0-2) );

				$linkUrl = preg_replace("/\{DynPG::cLink\(([^\)]+)*?\)\}/si", "\\1", $linkstr, 1);

                $_linked_res = preg_replace('/<a([^<>]+)\{DynPG::cLink\('.dynpg_formPregValid($linkUrl).'\)\}([^<>]+)>/'
                                            , "<a\\1".$GLOBALS['DefineRootToTool']."counter.php?inc=".urlencode($linkUrl)."\\2 class=\"DynPG_General_a_DYNEL_Font_linkc\">"
                                            , $_linked_res
                                            , 1);

            	$_linked_res =  substr($_linked_res, 0, $p0) .
                                preg_replace('/\[\/a\]/'
                    						, ( '</a> ['.( init_counter('link>'.strtolower(addslashes($linkUrl)), TRUE, 'RETURNTEXT') ).']' )
                                            , substr($_linked_res, $p0)
                                            , 1);
			}

			$p1 = $p0 + 1;

		    $_avoid_dos++;

            // To avoid a DoS this shold terminate the loop.
            if ( $_avoid_dos > 999 ) {
                echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                break;
            }
		}

        $result = preg_replace('/\[\/a\]/'
        						, '</a>'
                                , $_linked_res);

        // -----------------------------------------------------------

        // make sure that the seperator does not destroy the site-structure
        $x                = strpos($result, '[/SEPERATOR/]');
        $_opened_htmltags = '';
        if ( $x ) {
            $_output_space = substr($result, 0, $x);

            $result = $_output_space;

            $__output_space = "";
            $_avoid_dos     = 0;

            while ( $__output_space != $_output_space )
            {
                if ( !empty($__output_space) ) $_output_space = $__output_space;
                    else $__output_space = $_output_space;

                $__output_space = preg_replace('#<(\w+)[^>]*>([^<>]*?)</(\w+)>#sm', "", $__output_space, 1);
                $__output_space = preg_replace('#<(\w+)[^>]*/>#sm', "", $__output_space);

                $_avoid_dos++;

                // To avoid a DoS this shold terminate the loop.
                // A DoS would be caused here when there is written invald HTML-Code!
                if ( $_avoid_dos > 999 ) {
                    echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                    break;
                }
            }

            $_avoid_dos = 0;

            while ( preg_match('#<(\w+)[^>]*>#sm', $_output_space) )
            {
                $_output_space = preg_replace('#<(\w+)[^>]*>#sm', "[XTAG=\\1]", $_output_space, 1);

                $_avoid_dos++;

                // To avoid a DoS this shold terminate the loop.
                // A DoS would be caused here when there is written invald HTML-Code!
                if ( $_avoid_dos > 999 ) {
                    echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                    break;
                }
            }

            $i                = 1;
            $j                = 0;
            $_avoid_dos       = 0;

            while ( $i )
            {
                $i = strpos($_output_space, '[XTAG=', $j);

                if ( $i ) {
                    $k = strpos($_output_space, ']', $i);

                    $_dummy_code = substr($_output_space, $i, $k - $i + 1);
                    $_opened_htmltags .= '</'.preg_replace('/\[XTAG=(\w+)\]/', '\\1', $_dummy_code).'>';

                    $j = $i+1;
                    $k = $k+1;
                }

                $_avoid_dos++;

                // To avoid a DoS this shold terminate the loop.
                // A DoS would be caused here when there is written invald HTML-Code!
                if ( $_avoid_dos > 999 ) {
                    echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                    break;
                }
            }
            // finished
        }

        return ($result.$_opened_htmltags);
    }

	/**
		* procedure ReplaceDummyCode()
		*
		* Replace dummy code (of old texts)
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param text: string[, IsPreview: boolean, FromArticleId: integer]
		* @return string
		*/
	function ReplaceDummyCode($text, $IsPreview = FALSE, $FromArticleId = 0)
	{
        // -----------------------------------------------------------
        // set important variables and include some files

        if ( empty($GLOBALS["DefineRootToTool"]) ) {
            $GLOBALS["DefineRootToTool"] = "";
        }

		@include $GLOBALS["DefineRootToTool"]."config.php";

        if ( !$GLOBALS['cfg']['config_General_CompatibilityMode'] ) {
            return dynpgReplacePseudoCode($text);
        }

		$included_files = get_included_files();
		$whole = "";

		foreach ($included_files as $once)
			$whole .= $once;

		if ( !strstr($whole, "counter") )
			@include $GLOBALS["DefineRootToTool"] . "counter.php";

		if ( empty($GLOBALS["DYNPG_VAR_OUTSIDE_IMGURL"]) ) {
            if ( $IsPreview )
				$ImageUrlAddition = FORMS_IMAGES_DESTINATIONURL_ROOT;
    		else
				$ImageUrlAddition = FORMS_IMAGES_DESTINATIONURL_ROOT;
        } else {
			$ImageUrlAddition = FORMS_IMAGES_DESTINATIONURL_ROOT;
        }

        $result = ' ' . $text;

        // Windows replacement
		$result = str_replace("]<br />", "]", $result);

		// Unix replacement
		$result = str_replace("]\r<br />", "]", $result);

        // -----------------------------------------------------------

		// -----------------------------------------------------------
        // replace (simple) dummy-code with html-code - css-classes
        // are set in config_general.css

        // bold font
        $result = str_replace("[FETT-BEGINN]", "<span class=\"DynPG_General_span_DYNEL_Font_bold\">", $result);
		$result = str_replace("[FETT-ENDE]", "</span>", $result);

		// italic font
        $result = str_replace("[KURSIV-BEGINN]", "<span class=\"DynPG_General_span_DYNEL_Font_italic\">", $result);
		$result = str_replace("[KURSIV-ENDE]", "</span>", $result);

		// underlined font
        $result = str_replace("[UNTERSTRICHEN-BEGINN]", "<span class=\"DynPG_General_span_DYNEL_Font_underline\">", $result);
		$result = str_replace("[UNTERSTRICHEN-ENDE]", "</span>", $result);

		// email-link
        $result = preg_replace("/\[MAIL-BEGINN ([^\s<>]+)\]/", "<a href=\"mailto:\\1\" class=\"DynPG_General_a_DYNEL_Font_email\">", $result);
		$result = str_replace("[MAIL-ENDE]", "</a>", $result);

		// link (without counting clicks)
        $result = preg_replace("'\[LINK\-BEGINN TARGET=(\w+) ([^\]]+)*?\]'si", "<a href=\"\\2\" target=\"\\1\" class=\"DynPG_General_a_DYNEL_Font_link\">", $result);
		$result = preg_replace("'\[LINK\-BEGINN([^\]]+)*?\]'si", "<a href=\"\\1\" target=\"_blank\" class=\"DynPG_General_a_DYNEL_Font_link\">", $result);
		$result = str_replace("[LINK-ENDE]", "</a>", $result);

		// font definition
        $result = preg_replace("'\[FONT\-BEGINN([^\]]+)*?\]'si", "<span style=\"\\1\" class=\"DynPG_General_span_DYNEL_Font_font\">", $result);
		$result = str_replace("[FONT-ENDE]", "</span>", $result);

		// pre-defined css-classes
        $result = preg_replace("'\[CSSFONT\-BEGINN ([^\]]+)*?\]'si", "<span class=\"\\1\">", $result);
		$result = str_replace("[CSSFONT-ENDE]", "</span>", $result);

        // table
        $result = preg_replace("/RANDABST=(\w+)/", "Cellpadding=\"\\1\"", $result);
		$result = preg_replace("/\[TABELLE RAND=(\w+) RANDFARBE=([^\s<>]+)(.*)\]/", "<table border=\"\\1\"\\3 BorderColor=\"\\2\" class=\"DynPG_General_td_DYNEL_table\">", $result);

		$result = str_replace("[SPALTE]", "<td class=\"DynPG_General_td_DYNEL_table\">", $result);
		$result = str_replace("[/SPALTE]", "</td>", $result);

		$result = str_replace("[ZEILE]", "<TR class=\"DynPG_General_td_DYNEL_table\">", $result);
		$result = str_replace("[/ZEILE]", "</TR>", $result);

		$result = str_replace("[/TABELLE]", "</TABLE>", $result);

		// indend-close
        $result = str_replace("[TABBED-ENDE]", "]", $result);

        // numbered list
		$result = str_replace("[NUMMERIERTE-LISTE]", "<OL CLASS=\"DynPG_General_ol_DYNEL_list\">", $result);
		$result = str_replace("[NUMMERIERTE-LISTE-ENDE]", "</OL>", $result);

        // pointed list
		$result = str_replace("[PUNKTIERTE-LISTE]", "<UL CLASS=\"DynPG_General_ul_DYNEL_list\">", $result);
		$result = str_replace("[PUNKTIERTE-LISTE-ENDE]", "</UL>", $result);

        // listelements
		$result = str_replace("[EL]", "<LI CLASS=\"DynPG_General_li_DYNEL_list\">", $result);
		$result = str_replace("[/EL]", "</LI>", $result);

        // horizontal line
		$result = preg_replace("/\[HR (.*)\]/", "<HR STYLE=\"\\1\" CLASS=\"DynPG_General_hr_DYNEL_line\">", $result);

        // text-blocks
		$result = preg_replace("/\[TEXT (\w+)\((\w+)\)\]/", "<p style=\"text-align:\\2;\" class=\"DynPG_General_p_DYNEL_textblock\">", $result);
		$result = preg_replace("/\[TEXT (\w+) ENDE\]/", "</p>", $result);

        // -----------------------------------------------------------

		// -----------------------------------------------------------
        // replace (complex) dummy-code with html-code - css-classes
        // are set in config_general.css

        $result = preg_replace("/\[TABBED ([^\]]+)\]/"
			, "<table class=\"DynPG_General_table_DYNEL_indent\">
			 <tr class=\"DynPG_General_table_DYNEL_indent\">
			  <td width=\"\\1\">&nbsp;</td>
			  <td class=\"DynPG_General_table_DYNEL_indent\">
			    \\2
				", $result);

		$result = preg_replace("/\[TABBED-ENDE\]/"
			, "
				</span>
			  </td>
			 </tr>
			</table>", $result);

        // -----------------------------------------------------------

        // -----------------------------------------------------------
        // replace dummy-code for links and images with html-code
        // - css-classes are set in config_general.css

        $result = " $result";
		$i      = 0;
        $tpos   = 0;
        $pos    = TRUE;

		while ( $pos != FALSE )
		{
			$pos = strpos($result, "[LINK-C-BEGINN", $tpos);

			if ($pos!=FALSE)
			{
				$linkstr = substr($result, $pos, strpos($result, "]", $pos)-$pos+1);
				$save_linkstr = $linkstr;

				$linkstr = preg_replace("'\[LINK\-C\-BEGINN TARGET=(\w+) ([^\]]+)*?\]'si", "\\1;\\2", $linkstr, 1);
				$linkstr = explode(";", $linkstr);

				if (empty($linkstr[1]))
				{
					$linkstr = preg_replace("'\[LINK\-C\-BEGINN ([^\]]+)*?\]'si", "_blank;\\1", $save_linkstr, 1);
					$linkstr = explode(";", $linkstr);
				}

				$replacestring = "<a href=\"".$GLOBALS["DefineRootToTool"].
                                 "counter.php?inc=$linkstr[1]\" target=\"$linkstr[0]\" title=\"$linkstr[1]\" class=\"DynPG_General_a_DYNEL_Font_linkc\">";

            	$result = substr_replace($result, $replacestring, $pos, strlen($save_linkstr));
            	$result = preg_replace("/\[LINK-C-ENDE\]/",
            						  ("</a> [".( init_counter("link>".strtolower(addslashes($linkstr[1])), TRUE, "RETURNTEXT") )."]"),
            						  $result, 1);
			}

			$tpos = $pos + 1;
		    $i++;
            if ( $i>1000 ) break;
		}

        // -----------------------------------------------------------

        // -----------------------------------------------------------
        // images
		// -----------------------------------------------------------

		$i                          = 0;
        $tpos                       = 0;
        $pos                        = TRUE;
        $private_separator_inside   = FALSE;

		while ( $pos != FALSE )
		{
			$i++;
			$pos=strpos($result, "[BILD", $tpos);
			if ($pos!=FALSE)
			{
				$imagestr = substr($result, $pos, strpos($result, "}", $pos)-$pos+1);
				$save_imagestr=$imagestr;
				if (preg_match("/\[BILD ([^\s<>]+) (\w+) (\w+)([^\]]+)*?\]\{(.*)\}/s",$imagestr))
				{
					$imagestr = preg_replace("/\[BILD ([^\s<>]+) (\w+) (\w+)([^\]]+)*?\]\{(.*)\}/s", "\\1|~seperate~|\\2|~seperate~|\\3|~seperate~|\\4|~seperate~|\\5|~seperate~|\\6", $imagestr);
					$imagestr = explode("|~seperate~|", $imagestr);

					if ($imagestr[3]!="")
					{
						$t = strpos($imagestr[3], " TARGET=");
						$imagestr_target=substr($imagestr[3], (-1)*(strlen($imagestr[3])-$t)) ;
						$imagestr[3]=str_replace($imagestr_target, "", $imagestr[3]);
						$imagestr[3]=substr($imagestr[3], 1);
						$imagestr_target=str_replace(" TARGET=", "", $imagestr_target);
					}
				}
				else
				{
					# For old Version of [BILD]-Prefix: $[BILD NR ALIGN]{TEXT}$
					$imagestr = preg_replace("/\[BILD ([^\s<>]+) (\w+)\]\{(.*)\}/s", "\\1|~seperate~|\\2|~seperate~|\\3", $imagestr);
					$imagestr = explode("|~seperate~|", $imagestr);
					$imagestr[4]=$imagestr[2];
					$imagestr[2]="NEIN";
					$imagestr[3]="";
				}

				/*
				* '$imagestr' is now an array:
				*   |---------|----------------|
				*  	| offset  |     meaning    |
				* 	|---------|----------------|
				* 	|    0	  |   imagenumber  |
				*   |    1	  |   imagealign   |
				*   |    2	  |   ?floattext   |
				*   |    3	  |   IMG as URL   |
				*   |    4	  | text near img  |
				*   |---------|----------------|
				*   |    5	  |     img url    |
				*   |    6	  |    img descr   |
				*   |    7	  |    img title   |
				*   |---------|----------------|
				*/

				if ( strpos($imagestr[4], "[/SEPERATOR/]") )
					{
						$imagestr[4] = substr($imagestr[4], 0, strpos($imagestr[4], "[/SEPERATOR/]"));
						$private_separator_inside = TRUE;
					}

				include $GLOBALS["DefineRootToTool"]."connectdb.php";

				$SQL = "SELECT * FROM `dynpg_cms_images` WHERE `id`='$imagestr[0]'";
				$RES = mysql_query($SQL);
				$ROW = mysql_fetch_object($RES);

				$imagestr[5] = $ImageUrlAddition.$ROW->URL;
				$imagestr[6] = stripslashes($ROW->DESCR);
				$imagestr[7] = stripslashes($ROW->NAME);

				@mysql_free_result($RES);
				@mysql_close($mysql_connection);

				$imagefiletypes = array("jpg", "peg", "gif", "jpe", "bmp", "png");

				if ($imagestr[2]=="JA")
				{
					if ($imagestr[1]=="LINKS") $floattext = " align=\"left\"";
						else $floattext = " align=\"right\"";
					$imagestr[1].="F";
				} else $floattext="";

				if ( in_array( strtolower((substr($imagestr[5], -3))), $imagefiletypes ) )
					$summarized_image_str = "<img src=\"$imagestr[5]\" alt=\"$imagestr[7]\"$floattext class=\"DynPG_General_img_DYNEL_Image\">";
						else $summarized_image_str = "<a href=\"$imagestr[5]\" alt=\"$imagestr[7]\" target=\"_blank\" class=\"DynPG_General_a_DYNEL_File\">Multimediadatei</a>";

				if ( !empty($imagestr[3]) ) $summarized_image_str="<a href=\"$imagestr[3]\" target=\"$imagestr_target\" title=\"$imagestr[3]\" class=\"DynPG_General_a_DYNEL_Image\">$summarized_image_str</a>";

			 switch ($imagestr[1])
			 {
				case "LINKSF": $replacestring= "$summarized_image_str $imagestr[4]";  break;
				case "RECHTSF": $replacestring= "$summarized_image_str $imagestr[4]"; break;
				case "LINKS": $replacestring= "
				 <table class=\"DynPG_General_table_DYNEL_Image\">
				  <tr class=\"DynPG_General_table_DYNEL_Image\">
				    <td class=\"DynPG_General_table_DYNEL_Image\">
					 $summarized_image_str
					 <p class=\"DynPG_General_p_DYNEL_Image_descr\">$imagestr[6]</p>
				    </td>
				    <td class=\"DynPG_General_table_DYNEL_Image\">
					 <p class=\"DynPG_General_p_DYNEL_Image_text\">$imagestr[4]</p>
				    </td>
				   </tr>
				  </table>";
				 break;
				 case "RECHTS": $replacestring= "
				  <table class=\"DynPG_General_table_DYNEL_Image\">
				   <tr>
				    <td class=\"DynPG_General_table_DYNEL_Image\">
					 <p class=\"DynPG_General_p_DYNEL_Image_text\">$imagestr[4]</p>
				    </td>
					<td class=\"DynPG_General_table_DYNEL_Image\">
					 $summarized_image_str
					 <p class=\"DynPG_General_p_DYNEL_Image_descr\">$imagestr[6]</p>
				    </td>
				   </tr>
				  </table>";
				 break;
				 case "ZENTRIERT": $replacestring= "
				  <center>
				  <table class=\"DynPG_General_table_DYNEL_Image\">
				   <tr class=\"DynPG_General_table_DYNEL_Image\">
				    <td class=\"DynPG_General_table_DYNEL_Image\">
				    </td>
					<td class=\"DynPG_General_table_DYNEL_Image\">
					 $summarized_image_str
					 <p class=\"DynPG_General_p_DYNEL_Image_descr\">$imagestr[6]</p>
				    </td>
					<td class=\"DynPG_General_table_DYNEL_Image\">
				    </td>
				   </tr>
				  </table>
				  </center>";
				 break;
			 }

				if ($private_separator_inside) $result = substr($result, 0, strpos($result, $save_imagestr)+strlen($save_imagestr));

				$result = str_replace($save_imagestr, $replacestring, $result);
			}
			$tpos=$pos+1;
			$i++; if ($i>1000) break;
		}
        // -----------------------------------------------------------

		// Windows replacement
		$result = str_replace("><br />", ">", $result);

		// Unix replacement
		$result = str_replace(">\r<br />", ">", $result);

		// If data from article should be load in a forumlar the article-ID has to be transmitted through url.
        if ( $FromArticleId!=0 ) $result = str_replace(".F.", "?getformular_id=$FromArticleId", $result);

        $result = dynpgReplacePseudoCode($result);

		// return prepared text
        return $result;
	}

	/**
		* procedure ReplaceDummyCodeNil()
		*
		* Replace dummy code
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param text: string[, IsPreview: boolean, FromArticleId: integer]
		* @return string
		*/
	function ReplaceDummyCodeNil($text, $IsPreview = FALSE, $FromArticleId = 0)
	{
        if (empty($GLOBALS["DefineRootToTool"])) $GLOBALS["DefineRootToTool"] = "";

		@include $GLOBALS["DefineRootToTool"]."config.php";

		$included_files = get_included_files();
		$whole = "";
		foreach ($included_files as $once)
			$whole .= $once;

		if (!strstr($whole, "counter")) @include $GLOBALS["DefineRootToTool"]."counter.php";

		if ($IsPreview) $ImageUrlAddition = FORMS_IMAGES_DESTINATIONURL_ROOT;
			else $ImageUrlAddition = $GLOBALS["DefineRootToTool"].FORMS_IMAGES_DESTINATIONURL_ROOT;

		$result = " $text";

		$result = str_replace("[FETT-BEGINN]", "", $text);
		$result = str_replace("[FETT-ENDE]", "", $result);
		$result = str_replace("[KURSIV-BEGINN]", "", $result);
		$result = str_replace("[KURSIV-ENDE]", "", $result);
		$result = str_replace("[UNTERSTRICHEN-BEGINN]", "", $result);
		$result = str_replace("[UNTERSTRICHEN-ENDE]", "", $result);
		$result = preg_replace("/\[MAIL-BEGINN ([^\s<>]+)\]/", "", $result);
		$result = str_replace("[MAIL-ENDE]", "", $result);
		$result = preg_replace("'\[LINK\-BEGINN TARGET=(\w+) ([^\]]+)*?\]'si", "", $result);
		$result = preg_replace("'\[LINK\-BEGINN([^\]]+)*?\]'si", "", $result);
		$result = str_replace("[LINK-ENDE]", "", $result);
		$result = preg_replace("'\[FONT\-BEGINN([^\]]+)*?\]'si", "", $result);
		$result = str_replace("[FONT-ENDE]", "", $result);
		$result = preg_replace("'\[CSSFONT\-BEGINN ([^\]]+)*?\]'si", "", $result);
		$result = str_replace("[CSSFONT-ENDE]", "", $result);
		$result = str_replace("[SPALTE]", "", $result);
		$result = str_replace("[/SPALTE]", "", $result);
		$result = str_replace("[ZEILE]", "", $result);
		$result = str_replace("[/ZEILE]", "", $result);
		$result = str_replace("[/TABELLE]", "", $result);
		$result = preg_replace("/RANDABST=(\w+)/", "", $result);
		$result = preg_replace("/\[TABELLE RAND=(\w+) RANDFARBE=([^\s<>]+)(.*)\]/", "", $result);
		$result = str_replace("[TABBED-ENDE]", "", $result);
		$result = str_replace("[NUMMERIERTE-LISTE]", "", $result);
		$result = str_replace("[NUMMERIERTE-LISTE-ENDE]", "", $result);
		$result = str_replace("[PUNKTIERTE-LISTE]", "", $result);
		$result = str_replace("[PUNKTIERTE-LISTE-ENDE]", "", $result);
		$result = str_replace("[EL]", "", $result);
		$result = str_replace("[/EL]", "", $result);
		$result = preg_replace("/\[HR (.*)\]/", "", $result);
		$result = preg_replace("/\[TEXT (\w+)\((\w+)\)\]/", "", $result);
		$result = preg_replace("/\[TEXT (\w+) ENDE\]/", "", $result);
		$result = preg_replace("/\[VOTE ID=(\d+)\]/", "", $result);
		$result = str_replace("[/SEPERATOR/]", "", $result);
		$result = str_replace("[SHOP]", "", $result);
		$result = str_replace("[WARENKORB]", "", $result);
        $result = str_replace("[FORUM]", "", $result);

		$result = " $result";

		$i=0; $tpos=0; $pos=TRUE;
		while ($pos!=FALSE)
		{
			$i++;
			$pos=strpos($result, "[LINK-C-BEGINN", $tpos);
			if ($pos!=FALSE)
			{
				$linkstr = substr($result, $pos, strpos($result, "]", $pos)-$pos+1);
				$save_linkstr=$linkstr;
				$replacestring = "";
				$result = substr_replace($result, $replacestring, $pos, strlen($save_linkstr));
				$result = preg_replace("/\[LINK-C-ENDE\]/",
										  (""),
										  $result, 1);
			}
			$tpos=$pos+1;
		$i++; if ($i>1000) break;
		}

		$i=0; $tpos=0; $pos=TRUE;
		while ($pos!=FALSE)
		{
			$i++;
			if ($tpos<=strlen($result)) $pos=strpos($result, "[BILD", $tpos);
				else $pos=FALSE;
			if ($pos!=FALSE)
			{
				$imagestr = substr($result, $pos, strpos($result, "}", $pos)-$pos+1);
				$save_imagestr=$imagestr;

			 	$result = str_replace($save_imagestr, "", $result);
			}

			$tpos=$pos+1;
			$i++; if ($i>1000) break;
		}

		return $result;
	}

	/**
		* procedure PerformTextFormat()
		*
		* Call PlugIn functions
		*
		* @package DynPG Frontend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param text: string
		* @return string
		*/
	function PerformTextFormat($text)
	{
		$result = stripslashes( nl2br( $text ));

		if ( empty($GLOBALS["DefineRootToTool"]) ) {
            $GLOBALS["DefineRootToTool"] = "";
        }

		if ( empty($GLOBALS["UseThisPageInClass"]) ) {
            $GLOBALS["UseThisPageInClass"] = "";
        }

        if (file_exists($GLOBALS["DefineRootToTool"]."handlevotes.php"))
		{
			@include_once $GLOBALS["DefineRootToTool"]."handlevotes.php";

			$result = HandleVotesInText(" ".$result);
		}

		if (file_exists($GLOBALS["DefineRootToTool"]."handleforum.php"))
		{
			@include_once $GLOBALS["DefineRootToTool"]."handleforum.php";

			$result = HandleForumInText(" ".$result, $GLOBALS["DefineRootToTool"]);
		}

		$my_plugins = dynpg_handle_plugins('handle', true);

		foreach ( $my_plugins as $key => $plugin ) {
		    $result = call_user_func( 'callback_DynPG_PlugIn_' . strtolower($plugin) , $result );
		}

		$result = stripslashes( $result );

		return ($result);
	}

	/**
		* procedure dynpg_getRightsToUser()
		*
		* Check the rights of a user
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param [_typeOfRight: integer, _identStr: string, _identID: integer, _returnType: string]
		* @return boolean / array
		*/
	function dynpg_getRightsToUser($_typeOfRight = 1, $_identStr = 'ADMIN', $_identID = null, $_returnType = 'asValue')
	{
		@include "config.php";
		@include "connectdb.php";

        if ( empty($_SESSION['ID']) ) {
            return FALSE;
        }

        $typesOfRights  = Array( 1  => "CREATE",
                                 2  => "DELETE",
                                 3  => "CHANGE",
                                 4  => "GIVERIGHT",
                                 5  => "DOVOTES",
                                 6  => "DOGUESTBOOK",
                                 7  => "DOBASKET",
                                 8  => "DOFORUM",
                                 9  => "ADMINISTRATIVE",
                                 10 => "AUTARKIC",
                                 11 => "DOSTATISTICS"
                          );

        // identStr 's : ADMIN, GROUP, ARTICLE

        if ( $_typeOfRight > 3 ) {
            $__mysql_row = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_user` WHERE `id` = $_SESSION[ID]"), MYSQL_ASSOC);

            if ( empty($__mysql_row['CREATE']) ) {
                $__mysql_row['CREATE'] = 'FALSE';
            }

            if ( empty($__mysql_row['DELETE']) ) {
                $__mysql_row['DELETE'] = 'FALSE';
            }

            if ( empty($__mysql_row['CHANGE']) ) {
                $__mysql_row['CHANGE'] = 'FALSE';
            }

            if ( $_returnType == 'asValue' ) {
                return ( $__mysql_row[ $typesOfRights[$_typeOfRight] ] == 'TRUE' );
            } else {
                return Array($__mysql_row[ $typesOfRights[1] ], $__mysql_row[ $typesOfRights[2] ], $__mysql_row[ $typesOfRights[3] ]);
            }
        }

        $__mysql_row = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_rights` WHERE `USERID` = $_SESSION[ID] AND `PARENT` = '$_identStr' AND `SECTION` = $_identID"), MYSQL_ASSOC);

        $__mysql_result = mysql_query("SELECT * FROM `dynpg_cms_rights` WHERE `USERID` = $_SESSION[ID] AND `PARENT` = 'ADMIN'");

        if ( mysql_num_rows($__mysql_result) > 0 ) {
            $__offset_row = mysql_fetch_array($__mysql_result, MYSQL_ASSOC);

            if ( $__offset_row['CREATE'] == 'TRUE' && empty($__mysql_row['CREATE']) ) {
                $__mysql_row['CREATE'] = 'TRUE';
            }

            if ( $__offset_row['DELETE'] == 'TRUE' && empty($__mysql_row['DELETE']) ) {
                $__mysql_row['DELETE'] = 'TRUE';
            }

            if ( $__offset_row['CHANGE'] == 'TRUE' && empty($__mysql_row['CHANGE']) ) {
                $__mysql_row['CHANGE'] = 'TRUE';
            }
        }

        if ( empty($__mysql_row['CREATE']) ) {
            $__mysql_row['CREATE'] = 'FALSE';
        }

        if ( empty($__mysql_row['DELETE']) ) {
            $__mysql_row['DELETE'] = 'FALSE';
        }

        if ( empty($__mysql_row['CHANGE']) ) {
            $__mysql_row['CHANGE'] = 'FALSE';
        }

        if ( $_returnType == 'asValue' ) {
            return ( $__mysql_row[ $typesOfRights[$_typeOfRight] ] == 'TRUE' );
        } else {
            return Array($__mysql_row[ $typesOfRights[1] ], $__mysql_row[ $typesOfRights[2] ], $__mysql_row[ $typesOfRights[3] ]);
        }
	}

	/**
		* procedure mysql_password()
		*
		*
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param passStr: string
		* @return string
		*/
	function mysql_password($passStr)
	{
       $nr		=	0x50305735;
       $nr2		=	0x12345671;
       $add		=	7;
       $charArr = preg_split("//", $passStr);

       foreach ($charArr as $char) {
               if (($char == '') || ($char == ' ') || ($char == '\t')) continue;
               $charVal = ord($char);
                 $nr ^= ((($nr & 63) + $add) * $charVal) + ($nr << 8);
               $nr2 += ($nr2 << 8) ^ $nr;
                 $add += $charVal;
       }
       return sprintf("%08x%08x", ($nr & 0x7fffffff), ($nr2 & 0x7fffffff));
	}

	/**
		* procedure dynpg_htmlentities()
		*
		*
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param string: string
		* @return string
		*/
	function dynpg_htmlentities($string)
	{
		$_offset = $string;
		$_offset = str_replace("<", "#lt", $_offset);
		$_offset = str_replace(">", "#gt", $_offset);
		$_offset = str_replace("&", "#amp", $_offset);
		$_offset = htmlentities($_offset, ENT_NOQUOTES);
		$_offset = str_replace("#lt", "<", $_offset);
		$_offset = str_replace("#gt", ">", $_offset);
		$_offset = str_replace("#amp", "&", $_offset);

		return $_offset;
	}

	/**
		* procedure dynpg_insert_urlheader()
		*
		* Insert the url header
		*
		* @package DynPG Frontend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param [strip_out: string, src: string, force: boolean]
		* @return string
		*/
	function dynpg_insert_urlheader($strip_out = "", $src = "*", $force = TRUE)
	{
		$_src = ( $src == '*' && $force ) ? preg_replace("/&t=([^\&]+)/", "", getenv("QUERY_STRING")) : $src;

        $_src = preg_replace("/read_srch=([^\&]+)/", "", $_src);

        if ( substr($_src, -1)!='&' ) {
            $_src .= '&';
        }

        $_src = str_replace('?&', '?', $_src);

        $_valid = explode('&', $_src);

        $_src = '';

        foreach ( $_valid as $key => $value ) {
            if ( !empty($value) ) {
               $_src .= $value . '&';
            }
        }

		if ( empty($strip_out) ) {
            return $_src;
        } else {
            return ( preg_replace("/$strip_out/", "", $_src) );
        }
	}

	/**
		* procedure dynpg_datetotimestamp()
		*
		* Create a unix timestamp of a date and a time
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param date: string[, time: string]
		* @return integer
		*/
    function dynpg_datetotimestamp($date, $time = "00:00")
    {
        $offset = trim(str_replace(" ", "", $date));

        $offset = preg_replace("/(\w+).(\w+).(\w+)/", "\\1|\\2|\\3", $offset);

        list($day, $month, $year) = explode("|", $offset);

        $offset = trim(str_replace(" ", "", $time));

        if ( preg_match("/(\w+):(\w+):(\w+)/", $offset) ) {
            $offset = preg_replace("/(\w+):(\w+):(\w+)/", "\\1|\\2|\\3", $offset);
            list($hours, $minutes, $seconds) = explode("|", $offset);
        } else {
            $offset = preg_replace("/(\w+):(\w+)/", "\\1|\\2", $offset);
            list($hours, $minutes) = explode("|", $offset);
            $seconds = 0;
        }

        // fix for PHP-Versions >= 5
		// because mktime does not return -1 any more

		if ($date == "00.00.0000") {
			return -1;
		}

        return mktime($hours, $minutes, $seconds, $month, $day, $year);
    }

	/**
		* procedure dynpg_sendmail()
		*
		* Create email-header and send email
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __mailid: integer[, __ctx: array, __completeMail: boolean]
		* @return -
		*/
    function dynpg_sendmail($__mailid, $__ctx = array(), $__completeMail = True)
    {
        include 'connectdb.php';

        $maildata = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_mailtexts` WHERE `m_id` = '$__mailid'"), MYSQL_ASSOC);

        if ( $__completeMail ) {
            $maildata['mailtext'] = $__ctx['ctx_general->mailText'];
        }

        foreach ( $__ctx as $ctxCmd => $cmdContent )
        {
            // replace %$ctxCmd% with $cmdContent in $maildata['mailtext']
            $cmdContent = stripslashes($cmdContent);

            $maildata['mailtext']  = str_replace("%$ctxCmd%", $cmdContent, $maildata['mailtext']);
            $maildata['mailref']   = str_replace("%$ctxCmd%", $cmdContent, $maildata['mailref']);
            $maildata['mailfrom']  = str_replace("%$ctxCmd%", $cmdContent, $maildata['mailfrom']);
            $maildata['mailto']    = str_replace("%$ctxCmd%", $cmdContent, $maildata['mailto']);
            $maildata['mailreply'] = str_replace("%$ctxCmd%", $cmdContent, $maildata['mailreply']);
        }

        // we will produce a RFC 822 - conform mail

        $rfc822specials = Array("(", ")", "<", ">", "@",  ",", ";", ":", ".", "\"", "[", "]");

        $maildata['mailfrom'] = stripslashes($maildata['mailfrom']);

        foreach ( $rfc822specials as $char ) {
            $maildata['mailfrom'] = str_replace($char, '\\' . $char, $maildata['mailfrom']);
        }

        $boundary    = '--' . md5( uniqid("DYNPGboundary12112005") );
        $priorities  = array( '1 (Highest)', '2 (High)', '3 (Normal)', '4 (Low)', '5 (Lowest)' );
        $priority    = $priorities[2];
        $contype	 = $maildata['type'];
		$charset     = 'ISO-8859-1';
        $ctencoding  = '8bit';
        $sep         = chr(13) . chr(10);
        $disposition = 'inline';
        $from        = $maildata['mailfrom'].'<'.$maildata['mailreply'].'>';

        $_mailheader  = "From: $from\nX-Priority: $priority";
        $_mailheader .= "Mime-Version: 1.0\nContent-Type: multipart/mixed;\n boundary=\"$boundary\"\n";
        $_mailheader .= "Content-Transfer-Encoding: $ctencoding\nX-Mailer: Php/swmailer-0.1\n\n";

        if( $maildata['type']=="text/html" ) {
        	$mailtext =
            '<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 4.0 Transitional//EN">' . "\r\n" .
            '<html>' . "\r\n" .
            '   <head>' . "\r\n" .
            '    	<title>' . htmlentities($maildata['mailref']) . '</title>' . "\r\n" .
            '    </head>' . "\r\n" .
            '    <body>' . "\r\n" .
            '        ' . str_replace("\r\n", "<br />", $maildata['mailtext']) . "\r\n" .
            '    </body>' . "\r\n" .
            '</html>';
		}
		else {
			$mailtext = str_replace("\r\n", "\n", $maildata['mailtext']);
		}
		$_mailmessage = "This is a multi-part message in MIME format.\n--$boundary\n";
        $_mailmessage .= "Content-Type: $contype; charset=$charset\n";
        $_mailmessage .= "Content-Transfer-Encoding: $ctencoding\n\n" . $mailtext ."\n\n";
        $_mailmessage .= "--" . $boundary . "--";

        $_mailto = explode(';', $maildata['mailto']);

        // Debug:
        //  echo "<pre><b>to</b>: ";
        //  print_r($_mailto);
		//  echo "\n\n".htmlentities($_mailheader.$_mailmessage)."</pre>";

        foreach ( $_mailto as $to ) {
            mail(trim($to), $maildata['mailref'], $_mailmessage, $_mailheader);
        }
    }

	/**
		* procedure dynpg_stringprocessing_enlarge()
		*
		* Set a char/string between every letter of a string
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param str: string[, letter: string]
		* @return string
		*/
    function dynpg_stringprocessing_enlarge($str, $letter = ' ')
    {
        $__arr = Array();

        for ( $i = 0; $i <= strlen($str)-1; $i++ ) {
            $__arr[$i] = substr($str, $i, 1);
        }

        return implode($letter, $__arr);
    }

	/**
		* procedure dnypg_interna_List_Successors()
		*
		* Writes a list of grouptreestruct (of article-subgroups)
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param _group_id: integer[, _depth: integer, _output_row: string, _order_by: string, _sort: string, _as_html_list: boolean, _selection: integer, _check_rights: boolean]
		* @return -
		*/
    function dnypg_interna_List_Successors($_group_id, $_depth = 0, $_output_row = null, $_order_by = null, $_sort = null, $_as_html_list = TRUE, $_selection = null, $_check_rights = TRUE)
    {
        $__result = mysql_query("SELECT DISTINCT
                                        A.*,
                                        B.*
                                     FROM
                                        `dynpg_cms_group_treestruct` AS A
                                        INNER JOIN `dynpg_cms_groups` AS B
                                        ON A.`successor_id_fk` = B.`id`
                                     WHERE
                                        A.`element_id_fk` = '$_group_id'
                                     ORDER BY
                                        B.`$_order_by` $_sort");

        while ( $__row = mysql_fetch_array($__result, MYSQL_ASSOC) ) {
            $_ouput = $_output_row;

            if ( !is_null($__row['successor_id_fk']) ) {
                $offset = mysql_query("SELECT * FROM `dynpg_cms_group_treestruct` WHERE `element_id_fk` = '".$__row['successor_id_fk']."'");
                $__grp_has_Successors = mysql_num_rows($offset) > 0;
            } else {
                $__grp_has_Successors = FALSE;
            }

            if ( $_as_html_list ) {
                if ( $__grp_has_Successors ) {
                    $_ouput = str_replace('%SYMB%', '<img src="pictures/space.gif" alt="Space" title="" height="0" width="'.(string)($_depth * 20).'" border="0" />'.'<img src="pictures/subtree_min.gif" alt="SubtreeMin" title="ausgeklappt" border="0" />', $_ouput);
                } else {
                    $_ouput = str_replace('%SYMB%', '<img src="pictures/space.gif" alt="Space" title="" height="0" width="'.(string)($_depth * 20 + 9).'" border="0" />', $_ouput);
                }
            } else {
                if ( $__grp_has_Successors ) {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth).'', $_ouput);
                } else {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth) . '', $_ouput);
                }
            }

            foreach ( $__row as $key => $value ) {
                $value = htmlentities(stripslashes($value));

                if ( $key == 'NAME' ) {
                    if ( !$__grp_has_Successors && $_as_html_list ) {
                        $value = '<a href="index.php?show=3&take='.$__row['id'].'" target="_self" title="In &quot;'.$value.'&quot; neue Artikel erfassen"><b>'.$value.'</b></a>';
                    }
                }

                if ( $key == 'SHORTTEXT' && !empty($value) ) {
                    $value = '(' . $value . ')';
                }

                $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
            }

            if ( $_selection != $__row['id'] ) {
                $_ouput = str_replace(' selected="selected"', '', $_ouput);
            }

            if ( !$_check_rights || ( $_check_rights && dynpg_getRightsToUser(null, 'GROUP', $__row['id'], 'asArray') != Array('FALSE', 'FALSE', 'FALSE') ) ) {
                echo $_ouput;

                if ( !is_null($__row['successor_id_fk']) ) {
                        dnypg_interna_List_Successors($__row['successor_id_fk'], $_depth + 1, $_output_row, $_order_by, $_sort, $_as_html_list, $_selection);
                }
            }
        }
    }

	/**
		* procedure dnypg_interna_List_Successors_img()
		*
		* Writes a list of grouptreestruct (of file-subgroups)
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param _group_id: integer[, _depth: integer, _output_row: string, _order_by: string, _sort: string, _as_html_list: boolean, _selection: integer, _check_rights: boolean]
		* @return -
		*/
	function dnypg_interna_List_Successors_img($_group_id, $_depth = 0, $_output_row = null, $_order_by = null, $_sort = null, $_as_html_list = TRUE, $_selection = null, $_check_rights = TRUE)
    {
        $__result = mysql_query("SELECT DISTINCT
                                        A.*,
                                        B.*
                                     FROM
                                        `dynpg_cms_imagegroup_treestruct` AS A
                                        INNER JOIN `dynpg_cms_imagegroups` AS B
                                        ON A.`successor_id_fk` = B.`id`
                                     WHERE
                                        A.`element_id_fk` = '$_group_id'
                                     ORDER BY
                                        B.`$_order_by` $_sort");

        while ( $__row = mysql_fetch_array($__result, MYSQL_ASSOC) ) {
            $_ouput = $_output_row;

            if ( !is_null($__row['successor_id_fk']) ) {
                $offset = mysql_query("SELECT * FROM `dynpg_cms_imagegroup_treestruct` WHERE `element_id_fk` = '".$__row['successor_id_fk']."'");
                $__grp_has_Successors = mysql_num_rows($offset) > 0;
            } else {
                $__grp_has_Successors = FALSE;
            }

            if ( $_as_html_list ) {
                if ( $__grp_has_Successors ) {
                    $_ouput = str_replace('%SYMB%', '<img src="pictures/space.gif" alt="Space" title="" height="0" width="'.(string)($_depth * 20).'" border="0" />'.'<img src="pictures/subtree_min.gif" alt="SubtreeMin" title="ausgeklappt" border="0" />', $_ouput);
                } else {
                    $_ouput = str_replace('%SYMB%', '<img src="pictures/space.gif" alt="Space" title="" height="0" width="'.(string)($_depth * 20 + 9).'" border="0" />', $_ouput);
                }
            } else {
                if ( $__grp_has_Successors ) {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth).'', $_ouput);
                } else {
                    $_ouput = str_replace('%SYMB%', '|' . str_repeat('-', $_depth) . '', $_ouput);
                }
            }

            foreach ( $__row as $key => $value ) {
                $value = htmlentities(stripslashes($value));

                if ( $key == 'NAME' ) {
                    if ( !$__grp_has_Successors && $_as_html_list ) {
                        $value = '<a href="index.php?show=3&take='.$__row['id'].'" target="_self" title="In &quot;'.$value.'&quot; neue Artikel erfassen"><b>'.$value.'</b></a>';
                    }
                }

                if ( $key == 'SHORTTEXT' && !empty($value) ) {
                    $value = '(' . $value . ')';
                }

                $_ouput = str_replace('%'.strtoupper($key).'%', $value, $_ouput);
            }

            if ( $_selection != $__row['id'] ) {
                $_ouput = str_replace(' selected="selected"', '', $_ouput);
            }

            echo $_ouput;

            if ( !is_null($__row['successor_id_fk']) ) {
				dnypg_interna_List_Successors_img($__row['successor_id_fk'], $_depth + 1, $_output_row, $_order_by, $_sort, $_as_html_list, $_selection);
            }

        }
    }

	/**
		* procedure dynpg_public_create_strSum()
		*
		* Build the summary of a from binary to a decimal convertet char of a string
		*
		* @package DynPG Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param _str: string
		* @return integer
		*/
    function dynpg_public_create_strSum($_str)
    {
        $_str_arr = explode(';', chunk_split($_str, 1, ';'));

        $result = 0;
        foreach ( $_str_arr as $char ) {
            $result += bindec($char);
        }

        return $result;
    }

	/**
		* procedure dynpg_public_create_uniqueID()
		*
		* ?Create md5 and set some SESSION-variables of Guestbook
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param _time: integer[, _rnd: integer , _idx: integer]
		* @return string
		*/
	function dynpg_public_create_uniqueID($_time, $_rnd = null, $_idx = null)
    {
        srand( (double)microtime()*1000000 );

        $_fragment[0] = $_SESSION['DYNPG_GB_RND'] = GetRandomString(64);
        $_fragment[1] = $_SESSION['DYNPG_GB_IDX'] = $calcAs = rand(1,5);

        if ( !is_null($_rnd) ) {
            $_fragment[0] = $_rnd;
        }

        if ( !is_null($_idx) ) {
            $_fragment[1] = $_idx;
        }

        switch ( $_fragment[1] ) {
            case 1:  $_fragment[2] = md5( $_time * dynpg_public_create_strSum($_fragment[0]) );   break;
            case 2:  $_fragment[2] = md5( $_time + dynpg_public_create_strSum($_fragment[0]) );   break;
            case 3:  $_fragment[2] = md5( $_time + dynpg_public_create_strSum($_fragment[0])^2 ); break;
            case 4:  $_fragment[2] = md5( $_time - dynpg_public_create_strSum($_fragment[0]) );   break;
            default: $_fragment[2] = md5($_time); break;
        }

        return $_fragment[2];
    }

	/**
		* procedure dynpg_public_replaceFormsDefaultValues()
		*
		* Fill formfields default values
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __text: string
		* @return string
		*/
    function dynpg_public_replaceFormsDefaultValues($__text)
    {
        $result = $__text;

        $pos = Array('start' => 0, 'current' => 1, 'textarea' => 0, 'end' => 0);

        if ( $pos['start'] = strpos(strtolower($__text), 'name="' . strtolower(trim($_SESSION['FORM_DATA']['formname'])) . '"') ) {

            $result = substr($result, 0, strpos($result, '>', $pos['start']) + 1) . '{$Main->Forms->Error}' . substr($result, strpos($result, '>', $pos['start']) + 1);

            $pos['end']     = strpos($__text, '</form>', $pos['start']);
            $pos['current'] = 1;

            $_avoid_dos = 0;

            while ( $pos['end'] && $pos['current'] && $pos['current'] < $pos['end'] ) {
                $pos['textarea'] = strpos($__text, '<textarea', $pos['start']);
                $pos['select']   = strpos($__text, '<select', $pos['start']);
                $pos['current']  = strpos($__text, '<input', $pos['start']);

                // Debug
                // echo '<pre>';
                // print_r($pos);
                // echo '</pre>';

                if ( $pos['select'] && ( $pos['select'] < $pos['current'] || $pos['current'] === false ) && ( $pos['select'] < $pos['textarea'] || $pos['textarea'] === false ) ) {
                   $pos['current'] = $pos['select'];
                   $pos['select']  = TRUE;
                } else {
                   if ( !$pos['current'] && !$pos['textarea'] ) {
                    $pos['current'] = $pos['select'];
                   } else {
                    $pos['select'] = FALSE;
                   }
                }

                if ( !$pos['select'] ) {
                    if ( $pos['textarea'] && $pos['current'] > $pos['textarea'] ) {
                       $pos['current']  = $pos['textarea'];
                       $pos['textarea'] = TRUE;
                    } else {
                       if ( !$pos['current'] ) {
                        $pos['current'] = $pos['textarea'];
                       } else {
                        $pos['textarea'] = FALSE;
                       }
                    }
                } else {
                    $pos['textarea'] = FALSE;
                }

                $pos['start'] = $pos['current'] + 1;

                $current['ref'] = substr($__text, $pos['current'], ( $delimiter = strpos($__text, '>', $pos['current']) ) - $pos['current'] + 1 );
                $current['id']  = str_replace('[]', '', preg_replace('/.*name=[\'"]([^"\']+)[\'"].*/', '\1', $current['ref']));

                // Debug
                // echo '<p>'.htmlentities($current['ref']).'<p><p>'.htmlentities($current['id']).'<p><hr />';

                if ( strpos($current['ref'], 'type="checkbox"') ) {
                    if ( !isset($_SESSION['FORM_DATA'][$current['id']]) ) {
                        $_SESSION['FORM_DATA'][$current['id']] = Array();
                    } else {
                        if (! is_array($_SESSION['FORM_DATA'][$current['id']]) ) {
                            $_SESSION['FORM_DATA'][$current['id']] = Array($_SESSION['FORM_DATA'][$current['id']]);
                        }
                    }
                }

                if ( isset($_SESSION['FORM_DATA'][$current['id']]) ) {
                    if ( $pos['textarea'] ) {
                        $current['new'] = $current['ref'] . htmlentities(stripslashes($_SESSION['FORM_DATA'][$current['id']])) . '</textarea>';
                        $current['ref'] = $current['ref'] . substr($__text, $delimiter + 1, strpos($__text, '</textarea>', $delimiter) - $delimiter + 10);
                    } elseif ( $pos['select'] ) {
                        $current['ref'] = $current['ref'] . substr($__text, $delimiter + 1, strpos($__text, '</select>', $delimiter) - $delimiter + 8);
                        $current['new'] = preg_replace('/selected="selected"/', '', $current['ref']);
                        $current['new'] = preg_replace('/value="'.dynpg_formPregValid(stripslashes($_SESSION['FORM_DATA'][$current['id']])).'"/', 'value="'.htmlentities(stripslashes($_SESSION['FORM_DATA'][$current['id']])).'" selected="selected"', $current['ref']);
                    } else {
                        if ( !strpos($current['ref'], 'type="password"') && !is_array($_SESSION['FORM_DATA'][$current['id']]) ) {
                            if ( preg_match('/value="([^"]+)"/', $current['ref']) ) {
                                $current['new'] = preg_replace('/value="([^"]+)"/', 'value="'.htmlentities(stripslashes($_SESSION['FORM_DATA'][$current['id']])).'"', $current['ref']);
                            } else {
                                $current['new'] = preg_replace('/name="([^"]+)"/', 'name="\1" value="'.htmlentities(stripslashes($_SESSION['FORM_DATA'][$current['id']])).'"', $current['ref']);
                            }
                        } else {
                            $current['new'] = $current['ref'];
                        }

                        if ( strpos($current['ref'], 'type="radio"') ) {
                            $current['new']   = preg_replace('/checked="checked"/', '', $current['ref']);
                            $current['value'] = preg_replace('/.*value=[\'"]([^"\']+)[\'"].*/', '\1', $current['new']);

                            if ( $current['value'] == $_SESSION['FORM_DATA'][$current['id']] ) {
                                $current['new'] = preg_replace('/type="radio"/', 'type="radio" checked="checked"', $current['new']);
                            }
                        }

                        if ( strpos($current['ref'], 'type="checkbox"') ) {
                            $current['new']   = preg_replace('/checked="checked"/', '', $current['ref']);
                            $current['value'] = preg_replace('/.*value=[\'"]([^"\']+)[\'"].*/', '\1', $current['new']);

                            if ( in_array($current['value'], $_SESSION['FORM_DATA'][$current['id']]) ) {
                                $current['new'] = preg_replace('/type="checkbox"/', 'type="checkbox" checked="checked"', $current['new']);
                            }
                        }
                    }

                    $result = str_replace($current['ref'], $current['new'], $result);

                    // Debug
                    // echo '<p>'.htmlentities($current['ref']).'<p><p>'.htmlentities($current['new']).'<p><hr />';
                }

                $_avoid_dos++;

                // To avoid a DoS this shold terminate the loop.
                // A DoS would be caused here when there is written invald HTML-Code!
                if ( $_avoid_dos > 999 ) {
                    echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                    break;
                }
            }
        }

        return $result;
    }

	/**
		* procedure dynpg_public_replaceFormsWildcarts_PrivToPub()
		*
		* Replace wildcards of textareas with textarea, delete form-image wildcards and add hiddenfields
		*
		* @package DynPG Frontend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __text: string
		* @return string
		*/
    function dynpg_public_replaceFormsWildcarts_PrivToPub($__text)
    {
        $result = $__text;

        $pattern = '/<img([^<>]+)alt="area([^<>]+) text=([^"]*)"([^<>]+)\/>/';
        $replace = '<textarea {DynPG::specialChar} \2 {DynPG::/specialChar}>\3</textarea>';
        $result  = preg_replace($pattern, $replace, $result);

        $pos = Array('start' => 0, 'current' => 1, 'end' => 0);

        $_avoid_dos = 0;

        while ( $pos['current'] ) {
            $pos['current'] = strpos($result, '{DynPG::specialChar} ', $pos['start']);

            if ( $pos['current'] ) {
                $pos['ref'] = substr($result, $pos['current'], ( $delimiter = strpos($result, ' {DynPG::/specialChar}', $pos['current']) ) - $pos['current'] + 22 );

                $pos['replace'] = str_replace('&#39;', '"', $pos['ref']);
                $pos['replace'] = str_replace('{DynPG::specialChar} ', '', $pos['replace']);
                $pos['replace'] = str_replace(' {DynPG::/specialChar}', '', $pos['replace']);

                $result = str_replace($pos['ref'], $pos['replace'], $result);

                // Debug
                // echo '<p> ' . $pos['ref'] . ' <br /> ' . $pos['replace'] . ' </p>';

                $pos['start'] = $pos['current'] + 1;
            }

            $_avoid_dos++;

            // To avoid a DoS this shold terminate the loop.
            // A DoS would be caused here when there is written invald HTML-Code!
            if ( $_avoid_dos > 999 ) {
                echo '<p style="color:red;"><b>ATTENTION:</b> A Denial of Service (DoS) has been prevented!</p>';
                break;
            }
        }

        unset($pos);

        if ( !empty($_SESSION['FORM_DATA']) ) {
            $result = dynpg_public_replaceFormsDefaultValues($result);
        }

        $referpath = getenv('SERVER_NAME') . $_SERVER['PHP_SELF'];

        if ( !ereg('^http://', $referpath) ) {
            $referpath = 'http://' . $referpath;
        }

		if ( empty($_SESSION['FORM_DATA_HASH']) || empty($_SESSION['FORM_DATA_TIME']) ) {
            srand( microtime() * 1000000 );
            $_SESSION['FORM_DATA_HASH'] = strtoupper( md5( uniqid( rand() , true ) ) );
            $_SESSION['FORM_DATA_TIME'] = time();
        }

        $pattern = '/<img[^<>]+alt="zonebottom 1=([^\s]+)[\s]*2=([^\s]+)[\s]*3=(\w+)[\s]*4=(\w+)(\s*5=(\w+)){0,1}"([^<>]+)\/>/';
        $replace = '<input type="hidden" name="dynpgform" value="' . $_SESSION['FORM_DATA_HASH'] . '" />' .
                   '<input type="hidden" name="from_ts" value="' . time() . '" />' .
                   '<input type="hidden" name="sendmail" value="\1" />' .
                   '<input type="hidden" name="formname" value="\2" />'.
                   '<input type="hidden" name="successpge" value="\3" />'.
                   '<input type="hidden" name="errorpge" value="\4" />'.
                   '<input type="hidden" name="formset" value="\6" />'.
                   '<input type="hidden" name="referpath" value="' . $referpath . '" />' .
                   '<input type="hidden" name="querystring" value="' . getenv('QUERY_STRING') . '" />' .
                   '<input type="hidden" name="referquery" value="' . preg_replace('/(&?)read_article=(\w+)/', '', '?' . getenv('QUERY_STRING')) . '" />' .
                   '<input type="hidden" name="referfix" value="' . ( !preg_match('/(&?)read_article=(\w+)/', '?' . getenv('QUERY_STRING')) ? 'yes' : 'no' ) . '" />';

        $result  = preg_replace($pattern, $replace, $result);

        $pattern = '#<img alt="zonetop.*>#U';
        $replace = '';
        $result  = preg_replace($pattern, $replace, $result);

        $result  = str_replace('{DynPG::rootToTool}', $GLOBALS["DefineRootToTool"], $result);

        return $result;
    }

	/**
		* procedure dynpg_public_replaceFormsWildcarts_PubToPriv()
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param __text: string
		* @return string
		*/
    function dynpg_public_replaceFormsWildcarts_PubToPriv($__text)
    {
        $result = $__text;

        // A rewriting isn't required because data is saved in "pseudo"-format in database
        // This action is only "one-way".

        return $result;
    }

		/**
		* procedure dynpg_handle_plugins()
		*
		* Handle plugins
		*
		* @package DynPG Backend Engine
		* @author Daniel Schliebner <mail@ds-develop.de>
		* @version 1.0
		* @access public
		* @copyright Daniel Schliebner, 08.01.2007
		* @param [handle: string, once: boolean, require: boolean]
		* @return array
		*/
    function dynpg_handle_plugins($handle = 'handle', $once = false, $require = true)
    {
        require_once dirname(__FILE__) . '/plugins/plugins.php';
        require_once dirname(__FILE__) . '/plugins/templates.php';
        require_once dirname(__FILE__) . '/plugins/languages.php';

        $directory = opendir(dirname(__FILE__) . '/plugins/');
        $plugins   = Array();

        while ( $sub = readdir($directory) ) {
            if ( !in_array($sub, Array('.', '..')) && is_dir(dirname(__FILE__) . '/plugins/' . $sub) ) {
                if ( $require ) {
                    if ( $once ) {
                        require_once dirname(__FILE__) . '/plugins/' . $sub . '/' . $handle . '.php';
                    } else {
                        require      dirname(__FILE__) . '/plugins/' . $sub . '/' . $handle . '.php';
                    }
                }

                $plugins[] = $sub;
            }
        }

        closedir($directory);

        clearstatcache();

        return $plugins;
    }

    /**
	* function dynpg_deduceProtocol()
	*
	* Returns possible server protocol.
	*
	* @package DynPG Backend Engine
	* @author Daniel Schliebner <mail@ds-develop.de>
	* @version 1.0
	* @access public
	* @copyright Daniel Schliebner, 18.03.2007
	* @param -
	* @return string
	*/
	function dynpg_deduceProtocol() {
		$sP = strtolower($_SERVER["SERVER_PROTOCOL"]);
		$pP = Array(
				'http' ,
				'https' ,
				'ftp'
			  );

	// check if protocol is some of pP

		foreach ( $pP as $protocol ) {
			if ( preg_match("/^{$protocol}/", $sP) ) {
				return $protocol;
			}
		}

	// return http protocol by default
		return 'http';
	}

	/**
	* function dynpg_get_HTTP_URL()
	*
	* Create an absolute url from server variables to current script.
	*
	* @package DynPG Backend Engine
	* @author Daniel Schliebner <mail@ds-develop.de>
	* @version 1.0
	* @access public
	* @copyright Daniel Schliebner, 18.03.2007
	* @param [relPage: string, defaultPort: string]
	* @return string
	*/
	function dynpg_get_HTTP_URL($relPage = null, $defaultPort = '80') {
		return dynpg_deduceProtocol() . '://' . $_SERVER["SERVER_NAME"] . ($defaultPort==$_SERVER["SERVER_PORT"]? '': ":{$_SERVER['SERVER_PORT']}" ) . ( is_null($relPage)? $_SERVER["PHP_SELF"]: "/{$relPage}" );
	}
?>