<?php
/* {{{
*   START function public_Valid_form_data_ref102005($_form_type = 1, &$error)
*   }}}
*/
/**
* This function checks received data from a html-<form [...]>-object
* send with the flag method="post" or "get".
* As a result this data is included in the superglobal
* PHP-Arrays $_POST or $_GET.
*
*
* @package Validates html-<form>-data throught different routines.
* @author Daniel Schliebner
* @param integer
* @return boolean true when data is valid, otherwise false
*/
function public_Valid_form_data_ref102005($_form_type = 1, &$error)
{
    $error = 0;

    $_POST = array_map(create_function('$val', 'return !is_array($val)? trim($val): $val;'), $_POST);

	if ( !empty($_SESSION['_VALID_FORM_REF102005_IP'])
         && $_SESSION['_VALID_FORM_REF102005_IP'] == getenv('REMOTE_ADDR')
		 && in_array(strtolower($_POST['formname']), $_SESSION['_VALID_FORM_NAME'])
		 && (strtolower($_POST['formset']) == 'no' || empty($_POST['formset'])) ) {
            $error = 1;
            return FALSE;
    }

    if( getenv('HTTP_USER_AGENT') == '' ||
        getenv('HTTP_ACCEPT') == '' ||
        getenv('HTTP_ACCEPT_LANGUAGE') == '' ) {

        $error = 2;
        return FALSE;
    }

    $page = preg_replace('/www./sim', '', getenv('SERVER_NAME'), 1);

    if (isset($_SERVER['HTTP_REFERER']) || isset($GLOBALS['cfg']["config_Formular_AcceptReferers"])) {
		$referer_check  = false;
		$referer_accept = Array();

		if (!empty($GLOBALS['cfg']["config_Formular_AcceptReferers"]))
			$referer_accept = explode(',', trim($GLOBALS['cfg']["config_Formular_AcceptReferers"]));

		if (isset($_SERVER['HTTP_REFERER']))
			$referer_accept = (count($referer_accept) > 0)? array_merge($referer_accept, Array($_SERVER['HTTP_REFERER'])): Array($_SERVER['HTTP_REFERER']);

		foreach ($referer_accept as $referer) {
			if ( eregi($page, trim($referer)) ) {
				$referer_check = true;
				break;
		    }
	    }
	    if (! $referer_check) {
	    	$error = 3;
	        return FALSE;
	    }
    }

    if (! ( time() - (integer)$_SESSION['FORM_DATA_TIME'] > 8 && time() - (integer)$_SESSION['FORM_DATA_TIME'] < 1800 ) ) {
        $error = 4;
        return FALSE;
    }

    $_VALID_DATA = ( $_form_type==1 ) ? $_POST : $_GET;

    $_all_values = Array();

    foreach ( $_VALID_DATA as $key=>$value )
    {
        if ( is_array($value) ) {
            continue;
        }

        $value                 = trim($value);
        $_required_data        = strpos($key, "/required");
        $_required_mail        = strpos($key, "/mail");
        $_required_usrmail     = strpos($key, "/usrmail");
        $_required_url         = strpos($key, "/url");
        $_required_validcode   = strpos($key, "/validcode");

        // check if a required field is empty
        if ( ( $_required_data || $_required_mail || $_required_usrmail ) && empty($value) ) {
            $error = 5;
            return FALSE;
        }

        // check if a specified field is a correct e-mail-adress
        if ( ( $_required_mail || $_required_usrmail ) && !dynpg_is_valid_EMail(trim($value))===0 ) {
            $error = 6;
            return FALSE;
        }

		if ( ( $_required_mail || $_required_usrmail ) && strpos(trim($value),";") ) {
            $error = 6;
            return FALSE;
        }

        // check if a specified field is a correct link-type: "http:" is required in url's!
        if ( $_required_url && !preg_match('#(http://|ftp://|www.)([^\s<>]+).(\w+)#sim', trim($value)) ) {
            $error = 7;
            return FALSE;
        }

        // check if a validcode is correct (captcha)
        if ( $_required_validcode && md5($value) != $_SESSION['_VALID_FORM_REF102005_RND'] ) {
            $error = 8;
            return FALSE;
        }

        if ( preg_match('/(content-type:|bcc:|cc:|to:|from:)/im', $value) ) {
            $error = 9;
            return FALSE;
        }
    }

    return TRUE;
}
/* {{{ FINISHED function private_Is_array_empty_ref102005() }}} */
?>