<?php

/**
* This file includes the main class for the newsletter plugin.
*
* PLUGIN: Newsletter
*
* @package DynPG PlugIn Engine
* @author Daniel Schliebner
*/

class dynPG_Newsletter {

    // $property_code -> string
    // String which is generatet by DynPG where Plugin might by inserted in.
    var $property_code;

    // $dynpg_instance -> instance of class TDynPG_MainClass
    // Copy of instance from super global $GLOBALS['DynPG'].
    var $dynpg_instance;

    // $rootToTool -> string
    // Path to the CMS directory in which DynPG has been installed
    var $rootToTool;

    // $rootToPlugin -> string
    // Path to the plugin directory in which plugin
    var $rootToPlugin;

    // $output_Message -> string
    // buffered outputs when succeeded or failed
    var $output_Message;

    // $language -> array[0..1] of [ string | TLanguage ]
    // instaance for current language class (default is "de")
    var $language;

    // $template -> TTemplate
    // instance for current template processor
    var $template;

    // $parameters -> array
    // array of parameters for this plugin
    var $parameters;

    function dynPG_Newsletter() {
        // constructor //

        // 1. initiate variables with default values

        $this->output_Message = '';
        $this->property_code  = '';


        // 2. get some foreign data of DynPG CMS

        if ( isset($GLOBALS['DynPG']) && is_object($GLOBALS['DynPG']) ) {
            $this->dynpg_instance = $GLOBALS['DynPG'];
            $this->rootToTool     = $this->dynpg_instance->PathToRoot;
            $this->rootFromPlugin = dynPG_Newsletter::realpath($this->rootToTool . '../../') . '/';
        } else {
            $this->rootToTool     = '';
            $this->rootToPlugin   = '';
            $this->dynpg_instance = null;
        }


        // 3. read current language (selected by includes class)

        $this->setupLanguage($this->dynpg_instance->_PlugIn['dpgnewsletter']['language']);


        // 4. instanciate current template processor

        // a) create instance

        $this->template = new TTemplate();

        // b) set some default values

        $this->template->addVar('Main->rootToTool', $this->rootToTool );
        $this->template->addVar('Main->QueryString', htmlentities(getenv('QUERY_STRING')) );
        $this->template->addVar('Main->Host', htmlentities(getenv('HTTP_HOST')) );
        $this->template->addVar('Main->pathToPlugin', 'plugins/DPGnewsletter/' );
        $this->template->addVar('Main->time', time() );

        register_shutdown_function(array(&$this, 'destroy_dynPG_Newsletter'));


        // 5. connect MySQL

        $this->establish_MySQL_Connection();


        // 6. Include required data

        $this->setupRequirements();


        // 7. read parameters

        // a) instanciate defaults

            $_ = Array();

        // b) read user defined

            $this->parameters = array_merge($_, $this->dynpg_instance->_PlugIn['dpgnewsletter']['parameters']);
    }

    function realpath($path) {
		$_ = realpath($path);
		return (
			($_ != false)?
			$_:
			$path
		);
	}

    function perform() {
        if ( preg_match('/<img([^<>]+)alt="NEWSLETTER"([^<>]+)\/>/', $this->property_code ) ) {
            $newsletter_HTML4    = $this->writeNewsletter();
            $this->property_code = preg_replace('/<img([^<>]+)alt="NEWSLETTER"([^<>]+)\/>/', $newsletter_HTML4, $this->property_code);
        }
    }

    function setupLanguage($lang = 'de') {
        require_once dirname( __FILE__ ) . '/languages/'.strtolower($lang).'.lang.php';

        $this->language[0] = strtolower($lang);
        $this->language[1] = new TLanguage($this->language[0], 'DPGnewsletter');
    }

    function establish_MySQL_Connection() {
        require $this->rootToTool . 'connectdb.php';
    }

    function setupRequirements() {
        require_once dirname(__FILE__) . '/../../formulars_bin.php';
    }

    function setParam($param = '', $value = '') {
        $this->parameters[strtolower($param)] = $value;
    }

    function validate_User() {

        if (! get_magic_quotes_gpc() ) {
            $_GET['actID'] = addslashes($_GET['actID']);
        }

        mysql_query("UPDATE `dynpg_newsletter_user` SET `acceptid` = NULL WHERE `acceptid` = '{$_GET['actID']}'");

        if ( mysql_affected_rows() ) {
            return true;
        } else {
            return false;
        }
    }

    function logOff_User() {

        if (! get_magic_quotes_gpc() ) {
            $_GET['loID'] = addslashes($_GET['loID']);
        }

        mysql_query("DELETE FROM `dynpg_newsletter_user` WHERE `logoffid` = '{$_GET['loID']}'");

        if ( mysql_affected_rows() ) {
            return true;
        } else {
            return false;
        }
    }

    function writeNewsletter() {

        if ( isset($_SESSION['_VALID_FORM_NEWSLETTER_VALIDATION']) ) {
            if ( $_SESSION['_VALID_FORM_NEWSLETTER_VALIDATION'] ) {

                unset($_SESSION['_VALID_FORM_NEWSLETTER_VALIDATION']);
                return $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/announce_succeed.tpl' ,

                            true

                       );
            } else {

                unset($_SESSION['_VALID_FORM_NEWSLETTER_VALIDATION']);
                return $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/announce_fail.tpl' ,

                            true

                       );
            }
        }

        if ( isset($_SESSION['_VALID_FORM_NEWSLETTER_LOGOFF']) ) {
            if ( $_SESSION['_VALID_FORM_NEWSLETTER_LOGOFF'] ) {

                unset($_SESSION['_VALID_FORM_NEWSLETTER_LOGOFF']);
                return $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/logoff_succeed.tpl' ,

                            true

                       );
            } else {

                unset($_SESSION['_VALID_FORM_NEWSLETTER_LOGOFF']);
                return $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/logoff_fail.tpl' ,

                            true

                       );
            }
        }

        $newsletter = '';

        if ( empty($_POST['announce']) ) {

            $newsletter .= $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/announce.tpl' ,

                            true

                       );

        } else {

            if (! empty($_SESSION['_VALID_FORM_NEWSLETTER_TS']) ) {
                if ( time() - $_SESSION['_VALID_FORM_NEWSLETTER_TS'] >= 1800 ) {
                    $_SESSION['_VALID_FORM_NEWSLETTER_TS'] = time() - 9;
                }

                $_POST['from_ts'] = $_SESSION['_VALID_FORM_NEWSLETTER_TS'];
            } else {
                $_POST['from_ts'] = time() - 9;
            }

            $valid = public_Valid_form_data_ref102005(1, $error);
            $fail  = false;

            if (! $valid ) {
                if ( in_array($error , Array(2, 3, 4, 9)) ) {
                    $fail = true;
                }
            }

            if (! $fail ) {
                $fail = ( empty($_POST['dpgnewsletter_email']) || dynpg_is_valid_EMail(trim($_POST['dpgnewsletter_email'])) !== 0 );
                $error = 11;
            }

            if (! $fail ) {
                $fail = mysql_num_rows(mysql_query("SELECT * FROM `dynpg_newsletter_user` WHERE `email` = '{$_POST['dpgnewsletter_email']}' AND `user_group` = '{$_POST['dpgnewsletter_group']}'")) !== 0;
                $error = 22;
            }

            if (! $fail ) {
                if (! empty($_SESSION['_VALID_FORM_NEWSLETTER_IP']) ) {
                    $fail = getenv('REMOTE_ADDR') == $_SESSION['_VALID_FORM_NEWSLETTER_IP'];
                    $error = 1;
                }
            }

            if ( $fail ) {
                return  $this->template->fillTemplate(

                            $this->template->fillTemplate(

                                    dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/fail.tpl' ,

                                    true

                               ),

                            false,

                            Array( 'ERRORSTRING' => $this->language[1]->str['lang_newsletter_errors_number_' . sprintf("%02d", $error)] )
                        );
            }

            $_SESSION['_VALID_FORM_NEWSLETTER_TS'] = time();
            $_SESSION['_VALID_FORM_NEWSLETTER_IP'] = getenv('REMOTE_ADDR');

            // create unique id values
            $acceptid = strtoupper( md5( uniqid( time() , true) . GetRandomString(15) ) );
            $logoffid = strtoupper( md5( uniqid( time() , true) . GetRandomString(15) ) );
            $date     = time();

            $acceptInputs = Array(
                                'dpgnewsletter_group',
                                'dpgnewsletter_email',
                                'dpgnewsletter_forename',
                                'dpgnewsletter_surename',
                                'dpgnewsletter_title',
                                'dpgnewsletter_street',
                                'dpgnewsletter_city',
                                'dpgnewsletter_postcode',
                                'dpgnewsletter_company',
                                'dpgnewsletter_aux'
                            );

            foreach ( $acceptInputs as $value ) {
                if (! isset($_POST[$value]) ) {
                    $_POST[$value] = '';
                }
            }

            mysql_query("INSERT INTO `dynpg_newsletter_user`( `user_group`, `title` , `forename` , `surename` , `city` , `postcode` , `company` , `email` , `logoffid` , `acceptid` , `date` , `aux`)
                         VALUES ( '{$_POST['dpgnewsletter_group']}', '{$_POST['dpgnewsletter_title']}' , '{$_POST['dpgnewsletter_forename']}' , '{$_POST['dpgnewsletter_surename']}' , '{$_POST['dpgnewsletter_city']}' , '{$_POST['dpgnewsletter_postcode']}' , '{$_POST['dpgnewsletter_company']}' , '{$_POST['dpgnewsletter_email']}' , '{$logoffid}' , '{$acceptid}' , '{$date}' , '{$_POST['dpgnewsletter_aux']}' );");

            $activatelink = 'http://' . ( getenv('HTTP_HOST')==''? getenv('SERVER_NAME'): getenv('HTTP_HOST') ) . $_SERVER["PHP_SELF"] . preg_replace('/&actID=(\w+)/', '', ( getenv('QUERY_STRING')==''? '?': '?' . getenv('QUERY_STRING') )) . '&actID=' . $acceptid;
            $logofflink   = 'http://' . ( getenv('HTTP_HOST')==''? getenv('SERVER_NAME'): getenv('HTTP_HOST') ) . $_SERVER["PHP_SELF"] . preg_replace('/&loID=(\w+)/', '', ( getenv('QUERY_STRING')==''? '?': '?' . getenv('QUERY_STRING') )) . '&loID=' . $logoffid;

            $_standard_notice_mail = mysql_fetch_array(mysql_query("SELECT * FROM `dynpg_cms_mailadresses` WHERE `adr_id` = '6'"), MYSQL_ASSOC);

            $_ctx_cmd = array('ctx_to->mail'          => $_POST['dpgnewsletter_email'],
                              'ctx_to->name'          => "{$_POST['dpgnewsletter_title']} {$_POST['dpgnewsletter_forename']} {$_POST['dpgnewsletter_surename']}",
                              'ctx_general->currHost' => getenv("HTTP_HOST"),
                              'ctx_general->currPage' => 'http://' . ( getenv('HTTP_HOST')==''? getenv('SERVER_NAME'): getenv('HTTP_HOST') ) . $_SERVER["PHP_SELF"] . preg_replace('/&actID=(\w+)/', '', ( getenv('QUERY_STRING')==''? '': '?' . getenv('QUERY_STRING') )),
                              'ctx_from->name'        => 'Newsletter',
                              'ctx_general->relLink1' => $activatelink,
                              'ctx_general->relLink2' => $logofflink,
                              'ctx_general->dynText1' => $_POST['dpgnewsletter_city'],
                              'ctx_general->dynText2' => $_POST['dpgnewsletter_postcode'],
                              'ctx_general->dynText3' => $_POST['dpgnewsletter_company'],
                              'ctx_general->dynText4' => $_POST['dpgnewsletter_aux'],
                              'ctx_re->mail'          => $_standard_notice_mail['mail']);

            dynpg_sendmail(18, $_ctx_cmd, False);

            $newsletter .= $this->template->fillTemplate(

                            dirname( __FILE__) . '/templates/' . $this->dynpg_instance->_PlugIn['dpgnewsletter']['template'] . '/succeed.tpl' ,

                            true

                       );

        }

        return $newsletter;

    }

    function destroy_dynPG_Newsletter() {
        // destructor //
    }

}

?>